/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.CreateProfileRequest;
import com.google.cloud.talent.v4beta1.DeleteProfileRequest;
import com.google.cloud.talent.v4beta1.GetProfileRequest;
import com.google.cloud.talent.v4beta1.ListProfilesRequest;
import com.google.cloud.talent.v4beta1.ListProfilesResponse;
import com.google.cloud.talent.v4beta1.MockApplicationService;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.MockCompletion;
import com.google.cloud.talent.v4beta1.MockEventService;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.MockProfileService;
import com.google.cloud.talent.v4beta1.MockTenantService;
import com.google.cloud.talent.v4beta1.Profile;
import com.google.cloud.talent.v4beta1.ProfileName;
import com.google.cloud.talent.v4beta1.ProfileServiceClient;
import com.google.cloud.talent.v4beta1.ProfileServiceSettings;
import com.google.cloud.talent.v4beta1.RequestMetadata;
import com.google.cloud.talent.v4beta1.SearchProfilesRequest;
import com.google.cloud.talent.v4beta1.SearchProfilesResponse;
import com.google.cloud.talent.v4beta1.SummarizedProfile;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateProfileRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProfileServiceClientTest {
    private static MockApplicationService mockApplicationService;
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockProfileService mockProfileService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private ProfileServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockApplicationService = new MockApplicationService();
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockProfileService = new MockProfileService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockApplicationService, mockCompanyService, mockCompletion, mockEventService, mockJobService, mockProfileService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        ProfileServiceSettings settings = ((ProfileServiceSettings.Builder)((ProfileServiceSettings.Builder)ProfileServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ProfileServiceClient.create((ProfileServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void searchProfilesTest() {
        long estimatedTotalSize = 1882144769L;
        String nextPageToken = "";
        String resultSetId = "resultSetId-770306950";
        SummarizedProfile summarizedProfilesElement = SummarizedProfile.newBuilder().build();
        List<SummarizedProfile> summarizedProfiles = Arrays.asList(summarizedProfilesElement);
        SearchProfilesResponse expectedResponse = SearchProfilesResponse.newBuilder().setEstimatedTotalSize(estimatedTotalSize).setNextPageToken(nextPageToken).setResultSetId(resultSetId).addAllSummarizedProfiles(summarizedProfiles).build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
        SearchProfilesRequest request = SearchProfilesRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
        ProfileServiceClient.SearchProfilesPagedResponse pagedListResponse = this.client.searchProfiles(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSummarizedProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchProfilesRequest actualRequest = (SearchProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)requestMetadata, (Object)actualRequest.getRequestMetadata());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchProfilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
            SearchProfilesRequest request = SearchProfilesRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
            this.client.searchProfiles(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProfilesTest() {
        String nextPageToken = "";
        Profile profilesElement = Profile.newBuilder().build();
        List<Profile> profiles = Arrays.asList(profilesElement);
        ListProfilesResponse expectedResponse = ListProfilesResponse.newBuilder().setNextPageToken(nextPageToken).addAllProfiles(profiles).build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ProfileServiceClient.ListProfilesPagedResponse pagedListResponse = this.client.listProfiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProfilesRequest actualRequest = (ListProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProfilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            this.client.listProfiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProfileTest() {
        ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        String externalId = "externalId-1153075697";
        String source = "source-896505829";
        String uri = "uri116076";
        String groupId = "groupId506361563";
        boolean processed = true;
        String keywordSnippet = "keywordSnippet1325317319";
        Profile expectedResponse = Profile.newBuilder().setName(name.toString()).setExternalId(externalId).setSource(source).setUri(uri).setGroupId(groupId).setProcessed(processed).setKeywordSnippet(keywordSnippet).build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Profile profile = Profile.newBuilder().build();
        Profile actualResponse = this.client.createProfile(parent, profile);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProfileRequest actualRequest = (CreateProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)profile, (Object)actualRequest.getProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Profile profile = Profile.newBuilder().build();
            this.client.createProfile(parent, profile);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProfileTest() {
        ProfileName name2 = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        String externalId = "externalId-1153075697";
        String source = "source-896505829";
        String uri = "uri116076";
        String groupId = "groupId506361563";
        boolean processed = true;
        String keywordSnippet = "keywordSnippet1325317319";
        Profile expectedResponse = Profile.newBuilder().setName(name2.toString()).setExternalId(externalId).setSource(source).setUri(uri).setGroupId(groupId).setProcessed(processed).setKeywordSnippet(keywordSnippet).build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        Profile actualResponse = this.client.getProfile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProfileRequest actualRequest = (GetProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProfileName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
            this.client.getProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProfileTest() {
        ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        String externalId = "externalId-1153075697";
        String source = "source-896505829";
        String uri = "uri116076";
        String groupId = "groupId506361563";
        boolean processed = true;
        String keywordSnippet = "keywordSnippet1325317319";
        Profile expectedResponse = Profile.newBuilder().setName(name.toString()).setExternalId(externalId).setSource(source).setUri(uri).setGroupId(groupId).setProcessed(processed).setKeywordSnippet(keywordSnippet).build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        Profile profile = Profile.newBuilder().build();
        Profile actualResponse = this.client.updateProfile(profile);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProfileRequest actualRequest = (UpdateProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)profile, (Object)actualRequest.getProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            Profile profile = Profile.newBuilder().build();
            this.client.updateProfile(profile);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProfileTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProfileService.addResponse((AbstractMessage)expectedResponse);
        ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        this.client.deleteProfile(name);
        List<AbstractMessage> actualRequests = mockProfileService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProfileRequest actualRequest = (DeleteProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProfileName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProfileService.addException((Exception)exception);
        try {
            ProfileName name = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
            this.client.deleteProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

