/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.Company;
import com.google.cloud.talent.v4.CompanyName;
import com.google.cloud.talent.v4.CompanyServiceSettings;
import com.google.cloud.talent.v4.CreateCompanyRequest;
import com.google.cloud.talent.v4.DeleteCompanyRequest;
import com.google.cloud.talent.v4.GetCompanyRequest;
import com.google.cloud.talent.v4.ListCompaniesRequest;
import com.google.cloud.talent.v4.ListCompaniesResponse;
import com.google.cloud.talent.v4.TenantName;
import com.google.cloud.talent.v4.UpdateCompanyRequest;
import com.google.cloud.talent.v4.stub.CompanyServiceStub;
import com.google.cloud.talent.v4.stub.CompanyServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CompanyServiceClient
implements BackgroundResource {
    private final CompanyServiceSettings settings;
    private final CompanyServiceStub stub;

    public static final CompanyServiceClient create() throws IOException {
        return CompanyServiceClient.create(CompanyServiceSettings.newBuilder().build());
    }

    public static final CompanyServiceClient create(CompanyServiceSettings settings) throws IOException {
        return new CompanyServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CompanyServiceClient create(CompanyServiceStub stub) {
        return new CompanyServiceClient(stub);
    }

    protected CompanyServiceClient(CompanyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CompanyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CompanyServiceClient(CompanyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CompanyServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CompanyServiceStub getStub() {
        return this.stub;
    }

    public final Company createCompany(TenantName parent, Company company) {
        CreateCompanyRequest request = CreateCompanyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCompany(company).build();
        return this.createCompany(request);
    }

    public final Company createCompany(String parent, Company company) {
        CreateCompanyRequest request = CreateCompanyRequest.newBuilder().setParent(parent).setCompany(company).build();
        return this.createCompany(request);
    }

    public final Company createCompany(CreateCompanyRequest request) {
        return (Company)this.createCompanyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCompanyRequest, Company> createCompanyCallable() {
        return this.stub.createCompanyCallable();
    }

    public final Company getCompany(CompanyName name) {
        GetCompanyRequest request = GetCompanyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCompany(request);
    }

    public final Company getCompany(String name) {
        GetCompanyRequest request = GetCompanyRequest.newBuilder().setName(name).build();
        return this.getCompany(request);
    }

    public final Company getCompany(GetCompanyRequest request) {
        return (Company)this.getCompanyCallable().call((Object)request);
    }

    public final UnaryCallable<GetCompanyRequest, Company> getCompanyCallable() {
        return this.stub.getCompanyCallable();
    }

    public final Company updateCompany(Company company, FieldMask updateMask) {
        UpdateCompanyRequest request = UpdateCompanyRequest.newBuilder().setCompany(company).setUpdateMask(updateMask).build();
        return this.updateCompany(request);
    }

    public final Company updateCompany(UpdateCompanyRequest request) {
        return (Company)this.updateCompanyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCompanyRequest, Company> updateCompanyCallable() {
        return this.stub.updateCompanyCallable();
    }

    public final void deleteCompany(CompanyName name) {
        DeleteCompanyRequest request = DeleteCompanyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCompany(request);
    }

    public final void deleteCompany(String name) {
        DeleteCompanyRequest request = DeleteCompanyRequest.newBuilder().setName(name).build();
        this.deleteCompany(request);
    }

    public final void deleteCompany(DeleteCompanyRequest request) {
        this.deleteCompanyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCompanyRequest, Empty> deleteCompanyCallable() {
        return this.stub.deleteCompanyCallable();
    }

    public final ListCompaniesPagedResponse listCompanies(TenantName parent) {
        ListCompaniesRequest request = ListCompaniesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCompanies(request);
    }

    public final ListCompaniesPagedResponse listCompanies(String parent) {
        ListCompaniesRequest request = ListCompaniesRequest.newBuilder().setParent(parent).build();
        return this.listCompanies(request);
    }

    public final ListCompaniesPagedResponse listCompanies(ListCompaniesRequest request) {
        return (ListCompaniesPagedResponse)((Object)this.listCompaniesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCompaniesRequest, ListCompaniesPagedResponse> listCompaniesPagedCallable() {
        return this.stub.listCompaniesPagedCallable();
    }

    public final UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable() {
        return this.stub.listCompaniesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCompaniesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCompaniesRequest, ListCompaniesResponse, Company, ListCompaniesPage, ListCompaniesFixedSizeCollection> {
        private ListCompaniesFixedSizeCollection(List<ListCompaniesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCompaniesFixedSizeCollection createEmptyCollection() {
            return new ListCompaniesFixedSizeCollection(null, 0);
        }

        protected ListCompaniesFixedSizeCollection createCollection(List<ListCompaniesPage> pages, int collectionSize) {
            return new ListCompaniesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCompaniesPage
    extends AbstractPage<ListCompaniesRequest, ListCompaniesResponse, Company, ListCompaniesPage> {
        private ListCompaniesPage(PageContext<ListCompaniesRequest, ListCompaniesResponse, Company> context, ListCompaniesResponse response) {
            super(context, (Object)response);
        }

        private static ListCompaniesPage createEmptyPage() {
            return new ListCompaniesPage(null, null);
        }

        protected ListCompaniesPage createPage(PageContext<ListCompaniesRequest, ListCompaniesResponse, Company> context, ListCompaniesResponse response) {
            return new ListCompaniesPage(context, response);
        }

        public ApiFuture<ListCompaniesPage> createPageAsync(PageContext<ListCompaniesRequest, ListCompaniesResponse, Company> context, ApiFuture<ListCompaniesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCompaniesPagedResponse
    extends AbstractPagedListResponse<ListCompaniesRequest, ListCompaniesResponse, Company, ListCompaniesPage, ListCompaniesFixedSizeCollection> {
        public static ApiFuture<ListCompaniesPagedResponse> createAsync(PageContext<ListCompaniesRequest, ListCompaniesResponse, Company> context, ApiFuture<ListCompaniesResponse> futureResponse) {
            ApiFuture<ListCompaniesPage> futurePage = ListCompaniesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCompaniesPage, ListCompaniesPagedResponse>(){

                public ListCompaniesPagedResponse apply(ListCompaniesPage input) {
                    return new ListCompaniesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCompaniesPagedResponse(ListCompaniesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCompaniesFixedSizeCollection.createEmptyCollection());
        }
    }
}

