/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4.CompleteQueryRequest;
import com.google.cloud.talent.v4.CompleteQueryResponse;
import com.google.cloud.talent.v4.CompletionClient;
import com.google.cloud.talent.v4.CompletionSettings;
import com.google.cloud.talent.v4.MockCompanyService;
import com.google.cloud.talent.v4.MockCompletion;
import com.google.cloud.talent.v4.MockEventService;
import com.google.cloud.talent.v4.MockJobService;
import com.google.cloud.talent.v4.MockTenantService;
import com.google.cloud.talent.v4.TenantName;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompletionClientTest {
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private CompletionClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCompanyService, mockCompletion, mockEventService, mockJobService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        CompletionSettings settings = ((CompletionSettings.Builder)((CompletionSettings.Builder)CompletionSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CompletionClient.create((CompletionSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void completeQueryTest() {
        CompleteQueryResponse expectedResponse = CompleteQueryResponse.newBuilder().build();
        mockCompletion.addResponse((AbstractMessage)expectedResponse);
        TenantName tenant = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String query = "query107944136";
        int pageSize = 883849137;
        CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(tenant.toString()).setQuery(query).setPageSize(pageSize).build();
        CompleteQueryResponse actualResponse = this.client.completeQuery(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompletion.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CompleteQueryRequest actualRequest = (CompleteQueryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)tenant, (Object)TenantName.parse((String)actualRequest.getTenant()));
        Assert.assertEquals((Object)query, (Object)actualRequest.getQuery());
        Assert.assertEquals((long)pageSize, (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void completeQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompletion.addException((Exception)exception);
        try {
            TenantName tenant = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String query = "query107944136";
            int pageSize = 883849137;
            CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(tenant.toString()).setQuery(query).setPageSize(pageSize).build();
            this.client.completeQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

