/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.Application;
import com.google.cloud.talent.v4beta1.ApplicationName;
import com.google.cloud.talent.v4beta1.ApplicationServiceClient;
import com.google.cloud.talent.v4beta1.ApplicationServiceSettings;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CreateApplicationRequest;
import com.google.cloud.talent.v4beta1.DeleteApplicationRequest;
import com.google.cloud.talent.v4beta1.GetApplicationRequest;
import com.google.cloud.talent.v4beta1.JobName;
import com.google.cloud.talent.v4beta1.ListApplicationsRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsResponse;
import com.google.cloud.talent.v4beta1.MockApplicationService;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.MockCompletion;
import com.google.cloud.talent.v4beta1.MockEventService;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.MockProfileService;
import com.google.cloud.talent.v4beta1.MockTenantService;
import com.google.cloud.talent.v4beta1.ProfileName;
import com.google.cloud.talent.v4beta1.UpdateApplicationRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationServiceClientTest {
    private static MockApplicationService mockApplicationService;
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockProfileService mockProfileService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private ApplicationServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockApplicationService = new MockApplicationService();
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockProfileService = new MockProfileService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockApplicationService, mockCompanyService, mockCompletion, mockEventService, mockJobService, mockProfileService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        ApplicationServiceSettings settings = ((ApplicationServiceSettings.Builder)((ApplicationServiceSettings.Builder)ApplicationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ApplicationServiceClient.create((ApplicationServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createApplicationTest() {
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
        String externalId = "externalId-1153075697";
        String profile = "profile-309425751";
        JobName job = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String outcomeNotes = "outcomeNotes-355961964";
        String jobTitleSnippet = "jobTitleSnippet-1100512972";
        Application expectedResponse = Application.newBuilder().setName(name.toString()).setExternalId(externalId).setProfile(profile).setJob(job.toString()).setCompany(company.toString()).setOutcomeNotes(outcomeNotes).setJobTitleSnippet(jobTitleSnippet).build();
        mockApplicationService.addResponse((AbstractMessage)expectedResponse);
        ProfileName parent = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        Application application = Application.newBuilder().build();
        Application actualResponse = this.client.createApplication(parent, application);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockApplicationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateApplicationRequest actualRequest = (CreateApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProfileName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)application, (Object)actualRequest.getApplication());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockApplicationService.addException((Exception)exception);
        try {
            ProfileName parent = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
            Application application = Application.newBuilder().build();
            this.client.createApplication(parent, application);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getApplicationTest() {
        ApplicationName name2 = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
        String externalId = "externalId-1153075697";
        String profile = "profile-309425751";
        JobName job = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String outcomeNotes = "outcomeNotes-355961964";
        String jobTitleSnippet = "jobTitleSnippet-1100512972";
        Application expectedResponse = Application.newBuilder().setName(name2.toString()).setExternalId(externalId).setProfile(profile).setJob(job.toString()).setCompany(company.toString()).setOutcomeNotes(outcomeNotes).setJobTitleSnippet(jobTitleSnippet).build();
        mockApplicationService.addResponse((AbstractMessage)expectedResponse);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
        Application actualResponse = this.client.getApplication(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockApplicationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetApplicationRequest actualRequest = (GetApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ApplicationName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockApplicationService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
            this.client.getApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationTest() {
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
        String externalId = "externalId-1153075697";
        String profile = "profile-309425751";
        JobName job = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String outcomeNotes = "outcomeNotes-355961964";
        String jobTitleSnippet = "jobTitleSnippet-1100512972";
        Application expectedResponse = Application.newBuilder().setName(name.toString()).setExternalId(externalId).setProfile(profile).setJob(job.toString()).setCompany(company.toString()).setOutcomeNotes(outcomeNotes).setJobTitleSnippet(jobTitleSnippet).build();
        mockApplicationService.addResponse((AbstractMessage)expectedResponse);
        Application application = Application.newBuilder().build();
        Application actualResponse = this.client.updateApplication(application);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockApplicationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationRequest actualRequest = (UpdateApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)application, (Object)actualRequest.getApplication());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockApplicationService.addException((Exception)exception);
        try {
            Application application = Application.newBuilder().build();
            this.client.updateApplication(application);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteApplicationTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockApplicationService.addResponse((AbstractMessage)expectedResponse);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
        this.client.deleteApplication(name);
        List<AbstractMessage> actualRequests = mockApplicationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteApplicationRequest actualRequest = (DeleteApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ApplicationName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockApplicationService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]", (String)"[APPLICATION]");
            this.client.deleteApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listApplicationsTest() {
        String nextPageToken = "";
        Application applicationsElement = Application.newBuilder().build();
        List<Application> applications = Arrays.asList(applicationsElement);
        ListApplicationsResponse expectedResponse = ListApplicationsResponse.newBuilder().setNextPageToken(nextPageToken).addAllApplications(applications).build();
        mockApplicationService.addResponse((AbstractMessage)expectedResponse);
        ProfileName parent = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
        ApplicationServiceClient.ListApplicationsPagedResponse pagedListResponse = this.client.listApplications(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getApplicationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockApplicationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListApplicationsRequest actualRequest = (ListApplicationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProfileName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listApplicationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockApplicationService.addException((Exception)exception);
        try {
            ProfileName parent = ProfileName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[PROFILE]");
            this.client.listApplications(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

