/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.Company;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CompanyServiceClient;
import com.google.cloud.talent.v4beta1.CompanyServiceSettings;
import com.google.cloud.talent.v4beta1.CreateCompanyRequest;
import com.google.cloud.talent.v4beta1.DeleteCompanyRequest;
import com.google.cloud.talent.v4beta1.GetCompanyRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesResponse;
import com.google.cloud.talent.v4beta1.MockApplicationService;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.MockCompletion;
import com.google.cloud.talent.v4beta1.MockEventService;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.MockProfileService;
import com.google.cloud.talent.v4beta1.MockTenantService;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateCompanyRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompanyServiceClientTest {
    private static MockApplicationService mockApplicationService;
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockProfileService mockProfileService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private CompanyServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockApplicationService = new MockApplicationService();
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockProfileService = new MockProfileService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockApplicationService, mockCompanyService, mockCompletion, mockEventService, mockJobService, mockProfileService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        CompanyServiceSettings settings = ((CompanyServiceSettings.Builder)((CompanyServiceSettings.Builder)CompanyServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CompanyServiceClient.create((CompanyServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createCompanyTest() {
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String displayName = "displayName1615086568";
        String externalId = "externalId-1153075697";
        String headquartersAddress = "headquartersAddress-1879520036";
        boolean hiringAgency = false;
        String eeoText = "eeoText-1652097123";
        String websiteUri = "websiteUri-2118185016";
        String careerSiteUri = "careerSiteUri1223331861";
        String imageUri = "imageUri-877823864";
        boolean suspended = false;
        Company expectedResponse = Company.newBuilder().setName(name.toString()).setDisplayName(displayName).setExternalId(externalId).setHeadquartersAddress(headquartersAddress).setHiringAgency(hiringAgency).setEeoText(eeoText).setWebsiteUri(websiteUri).setCareerSiteUri(careerSiteUri).setImageUri(imageUri).setSuspended(suspended).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCompanyRequest actualRequest = (CreateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Company company = Company.newBuilder().build();
            this.client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCompanyTest() {
        CompanyName name2 = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String displayName = "displayName1615086568";
        String externalId = "externalId-1153075697";
        String headquartersAddress = "headquartersAddress-1879520036";
        boolean hiringAgency = false;
        String eeoText = "eeoText-1652097123";
        String websiteUri = "websiteUri-2118185016";
        String careerSiteUri = "careerSiteUri1223331861";
        String imageUri = "imageUri-877823864";
        boolean suspended = false;
        Company expectedResponse = Company.newBuilder().setName(name2.toString()).setDisplayName(displayName).setExternalId(externalId).setHeadquartersAddress(headquartersAddress).setHiringAgency(hiringAgency).setEeoText(eeoText).setWebsiteUri(websiteUri).setCareerSiteUri(careerSiteUri).setImageUri(imageUri).setSuspended(suspended).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        Company actualResponse = this.client.getCompany(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCompanyRequest actualRequest = (GetCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)CompanyName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            this.client.getCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCompanyTest() {
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String displayName = "displayName1615086568";
        String externalId = "externalId-1153075697";
        String headquartersAddress = "headquartersAddress-1879520036";
        boolean hiringAgency = false;
        String eeoText = "eeoText-1652097123";
        String websiteUri = "websiteUri-2118185016";
        String careerSiteUri = "careerSiteUri1223331861";
        String imageUri = "imageUri-877823864";
        boolean suspended = false;
        Company expectedResponse = Company.newBuilder().setName(name.toString()).setDisplayName(displayName).setExternalId(externalId).setHeadquartersAddress(headquartersAddress).setHiringAgency(hiringAgency).setEeoText(eeoText).setWebsiteUri(websiteUri).setCareerSiteUri(careerSiteUri).setImageUri(imageUri).setSuspended(suspended).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.updateCompany(company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateCompanyRequest actualRequest = (UpdateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            Company company = Company.newBuilder().build();
            this.client.updateCompany(company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCompanyTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        this.client.deleteCompany(name);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCompanyRequest actualRequest = (DeleteCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)CompanyName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            this.client.deleteCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest() {
        String nextPageToken = "";
        Company companiesElement = Company.newBuilder().build();
        List<Company> companies = Arrays.asList(companiesElement);
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken(nextPageToken).addAllCompanies(companies).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = this.client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCompaniesRequest actualRequest = (ListCompaniesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCompaniesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            this.client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

