/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.Application;
import com.google.cloud.talent.v4beta1.ApplicationName;
import com.google.cloud.talent.v4beta1.ApplicationServiceSettings;
import com.google.cloud.talent.v4beta1.CreateApplicationRequest;
import com.google.cloud.talent.v4beta1.DeleteApplicationRequest;
import com.google.cloud.talent.v4beta1.GetApplicationRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsRequest;
import com.google.cloud.talent.v4beta1.ListApplicationsResponse;
import com.google.cloud.talent.v4beta1.ProfileName;
import com.google.cloud.talent.v4beta1.UpdateApplicationRequest;
import com.google.cloud.talent.v4beta1.stub.ApplicationServiceStub;
import com.google.cloud.talent.v4beta1.stub.ApplicationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ApplicationServiceClient
implements BackgroundResource {
    private final ApplicationServiceSettings settings;
    private final ApplicationServiceStub stub;

    public static final ApplicationServiceClient create() throws IOException {
        return ApplicationServiceClient.create(ApplicationServiceSettings.newBuilder().build());
    }

    public static final ApplicationServiceClient create(ApplicationServiceSettings settings) throws IOException {
        return new ApplicationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ApplicationServiceClient create(ApplicationServiceStub stub) {
        return new ApplicationServiceClient(stub);
    }

    protected ApplicationServiceClient(ApplicationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApplicationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ApplicationServiceClient(ApplicationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApplicationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ApplicationServiceStub getStub() {
        return this.stub;
    }

    public final Application createApplication(ProfileName parent, Application application) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApplication(application).build();
        return this.createApplication(request);
    }

    public final Application createApplication(String parent, Application application) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent).setApplication(application).build();
        return this.createApplication(request);
    }

    public final Application createApplication(CreateApplicationRequest request) {
        return (Application)this.createApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApplicationRequest, Application> createApplicationCallable() {
        return this.stub.createApplicationCallable();
    }

    public final Application getApplication(ApplicationName name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApplication(request);
    }

    public final Application getApplication(String name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name).build();
        return this.getApplication(request);
    }

    public final Application getApplication(GetApplicationRequest request) {
        return (Application)this.getApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.stub.getApplicationCallable();
    }

    public final Application updateApplication(Application application) {
        UpdateApplicationRequest request = UpdateApplicationRequest.newBuilder().setApplication(application).build();
        return this.updateApplication(request);
    }

    public final Application updateApplication(UpdateApplicationRequest request) {
        return (Application)this.updateApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApplicationRequest, Application> updateApplicationCallable() {
        return this.stub.updateApplicationCallable();
    }

    public final void deleteApplication(ApplicationName name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApplication(request);
    }

    public final void deleteApplication(String name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name).build();
        this.deleteApplication(request);
    }

    public final void deleteApplication(DeleteApplicationRequest request) {
        this.deleteApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApplicationRequest, Empty> deleteApplicationCallable() {
        return this.stub.deleteApplicationCallable();
    }

    public final ListApplicationsPagedResponse listApplications(ProfileName parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(String parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(ListApplicationsRequest request) {
        return (ListApplicationsPagedResponse)((Object)this.listApplicationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.stub.listApplicationsPagedCallable();
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.stub.listApplicationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListApplicationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        private ListApplicationsFixedSizeCollection(List<ListApplicationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApplicationsFixedSizeCollection createEmptyCollection() {
            return new ListApplicationsFixedSizeCollection(null, 0);
        }

        protected ListApplicationsFixedSizeCollection createCollection(List<ListApplicationsPage> pages, int collectionSize) {
            return new ListApplicationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApplicationsPage
    extends AbstractPage<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage> {
        private ListApplicationsPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            super(context, (Object)response);
        }

        private static ListApplicationsPage createEmptyPage() {
            return new ListApplicationsPage(null, null);
        }

        protected ListApplicationsPage createPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            return new ListApplicationsPage(context, response);
        }

        public ApiFuture<ListApplicationsPage> createPageAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApplicationsPagedResponse
    extends AbstractPagedListResponse<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        public static ApiFuture<ListApplicationsPagedResponse> createAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            ApiFuture<ListApplicationsPage> futurePage = ListApplicationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListApplicationsPage, ListApplicationsPagedResponse>(){

                public ListApplicationsPagedResponse apply(ListApplicationsPage input) {
                    return new ListApplicationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListApplicationsPagedResponse(ListApplicationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApplicationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

