/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.Company;
import com.google.cloud.talent.v4beta1.CompanyServiceClient;
import com.google.cloud.talent.v4beta1.CreateCompanyRequest;
import com.google.cloud.talent.v4beta1.DeleteCompanyRequest;
import com.google.cloud.talent.v4beta1.GetCompanyRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesResponse;
import com.google.cloud.talent.v4beta1.UpdateCompanyRequest;
import com.google.cloud.talent.v4beta1.stub.CompanyServiceStub;
import com.google.cloud.talent.v4beta1.stub.CompanyServiceStubSettings;
import com.google.cloud.talent.v4beta1.stub.HttpJsonCompanyServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCompanyServiceStub
extends CompanyServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateCompanyRequest, Company> createCompanyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.CompanyService/CreateCompany").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/companies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/companies"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Company.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCompanyRequest, Company> getCompanyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.CompanyService/GetCompany").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{name=projects/*/tenants/*/companies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{name=projects/*/companies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Company.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCompanyRequest, Company> updateCompanyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.CompanyService/UpdateCompany").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{company.name=projects/*/tenants/*/companies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "company.name", (Object)request.getCompany().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{company.name=projects/*/companies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Company.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteCompanyRequest, Empty> deleteCompanyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.CompanyService/DeleteCompany").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{name=projects/*/tenants/*/companies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{name=projects/*/companies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCompaniesRequest, ListCompaniesResponse> listCompaniesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.talent.v4beta1.CompanyService/ListCompanies").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v4beta1/{parent=projects/*/tenants/*}/companies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v4beta1/{parent=projects/*}/companies"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "requireOpenJobs", (Object)request.getRequireOpenJobs());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCompaniesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateCompanyRequest, Company> createCompanyCallable;
    private final UnaryCallable<GetCompanyRequest, Company> getCompanyCallable;
    private final UnaryCallable<UpdateCompanyRequest, Company> updateCompanyCallable;
    private final UnaryCallable<DeleteCompanyRequest, Empty> deleteCompanyCallable;
    private final UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable;
    private final UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCompanyServiceStub create(CompanyServiceStubSettings settings) throws IOException {
        return new HttpJsonCompanyServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCompanyServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCompanyServiceStub(CompanyServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCompanyServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCompanyServiceStub(CompanyServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCompanyServiceCallableFactory());
    }

    protected HttpJsonCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createCompanyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCompanyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getCompanyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCompanyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateCompanyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCompanyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteCompanyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCompanyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listCompaniesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCompaniesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createCompanyCallable = callableFactory.createUnaryCallable(createCompanyTransportSettings, settings.createCompanySettings(), clientContext);
        this.getCompanyCallable = callableFactory.createUnaryCallable(getCompanyTransportSettings, settings.getCompanySettings(), clientContext);
        this.updateCompanyCallable = callableFactory.createUnaryCallable(updateCompanyTransportSettings, settings.updateCompanySettings(), clientContext);
        this.deleteCompanyCallable = callableFactory.createUnaryCallable(deleteCompanyTransportSettings, settings.deleteCompanySettings(), clientContext);
        this.listCompaniesCallable = callableFactory.createUnaryCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.listCompaniesPagedCallable = callableFactory.createPagedCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createCompanyMethodDescriptor);
        methodDescriptors.add(getCompanyMethodDescriptor);
        methodDescriptors.add(updateCompanyMethodDescriptor);
        methodDescriptors.add(deleteCompanyMethodDescriptor);
        methodDescriptors.add(listCompaniesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateCompanyRequest, Company> createCompanyCallable() {
        return this.createCompanyCallable;
    }

    @Override
    public UnaryCallable<GetCompanyRequest, Company> getCompanyCallable() {
        return this.getCompanyCallable;
    }

    @Override
    public UnaryCallable<UpdateCompanyRequest, Company> updateCompanyCallable() {
        return this.updateCompanyCallable;
    }

    @Override
    public UnaryCallable<DeleteCompanyRequest, Empty> deleteCompanyCallable() {
        return this.deleteCompanyCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable() {
        return this.listCompaniesCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable() {
        return this.listCompaniesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

