/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4.ClientEvent;
import com.google.cloud.talent.v4.CreateClientEventRequest;
import com.google.cloud.talent.v4.EventServiceClient;
import com.google.cloud.talent.v4.EventServiceSettings;
import com.google.cloud.talent.v4.MockEventService;
import com.google.cloud.talent.v4.TenantName;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventServiceClientTest {
    private static MockEventService mockEventService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private EventServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockEventService = new MockEventService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockEventService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        EventServiceSettings settings = ((EventServiceSettings.Builder)((EventServiceSettings.Builder)EventServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = EventServiceClient.create((EventServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createClientEventTest() throws Exception {
        ClientEvent expectedResponse = ClientEvent.newBuilder().setRequestId("requestId693933066").setEventId("eventId-1376502443").setCreateTime(Timestamp.newBuilder().build()).setEventNotes("eventNotes968522823").build();
        mockEventService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ClientEvent clientEvent = ClientEvent.newBuilder().build();
        ClientEvent actualResponse = this.client.createClientEvent(parent, clientEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEventService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClientEventRequest actualRequest = (CreateClientEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)clientEvent, (Object)actualRequest.getClientEvent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClientEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEventService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ClientEvent clientEvent = ClientEvent.newBuilder().build();
            this.client.createClientEvent(parent, clientEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createClientEventTest2() throws Exception {
        ClientEvent expectedResponse = ClientEvent.newBuilder().setRequestId("requestId693933066").setEventId("eventId-1376502443").setCreateTime(Timestamp.newBuilder().build()).setEventNotes("eventNotes968522823").build();
        mockEventService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ClientEvent clientEvent = ClientEvent.newBuilder().build();
        ClientEvent actualResponse = this.client.createClientEvent(parent, clientEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEventService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClientEventRequest actualRequest = (CreateClientEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)clientEvent, (Object)actualRequest.getClientEvent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClientEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEventService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ClientEvent clientEvent = ClientEvent.newBuilder().build();
            this.client.createClientEvent(parent, clientEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

