/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.CompleteQueryRequest;
import com.google.cloud.talent.v4beta1.CompleteQueryResponse;
import com.google.cloud.talent.v4beta1.CompletionSettings;
import com.google.cloud.talent.v4beta1.stub.CompletionStub;
import com.google.cloud.talent.v4beta1.stub.CompletionStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CompletionClient
implements BackgroundResource {
    private final CompletionSettings settings;
    private final CompletionStub stub;

    public static final CompletionClient create() throws IOException {
        return CompletionClient.create(CompletionSettings.newBuilder().build());
    }

    public static final CompletionClient create(CompletionSettings settings) throws IOException {
        return new CompletionClient(settings);
    }

    public static final CompletionClient create(CompletionStub stub) {
        return new CompletionClient(stub);
    }

    protected CompletionClient(CompletionSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CompletionStubSettings)settings.getStubSettings()).createStub();
    }

    protected CompletionClient(CompletionStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CompletionSettings getSettings() {
        return this.settings;
    }

    public CompletionStub getStub() {
        return this.stub;
    }

    public final CompleteQueryResponse completeQuery(CompleteQueryRequest request) {
        return (CompleteQueryResponse)this.completeQueryCallable().call((Object)request);
    }

    public final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.stub.completeQueryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

