/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.talent.v4.CompanyName;
import com.google.cloud.talent.v4.CompleteQueryRequest;
import com.google.cloud.talent.v4.CompleteQueryResponse;
import com.google.cloud.talent.v4.CompletionClient;
import com.google.cloud.talent.v4.CompletionSettings;
import com.google.cloud.talent.v4.ResponseMetadata;
import com.google.cloud.talent.v4.TenantName;
import com.google.cloud.talent.v4.stub.HttpJsonCompletionStub;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompletionClientHttpJsonTest {
    private static MockHttpService mockService;
    private static CompletionClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonCompletionStub.getMethodDescriptors(), CompletionSettings.getDefaultEndpoint());
        CompletionSettings settings = ((CompletionSettings.Builder)((CompletionSettings.Builder)CompletionSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)CompletionSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = CompletionClient.create((CompletionSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void completeQueryTest() throws Exception {
        CompleteQueryResponse expectedResponse = CompleteQueryResponse.newBuilder().addAllCompletionResults(new ArrayList()).setMetadata(ResponseMetadata.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setQuery("query107944136").addAllLanguageCodes(new ArrayList()).setPageSize(883849137).setCompany(CompanyName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).build();
        CompleteQueryResponse actualResponse = client.completeQuery(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void completeQueryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setQuery("query107944136").addAllLanguageCodes(new ArrayList()).setPageSize(883849137).setCompany(CompanyName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).build();
            client.completeQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

