/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.talent.v4beta1.Company;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CompanyServiceClient;
import com.google.cloud.talent.v4beta1.CompanyServiceSettings;
import com.google.cloud.talent.v4beta1.CompanySize;
import com.google.cloud.talent.v4beta1.ListCompaniesResponse;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.stub.HttpJsonCompanyServiceStub;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompanyServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static CompanyServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonCompanyServiceStub.getMethodDescriptors(), CompanyServiceSettings.getDefaultEndpoint());
        CompanyServiceSettings settings = ((CompanyServiceSettings.Builder)((CompanyServiceSettings.Builder)CompanyServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)CompanyServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = CompanyServiceClient.create((CompanyServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Company company = Company.newBuilder().build();
        Company actualResponse = client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCompanyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Company company = Company.newBuilder().build();
            client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCompanyTest2() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Company company = Company.newBuilder().build();
        Company actualResponse = client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCompanyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Company company = Company.newBuilder().build();
            client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCompanyTest3() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        Company company = Company.newBuilder().build();
        Company actualResponse = client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCompanyExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            Company company = Company.newBuilder().build();
            client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        Company actualResponse = client.getCompany(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCompanyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            client.getCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCompanyTest2() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7596/tenants/tenant-7596/companies/companie-7596";
        Company actualResponse = client.getCompany(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCompanyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7596/tenants/tenant-7596/companies/companie-7596";
            client.getCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockService.addResponse((Object)expectedResponse);
        Company company = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        Company actualResponse = client.updateCompany(company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateCompanyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Company company = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
            client.updateCompany(company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCompanyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        client.deleteCompany(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCompanyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            client.deleteCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCompanyTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7596/tenants/tenant-7596/companies/companie-7596";
        client.deleteCompany(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCompanyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7596/tenants/tenant-7596/companies/companie-7596";
            client.deleteCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCompaniesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest2() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCompaniesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest3() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCompaniesExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

