/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.Company;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CompanyServiceClient;
import com.google.cloud.talent.v4beta1.CompanyServiceSettings;
import com.google.cloud.talent.v4beta1.CompanySize;
import com.google.cloud.talent.v4beta1.CreateCompanyRequest;
import com.google.cloud.talent.v4beta1.DeleteCompanyRequest;
import com.google.cloud.talent.v4beta1.GetCompanyRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesRequest;
import com.google.cloud.talent.v4beta1.ListCompaniesResponse;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateCompanyRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompanyServiceClientTest {
    private static MockCompanyService mockCompanyService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private CompanyServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockCompanyService = new MockCompanyService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCompanyService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CompanyServiceSettings settings = ((CompanyServiceSettings.Builder)((CompanyServiceSettings.Builder)CompanyServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CompanyServiceClient.create((CompanyServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCompanyRequest actualRequest = (CreateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Company company = Company.newBuilder().build();
            this.client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCompanyTest2() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCompanyRequest actualRequest = (CreateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCompanyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Company company = Company.newBuilder().build();
            this.client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCompanyTest3() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.createCompany(parent, company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCompanyRequest actualRequest = (CreateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCompanyExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Company company = Company.newBuilder().build();
            this.client.createCompany(parent, company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        Company actualResponse = this.client.getCompany(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCompanyRequest actualRequest = (GetCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            this.client.getCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCompanyTest2() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Company actualResponse = this.client.getCompany(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCompanyRequest actualRequest = (GetCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCompanyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCompanyTest() throws Exception {
        Company expectedResponse = Company.newBuilder().setName(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setDisplayName("displayName1714148973").setExternalId("externalId-1699764666").setSize(CompanySize.forNumber((int)0)).setHeadquartersAddress("headquartersAddress555829453").setHiringAgency(true).setEeoText("eeoText-1854750308").setWebsiteUri("websiteUri1317135057").setCareerSiteUri("careerSiteUri2004228935").setImageUri("imageUri-859610607").addAllKeywordSearchableJobCustomAttributes(new ArrayList()).setDerivedInfo(Company.DerivedInfo.newBuilder().build()).setSuspended(true).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        Company company = Company.newBuilder().build();
        Company actualResponse = this.client.updateCompany(company);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateCompanyRequest actualRequest = (UpdateCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)company, (Object)actualRequest.getCompany());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            Company company = Company.newBuilder().build();
            this.client.updateCompany(company);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCompanyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        this.client.deleteCompany(name);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCompanyRequest actualRequest = (DeleteCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCompanyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            CompanyName name = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
            this.client.deleteCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCompanyTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteCompany(name);
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCompanyRequest actualRequest = (DeleteCompanyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCompanyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteCompany(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = this.client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCompaniesRequest actualRequest = (ListCompaniesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCompaniesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest2() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = this.client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCompaniesRequest actualRequest = (ListCompaniesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCompaniesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            this.client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCompaniesTest3() throws Exception {
        Company responsesElement = Company.newBuilder().build();
        ListCompaniesResponse expectedResponse = ListCompaniesResponse.newBuilder().setNextPageToken("").addAllCompanies(Arrays.asList(responsesElement)).build();
        mockCompanyService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CompanyServiceClient.ListCompaniesPagedResponse pagedListResponse = this.client.listCompanies(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCompaniesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCompanyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCompaniesRequest actualRequest = (ListCompaniesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCompaniesExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompanyService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listCompanies(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

