/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CompensationInfo;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobLevel;
import com.google.cloud.talent.v4beta1.JobName;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobQuery;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.JobServiceSettings;
import com.google.cloud.talent.v4beta1.JobView;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.PostingRegion;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.RequestMetadata;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.Visibility;
import com.google.cloud.talent.v4beta1.stub.HttpJsonJobServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JobServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static JobServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonJobServiceStub.getMethodDescriptors(), JobServiceSettings.getDefaultEndpoint());
        JobServiceSettings settings = ((JobServiceSettings.Builder)((JobServiceSettings.Builder)JobServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)JobServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = JobServiceClient.create((JobServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Job job = Job.newBuilder().build();
        Job actualResponse = client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createJobExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Job job = Job.newBuilder().build();
            client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Job job = Job.newBuilder().build();
        Job actualResponse = client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createJobExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Job job = Job.newBuilder().build();
            client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTest3() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        Job job = Job.newBuilder().build();
        Job actualResponse = client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createJobExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            Job job = Job.newBuilder().build();
            client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchCreateJobsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ArrayList jobs = new ArrayList();
            client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateJobsTest2() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchCreateJobsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateJobsTest3() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8940/tenants/tenant-8940";
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchCreateJobsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            ArrayList jobs = new ArrayList();
            client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        Job actualResponse = client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getJobExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4373/tenants/tenant-4373/jobs/job-4373";
        Job actualResponse = client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getJobExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4373/tenants/tenant-4373/jobs/job-4373";
            client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Job job = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        Job actualResponse = client.updateJob(job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateJobExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Job job = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
            client.updateJob(job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchUpdateJobsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ArrayList jobs = new ArrayList();
            client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateJobsTest2() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchUpdateJobsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateJobsTest3() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8940/tenants/tenant-8940";
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchUpdateJobsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            ArrayList jobs = new ArrayList();
            client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        client.deleteJob(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteJobExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4373/tenants/tenant-4373/jobs/job-4373";
        client.deleteJob(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteJobExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4373/tenants/tenant-4373/jobs/job-4373";
            client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String filter = "filter-1274492040";
        client.batchDeleteJobs(parent, filter);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchDeleteJobsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String filter = "filter-1274492040";
            client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        client.batchDeleteJobs(parent, filter);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchDeleteJobsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        String filter = "filter-1274492040";
        client.batchDeleteJobs(parent, filter);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchDeleteJobsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            String filter = "filter-1274492040";
            client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listJobsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String filter = "filter-1274492040";
            client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest2() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listJobsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest3() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listJobsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            String filter = "filter-1274492040";
            client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsTest() throws Exception {
        SearchJobsResponse.MatchingJob responsesElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken("").addAllMatchingJobs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
        JobServiceClient.SearchJobsPagedResponse pagedListResponse = client.searchJobs(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchJobsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
            client.searchJobs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsForAlertTest() throws Exception {
        SearchJobsResponse.MatchingJob responsesElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken("").addAllMatchingJobs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
        JobServiceClient.SearchJobsForAlertPagedResponse pagedListResponse = client.searchJobsForAlert(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchJobsForAlertExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
            client.searchJobsForAlert(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

