/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4.CompanyName;
import com.google.cloud.talent.v4.CompleteQueryRequest;
import com.google.cloud.talent.v4.CompleteQueryResponse;
import com.google.cloud.talent.v4.CompletionClient;
import com.google.cloud.talent.v4.CompletionSettings;
import com.google.cloud.talent.v4.MockCompletion;
import com.google.cloud.talent.v4.ResponseMetadata;
import com.google.cloud.talent.v4.TenantName;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompletionClientTest {
    private static MockCompletion mockCompletion;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private CompletionClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockCompletion = new MockCompletion();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCompletion));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CompletionSettings settings = ((CompletionSettings.Builder)((CompletionSettings.Builder)CompletionSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CompletionClient.create((CompletionSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void completeQueryTest() throws Exception {
        CompleteQueryResponse expectedResponse = CompleteQueryResponse.newBuilder().addAllCompletionResults(new ArrayList()).setMetadata(ResponseMetadata.newBuilder().build()).build();
        mockCompletion.addResponse((AbstractMessage)expectedResponse);
        CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setQuery("query107944136").addAllLanguageCodes(new ArrayList()).setPageSize(883849137).setCompany(CompanyName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).build();
        CompleteQueryResponse actualResponse = this.client.completeQuery(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCompletion.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CompleteQueryRequest actualRequest = (CompleteQueryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getTenant(), (Object)actualRequest.getTenant());
        Assert.assertEquals((Object)request.getQuery(), (Object)actualRequest.getQuery());
        Assert.assertEquals((Object)request.getLanguageCodesList(), (Object)actualRequest.getLanguageCodesList());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getCompany(), (Object)actualRequest.getCompany());
        Assert.assertEquals((Object)request.getScope(), (Object)actualRequest.getScope());
        Assert.assertEquals((Object)request.getType(), (Object)actualRequest.getType());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void completeQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCompletion.addException((Exception)exception);
        try {
            CompleteQueryRequest request = CompleteQueryRequest.newBuilder().setTenant(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setQuery("query107944136").addAllLanguageCodes(new ArrayList()).setPageSize(883849137).setCompany(CompanyName.of((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).build();
            this.client.completeQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

