/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.talent.v4.ClientEvent;
import com.google.cloud.talent.v4.EventServiceClient;
import com.google.cloud.talent.v4.EventServiceSettings;
import com.google.cloud.talent.v4.TenantName;
import com.google.cloud.talent.v4.stub.HttpJsonEventServiceStub;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static EventServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonEventServiceStub.getMethodDescriptors(), EventServiceSettings.getDefaultEndpoint());
        EventServiceSettings settings = ((EventServiceSettings.Builder)((EventServiceSettings.Builder)EventServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)EventServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = EventServiceClient.create((EventServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createClientEventTest() throws Exception {
        ClientEvent expectedResponse = ClientEvent.newBuilder().setRequestId("requestId693933066").setEventId("eventId-1376502443").setCreateTime(Timestamp.newBuilder().build()).setEventNotes("eventNotes968522823").build();
        mockService.addResponse((Object)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ClientEvent clientEvent = ClientEvent.newBuilder().build();
        ClientEvent actualResponse = client.createClientEvent(parent, clientEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createClientEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ClientEvent clientEvent = ClientEvent.newBuilder().build();
            client.createClientEvent(parent, clientEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createClientEventTest2() throws Exception {
        ClientEvent expectedResponse = ClientEvent.newBuilder().setRequestId("requestId693933066").setEventId("eventId-1376502443").setCreateTime(Timestamp.newBuilder().build()).setEventNotes("eventNotes968522823").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8940/tenants/tenant-8940";
        ClientEvent clientEvent = ClientEvent.newBuilder().build();
        ClientEvent actualResponse = client.createClientEvent(parent, clientEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createClientEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8940/tenants/tenant-8940";
            ClientEvent clientEvent = ClientEvent.newBuilder().build();
            client.createClientEvent(parent, clientEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

