/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4.CreateTenantRequest;
import com.google.cloud.talent.v4.DeleteTenantRequest;
import com.google.cloud.talent.v4.GetTenantRequest;
import com.google.cloud.talent.v4.ListTenantsRequest;
import com.google.cloud.talent.v4.ListTenantsResponse;
import com.google.cloud.talent.v4.MockTenantService;
import com.google.cloud.talent.v4.ProjectName;
import com.google.cloud.talent.v4.Tenant;
import com.google.cloud.talent.v4.TenantName;
import com.google.cloud.talent.v4.TenantServiceClient;
import com.google.cloud.talent.v4.TenantServiceSettings;
import com.google.cloud.talent.v4.UpdateTenantRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TenantServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTenantService mockTenantService;
    private LocalChannelProvider channelProvider;
    private TenantServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTenantService = new MockTenantService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTenantService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TenantServiceSettings settings = ((TenantServiceSettings.Builder)((TenantServiceSettings.Builder)TenantServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TenantServiceClient.create((TenantServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createTenantTest() throws Exception {
        Tenant expectedResponse = Tenant.newBuilder().setName(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setExternalId("externalId-1699764666").build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Tenant tenant = Tenant.newBuilder().build();
        Tenant actualResponse = this.client.createTenant(parent, tenant);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTenantRequest actualRequest = (CreateTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tenant, (Object)actualRequest.getTenant());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTenantExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Tenant tenant = Tenant.newBuilder().build();
            this.client.createTenant(parent, tenant);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTenantTest2() throws Exception {
        Tenant expectedResponse = Tenant.newBuilder().setName(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setExternalId("externalId-1699764666").build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Tenant tenant = Tenant.newBuilder().build();
        Tenant actualResponse = this.client.createTenant(parent, tenant);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTenantRequest actualRequest = (CreateTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)tenant, (Object)actualRequest.getTenant());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTenantExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Tenant tenant = Tenant.newBuilder().build();
            this.client.createTenant(parent, tenant);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTenantTest() throws Exception {
        Tenant expectedResponse = Tenant.newBuilder().setName(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setExternalId("externalId-1699764666").build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        TenantName name = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Tenant actualResponse = this.client.getTenant(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTenantRequest actualRequest = (GetTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTenantExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            TenantName name = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            this.client.getTenant(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTenantTest2() throws Exception {
        Tenant expectedResponse = Tenant.newBuilder().setName(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setExternalId("externalId-1699764666").build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Tenant actualResponse = this.client.getTenant(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTenantRequest actualRequest = (GetTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTenantExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTenant(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTenantTest() throws Exception {
        Tenant expectedResponse = Tenant.newBuilder().setName(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setExternalId("externalId-1699764666").build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        Tenant tenant = Tenant.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Tenant actualResponse = this.client.updateTenant(tenant, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateTenantRequest actualRequest = (UpdateTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)tenant, (Object)actualRequest.getTenant());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateTenantExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            Tenant tenant = Tenant.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateTenant(tenant, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTenantTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        TenantName name = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        this.client.deleteTenant(name);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTenantRequest actualRequest = (DeleteTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTenantExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            TenantName name = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            this.client.deleteTenant(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTenantTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteTenant(name);
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTenantRequest actualRequest = (DeleteTenantRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTenantExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteTenant(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTenantsTest() throws Exception {
        Tenant responsesElement = Tenant.newBuilder().build();
        ListTenantsResponse expectedResponse = ListTenantsResponse.newBuilder().setNextPageToken("").addAllTenants(Arrays.asList(responsesElement)).build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        TenantServiceClient.ListTenantsPagedResponse pagedListResponse = this.client.listTenants(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTenantsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTenantsRequest actualRequest = (ListTenantsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTenantsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listTenants(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTenantsTest2() throws Exception {
        Tenant responsesElement = Tenant.newBuilder().build();
        ListTenantsResponse expectedResponse = ListTenantsResponse.newBuilder().setNextPageToken("").addAllTenants(Arrays.asList(responsesElement)).build();
        mockTenantService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TenantServiceClient.ListTenantsPagedResponse pagedListResponse = this.client.listTenants(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTenantsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTenantService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTenantsRequest actualRequest = (ListTenantsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTenantsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTenantService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTenants(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

