/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.BatchCreateJobsRequest;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CompensationInfo;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobLevel;
import com.google.cloud.talent.v4beta1.JobName;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobQuery;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.JobServiceSettings;
import com.google.cloud.talent.v4beta1.JobView;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.PostingRegion;
import com.google.cloud.talent.v4beta1.ProjectName;
import com.google.cloud.talent.v4beta1.RequestMetadata;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.cloud.talent.v4beta1.Visibility;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JobServiceClientTest {
    private static MockJobService mockJobService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private JobServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockJobService = new MockJobService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockJobService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        JobServiceSettings settings = ((JobServiceSettings.Builder)((JobServiceSettings.Builder)JobServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = JobServiceClient.create((JobServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTest3() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateJobsRequest actualRequest = (BatchCreateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ArrayList jobs = new ArrayList();
            this.client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchCreateJobsTest2() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateJobsRequest actualRequest = (BatchCreateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            this.client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchCreateJobsTest3() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateJobsRequest actualRequest = (BatchCreateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateJobsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList jobs = new ArrayList();
            this.client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        Job actualResponse = this.client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobRequest actualRequest = (GetJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            this.client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Job actualResponse = this.client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobRequest actualRequest = (GetJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]").toString()).setCompany(CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]").toString()).setRequisitionId("requisitionId-1769495849").setTitle("title110371416").setDescription("description-1724546052").addAllAddresses(new ArrayList()).setApplicationInfo(Job.ApplicationInfo.newBuilder().build()).addAllJobBenefits(new ArrayList()).setCompensationInfo(CompensationInfo.newBuilder().build()).putAllCustomAttributes(new HashMap()).addAllDegreeTypes(new ArrayList()).setDepartment("department848184146").addAllEmploymentTypes(new ArrayList()).setIncentives("incentives-1262874520").setLanguageCode("languageCode-2092349083").setJobLevel(JobLevel.forNumber((int)0)).setPromotionValue(353413845).setQualifications("qualifications1903501412").setResponsibilities("responsibilities-926952660").setPostingRegion(PostingRegion.forNumber((int)0)).setVisibility(Visibility.forNumber((int)0)).setJobStartTime(Timestamp.newBuilder().build()).setJobEndTime(Timestamp.newBuilder().build()).setPostingPublishTime(Timestamp.newBuilder().build()).setPostingExpireTime(Timestamp.newBuilder().build()).setPostingCreateTime(Timestamp.newBuilder().build()).setPostingUpdateTime(Timestamp.newBuilder().build()).setCompanyDisplayName("companyDisplayName-686915152").setDerivedInfo(Job.DerivedInfo.newBuilder().build()).setProcessingOptions(Job.ProcessingOptions.newBuilder().build()).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.updateJob(job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateJobRequest actualRequest = (UpdateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            Job job = Job.newBuilder().build();
            this.client.updateJob(job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchUpdateJobsRequest actualRequest = (BatchUpdateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchUpdateJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ArrayList jobs = new ArrayList();
            this.client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchUpdateJobsTest2() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchUpdateJobsRequest actualRequest = (BatchUpdateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchUpdateJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            this.client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchUpdateJobsTest3() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().addAllJobResults(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchUpdateJobsRequest actualRequest = (BatchUpdateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchUpdateJobsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList jobs = new ArrayList();
            this.client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteJobTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        this.client.deleteJob(name);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobRequest actualRequest = (DeleteJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            this.client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteJob(name);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobRequest actualRequest = (DeleteJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String filter = "filter-1274492040";
        this.client.batchDeleteJobs(parent, filter);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchDeleteJobsRequest actualRequest = (BatchDeleteJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchDeleteJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String filter = "filter-1274492040";
            this.client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        this.client.batchDeleteJobs(parent, filter);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchDeleteJobsRequest actualRequest = (BatchDeleteJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchDeleteJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            this.client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String filter = "filter-1274492040";
        this.client.batchDeleteJobs(parent, filter);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchDeleteJobsRequest actualRequest = (BatchDeleteJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchDeleteJobsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String filter = "filter-1274492040";
            this.client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String filter = "filter-1274492040";
            this.client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest2() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            this.client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest3() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String filter = "filter-1274492040";
            this.client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsTest() throws Exception {
        SearchJobsResponse.MatchingJob responsesElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken("").addAllMatchingJobs(Arrays.asList(responsesElement)).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
        JobServiceClient.SearchJobsPagedResponse pagedListResponse = this.client.searchJobs(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchJobsRequest actualRequest = (SearchJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSearchMode(), (Object)actualRequest.getSearchMode());
        Assert.assertEquals((Object)request.getRequestMetadata(), (Object)actualRequest.getRequestMetadata());
        Assert.assertEquals((Object)request.getJobQuery(), (Object)actualRequest.getJobQuery());
        Assert.assertEquals((Object)request.getEnableBroadening(), (Object)actualRequest.getEnableBroadening());
        Assert.assertEquals((Object)request.getRequirePreciseResultSize(), (Object)actualRequest.getRequirePreciseResultSize());
        Assert.assertEquals((Object)request.getHistogramQueriesList(), (Object)actualRequest.getHistogramQueriesList());
        Assert.assertEquals((Object)request.getJobView(), (Object)actualRequest.getJobView());
        Assert.assertEquals((long)request.getOffset(), (long)actualRequest.getOffset());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getDiversificationLevel(), (Object)actualRequest.getDiversificationLevel());
        Assert.assertEquals((Object)request.getCustomRankingInfo(), (Object)actualRequest.getCustomRankingInfo());
        Assert.assertEquals((Object)request.getDisableKeywordMatch(), (Object)actualRequest.getDisableKeywordMatch());
        Assert.assertEquals((Object)request.getKeywordMatchMode(), (Object)actualRequest.getKeywordMatchMode());
        Assert.assertEquals((Object)request.getRelevanceThreshold(), (Object)actualRequest.getRelevanceThreshold());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
            this.client.searchJobs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsForAlertTest() throws Exception {
        SearchJobsResponse.MatchingJob responsesElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken("").addAllMatchingJobs(Arrays.asList(responsesElement)).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
        JobServiceClient.SearchJobsForAlertPagedResponse pagedListResponse = this.client.searchJobsForAlert(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchJobsRequest actualRequest = (SearchJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSearchMode(), (Object)actualRequest.getSearchMode());
        Assert.assertEquals((Object)request.getRequestMetadata(), (Object)actualRequest.getRequestMetadata());
        Assert.assertEquals((Object)request.getJobQuery(), (Object)actualRequest.getJobQuery());
        Assert.assertEquals((Object)request.getEnableBroadening(), (Object)actualRequest.getEnableBroadening());
        Assert.assertEquals((Object)request.getRequirePreciseResultSize(), (Object)actualRequest.getRequirePreciseResultSize());
        Assert.assertEquals((Object)request.getHistogramQueriesList(), (Object)actualRequest.getHistogramQueriesList());
        Assert.assertEquals((Object)request.getJobView(), (Object)actualRequest.getJobView());
        Assert.assertEquals((long)request.getOffset(), (long)actualRequest.getOffset());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getDiversificationLevel(), (Object)actualRequest.getDiversificationLevel());
        Assert.assertEquals((Object)request.getCustomRankingInfo(), (Object)actualRequest.getCustomRankingInfo());
        Assert.assertEquals((Object)request.getDisableKeywordMatch(), (Object)actualRequest.getDisableKeywordMatch());
        Assert.assertEquals((Object)request.getKeywordMatchMode(), (Object)actualRequest.getKeywordMatchMode());
        Assert.assertEquals((Object)request.getRelevanceThreshold(), (Object)actualRequest.getRelevanceThreshold());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchJobsForAlertExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(TenantName.of((String)"[PROJECT]", (String)"[TENANT]").toString()).setRequestMetadata(RequestMetadata.newBuilder().build()).setJobQuery(JobQuery.newBuilder().build()).setEnableBroadening(true).setRequirePreciseResultSize(true).addAllHistogramQueries(new ArrayList()).setJobView(JobView.forNumber((int)0)).setOffset(-1019779949).setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setCustomRankingInfo(SearchJobsRequest.CustomRankingInfo.newBuilder().build()).setDisableKeywordMatch(true).build();
            this.client.searchJobsForAlert(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

