/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.TranslationsResource;
import com.google.cloud.translate.Translation;
import org.junit.Assert;
import org.junit.Test;

public class TranslationTest {
    private static final String TRANSLATED_TEXT = "Hello world";
    private static final String SOURCE_LANGUAGE = "en";
    private static final String MODEL = "nmt";
    private static final TranslationsResource TRANSLATION_PB = new TranslationsResource().setTranslatedText("Hello world").setDetectedSourceLanguage("en").setModel("nmt");
    private static final Translation TRANSLATION = Translation.fromPb((TranslationsResource)TRANSLATION_PB);

    @Test
    public void testFromPb() {
        Assert.assertEquals((Object)TRANSLATED_TEXT, (Object)TRANSLATION.getTranslatedText());
        Assert.assertEquals((Object)SOURCE_LANGUAGE, (Object)TRANSLATION.getSourceLanguage());
        Assert.assertEquals((Object)MODEL, (Object)TRANSLATION.getModel());
        this.compareTranslation(TRANSLATION, Translation.fromPb((TranslationsResource)TRANSLATION_PB));
    }

    private void compareTranslation(Translation expected, Translation value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getTranslatedText(), (Object)value.getTranslatedText());
        Assert.assertEquals((Object)expected.getSourceLanguage(), (Object)value.getSourceLanguage());
        Assert.assertEquals((Object)expected.getModel(), (Object)value.getModel());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

