/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.translate.v3beta1.BatchDocumentOutputConfig;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateTextRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryResponse;
import com.google.cloud.translate.v3beta1.DetectLanguageResponse;
import com.google.cloud.translate.v3beta1.DocumentInputConfig;
import com.google.cloud.translate.v3beta1.DocumentOutputConfig;
import com.google.cloud.translate.v3beta1.DocumentTranslation;
import com.google.cloud.translate.v3beta1.Glossary;
import com.google.cloud.translate.v3beta1.GlossaryInputConfig;
import com.google.cloud.translate.v3beta1.GlossaryName;
import com.google.cloud.translate.v3beta1.ListGlossariesResponse;
import com.google.cloud.translate.v3beta1.LocationName;
import com.google.cloud.translate.v3beta1.OutputConfig;
import com.google.cloud.translate.v3beta1.SupportedLanguages;
import com.google.cloud.translate.v3beta1.TranslateDocumentRequest;
import com.google.cloud.translate.v3beta1.TranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig;
import com.google.cloud.translate.v3beta1.TranslateTextRequest;
import com.google.cloud.translate.v3beta1.TranslateTextResponse;
import com.google.cloud.translate.v3beta1.TranslationServiceClient;
import com.google.cloud.translate.v3beta1.TranslationServiceSettings;
import com.google.cloud.translate.v3beta1.stub.HttpJsonTranslationServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TranslationServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static TranslationServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonTranslationServiceStub.getMethodDescriptors(), TranslationServiceSettings.getDefaultEndpoint());
        TranslationServiceSettings settings = ((TranslationServiceSettings.Builder)((TranslationServiceSettings.Builder)TranslationServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)TranslationServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = TranslationServiceClient.create((TranslationServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void translateTextTest() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TranslateTextRequest request = TranslateTextRequest.newBuilder().addAllContents(new ArrayList()).setMimeType("mimeType-1392120434").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).build();
        TranslateTextResponse actualResponse = client.translateText(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void translateTextExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TranslateTextRequest request = TranslateTextRequest.newBuilder().addAllContents(new ArrayList()).setMimeType("mimeType-1392120434").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).build();
            client.translateText(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        DetectLanguageResponse actualResponse = client.detectLanguage(parent, model, mimeType);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void detectLanguageExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            client.detectLanguage(parent, model, mimeType);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest2() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        DetectLanguageResponse actualResponse = client.detectLanguage(parent, model, mimeType);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void detectLanguageExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            client.detectLanguage(parent, model, mimeType);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String displayLanguageCode = "displayLanguageCode-1457478841";
        String model = "model104069929";
        SupportedLanguages actualResponse = client.getSupportedLanguages(parent, displayLanguageCode, model);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSupportedLanguagesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String displayLanguageCode = "displayLanguageCode-1457478841";
            String model = "model104069929";
            client.getSupportedLanguages(parent, displayLanguageCode, model);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest2() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        String displayLanguageCode = "displayLanguageCode-1457478841";
        String model = "model104069929";
        SupportedLanguages actualResponse = client.getSupportedLanguages(parent, displayLanguageCode, model);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSupportedLanguagesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            String displayLanguageCode = "displayLanguageCode-1457478841";
            String model = "model104069929";
            client.getSupportedLanguages(parent, displayLanguageCode, model);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateDocumentTest() throws Exception {
        TranslateDocumentResponse expectedResponse = TranslateDocumentResponse.newBuilder().setDocumentTranslation(DocumentTranslation.newBuilder().build()).setGlossaryDocumentTranslation(DocumentTranslation.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("projects/project-5833/locations/location-5833").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
        TranslateDocumentResponse actualResponse = client.translateDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void translateDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("projects/project-5833/locations/location-5833").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
            client.translateDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchTranslateTextTest() throws Exception {
        BatchTranslateResponse expectedResponse = BatchTranslateResponse.newBuilder().setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateTextTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
        BatchTranslateResponse actualResponse = (BatchTranslateResponse)client.batchTranslateTextAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchTranslateTextExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
            client.batchTranslateTextAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchTranslateDocumentTest() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchTranslateDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchTranslateDocumentTest2() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchTranslateDocumentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGlossaryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Glossary glossary = Glossary.newBuilder().build();
            client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGlossaryExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Glossary glossary = Glossary.newBuilder().build();
            client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossariesTest() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String filter = "filter-1274492040";
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = client.listGlossaries(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGlossariesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String filter = "filter-1274492040";
            client.listGlossaries(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossariesTest2() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        String filter = "filter-1274492040";
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = client.listGlossaries(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGlossariesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            String filter = "filter-1274492040";
            client.listGlossaries(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        Glossary actualResponse = client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGlossaryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9868/locations/location-9868/glossaries/glossarie-9868";
        Glossary actualResponse = client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGlossaryExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9868/locations/location-9868/glossaries/glossarie-9868";
            client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryTest() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGlossaryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryTest2() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-9868/locations/location-9868/glossaries/glossarie-9868";
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGlossaryExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9868/locations/location-9868/glossaries/glossarie-9868";
            client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

