/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.cloud.translate.Detection;
import org.junit.Assert;
import org.junit.Test;

public class DetectionTest {
    private static final String LANGUAGE = "en";
    private static final float CONFIDENCE = 0.42f;
    private static final DetectionsResourceItems DETECTION_PB = new DetectionsResourceItems().setLanguage("en").setConfidence(Float.valueOf(0.42f));
    private static final Detection DETECTION = Detection.fromPb((DetectionsResourceItems)DETECTION_PB);

    @Test
    public void testFromPb() {
        Assert.assertEquals((Object)LANGUAGE, (Object)DETECTION.getLanguage());
        Assert.assertEquals((float)0.42f, (float)DETECTION.getConfidence(), (float)0.0f);
        this.compareDetection(DETECTION, Detection.fromPb((DetectionsResourceItems)DETECTION_PB));
    }

    private void compareDetection(Detection expected, Detection value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getLanguage(), (Object)value.getLanguage());
        Assert.assertEquals((float)expected.getConfidence(), (float)value.getConfidence(), (float)0.0f);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

