/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.cloud.translate.Option;
import com.google.cloud.translate.spi.v2.TranslateRpc;
import org.junit.Assert;
import org.junit.Test;

public class OptionTest {
    private static final TranslateRpc.Option RPC_OPTION = TranslateRpc.Option.SOURCE_LANGUAGE;
    private static final String VALUE = "some value";
    private static final String OTHER_VALUE = "another value";
    private static final Option OPTION = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_EQUALS = new Option(RPC_OPTION, "some value"){};
    private static final Option OPTION_NOT_EQUALS = new Option(RPC_OPTION, "another value"){};

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)OPTION, (Object)OPTION_EQUALS);
        Assert.assertNotEquals((Object)OPTION, (Object)OPTION_NOT_EQUALS);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)OPTION.hashCode(), (long)OPTION_EQUALS.hashCode());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructor() {
        Assert.assertEquals((Object)RPC_OPTION, (Object)OPTION.getRpcOption());
        Assert.assertEquals((Object)VALUE, (Object)OPTION.getValue());
        Option option = new Option(RPC_OPTION, null){};
        Assert.assertEquals((Object)RPC_OPTION, (Object)option.getRpcOption());
        Assert.assertNull((Object)option.getValue());
        new Option(null, VALUE){};
    }
}

