/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.translate.TranslateException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TranslateExceptionTest {
    @Test
    public void testTranslateException() {
        TranslateException exception = new TranslateException(500, "message");
        Assert.assertEquals((long)500L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertTrue((boolean)exception.isRetryable());
        exception = new TranslateException(400, "message");
        Assert.assertEquals((long)400L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertFalse((boolean)exception.isRetryable());
        SocketTimeoutException cause = new SocketTimeoutException();
        exception = new TranslateException((IOException)cause);
        Assert.assertNull((Object)exception.getReason());
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.isRetryable());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        exception = new TranslateException(400, "message", (Throwable)cause);
        Assert.assertEquals((long)400L, (long)exception.getCode());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getReason());
        Assert.assertFalse((boolean)exception.isRetryable());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        Throwable cause = new TranslateException(500, "message");
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            TranslateException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)500L, (long)ex.getCode());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertTrue((boolean)ex.isRetryable());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
        cause = new IllegalArgumentException("message");
        exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getMessage()).andReturn((Object)"message").times(1);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            TranslateException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)0L, (long)ex.getCode());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.isRetryable());
                Assert.assertSame((Object)cause, (Object)ex.getCause());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }
}

