/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.services.translate.model.DetectionsResourceItems;
import com.google.api.services.translate.model.LanguagesResource;
import com.google.api.services.translate.model.TranslationsResource;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateException;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.google.cloud.translate.spi.TranslateRpcFactory;
import com.google.cloud.translate.spi.v2.TranslateRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TranslateImplTest {
    private static final String TARGET_LANGUAGE = "es";
    private static final LanguagesResource LANGUAGE1_PB = new LanguagesResource().setLanguage("en").setName("english");
    private static final LanguagesResource LANGUAGE2_PB = new LanguagesResource().setLanguage("es").setName("spanish");
    private static final LanguagesResource LANGUAGE3_PB = new LanguagesResource().setLanguage("en").setName("ingl\u00e9s");
    private static final LanguagesResource LANGUAGE4_PB = new LanguagesResource().setLanguage("es").setName("espa\u00f1ol");
    private static final Language LANGUAGE1 = Language.fromPb((LanguagesResource)LANGUAGE1_PB);
    private static final Language LANGUAGE2 = Language.fromPb((LanguagesResource)LANGUAGE2_PB);
    private static final Language LANGUAGE3 = Language.fromPb((LanguagesResource)LANGUAGE3_PB);
    private static final Language LANGUAGE4 = Language.fromPb((LanguagesResource)LANGUAGE4_PB);
    private static final List<Language> LANGUAGES1 = ImmutableList.of((Object)LANGUAGE1, (Object)LANGUAGE2);
    private static final List<Language> LANGUAGES2 = ImmutableList.of((Object)LANGUAGE3, (Object)LANGUAGE4);
    private static final DetectionsResourceItems DETECTION1_PB = new DetectionsResourceItems().setLanguage("en").setConfidence(Float.valueOf(0.9f));
    private static final DetectionsResourceItems DETECTION2_PB = new DetectionsResourceItems().setLanguage("en").setConfidence(Float.valueOf(0.8f));
    private static final Detection DETECTION1 = Detection.fromPb((DetectionsResourceItems)DETECTION1_PB);
    private static final Detection DETECTION2 = Detection.fromPb((DetectionsResourceItems)DETECTION2_PB);
    private static final TranslationsResource TRANSLATION1_PB = new TranslationsResource().setTranslatedText("Hello World!").setDetectedSourceLanguage("es");
    private static final TranslationsResource TRANSLATION2_PB = new TranslationsResource().setTranslatedText("Hello World!").setDetectedSourceLanguage("de");
    private static final Translation TRANSLATION1 = Translation.fromPb((TranslationsResource)TRANSLATION1_PB);
    private static final Translation TRANSLATION2 = Translation.fromPb((TranslationsResource)TRANSLATION2_PB);
    private static final Map<TranslateRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final Translate.LanguageListOption LANGUAGE_LIST_OPTION = Translate.LanguageListOption.targetLanguage((String)"es");
    private static final Map<TranslateRpc.Option, ?> LANGUAGE_LIST_OPTIONS = ImmutableMap.of((Object)TranslateRpc.Option.TARGET_LANGUAGE, (Object)LANGUAGE_LIST_OPTION.getValue());
    private static final Translate.TranslateOption TARGET_LANGUAGE_OPTION = Translate.TranslateOption.targetLanguage((String)"en");
    private static final Translate.TranslateOption SOURCE_LANGUAGE_OPTION = Translate.TranslateOption.sourceLanguage((String)"de");
    private static final Translate.TranslateOption MODEL_OPTION = Translate.TranslateOption.model((String)"nmt");
    private static final Translate.TranslateOption FORMAT_OPTION = Translate.TranslateOption.format((String)"text");
    private static final Map<TranslateRpc.Option, ?> TRANSLATE_OPTIONS = ImmutableMap.of((Object)TranslateRpc.Option.TARGET_LANGUAGE, (Object)TARGET_LANGUAGE_OPTION.getValue(), (Object)TranslateRpc.Option.SOURCE_LANGUAGE, (Object)SOURCE_LANGUAGE_OPTION.getValue(), (Object)TranslateRpc.Option.MODEL, (Object)"nmt", (Object)TranslateRpc.Option.FORMAT, (Object)"text");
    private static final RetrySettings NO_RETRY_SETTINGS = ServiceOptions.getNoRetrySettings();
    private TranslateOptions options;
    private TranslateRpcFactory rpcFactoryMock;
    private TranslateRpc translateRpcMock;
    private Translate translate;

    @Before
    public void setUp() {
        this.rpcFactoryMock = (TranslateRpcFactory)EasyMock.createMock(TranslateRpcFactory.class);
        this.translateRpcMock = (TranslateRpc)EasyMock.createMock(TranslateRpc.class);
        EasyMock.expect((Object)this.rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(TranslateOptions.class))).andReturn((Object)this.translateRpcMock);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock});
        this.options = ((TranslateOptions.Builder)((TranslateOptions.Builder)TranslateOptions.newBuilder().setServiceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).setRetrySettings(NO_RETRY_SETTINGS)).build();
    }

    private void verify() {
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.translateRpcMock});
    }

    private void initializeService() {
        this.translate = (Translate)this.options.getService();
    }

    @Test
    public void testGetOptions() {
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertSame((Object)this.options, (Object)this.translate.getOptions());
        this.verify();
    }

    @Test
    public void testListSupportedLanguages() {
        EasyMock.expect((Object)this.translateRpcMock.listSupportedLanguages(EMPTY_RPC_OPTIONS)).andReturn((Object)ImmutableList.of((Object)LANGUAGE1_PB, (Object)LANGUAGE2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals(LANGUAGES1, (Object)this.translate.listSupportedLanguages(new Translate.LanguageListOption[0]));
        this.verify();
    }

    @Test
    public void testListSupportedLanguagesWithOptions() {
        EasyMock.expect((Object)this.translateRpcMock.listSupportedLanguages(LANGUAGE_LIST_OPTIONS)).andReturn((Object)ImmutableList.of((Object)LANGUAGE3_PB, (Object)LANGUAGE4_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals(LANGUAGES2, (Object)this.translate.listSupportedLanguages(new Translate.LanguageListOption[]{Translate.LanguageListOption.targetLanguage((String)TARGET_LANGUAGE)}));
        this.verify();
    }

    @Test
    public void testDetect() {
        String text = "text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)DETECTION1, (Object)this.translate.detect(text));
        this.verify();
    }

    @Test
    public void testDetectMultipleDetections() {
        String text = "text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB, (Object)DETECTION2_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect(text);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Multiple detections found for text: text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testDetectNoDetection() {
        String text = "text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of()));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect(text);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"No detection found for text: text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testDetectList() {
        String text1 = "text";
        String text2 = "other text";
        ImmutableList texts = ImmutableList.of((Object)text1, (Object)text2);
        EasyMock.expect((Object)this.translateRpcMock.detect((List)texts)).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB), (Object)ImmutableList.of((Object)DETECTION2_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)ImmutableList.of((Object)DETECTION1, (Object)DETECTION2), (Object)this.translate.detect((List)texts));
        this.verify();
    }

    @Test
    public void testDetectListMultipleDetections() {
        String text1 = "text";
        String text2 = "other text";
        ImmutableList texts = ImmutableList.of((Object)text1, (Object)text2);
        EasyMock.expect((Object)this.translateRpcMock.detect((List)texts)).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB, (Object)DETECTION2_PB), (Object)ImmutableList.of((Object)DETECTION1_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect((List)texts);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Multiple detections found for text: text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testDetectListNoDetection() {
        String text1 = "text";
        String text2 = "other text";
        ImmutableList texts = ImmutableList.of((Object)text1, (Object)text2);
        EasyMock.expect((Object)this.translateRpcMock.detect((List)texts)).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB), (Object)ImmutableList.of()));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect((List)texts);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"No detection found for text: other text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testDetectVararg() {
        String text1 = "text";
        String text2 = "other text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text1, (Object)text2))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB), (Object)ImmutableList.of((Object)DETECTION2_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)ImmutableList.of((Object)DETECTION1, (Object)DETECTION2), (Object)this.translate.detect(new String[]{text1, text2}));
        this.verify();
    }

    @Test
    public void testDetectVarargMultipleDetections() {
        String text1 = "text";
        String text2 = "other text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text1, (Object)text2))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB, (Object)DETECTION2_PB), (Object)ImmutableList.of((Object)DETECTION1_PB)));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect(new String[]{text1, text2});
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Multiple detections found for text: text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testDetectVarargNoDetection() {
        String text1 = "text";
        String text2 = "other text";
        EasyMock.expect((Object)this.translateRpcMock.detect((List)ImmutableList.of((Object)text1, (Object)text2))).andReturn((Object)ImmutableList.of((Object)ImmutableList.of((Object)DETECTION1_PB), (Object)ImmutableList.of()));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        try {
            this.translate.detect(new String[]{text1, text2});
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"No detection found for text: other text", (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testTranslate() {
        String text = "\u00a1Hola Mundo!";
        EasyMock.expect((Object)this.translateRpcMock.translate((List)ImmutableList.of((Object)text), EMPTY_RPC_OPTIONS)).andReturn((Object)ImmutableList.of((Object)TRANSLATION1_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)TRANSLATION1, (Object)this.translate.translate(text, new Translate.TranslateOption[0]));
        this.verify();
    }

    @Test
    public void testTranslateWithOptions() {
        String text = "Hallo Welt!";
        EasyMock.expect((Object)this.translateRpcMock.translate((List)ImmutableList.of((Object)text), TRANSLATE_OPTIONS)).andReturn((Object)ImmutableList.of((Object)TRANSLATION2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)TRANSLATION2, (Object)this.translate.translate(text, new Translate.TranslateOption[]{TARGET_LANGUAGE_OPTION, SOURCE_LANGUAGE_OPTION, MODEL_OPTION, FORMAT_OPTION}));
        this.verify();
    }

    @Test
    public void testTranslateList() {
        String text1 = "\u00a1Hola Mundo!";
        String text2 = "Hallo Welt!";
        ImmutableList texts = ImmutableList.of((Object)text1, (Object)text2);
        EasyMock.expect((Object)this.translateRpcMock.translate((List)texts, EMPTY_RPC_OPTIONS)).andReturn((Object)ImmutableList.of((Object)TRANSLATION1_PB, (Object)TRANSLATION2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)ImmutableList.of((Object)TRANSLATION1, (Object)TRANSLATION2), (Object)this.translate.translate((List)texts, new Translate.TranslateOption[0]));
        this.verify();
    }

    @Test
    public void testTranslateListWithOptions() {
        String text = "Hallo Welt!";
        ImmutableList texts = ImmutableList.of((Object)text);
        EasyMock.expect((Object)this.translateRpcMock.translate((List)texts, TRANSLATE_OPTIONS)).andReturn((Object)ImmutableList.of((Object)TRANSLATION2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)ImmutableList.of((Object)TRANSLATION2), (Object)this.translate.translate((List)texts, new Translate.TranslateOption[]{TARGET_LANGUAGE_OPTION, SOURCE_LANGUAGE_OPTION, MODEL_OPTION, FORMAT_OPTION}));
        this.verify();
    }

    @Test
    public void testTranslateTextListWithModel() {
        String text = "Hallo Welt!";
        ImmutableList texts = ImmutableList.of((Object)text);
        EasyMock.expect((Object)this.translateRpcMock.translate((List)texts, (Map)ImmutableMap.of((Object)TranslateRpc.Option.MODEL, (Object)"nmt"))).andReturn((Object)ImmutableList.of((Object)TRANSLATION2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.initializeService();
        Assert.assertEquals((Object)ImmutableList.of((Object)TRANSLATION2), (Object)this.translate.translate((List)texts, new Translate.TranslateOption[]{MODEL_OPTION}));
        this.verify();
    }

    @Test
    public void testRetryableException() {
        EasyMock.expect((Object)this.translateRpcMock.listSupportedLanguages(EMPTY_RPC_OPTIONS)).andThrow((Throwable)new TranslateException(500, "internalError")).andReturn((Object)ImmutableList.of((Object)LANGUAGE1_PB, (Object)LANGUAGE2_PB));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.translate = (Translate)((TranslateOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        Assert.assertEquals(LANGUAGES1, (Object)this.translate.listSupportedLanguages(new Translate.LanguageListOption[0]));
        this.verify();
    }

    @Test
    public void testNonRetryableException() {
        String exceptionMessage = "Not Implemented";
        EasyMock.expect((Object)this.translateRpcMock.listSupportedLanguages(EMPTY_RPC_OPTIONS)).andThrow((Throwable)new TranslateException(501, exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.translate = (Translate)((TranslateOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            this.translate.listSupportedLanguages(new Translate.LanguageListOption[0]);
            Assert.fail();
        }
        catch (TranslateException ex) {
            Assert.assertEquals((Object)exceptionMessage, (Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testRuntimeException() {
        String exceptionMessage = "Artificial runtime exception";
        EasyMock.expect((Object)this.translateRpcMock.listSupportedLanguages(EMPTY_RPC_OPTIONS)).andThrow((Throwable)new RuntimeException(exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.translateRpcMock});
        this.translate = (Translate)((TranslateOptions.Builder)this.options.toBuilder().setRetrySettings(ServiceOptions.getDefaultRetrySettings())).build().getService();
        try {
            this.translate.listSupportedLanguages(new Translate.LanguageListOption[0]);
            Assert.fail();
        }
        catch (RuntimeException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
        this.verify();
    }

    @Test
    public void testCredentialsOverridesApiKey() {
        NoCredentials credentials = NoCredentials.getInstance();
        TranslateOptions overridden = ((TranslateOptions.Builder)this.options.toBuilder().setCredentials((Credentials)credentials)).build();
        Assert.assertSame((Object)overridden.getCredentials(), (Object)credentials);
        Assert.assertNull((Object)overridden.getApiKey());
    }
}

