/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.it;

import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.google.cloud.translate.testing.RemoteTranslateHelper;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class ITTranslateTest {
    private static final Translate TRANSLATE = (Translate)RemoteTranslateHelper.create().getOptions().getService();
    private static final String[] LANGUAGES = new String[]{"af", "sq", "ar", "hy", "az", "eu", "be", "bn", "bs", "bg", "ca", "ceb", "ny", "zh-TW", "hr", "cs", "da", "nl", "en", "eo", "et", "tl", "fi", "fr", "gl", "ka", "de", "el", "gu", "ht", "ha", "iw", "hi", "hmn", "hu", "is", "ig", "id", "ga", "it", "ja", "jw", "kn", "kk", "km", "ko", "lo", "la", "lv", "lt", "mk", "mg", "ms", "ml", "mt", "mi", "mr", "mn", "my", "ne", "no", "fa", "pl", "pt", "ro", "ru", "sr", "st", "si", "sk", "sl", "so", "es", "su", "sw", "sv", "tg", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "cy", "yi", "yo", "zu"};
    private static final String API_KEY = "api_key";

    @Test
    public void testListSupportedLanguages() {
        HashSet<String> supportedLanguages = new HashSet<String>();
        List languages = TRANSLATE.listSupportedLanguages(new Translate.LanguageListOption[0]);
        for (Language language : languages) {
            supportedLanguages.add(language.getCode());
            Assert.assertNotNull((Object)language.getName());
        }
        for (String code : LANGUAGES) {
            Assert.assertTrue((boolean)supportedLanguages.contains(code));
        }
    }

    @Test
    public void testListSupportedLanguagesWithOptions() {
        HashSet<String> supportedLanguages = new HashSet<String>();
        List languages = TRANSLATE.listSupportedLanguages(new Translate.LanguageListOption[]{Translate.LanguageListOption.targetLanguage((String)"es")});
        for (Language language : languages) {
            supportedLanguages.add(language.getCode());
            Assert.assertNotNull((Object)language.getName());
        }
        for (String code : LANGUAGES) {
            Assert.assertTrue((boolean)supportedLanguages.contains(code));
        }
    }

    @Test
    public void testDetectLanguageOfTexts() {
        List detections = TRANSLATE.detect(new String[]{"Hello", "Hallo"});
        Detection detection = (Detection)detections.get(0);
        Assert.assertEquals((Object)"en", (Object)detection.getLanguage());
        detection = (Detection)detections.get(1);
        Assert.assertEquals((Object)"de", (Object)detection.getLanguage());
    }

    @Test
    public void testDetectLanguageOfTextList() {
        List detections = TRANSLATE.detect((List)ImmutableList.of((Object)"Hello", (Object)"Hallo"));
        Detection detection = (Detection)detections.get(0);
        Assert.assertEquals((Object)"en", (Object)detection.getLanguage());
        detection = (Detection)detections.get(1);
        Assert.assertEquals((Object)"de", (Object)detection.getLanguage());
    }

    @Test
    public void testDetectLanguageOfText() {
        Detection detection = TRANSLATE.detect("Hello");
        Assert.assertEquals((Object)"en", (Object)detection.getLanguage());
    }

    @Test
    public void testTranslateTextList() {
        List translations = TRANSLATE.translate((List)ImmutableList.of((Object)"ocho", (Object)"acht"), new Translate.TranslateOption[0]);
        Translation translation = (Translation)translations.get(0);
        Assert.assertEquals((Object)"eight", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"es", (Object)translation.getSourceLanguage());
        translation = (Translation)translations.get(1);
        Assert.assertEquals((Object)"act", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"ga", (Object)translation.getSourceLanguage());
    }

    @Test
    public void testTranslateTextListWithModel() {
        List translations = TRANSLATE.translate((List)ImmutableList.of((Object)"ocho", (Object)"acht"), new Translate.TranslateOption[]{Translate.TranslateOption.model((String)"nmt")});
        Translation translation = (Translation)translations.get(0);
        Assert.assertEquals((Object)"eight", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"es", (Object)translation.getSourceLanguage());
        Assert.assertEquals((Object)"nmt", (Object)translation.getModel());
        translation = (Translation)translations.get(1);
        Assert.assertEquals((Object)"act", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"ga", (Object)translation.getSourceLanguage());
        Assert.assertEquals((Object)"nmt", (Object)translation.getModel());
    }

    @Test
    public void testTranslateText() {
        Translation translation = TRANSLATE.translate("ocho", new Translate.TranslateOption[0]);
        Assert.assertEquals((Object)"eight", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"es", (Object)translation.getSourceLanguage());
    }

    @Test
    public void testTranslateTextWithOptions() {
        Translation translation = TRANSLATE.translate("Hola", new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)"es"), Translate.TranslateOption.targetLanguage((String)"de")});
        Assert.assertEquals((Object)"Hallo", (Object)translation.getTranslatedText());
        Assert.assertEquals((Object)"es", (Object)translation.getSourceLanguage());
    }

    @Test
    public void testApiKeyOverridesDefaultCredentials() {
        TranslateOptions options = RemoteTranslateHelper.create((String)API_KEY).getOptions();
        Assert.assertNull((Object)options.getCredentials());
        Assert.assertEquals((Object)options.getApiKey(), (Object)API_KEY);
    }

    @Test
    public void testDefaultCredentialsOverridesDefaultApiKey() {
        TranslateOptions options = RemoteTranslateHelper.create().getOptions();
        Assert.assertNotNull((Object)options.getCredentials());
        Assert.assertNull((Object)options.getApiKey());
    }

    @Test
    public void testTranslateTextWithApiKey() {
        Translate translate = (Translate)RemoteTranslateHelper.create().getOptions().getService();
        Translation translation = translate.translate("ocho", new Translate.TranslateOption[0]);
        Assert.assertEquals((Object)"eight", (Object)translation.getTranslatedText().toLowerCase(Locale.ENGLISH));
        Assert.assertEquals((Object)"es", (Object)translation.getSourceLanguage());
    }
}

