/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.translate.v3.AdaptiveMtDataset;
import com.google.cloud.translate.v3.AdaptiveMtDatasetName;
import com.google.cloud.translate.v3.AdaptiveMtFile;
import com.google.cloud.translate.v3.AdaptiveMtFileName;
import com.google.cloud.translate.v3.AdaptiveMtSentence;
import com.google.cloud.translate.v3.AdaptiveMtTranslateRequest;
import com.google.cloud.translate.v3.AdaptiveMtTranslateResponse;
import com.google.cloud.translate.v3.BatchDocumentOutputConfig;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.CreateDatasetRequest;
import com.google.cloud.translate.v3.CreateGlossaryEntryRequest;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.CreateModelRequest;
import com.google.cloud.translate.v3.Dataset;
import com.google.cloud.translate.v3.DatasetInputConfig;
import com.google.cloud.translate.v3.DatasetName;
import com.google.cloud.translate.v3.DatasetOutputConfig;
import com.google.cloud.translate.v3.DeleteAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.DeleteAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.DeleteDatasetRequest;
import com.google.cloud.translate.v3.DeleteGlossaryEntryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DeleteModelRequest;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.DocumentInputConfig;
import com.google.cloud.translate.v3.DocumentOutputConfig;
import com.google.cloud.translate.v3.DocumentTranslation;
import com.google.cloud.translate.v3.Example;
import com.google.cloud.translate.v3.ExportDataRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.GetDatasetRequest;
import com.google.cloud.translate.v3.GetGlossaryEntryRequest;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetModelRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.GlossaryEntry;
import com.google.cloud.translate.v3.GlossaryEntryName;
import com.google.cloud.translate.v3.GlossaryInputConfig;
import com.google.cloud.translate.v3.GlossaryName;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileResponse;
import com.google.cloud.translate.v3.ImportDataRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesResponse;
import com.google.cloud.translate.v3.ListDatasetsRequest;
import com.google.cloud.translate.v3.ListDatasetsResponse;
import com.google.cloud.translate.v3.ListExamplesRequest;
import com.google.cloud.translate.v3.ListExamplesResponse;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.ListGlossaryEntriesRequest;
import com.google.cloud.translate.v3.ListGlossaryEntriesResponse;
import com.google.cloud.translate.v3.ListModelsRequest;
import com.google.cloud.translate.v3.ListModelsResponse;
import com.google.cloud.translate.v3.LocationName;
import com.google.cloud.translate.v3.MockTranslationService;
import com.google.cloud.translate.v3.Model;
import com.google.cloud.translate.v3.ModelName;
import com.google.cloud.translate.v3.OutputConfig;
import com.google.cloud.translate.v3.RomanizeTextRequest;
import com.google.cloud.translate.v3.RomanizeTextResponse;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextGlossaryConfig;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceClient;
import com.google.cloud.translate.v3.TranslationServiceSettings;
import com.google.cloud.translate.v3.UpdateGlossaryEntryRequest;
import com.google.cloud.translate.v3.UpdateGlossaryRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TranslationServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTranslationService mockTranslationService;
    private LocalChannelProvider channelProvider;
    private TranslationServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTranslationService = new MockTranslationService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTranslationService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TranslationServiceSettings settings = ((TranslationServiceSettings.Builder)((TranslationServiceSettings.Builder)TranslationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TranslationServiceClient.create((TranslationServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void translateTextTest() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String targetLanguageCode = "targetLanguageCode-106414698";
        ArrayList contents = new ArrayList();
        TranslateTextResponse actualResponse = this.client.translateText(parent, targetLanguageCode, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateTextRequest actualRequest = (TranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)targetLanguageCode, (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateTextExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String targetLanguageCode = "targetLanguageCode-106414698";
            ArrayList contents = new ArrayList();
            this.client.translateText(parent, targetLanguageCode, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateTextTest2() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String targetLanguageCode = "targetLanguageCode-106414698";
        ArrayList contents = new ArrayList();
        TranslateTextResponse actualResponse = this.client.translateText(parent, targetLanguageCode, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateTextRequest actualRequest = (TranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)targetLanguageCode, (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateTextExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String targetLanguageCode = "targetLanguageCode-106414698";
            ArrayList contents = new ArrayList();
            this.client.translateText(parent, targetLanguageCode, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateTextTest3() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        String targetLanguageCode = "targetLanguageCode-106414698";
        ArrayList contents = new ArrayList();
        TranslateTextResponse actualResponse = this.client.translateText(parent, model, mimeType, sourceLanguageCode, targetLanguageCode, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateTextRequest actualRequest = (TranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)targetLanguageCode, (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateTextExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            String targetLanguageCode = "targetLanguageCode-106414698";
            ArrayList contents = new ArrayList();
            this.client.translateText(parent, model, mimeType, sourceLanguageCode, targetLanguageCode, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateTextTest4() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        String targetLanguageCode = "targetLanguageCode-106414698";
        ArrayList contents = new ArrayList();
        TranslateTextResponse actualResponse = this.client.translateText(parent, model, mimeType, sourceLanguageCode, targetLanguageCode, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateTextRequest actualRequest = (TranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)targetLanguageCode, (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateTextExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            String targetLanguageCode = "targetLanguageCode-106414698";
            ArrayList contents = new ArrayList();
            this.client.translateText(parent, model, mimeType, sourceLanguageCode, targetLanguageCode, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void romanizeTextTest() throws Exception {
        RomanizeTextResponse expectedResponse = RomanizeTextResponse.newBuilder().addAllRomanizations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ArrayList contents = new ArrayList();
        RomanizeTextResponse actualResponse = this.client.romanizeText(parent, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RomanizeTextRequest actualRequest = (RomanizeTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void romanizeTextExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ArrayList contents = new ArrayList();
            this.client.romanizeText(parent, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void romanizeTextTest2() throws Exception {
        RomanizeTextResponse expectedResponse = RomanizeTextResponse.newBuilder().addAllRomanizations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ArrayList contents = new ArrayList();
        RomanizeTextResponse actualResponse = this.client.romanizeText(parent, contents);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RomanizeTextRequest actualRequest = (RomanizeTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(contents, (Object)actualRequest.getContentsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void romanizeTextExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList contents = new ArrayList();
            this.client.romanizeText(parent, contents);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        String content = "content951530617";
        DetectLanguageResponse actualResponse = this.client.detectLanguage(parent, model, mimeType, content);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DetectLanguageRequest actualRequest = (DetectLanguageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertEquals((Object)content, (Object)actualRequest.getContent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void detectLanguageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            String content = "content951530617";
            this.client.detectLanguage(parent, model, mimeType, content);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest2() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        String content = "content951530617";
        DetectLanguageResponse actualResponse = this.client.detectLanguage(parent, model, mimeType, content);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DetectLanguageRequest actualRequest = (DetectLanguageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertEquals((Object)content, (Object)actualRequest.getContent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void detectLanguageExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            String content = "content951530617";
            this.client.detectLanguage(parent, model, mimeType, content);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String model = "model104069929";
        String displayLanguageCode = "displayLanguageCode-1457478841";
        SupportedLanguages actualResponse = this.client.getSupportedLanguages(parent, model, displayLanguageCode);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSupportedLanguagesRequest actualRequest = (GetSupportedLanguagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)displayLanguageCode, (Object)actualRequest.getDisplayLanguageCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSupportedLanguagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String model = "model104069929";
            String displayLanguageCode = "displayLanguageCode-1457478841";
            this.client.getSupportedLanguages(parent, model, displayLanguageCode);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest2() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String model = "model104069929";
        String displayLanguageCode = "displayLanguageCode-1457478841";
        SupportedLanguages actualResponse = this.client.getSupportedLanguages(parent, model, displayLanguageCode);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSupportedLanguagesRequest actualRequest = (GetSupportedLanguagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)displayLanguageCode, (Object)actualRequest.getDisplayLanguageCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSupportedLanguagesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String model = "model104069929";
            String displayLanguageCode = "displayLanguageCode-1457478841";
            this.client.getSupportedLanguages(parent, model, displayLanguageCode);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateDocumentTest() throws Exception {
        TranslateDocumentResponse expectedResponse = TranslateDocumentResponse.newBuilder().setDocumentTranslation(DocumentTranslation.newBuilder().build()).setGlossaryDocumentTranslation(DocumentTranslation.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("parent-995424086").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
        TranslateDocumentResponse actualResponse = this.client.translateDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateDocumentRequest actualRequest = (TranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSourceLanguageCode(), (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)request.getTargetLanguageCode(), (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals((Object)request.getDocumentInputConfig(), (Object)actualRequest.getDocumentInputConfig());
        Assert.assertEquals((Object)request.getDocumentOutputConfig(), (Object)actualRequest.getDocumentOutputConfig());
        Assert.assertEquals((Object)request.getModel(), (Object)actualRequest.getModel());
        Assert.assertEquals((Object)request.getGlossaryConfig(), (Object)actualRequest.getGlossaryConfig());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertEquals((Object)request.getCustomizedAttribution(), (Object)actualRequest.getCustomizedAttribution());
        Assert.assertEquals((Object)request.getIsTranslateNativePdfOnly(), (Object)actualRequest.getIsTranslateNativePdfOnly());
        Assert.assertEquals((Object)request.getEnableShadowRemovalNativePdf(), (Object)actualRequest.getEnableShadowRemovalNativePdf());
        Assert.assertEquals((Object)request.getEnableRotationCorrection(), (Object)actualRequest.getEnableRotationCorrection());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("parent-995424086").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
            this.client.translateDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchTranslateTextTest() throws Exception {
        BatchTranslateResponse expectedResponse = BatchTranslateResponse.newBuilder().setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateTextTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
        BatchTranslateResponse actualResponse = (BatchTranslateResponse)this.client.batchTranslateTextAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateTextRequest actualRequest = (BatchTranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSourceLanguageCode(), (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)request.getTargetLanguageCodesList(), (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals((Object)request.getModelsMap(), (Object)actualRequest.getModelsMap());
        Assert.assertEquals((Object)request.getInputConfigsList(), (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)request.getOutputConfig(), (Object)actualRequest.getOutputConfig());
        Assert.assertEquals((Object)request.getGlossariesMap(), (Object)actualRequest.getGlossariesMap());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateTextExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
            this.client.batchTranslateTextAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchTranslateDocumentTest() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateDocumentRequest actualRequest = (BatchTranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals(targetLanguageCodes, (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals(inputConfigs, (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchTranslateDocumentTest2() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateDocumentRequest actualRequest = (BatchTranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals(targetLanguageCodes, (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals(inputConfigs, (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateDocumentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)this.client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryRequest actualRequest = (CreateGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossary, (Object)actualRequest.getGlossary());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Glossary glossary = Glossary.newBuilder().build();
            this.client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)this.client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryRequest actualRequest = (CreateGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossary, (Object)actualRequest.getGlossary());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Glossary glossary = Glossary.newBuilder().build();
            this.client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("updateGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        Glossary glossary = Glossary.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Glossary actualResponse = (Glossary)this.client.updateGlossaryAsync(glossary, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGlossaryRequest actualRequest = (UpdateGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)glossary, (Object)actualRequest.getGlossary());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            Glossary glossary = Glossary.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGlossaryAsync(glossary, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listGlossariesTest() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = this.client.listGlossaries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossariesRequest actualRequest = (ListGlossariesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossariesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listGlossaries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossariesTest2() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = this.client.listGlossaries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossariesRequest actualRequest = (ListGlossariesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossariesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listGlossaries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        Glossary actualResponse = this.client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryRequest actualRequest = (GetGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            this.client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Glossary actualResponse = this.client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryRequest actualRequest = (GetGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryTest() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)this.client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryRequest actualRequest = (DeleteGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            this.client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGlossaryTest2() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)this.client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryRequest actualRequest = (DeleteGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getGlossaryEntryTest() throws Exception {
        GlossaryEntry expectedResponse = GlossaryEntry.newBuilder().setName(GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]").toString()).setDescription("description-1724546052").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryEntryName name = GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]");
        GlossaryEntry actualResponse = this.client.getGlossaryEntry(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryEntryRequest actualRequest = (GetGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryEntryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryEntryName name = GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]");
            this.client.getGlossaryEntry(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryEntryTest2() throws Exception {
        GlossaryEntry expectedResponse = GlossaryEntry.newBuilder().setName(GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]").toString()).setDescription("description-1724546052").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GlossaryEntry actualResponse = this.client.getGlossaryEntry(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryEntryRequest actualRequest = (GetGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryEntryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGlossaryEntry(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossaryEntriesTest() throws Exception {
        GlossaryEntry responsesElement = GlossaryEntry.newBuilder().build();
        ListGlossaryEntriesResponse expectedResponse = ListGlossaryEntriesResponse.newBuilder().setNextPageToken("").addAllGlossaryEntries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryName parent = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        TranslationServiceClient.ListGlossaryEntriesPagedResponse pagedListResponse = this.client.listGlossaryEntries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossaryEntriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossaryEntriesRequest actualRequest = (ListGlossaryEntriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossaryEntriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName parent = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            this.client.listGlossaryEntries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossaryEntriesTest2() throws Exception {
        GlossaryEntry responsesElement = GlossaryEntry.newBuilder().build();
        ListGlossaryEntriesResponse expectedResponse = ListGlossaryEntriesResponse.newBuilder().setNextPageToken("").addAllGlossaryEntries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListGlossaryEntriesPagedResponse pagedListResponse = this.client.listGlossaryEntries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossaryEntriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossaryEntriesRequest actualRequest = (ListGlossaryEntriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossaryEntriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listGlossaryEntries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGlossaryEntryTest() throws Exception {
        GlossaryEntry expectedResponse = GlossaryEntry.newBuilder().setName(GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]").toString()).setDescription("description-1724546052").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryName parent = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
        GlossaryEntry actualResponse = this.client.createGlossaryEntry(parent, glossaryEntry);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryEntryRequest actualRequest = (CreateGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossaryEntry, (Object)actualRequest.getGlossaryEntry());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryEntryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName parent = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
            this.client.createGlossaryEntry(parent, glossaryEntry);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGlossaryEntryTest2() throws Exception {
        GlossaryEntry expectedResponse = GlossaryEntry.newBuilder().setName(GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]").toString()).setDescription("description-1724546052").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
        GlossaryEntry actualResponse = this.client.createGlossaryEntry(parent, glossaryEntry);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryEntryRequest actualRequest = (CreateGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossaryEntry, (Object)actualRequest.getGlossaryEntry());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryEntryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
            this.client.createGlossaryEntry(parent, glossaryEntry);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGlossaryEntryTest() throws Exception {
        GlossaryEntry expectedResponse = GlossaryEntry.newBuilder().setName(GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]").toString()).setDescription("description-1724546052").build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
        GlossaryEntry actualResponse = this.client.updateGlossaryEntry(glossaryEntry);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGlossaryEntryRequest actualRequest = (UpdateGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)glossaryEntry, (Object)actualRequest.getGlossaryEntry());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGlossaryEntryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryEntry glossaryEntry = GlossaryEntry.newBuilder().build();
            this.client.updateGlossaryEntry(glossaryEntry);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryEntryTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryEntryName name = GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]");
        this.client.deleteGlossaryEntry(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryEntryRequest actualRequest = (DeleteGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryEntryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryEntryName name = GlossaryEntryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]", (String)"[GLOSSARY_ENTRY]");
            this.client.deleteGlossaryEntry(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryEntryTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteGlossaryEntry(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryEntryRequest actualRequest = (DeleteGlossaryEntryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryEntryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGlossaryEntry(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatasetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = (Dataset)this.client.createDatasetAsync(parent, dataset).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDatasetAsync(parent, dataset).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatasetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = (Dataset)this.client.createDatasetAsync(parent, dataset).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDatasetAsync(parent, dataset).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranslationServiceClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest2() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDatasetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        this.client.deleteDatasetAsync(name).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.deleteDatasetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteDatasetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDatasetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteDatasetAsync(name).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDatasetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createAdaptiveMtDatasetTest() throws Exception {
        AdaptiveMtDataset expectedResponse = AdaptiveMtDataset.newBuilder().setName(AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AdaptiveMtDataset adaptiveMtDataset = AdaptiveMtDataset.newBuilder().build();
        AdaptiveMtDataset actualResponse = this.client.createAdaptiveMtDataset(parent, adaptiveMtDataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAdaptiveMtDatasetRequest actualRequest = (CreateAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)adaptiveMtDataset, (Object)actualRequest.getAdaptiveMtDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAdaptiveMtDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            AdaptiveMtDataset adaptiveMtDataset = AdaptiveMtDataset.newBuilder().build();
            this.client.createAdaptiveMtDataset(parent, adaptiveMtDataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAdaptiveMtDatasetTest2() throws Exception {
        AdaptiveMtDataset expectedResponse = AdaptiveMtDataset.newBuilder().setName(AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AdaptiveMtDataset adaptiveMtDataset = AdaptiveMtDataset.newBuilder().build();
        AdaptiveMtDataset actualResponse = this.client.createAdaptiveMtDataset(parent, adaptiveMtDataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAdaptiveMtDatasetRequest actualRequest = (CreateAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)adaptiveMtDataset, (Object)actualRequest.getAdaptiveMtDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAdaptiveMtDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            AdaptiveMtDataset adaptiveMtDataset = AdaptiveMtDataset.newBuilder().build();
            this.client.createAdaptiveMtDataset(parent, adaptiveMtDataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAdaptiveMtDatasetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtDatasetName name = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        this.client.deleteAdaptiveMtDataset(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAdaptiveMtDatasetRequest actualRequest = (DeleteAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAdaptiveMtDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtDatasetName name = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.deleteAdaptiveMtDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAdaptiveMtDatasetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAdaptiveMtDataset(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAdaptiveMtDatasetRequest actualRequest = (DeleteAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAdaptiveMtDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAdaptiveMtDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAdaptiveMtDatasetTest() throws Exception {
        AdaptiveMtDataset expectedResponse = AdaptiveMtDataset.newBuilder().setName(AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtDatasetName name = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        AdaptiveMtDataset actualResponse = this.client.getAdaptiveMtDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAdaptiveMtDatasetRequest actualRequest = (GetAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAdaptiveMtDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtDatasetName name = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.getAdaptiveMtDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAdaptiveMtDatasetTest2() throws Exception {
        AdaptiveMtDataset expectedResponse = AdaptiveMtDataset.newBuilder().setName(AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setExampleCount(1517063674).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AdaptiveMtDataset actualResponse = this.client.getAdaptiveMtDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAdaptiveMtDatasetRequest actualRequest = (GetAdaptiveMtDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAdaptiveMtDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAdaptiveMtDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtDatasetsTest() throws Exception {
        AdaptiveMtDataset responsesElement = AdaptiveMtDataset.newBuilder().build();
        ListAdaptiveMtDatasetsResponse expectedResponse = ListAdaptiveMtDatasetsResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtDatasets(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse pagedListResponse = this.client.listAdaptiveMtDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtDatasetsRequest actualRequest = (ListAdaptiveMtDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtDatasetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listAdaptiveMtDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtDatasetsTest2() throws Exception {
        AdaptiveMtDataset responsesElement = AdaptiveMtDataset.newBuilder().build();
        ListAdaptiveMtDatasetsResponse expectedResponse = ListAdaptiveMtDatasetsResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtDatasets(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse pagedListResponse = this.client.listAdaptiveMtDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtDatasetsRequest actualRequest = (ListAdaptiveMtDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtDatasetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAdaptiveMtDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void adaptiveMtTranslateTest() throws Exception {
        AdaptiveMtTranslateResponse expectedResponse = AdaptiveMtTranslateResponse.newBuilder().addAllTranslations(new ArrayList()).setLanguageCode("languageCode-2092349083").addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ArrayList content = new ArrayList();
        AdaptiveMtTranslateResponse actualResponse = this.client.adaptiveMtTranslate(parent, content);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AdaptiveMtTranslateRequest actualRequest = (AdaptiveMtTranslateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(content, (Object)actualRequest.getContentList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void adaptiveMtTranslateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ArrayList content = new ArrayList();
            this.client.adaptiveMtTranslate(parent, content);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void adaptiveMtTranslateTest2() throws Exception {
        AdaptiveMtTranslateResponse expectedResponse = AdaptiveMtTranslateResponse.newBuilder().addAllTranslations(new ArrayList()).setLanguageCode("languageCode-2092349083").addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ArrayList content = new ArrayList();
        AdaptiveMtTranslateResponse actualResponse = this.client.adaptiveMtTranslate(parent, content);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AdaptiveMtTranslateRequest actualRequest = (AdaptiveMtTranslateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(content, (Object)actualRequest.getContentList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void adaptiveMtTranslateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList content = new ArrayList();
            this.client.adaptiveMtTranslate(parent, content);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAdaptiveMtFileTest() throws Exception {
        AdaptiveMtFile expectedResponse = AdaptiveMtFile.newBuilder().setName(AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]").toString()).setDisplayName("displayName1714148973").setEntryCount(-811131134).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtFileName name = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
        AdaptiveMtFile actualResponse = this.client.getAdaptiveMtFile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAdaptiveMtFileRequest actualRequest = (GetAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAdaptiveMtFileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtFileName name = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
            this.client.getAdaptiveMtFile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAdaptiveMtFileTest2() throws Exception {
        AdaptiveMtFile expectedResponse = AdaptiveMtFile.newBuilder().setName(AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]").toString()).setDisplayName("displayName1714148973").setEntryCount(-811131134).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AdaptiveMtFile actualResponse = this.client.getAdaptiveMtFile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAdaptiveMtFileRequest actualRequest = (GetAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAdaptiveMtFileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAdaptiveMtFile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAdaptiveMtFileTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtFileName name = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
        this.client.deleteAdaptiveMtFile(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAdaptiveMtFileRequest actualRequest = (DeleteAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAdaptiveMtFileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtFileName name = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
            this.client.deleteAdaptiveMtFile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAdaptiveMtFileTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAdaptiveMtFile(name);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAdaptiveMtFileRequest actualRequest = (DeleteAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAdaptiveMtFileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAdaptiveMtFile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importAdaptiveMtFileTest() throws Exception {
        ImportAdaptiveMtFileResponse expectedResponse = ImportAdaptiveMtFileResponse.newBuilder().setAdaptiveMtFile(AdaptiveMtFile.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtDatasetName parent = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        ImportAdaptiveMtFileResponse actualResponse = this.client.importAdaptiveMtFile(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportAdaptiveMtFileRequest actualRequest = (ImportAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importAdaptiveMtFileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtDatasetName parent = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.importAdaptiveMtFile(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importAdaptiveMtFileTest2() throws Exception {
        ImportAdaptiveMtFileResponse expectedResponse = ImportAdaptiveMtFileResponse.newBuilder().setAdaptiveMtFile(AdaptiveMtFile.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ImportAdaptiveMtFileResponse actualResponse = this.client.importAdaptiveMtFile(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportAdaptiveMtFileRequest actualRequest = (ImportAdaptiveMtFileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importAdaptiveMtFileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.importAdaptiveMtFile(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtFilesTest() throws Exception {
        AdaptiveMtFile responsesElement = AdaptiveMtFile.newBuilder().build();
        ListAdaptiveMtFilesResponse expectedResponse = ListAdaptiveMtFilesResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtFiles(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtDatasetName parent = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        TranslationServiceClient.ListAdaptiveMtFilesPagedResponse pagedListResponse = this.client.listAdaptiveMtFiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtFilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtFilesRequest actualRequest = (ListAdaptiveMtFilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtFilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtDatasetName parent = AdaptiveMtDatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.listAdaptiveMtFiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtFilesTest2() throws Exception {
        AdaptiveMtFile responsesElement = AdaptiveMtFile.newBuilder().build();
        ListAdaptiveMtFilesResponse expectedResponse = ListAdaptiveMtFilesResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtFiles(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListAdaptiveMtFilesPagedResponse pagedListResponse = this.client.listAdaptiveMtFiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtFilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtFilesRequest actualRequest = (ListAdaptiveMtFilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtFilesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAdaptiveMtFiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtSentencesTest() throws Exception {
        AdaptiveMtSentence responsesElement = AdaptiveMtSentence.newBuilder().build();
        ListAdaptiveMtSentencesResponse expectedResponse = ListAdaptiveMtSentencesResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtSentences(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        AdaptiveMtFileName parent = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
        TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse pagedListResponse = this.client.listAdaptiveMtSentences(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtSentencesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtSentencesRequest actualRequest = (ListAdaptiveMtSentencesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtSentencesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            AdaptiveMtFileName parent = AdaptiveMtFileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]", (String)"[FILE]");
            this.client.listAdaptiveMtSentences(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAdaptiveMtSentencesTest2() throws Exception {
        AdaptiveMtSentence responsesElement = AdaptiveMtSentence.newBuilder().build();
        ListAdaptiveMtSentencesResponse expectedResponse = ListAdaptiveMtSentencesResponse.newBuilder().setNextPageToken("").addAllAdaptiveMtSentences(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse pagedListResponse = this.client.listAdaptiveMtSentences(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAdaptiveMtSentencesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAdaptiveMtSentencesRequest actualRequest = (ListAdaptiveMtSentencesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAdaptiveMtSentencesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAdaptiveMtSentences(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importDataTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("importDataTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String dataset = "dataset1443214456";
        DatasetInputConfig inputConfig = DatasetInputConfig.newBuilder().build();
        this.client.importDataAsync(dataset, inputConfig).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportDataRequest actualRequest = (ImportDataRequest)actualRequests.get(0);
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertEquals((Object)inputConfig, (Object)actualRequest.getInputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importDataExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String dataset = "dataset1443214456";
            DatasetInputConfig inputConfig = DatasetInputConfig.newBuilder().build();
            this.client.importDataAsync(dataset, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void exportDataTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("exportDataTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String dataset = "dataset1443214456";
        DatasetOutputConfig outputConfig = DatasetOutputConfig.newBuilder().build();
        this.client.exportDataAsync(dataset, outputConfig).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportDataRequest actualRequest = (ExportDataRequest)actualRequests.get(0);
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportDataExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String dataset = "dataset1443214456";
            DatasetOutputConfig outputConfig = DatasetOutputConfig.newBuilder().build();
            this.client.exportDataAsync(dataset, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listExamplesTest() throws Exception {
        Example responsesElement = Example.newBuilder().build();
        ListExamplesResponse expectedResponse = ListExamplesResponse.newBuilder().setNextPageToken("").addAllExamples(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        DatasetName parent = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
        TranslationServiceClient.ListExamplesPagedResponse pagedListResponse = this.client.listExamples(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getExamplesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListExamplesRequest actualRequest = (ListExamplesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listExamplesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            DatasetName parent = DatasetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DATASET]");
            this.client.listExamples(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listExamplesTest2() throws Exception {
        Example responsesElement = Example.newBuilder().build();
        ListExamplesResponse expectedResponse = ListExamplesResponse.newBuilder().setNextPageToken("").addAllExamples(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListExamplesPagedResponse pagedListResponse = this.client.listExamples(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getExamplesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListExamplesRequest actualRequest = (ListExamplesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listExamplesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listExamples(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createModelTest() throws Exception {
        Model expectedResponse = Model.newBuilder().setName(ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]").toString()).setDisplayName("displayName1714148973").setDataset("dataset1443214456").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createModelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Model model = Model.newBuilder().build();
        Model actualResponse = (Model)this.client.createModelAsync(parent, model).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateModelRequest actualRequest = (CreateModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createModelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Model model = Model.newBuilder().build();
            this.client.createModelAsync(parent, model).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createModelTest2() throws Exception {
        Model expectedResponse = Model.newBuilder().setName(ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]").toString()).setDisplayName("displayName1714148973").setDataset("dataset1443214456").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createModelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Model model = Model.newBuilder().build();
        Model actualResponse = (Model)this.client.createModelAsync(parent, model).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateModelRequest actualRequest = (CreateModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createModelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Model model = Model.newBuilder().build();
            this.client.createModelAsync(parent, model).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listModelsTest() throws Exception {
        Model responsesElement = Model.newBuilder().build();
        ListModelsResponse expectedResponse = ListModelsResponse.newBuilder().setNextPageToken("").addAllModels(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranslationServiceClient.ListModelsPagedResponse pagedListResponse = this.client.listModels(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getModelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListModelsRequest actualRequest = (ListModelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listModelsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listModels(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listModelsTest2() throws Exception {
        Model responsesElement = Model.newBuilder().build();
        ListModelsResponse expectedResponse = ListModelsResponse.newBuilder().setNextPageToken("").addAllModels(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranslationServiceClient.ListModelsPagedResponse pagedListResponse = this.client.listModels(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getModelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListModelsRequest actualRequest = (ListModelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listModelsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listModels(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getModelTest() throws Exception {
        Model expectedResponse = Model.newBuilder().setName(ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]").toString()).setDisplayName("displayName1714148973").setDataset("dataset1443214456").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        ModelName name = ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]");
        Model actualResponse = this.client.getModel(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetModelRequest actualRequest = (GetModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getModelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            ModelName name = ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]");
            this.client.getModel(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getModelTest2() throws Exception {
        Model expectedResponse = Model.newBuilder().setName(ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]").toString()).setDisplayName("displayName1714148973").setDataset("dataset1443214456").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setTrainExampleCount(-1755438077).setValidateExampleCount(159308433).setTestExampleCount(483147021).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Model actualResponse = this.client.getModel(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetModelRequest actualRequest = (GetModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getModelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getModel(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteModelTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteModelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        ModelName name = ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]");
        this.client.deleteModelAsync(name).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteModelRequest actualRequest = (DeleteModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteModelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            ModelName name = ModelName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MODEL]");
            this.client.deleteModelAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteModelTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteModelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteModelAsync(name).get();
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteModelRequest actualRequest = (DeleteModelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteModelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteModelAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

