/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.translate.v3beta1.BatchDocumentOutputConfig;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateTextRequest;
import com.google.cloud.translate.v3beta1.CreateGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryResponse;
import com.google.cloud.translate.v3beta1.DetectLanguageRequest;
import com.google.cloud.translate.v3beta1.DetectLanguageResponse;
import com.google.cloud.translate.v3beta1.DocumentInputConfig;
import com.google.cloud.translate.v3beta1.DocumentOutputConfig;
import com.google.cloud.translate.v3beta1.DocumentTranslation;
import com.google.cloud.translate.v3beta1.GetGlossaryRequest;
import com.google.cloud.translate.v3beta1.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3beta1.Glossary;
import com.google.cloud.translate.v3beta1.GlossaryInputConfig;
import com.google.cloud.translate.v3beta1.GlossaryName;
import com.google.cloud.translate.v3beta1.ListGlossariesRequest;
import com.google.cloud.translate.v3beta1.ListGlossariesResponse;
import com.google.cloud.translate.v3beta1.LocationName;
import com.google.cloud.translate.v3beta1.MockTranslationService;
import com.google.cloud.translate.v3beta1.OutputConfig;
import com.google.cloud.translate.v3beta1.SupportedLanguages;
import com.google.cloud.translate.v3beta1.TranslateDocumentRequest;
import com.google.cloud.translate.v3beta1.TranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig;
import com.google.cloud.translate.v3beta1.TranslateTextRequest;
import com.google.cloud.translate.v3beta1.TranslateTextResponse;
import com.google.cloud.translate.v3beta1.TranslationServiceClient;
import com.google.cloud.translate.v3beta1.TranslationServiceSettings;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TranslationServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTranslationService mockTranslationService;
    private LocalChannelProvider channelProvider;
    private TranslationServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTranslationService = new MockTranslationService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTranslationService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TranslationServiceSettings settings = ((TranslationServiceSettings.Builder)((TranslationServiceSettings.Builder)TranslationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TranslationServiceClient.create((TranslationServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void translateTextTest() throws Exception {
        TranslateTextResponse expectedResponse = TranslateTextResponse.newBuilder().addAllTranslations(new ArrayList()).addAllGlossaryTranslations(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        TranslateTextRequest request = TranslateTextRequest.newBuilder().addAllContents(new ArrayList()).setMimeType("mimeType-1392120434").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).build();
        TranslateTextResponse actualResponse = this.client.translateText(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateTextRequest actualRequest = (TranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getContentsList(), (Object)actualRequest.getContentsList());
        Assert.assertEquals((Object)request.getMimeType(), (Object)actualRequest.getMimeType());
        Assert.assertEquals((Object)request.getSourceLanguageCode(), (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)request.getTargetLanguageCode(), (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getModel(), (Object)actualRequest.getModel());
        Assert.assertEquals((Object)request.getGlossaryConfig(), (Object)actualRequest.getGlossaryConfig());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateTextExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            TranslateTextRequest request = TranslateTextRequest.newBuilder().addAllContents(new ArrayList()).setMimeType("mimeType-1392120434").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).build();
            this.client.translateText(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        DetectLanguageResponse actualResponse = this.client.detectLanguage(parent, model, mimeType);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DetectLanguageRequest actualRequest = (DetectLanguageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void detectLanguageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            this.client.detectLanguage(parent, model, mimeType);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detectLanguageTest2() throws Exception {
        DetectLanguageResponse expectedResponse = DetectLanguageResponse.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String model = "model104069929";
        String mimeType = "mimeType-1392120434";
        DetectLanguageResponse actualResponse = this.client.detectLanguage(parent, model, mimeType);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DetectLanguageRequest actualRequest = (DetectLanguageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertEquals((Object)mimeType, (Object)actualRequest.getMimeType());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void detectLanguageExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String model = "model104069929";
            String mimeType = "mimeType-1392120434";
            this.client.detectLanguage(parent, model, mimeType);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String displayLanguageCode = "displayLanguageCode-1457478841";
        String model = "model104069929";
        SupportedLanguages actualResponse = this.client.getSupportedLanguages(parent, displayLanguageCode, model);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSupportedLanguagesRequest actualRequest = (GetSupportedLanguagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)displayLanguageCode, (Object)actualRequest.getDisplayLanguageCode());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSupportedLanguagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String displayLanguageCode = "displayLanguageCode-1457478841";
            String model = "model104069929";
            this.client.getSupportedLanguages(parent, displayLanguageCode, model);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSupportedLanguagesTest2() throws Exception {
        SupportedLanguages expectedResponse = SupportedLanguages.newBuilder().addAllLanguages(new ArrayList()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String displayLanguageCode = "displayLanguageCode-1457478841";
        String model = "model104069929";
        SupportedLanguages actualResponse = this.client.getSupportedLanguages(parent, displayLanguageCode, model);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSupportedLanguagesRequest actualRequest = (GetSupportedLanguagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)displayLanguageCode, (Object)actualRequest.getDisplayLanguageCode());
        Assert.assertEquals((Object)model, (Object)actualRequest.getModel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSupportedLanguagesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String displayLanguageCode = "displayLanguageCode-1457478841";
            String model = "model104069929";
            this.client.getSupportedLanguages(parent, displayLanguageCode, model);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void translateDocumentTest() throws Exception {
        TranslateDocumentResponse expectedResponse = TranslateDocumentResponse.newBuilder().setDocumentTranslation(DocumentTranslation.newBuilder().build()).setGlossaryDocumentTranslation(DocumentTranslation.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("parent-995424086").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
        TranslateDocumentResponse actualResponse = this.client.translateDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TranslateDocumentRequest actualRequest = (TranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSourceLanguageCode(), (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)request.getTargetLanguageCode(), (Object)actualRequest.getTargetLanguageCode());
        Assert.assertEquals((Object)request.getDocumentInputConfig(), (Object)actualRequest.getDocumentInputConfig());
        Assert.assertEquals((Object)request.getDocumentOutputConfig(), (Object)actualRequest.getDocumentOutputConfig());
        Assert.assertEquals((Object)request.getModel(), (Object)actualRequest.getModel());
        Assert.assertEquals((Object)request.getGlossaryConfig(), (Object)actualRequest.getGlossaryConfig());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertEquals((Object)request.getCustomizedAttribution(), (Object)actualRequest.getCustomizedAttribution());
        Assert.assertEquals((Object)request.getIsTranslateNativePdfOnly(), (Object)actualRequest.getIsTranslateNativePdfOnly());
        Assert.assertEquals((Object)request.getEnableShadowRemovalNativePdf(), (Object)actualRequest.getEnableShadowRemovalNativePdf());
        Assert.assertEquals((Object)request.getEnableRotationCorrection(), (Object)actualRequest.getEnableRotationCorrection());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void translateDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            TranslateDocumentRequest request = TranslateDocumentRequest.newBuilder().setParent("parent-995424086").setSourceLanguageCode("sourceLanguageCode1645917472").setTargetLanguageCode("targetLanguageCode-106414698").setDocumentInputConfig(DocumentInputConfig.newBuilder().build()).setDocumentOutputConfig(DocumentOutputConfig.newBuilder().build()).setModel("model104069929").setGlossaryConfig(TranslateTextGlossaryConfig.newBuilder().build()).putAllLabels(new HashMap()).setCustomizedAttribution("customizedAttribution557650238").setIsTranslateNativePdfOnly(true).setEnableShadowRemovalNativePdf(true).setEnableRotationCorrection(true).build();
            this.client.translateDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchTranslateTextTest() throws Exception {
        BatchTranslateResponse expectedResponse = BatchTranslateResponse.newBuilder().setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateTextTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
        BatchTranslateResponse actualResponse = (BatchTranslateResponse)this.client.batchTranslateTextAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateTextRequest actualRequest = (BatchTranslateTextRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSourceLanguageCode(), (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals((Object)request.getTargetLanguageCodesList(), (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals((Object)request.getModelsMap(), (Object)actualRequest.getModelsMap());
        Assert.assertEquals((Object)request.getInputConfigsList(), (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)request.getOutputConfig(), (Object)actualRequest.getOutputConfig());
        Assert.assertEquals((Object)request.getGlossariesMap(), (Object)actualRequest.getGlossariesMap());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateTextExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            BatchTranslateTextRequest request = BatchTranslateTextRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setSourceLanguageCode("sourceLanguageCode1645917472").addAllTargetLanguageCodes(new ArrayList()).putAllModels(new HashMap()).addAllInputConfigs(new ArrayList()).setOutputConfig(OutputConfig.newBuilder().build()).putAllGlossaries(new HashMap()).putAllLabels(new HashMap()).build();
            this.client.batchTranslateTextAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchTranslateDocumentTest() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateDocumentRequest actualRequest = (BatchTranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals(targetLanguageCodes, (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals(inputConfigs, (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchTranslateDocumentTest2() throws Exception {
        BatchTranslateDocumentResponse expectedResponse = BatchTranslateDocumentResponse.newBuilder().setTotalPages(-396186871L).setTranslatedPages(-1652747493L).setFailedPages(-2002254526L).setTotalBillablePages(1292117569L).setTotalCharacters(-1368640955L).setTranslatedCharacters(-1337326221L).setFailedCharacters(1723028396L).setTotalBillableCharacters(1242495501L).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchTranslateDocumentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String sourceLanguageCode = "sourceLanguageCode1645917472";
        ArrayList targetLanguageCodes = new ArrayList();
        ArrayList inputConfigs = new ArrayList();
        BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
        BatchTranslateDocumentResponse actualResponse = (BatchTranslateDocumentResponse)this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchTranslateDocumentRequest actualRequest = (BatchTranslateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)sourceLanguageCode, (Object)actualRequest.getSourceLanguageCode());
        Assert.assertEquals(targetLanguageCodes, (Object)actualRequest.getTargetLanguageCodesList());
        Assert.assertEquals(inputConfigs, (Object)actualRequest.getInputConfigsList());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchTranslateDocumentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String sourceLanguageCode = "sourceLanguageCode1645917472";
            ArrayList targetLanguageCodes = new ArrayList();
            ArrayList inputConfigs = new ArrayList();
            BatchDocumentOutputConfig outputConfig = BatchDocumentOutputConfig.newBuilder().build();
            this.client.batchTranslateDocumentAsync(parent, sourceLanguageCode, targetLanguageCodes, inputConfigs, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)this.client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryRequest actualRequest = (CreateGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossary, (Object)actualRequest.getGlossary());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Glossary glossary = Glossary.newBuilder().build();
            this.client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Glossary glossary = Glossary.newBuilder().build();
        Glossary actualResponse = (Glossary)this.client.createGlossaryAsync(parent, glossary).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGlossaryRequest actualRequest = (CreateGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)glossary, (Object)actualRequest.getGlossary());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Glossary glossary = Glossary.newBuilder().build();
            this.client.createGlossaryAsync(parent, glossary).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listGlossariesTest() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String filter = "filter-1274492040";
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = this.client.listGlossaries(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossariesRequest actualRequest = (ListGlossariesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossariesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String filter = "filter-1274492040";
            this.client.listGlossaries(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGlossariesTest2() throws Exception {
        Glossary responsesElement = Glossary.newBuilder().build();
        ListGlossariesResponse expectedResponse = ListGlossariesResponse.newBuilder().setNextPageToken("").addAllGlossaries(Arrays.asList(responsesElement)).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String filter = "filter-1274492040";
        TranslationServiceClient.ListGlossariesPagedResponse pagedListResponse = this.client.listGlossaries(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGlossariesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGlossariesRequest actualRequest = (ListGlossariesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGlossariesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String filter = "filter-1274492040";
            this.client.listGlossaries(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        Glossary actualResponse = this.client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryRequest actualRequest = (GetGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            this.client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGlossaryTest2() throws Exception {
        Glossary expectedResponse = Glossary.newBuilder().setName(GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]").toString()).setInputConfig(GlossaryInputConfig.newBuilder().build()).setEntryCount(-811131134).setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockTranslationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Glossary actualResponse = this.client.getGlossary(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGlossaryRequest actualRequest = (GetGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGlossary(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGlossaryTest() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)this.client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryRequest actualRequest = (DeleteGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            GlossaryName name = GlossaryName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GLOSSARY]");
            this.client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGlossaryTest2() throws Exception {
        DeleteGlossaryResponse expectedResponse = DeleteGlossaryResponse.newBuilder().setName("name3373707").setSubmitTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGlossaryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTranslationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        DeleteGlossaryResponse actualResponse = (DeleteGlossaryResponse)this.client.deleteGlossaryAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranslationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGlossaryRequest actualRequest = (DeleteGlossaryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGlossaryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranslationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGlossaryAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

