/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3.AdaptiveMtDataset;
import com.google.cloud.translate.v3.AdaptiveMtDatasetName;
import com.google.cloud.translate.v3.AdaptiveMtFile;
import com.google.cloud.translate.v3.AdaptiveMtFileName;
import com.google.cloud.translate.v3.AdaptiveMtSentence;
import com.google.cloud.translate.v3.AdaptiveMtTranslateRequest;
import com.google.cloud.translate.v3.AdaptiveMtTranslateResponse;
import com.google.cloud.translate.v3.BatchDocumentInputConfig;
import com.google.cloud.translate.v3.BatchDocumentOutputConfig;
import com.google.cloud.translate.v3.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateMetadata;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.CreateDatasetMetadata;
import com.google.cloud.translate.v3.CreateDatasetRequest;
import com.google.cloud.translate.v3.CreateGlossaryEntryRequest;
import com.google.cloud.translate.v3.CreateGlossaryMetadata;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.CreateModelMetadata;
import com.google.cloud.translate.v3.CreateModelRequest;
import com.google.cloud.translate.v3.Dataset;
import com.google.cloud.translate.v3.DatasetInputConfig;
import com.google.cloud.translate.v3.DatasetName;
import com.google.cloud.translate.v3.DatasetOutputConfig;
import com.google.cloud.translate.v3.DeleteAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.DeleteAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.DeleteDatasetMetadata;
import com.google.cloud.translate.v3.DeleteDatasetRequest;
import com.google.cloud.translate.v3.DeleteGlossaryEntryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DeleteModelMetadata;
import com.google.cloud.translate.v3.DeleteModelRequest;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.Example;
import com.google.cloud.translate.v3.ExportDataMetadata;
import com.google.cloud.translate.v3.ExportDataRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.GetDatasetRequest;
import com.google.cloud.translate.v3.GetGlossaryEntryRequest;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetModelRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.GlossaryEntry;
import com.google.cloud.translate.v3.GlossaryEntryName;
import com.google.cloud.translate.v3.GlossaryName;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileResponse;
import com.google.cloud.translate.v3.ImportDataMetadata;
import com.google.cloud.translate.v3.ImportDataRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesResponse;
import com.google.cloud.translate.v3.ListDatasetsRequest;
import com.google.cloud.translate.v3.ListDatasetsResponse;
import com.google.cloud.translate.v3.ListExamplesRequest;
import com.google.cloud.translate.v3.ListExamplesResponse;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.ListGlossaryEntriesRequest;
import com.google.cloud.translate.v3.ListGlossaryEntriesResponse;
import com.google.cloud.translate.v3.ListModelsRequest;
import com.google.cloud.translate.v3.ListModelsResponse;
import com.google.cloud.translate.v3.LocationName;
import com.google.cloud.translate.v3.Model;
import com.google.cloud.translate.v3.ModelName;
import com.google.cloud.translate.v3.RomanizeTextRequest;
import com.google.cloud.translate.v3.RomanizeTextResponse;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceSettings;
import com.google.cloud.translate.v3.UpdateGlossaryEntryRequest;
import com.google.cloud.translate.v3.UpdateGlossaryMetadata;
import com.google.cloud.translate.v3.UpdateGlossaryRequest;
import com.google.cloud.translate.v3.stub.TranslationServiceStub;
import com.google.cloud.translate.v3.stub.TranslationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TranslationServiceClient
implements BackgroundResource {
    private final TranslationServiceSettings settings;
    private final TranslationServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final TranslationServiceClient create() throws IOException {
        return TranslationServiceClient.create(TranslationServiceSettings.newBuilder().build());
    }

    public static final TranslationServiceClient create(TranslationServiceSettings settings) throws IOException {
        return new TranslationServiceClient(settings);
    }

    public static final TranslationServiceClient create(TranslationServiceStub stub) {
        return new TranslationServiceClient(stub);
    }

    protected TranslationServiceClient(TranslationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TranslationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected TranslationServiceClient(TranslationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final TranslationServiceSettings getSettings() {
        return this.settings;
    }

    public TranslationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final TranslateTextResponse translateText(LocationName parent, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(String parent, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(LocationName parent, String model, String mimeType, String sourceLanguageCode, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setMimeType(mimeType).setSourceLanguageCode(sourceLanguageCode).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(String parent, String model, String mimeType, String sourceLanguageCode, String targetLanguageCode, List<String> contents) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(parent).setModel(model).setMimeType(mimeType).setSourceLanguageCode(sourceLanguageCode).setTargetLanguageCode(targetLanguageCode).addAllContents(contents).build();
        return this.translateText(request);
    }

    public final TranslateTextResponse translateText(TranslateTextRequest request) {
        return (TranslateTextResponse)this.translateTextCallable().call((Object)request);
    }

    public final UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable() {
        return this.stub.translateTextCallable();
    }

    public final RomanizeTextResponse romanizeText(LocationName parent, List<String> contents) {
        RomanizeTextRequest request = RomanizeTextRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllContents(contents).build();
        return this.romanizeText(request);
    }

    public final RomanizeTextResponse romanizeText(String parent, List<String> contents) {
        RomanizeTextRequest request = RomanizeTextRequest.newBuilder().setParent(parent).addAllContents(contents).build();
        return this.romanizeText(request);
    }

    public final RomanizeTextResponse romanizeText(RomanizeTextRequest request) {
        return (RomanizeTextResponse)this.romanizeTextCallable().call((Object)request);
    }

    public final UnaryCallable<RomanizeTextRequest, RomanizeTextResponse> romanizeTextCallable() {
        return this.stub.romanizeTextCallable();
    }

    public final DetectLanguageResponse detectLanguage(LocationName parent, String model, String mimeType, String content) {
        DetectLanguageRequest request = DetectLanguageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setMimeType(mimeType).setContent(content).build();
        return this.detectLanguage(request);
    }

    public final DetectLanguageResponse detectLanguage(String parent, String model, String mimeType, String content) {
        DetectLanguageRequest request = DetectLanguageRequest.newBuilder().setParent(parent).setModel(model).setMimeType(mimeType).setContent(content).build();
        return this.detectLanguage(request);
    }

    public final DetectLanguageResponse detectLanguage(DetectLanguageRequest request) {
        return (DetectLanguageResponse)this.detectLanguageCallable().call((Object)request);
    }

    public final UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable() {
        return this.stub.detectLanguageCallable();
    }

    public final SupportedLanguages getSupportedLanguages(LocationName parent, String model, String displayLanguageCode) {
        GetSupportedLanguagesRequest request = GetSupportedLanguagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setDisplayLanguageCode(displayLanguageCode).build();
        return this.getSupportedLanguages(request);
    }

    public final SupportedLanguages getSupportedLanguages(String parent, String model, String displayLanguageCode) {
        GetSupportedLanguagesRequest request = GetSupportedLanguagesRequest.newBuilder().setParent(parent).setModel(model).setDisplayLanguageCode(displayLanguageCode).build();
        return this.getSupportedLanguages(request);
    }

    public final SupportedLanguages getSupportedLanguages(GetSupportedLanguagesRequest request) {
        return (SupportedLanguages)this.getSupportedLanguagesCallable().call((Object)request);
    }

    public final UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable() {
        return this.stub.getSupportedLanguagesCallable();
    }

    public final TranslateDocumentResponse translateDocument(TranslateDocumentRequest request) {
        return (TranslateDocumentResponse)this.translateDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable() {
        return this.stub.translateDocumentCallable();
    }

    public final OperationFuture<BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextAsync(BatchTranslateTextRequest request) {
        return this.batchTranslateTextOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable() {
        return this.stub.batchTranslateTextOperationCallable();
    }

    public final UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable() {
        return this.stub.batchTranslateTextCallable();
    }

    public final OperationFuture<BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentAsync(LocationName parent, String sourceLanguageCode, List<String> targetLanguageCodes, List<BatchDocumentInputConfig> inputConfigs, BatchDocumentOutputConfig outputConfig) {
        BatchTranslateDocumentRequest request = BatchTranslateDocumentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceLanguageCode(sourceLanguageCode).addAllTargetLanguageCodes(targetLanguageCodes).addAllInputConfigs(inputConfigs).setOutputConfig(outputConfig).build();
        return this.batchTranslateDocumentAsync(request);
    }

    public final OperationFuture<BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentAsync(String parent, String sourceLanguageCode, List<String> targetLanguageCodes, List<BatchDocumentInputConfig> inputConfigs, BatchDocumentOutputConfig outputConfig) {
        BatchTranslateDocumentRequest request = BatchTranslateDocumentRequest.newBuilder().setParent(parent).setSourceLanguageCode(sourceLanguageCode).addAllTargetLanguageCodes(targetLanguageCodes).addAllInputConfigs(inputConfigs).setOutputConfig(outputConfig).build();
        return this.batchTranslateDocumentAsync(request);
    }

    public final OperationFuture<BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentAsync(BatchTranslateDocumentRequest request) {
        return this.batchTranslateDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable() {
        return this.stub.batchTranslateDocumentOperationCallable();
    }

    public final UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable() {
        return this.stub.batchTranslateDocumentCallable();
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(LocationName parent, Glossary glossary) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGlossary(glossary).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(String parent, Glossary glossary) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent).setGlossary(glossary).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, CreateGlossaryMetadata> createGlossaryAsync(CreateGlossaryRequest request) {
        return this.createGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable() {
        return this.stub.createGlossaryOperationCallable();
    }

    public final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.stub.createGlossaryCallable();
    }

    public final OperationFuture<Glossary, UpdateGlossaryMetadata> updateGlossaryAsync(Glossary glossary, FieldMask updateMask) {
        UpdateGlossaryRequest request = UpdateGlossaryRequest.newBuilder().setGlossary(glossary).setUpdateMask(updateMask).build();
        return this.updateGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, UpdateGlossaryMetadata> updateGlossaryAsync(UpdateGlossaryRequest request) {
        return this.updateGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGlossaryRequest, Glossary, UpdateGlossaryMetadata> updateGlossaryOperationCallable() {
        return this.stub.updateGlossaryOperationCallable();
    }

    public final UnaryCallable<UpdateGlossaryRequest, Operation> updateGlossaryCallable() {
        return this.stub.updateGlossaryCallable();
    }

    public final ListGlossariesPagedResponse listGlossaries(LocationName parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(String parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(ListGlossariesRequest request) {
        return (ListGlossariesPagedResponse)((Object)this.listGlossariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.stub.listGlossariesPagedCallable();
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.stub.listGlossariesCallable();
    }

    public final Glossary getGlossary(GlossaryName name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(String name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(GetGlossaryRequest request) {
        return (Glossary)this.getGlossaryCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.stub.getGlossaryCallable();
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(GlossaryName name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(String name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryAsync(DeleteGlossaryRequest request) {
        return this.deleteGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable() {
        return this.stub.deleteGlossaryOperationCallable();
    }

    public final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.stub.deleteGlossaryCallable();
    }

    public final GlossaryEntry getGlossaryEntry(GlossaryEntryName name) {
        GetGlossaryEntryRequest request = GetGlossaryEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossaryEntry(request);
    }

    public final GlossaryEntry getGlossaryEntry(String name) {
        GetGlossaryEntryRequest request = GetGlossaryEntryRequest.newBuilder().setName(name).build();
        return this.getGlossaryEntry(request);
    }

    public final GlossaryEntry getGlossaryEntry(GetGlossaryEntryRequest request) {
        return (GlossaryEntry)this.getGlossaryEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryEntryRequest, GlossaryEntry> getGlossaryEntryCallable() {
        return this.stub.getGlossaryEntryCallable();
    }

    public final ListGlossaryEntriesPagedResponse listGlossaryEntries(GlossaryName parent) {
        ListGlossaryEntriesRequest request = ListGlossaryEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaryEntries(request);
    }

    public final ListGlossaryEntriesPagedResponse listGlossaryEntries(String parent) {
        ListGlossaryEntriesRequest request = ListGlossaryEntriesRequest.newBuilder().setParent(parent).build();
        return this.listGlossaryEntries(request);
    }

    public final ListGlossaryEntriesPagedResponse listGlossaryEntries(ListGlossaryEntriesRequest request) {
        return (ListGlossaryEntriesPagedResponse)((Object)this.listGlossaryEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossaryEntriesRequest, ListGlossaryEntriesPagedResponse> listGlossaryEntriesPagedCallable() {
        return this.stub.listGlossaryEntriesPagedCallable();
    }

    public final UnaryCallable<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse> listGlossaryEntriesCallable() {
        return this.stub.listGlossaryEntriesCallable();
    }

    public final GlossaryEntry createGlossaryEntry(GlossaryName parent, GlossaryEntry glossaryEntry) {
        CreateGlossaryEntryRequest request = CreateGlossaryEntryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGlossaryEntry(glossaryEntry).build();
        return this.createGlossaryEntry(request);
    }

    public final GlossaryEntry createGlossaryEntry(String parent, GlossaryEntry glossaryEntry) {
        CreateGlossaryEntryRequest request = CreateGlossaryEntryRequest.newBuilder().setParent(parent).setGlossaryEntry(glossaryEntry).build();
        return this.createGlossaryEntry(request);
    }

    public final GlossaryEntry createGlossaryEntry(CreateGlossaryEntryRequest request) {
        return (GlossaryEntry)this.createGlossaryEntryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGlossaryEntryRequest, GlossaryEntry> createGlossaryEntryCallable() {
        return this.stub.createGlossaryEntryCallable();
    }

    public final GlossaryEntry updateGlossaryEntry(GlossaryEntry glossaryEntry) {
        UpdateGlossaryEntryRequest request = UpdateGlossaryEntryRequest.newBuilder().setGlossaryEntry(glossaryEntry).build();
        return this.updateGlossaryEntry(request);
    }

    public final GlossaryEntry updateGlossaryEntry(UpdateGlossaryEntryRequest request) {
        return (GlossaryEntry)this.updateGlossaryEntryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGlossaryEntryRequest, GlossaryEntry> updateGlossaryEntryCallable() {
        return this.stub.updateGlossaryEntryCallable();
    }

    public final void deleteGlossaryEntry(GlossaryEntryName name) {
        DeleteGlossaryEntryRequest request = DeleteGlossaryEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGlossaryEntry(request);
    }

    public final void deleteGlossaryEntry(String name) {
        DeleteGlossaryEntryRequest request = DeleteGlossaryEntryRequest.newBuilder().setName(name).build();
        this.deleteGlossaryEntry(request);
    }

    public final void deleteGlossaryEntry(DeleteGlossaryEntryRequest request) {
        this.deleteGlossaryEntryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlossaryEntryRequest, Empty> deleteGlossaryEntryCallable() {
        return this.stub.deleteGlossaryEntryCallable();
    }

    public final OperationFuture<Dataset, CreateDatasetMetadata> createDatasetAsync(LocationName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, CreateDatasetMetadata> createDatasetAsync(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, CreateDatasetMetadata> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetMetadata> createDatasetOperationCallable() {
        return this.stub.createDatasetOperationCallable();
    }

    public final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(LocationName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final OperationFuture<Empty, DeleteDatasetMetadata> deleteDatasetAsync(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteDatasetMetadata> deleteDatasetAsync(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteDatasetMetadata> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatasetRequest, Empty, DeleteDatasetMetadata> deleteDatasetOperationCallable() {
        return this.stub.deleteDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final AdaptiveMtDataset createAdaptiveMtDataset(LocationName parent, AdaptiveMtDataset adaptiveMtDataset) {
        CreateAdaptiveMtDatasetRequest request = CreateAdaptiveMtDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAdaptiveMtDataset(adaptiveMtDataset).build();
        return this.createAdaptiveMtDataset(request);
    }

    public final AdaptiveMtDataset createAdaptiveMtDataset(String parent, AdaptiveMtDataset adaptiveMtDataset) {
        CreateAdaptiveMtDatasetRequest request = CreateAdaptiveMtDatasetRequest.newBuilder().setParent(parent).setAdaptiveMtDataset(adaptiveMtDataset).build();
        return this.createAdaptiveMtDataset(request);
    }

    public final AdaptiveMtDataset createAdaptiveMtDataset(CreateAdaptiveMtDatasetRequest request) {
        return (AdaptiveMtDataset)this.createAdaptiveMtDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetCallable() {
        return this.stub.createAdaptiveMtDatasetCallable();
    }

    public final void deleteAdaptiveMtDataset(AdaptiveMtDatasetName name) {
        DeleteAdaptiveMtDatasetRequest request = DeleteAdaptiveMtDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAdaptiveMtDataset(request);
    }

    public final void deleteAdaptiveMtDataset(String name) {
        DeleteAdaptiveMtDatasetRequest request = DeleteAdaptiveMtDatasetRequest.newBuilder().setName(name).build();
        this.deleteAdaptiveMtDataset(request);
    }

    public final void deleteAdaptiveMtDataset(DeleteAdaptiveMtDatasetRequest request) {
        this.deleteAdaptiveMtDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetCallable() {
        return this.stub.deleteAdaptiveMtDatasetCallable();
    }

    public final AdaptiveMtDataset getAdaptiveMtDataset(AdaptiveMtDatasetName name) {
        GetAdaptiveMtDatasetRequest request = GetAdaptiveMtDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAdaptiveMtDataset(request);
    }

    public final AdaptiveMtDataset getAdaptiveMtDataset(String name) {
        GetAdaptiveMtDatasetRequest request = GetAdaptiveMtDatasetRequest.newBuilder().setName(name).build();
        return this.getAdaptiveMtDataset(request);
    }

    public final AdaptiveMtDataset getAdaptiveMtDataset(GetAdaptiveMtDatasetRequest request) {
        return (AdaptiveMtDataset)this.getAdaptiveMtDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetCallable() {
        return this.stub.getAdaptiveMtDatasetCallable();
    }

    public final ListAdaptiveMtDatasetsPagedResponse listAdaptiveMtDatasets(LocationName parent) {
        ListAdaptiveMtDatasetsRequest request = ListAdaptiveMtDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdaptiveMtDatasets(request);
    }

    public final ListAdaptiveMtDatasetsPagedResponse listAdaptiveMtDatasets(String parent) {
        ListAdaptiveMtDatasetsRequest request = ListAdaptiveMtDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listAdaptiveMtDatasets(request);
    }

    public final ListAdaptiveMtDatasetsPagedResponse listAdaptiveMtDatasets(ListAdaptiveMtDatasetsRequest request) {
        return (ListAdaptiveMtDatasetsPagedResponse)((Object)this.listAdaptiveMtDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsPagedCallable() {
        return this.stub.listAdaptiveMtDatasetsPagedCallable();
    }

    public final UnaryCallable<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse> listAdaptiveMtDatasetsCallable() {
        return this.stub.listAdaptiveMtDatasetsCallable();
    }

    public final AdaptiveMtTranslateResponse adaptiveMtTranslate(LocationName parent, List<String> content) {
        AdaptiveMtTranslateRequest request = AdaptiveMtTranslateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllContent(content).build();
        return this.adaptiveMtTranslate(request);
    }

    public final AdaptiveMtTranslateResponse adaptiveMtTranslate(String parent, List<String> content) {
        AdaptiveMtTranslateRequest request = AdaptiveMtTranslateRequest.newBuilder().setParent(parent).addAllContent(content).build();
        return this.adaptiveMtTranslate(request);
    }

    public final AdaptiveMtTranslateResponse adaptiveMtTranslate(AdaptiveMtTranslateRequest request) {
        return (AdaptiveMtTranslateResponse)this.adaptiveMtTranslateCallable().call((Object)request);
    }

    public final UnaryCallable<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateCallable() {
        return this.stub.adaptiveMtTranslateCallable();
    }

    public final AdaptiveMtFile getAdaptiveMtFile(AdaptiveMtFileName name) {
        GetAdaptiveMtFileRequest request = GetAdaptiveMtFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAdaptiveMtFile(request);
    }

    public final AdaptiveMtFile getAdaptiveMtFile(String name) {
        GetAdaptiveMtFileRequest request = GetAdaptiveMtFileRequest.newBuilder().setName(name).build();
        return this.getAdaptiveMtFile(request);
    }

    public final AdaptiveMtFile getAdaptiveMtFile(GetAdaptiveMtFileRequest request) {
        return (AdaptiveMtFile)this.getAdaptiveMtFileCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileCallable() {
        return this.stub.getAdaptiveMtFileCallable();
    }

    public final void deleteAdaptiveMtFile(AdaptiveMtFileName name) {
        DeleteAdaptiveMtFileRequest request = DeleteAdaptiveMtFileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAdaptiveMtFile(request);
    }

    public final void deleteAdaptiveMtFile(String name) {
        DeleteAdaptiveMtFileRequest request = DeleteAdaptiveMtFileRequest.newBuilder().setName(name).build();
        this.deleteAdaptiveMtFile(request);
    }

    public final void deleteAdaptiveMtFile(DeleteAdaptiveMtFileRequest request) {
        this.deleteAdaptiveMtFileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileCallable() {
        return this.stub.deleteAdaptiveMtFileCallable();
    }

    public final ImportAdaptiveMtFileResponse importAdaptiveMtFile(AdaptiveMtDatasetName parent) {
        ImportAdaptiveMtFileRequest request = ImportAdaptiveMtFileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.importAdaptiveMtFile(request);
    }

    public final ImportAdaptiveMtFileResponse importAdaptiveMtFile(String parent) {
        ImportAdaptiveMtFileRequest request = ImportAdaptiveMtFileRequest.newBuilder().setParent(parent).build();
        return this.importAdaptiveMtFile(request);
    }

    public final ImportAdaptiveMtFileResponse importAdaptiveMtFile(ImportAdaptiveMtFileRequest request) {
        return (ImportAdaptiveMtFileResponse)this.importAdaptiveMtFileCallable().call((Object)request);
    }

    public final UnaryCallable<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileCallable() {
        return this.stub.importAdaptiveMtFileCallable();
    }

    public final ListAdaptiveMtFilesPagedResponse listAdaptiveMtFiles(AdaptiveMtDatasetName parent) {
        ListAdaptiveMtFilesRequest request = ListAdaptiveMtFilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdaptiveMtFiles(request);
    }

    public final ListAdaptiveMtFilesPagedResponse listAdaptiveMtFiles(String parent) {
        ListAdaptiveMtFilesRequest request = ListAdaptiveMtFilesRequest.newBuilder().setParent(parent).build();
        return this.listAdaptiveMtFiles(request);
    }

    public final ListAdaptiveMtFilesPagedResponse listAdaptiveMtFiles(ListAdaptiveMtFilesRequest request) {
        return (ListAdaptiveMtFilesPagedResponse)((Object)this.listAdaptiveMtFilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesPagedCallable() {
        return this.stub.listAdaptiveMtFilesPagedCallable();
    }

    public final UnaryCallable<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse> listAdaptiveMtFilesCallable() {
        return this.stub.listAdaptiveMtFilesCallable();
    }

    public final ListAdaptiveMtSentencesPagedResponse listAdaptiveMtSentences(AdaptiveMtFileName parent) {
        ListAdaptiveMtSentencesRequest request = ListAdaptiveMtSentencesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdaptiveMtSentences(request);
    }

    public final ListAdaptiveMtSentencesPagedResponse listAdaptiveMtSentences(String parent) {
        ListAdaptiveMtSentencesRequest request = ListAdaptiveMtSentencesRequest.newBuilder().setParent(parent).build();
        return this.listAdaptiveMtSentences(request);
    }

    public final ListAdaptiveMtSentencesPagedResponse listAdaptiveMtSentences(ListAdaptiveMtSentencesRequest request) {
        return (ListAdaptiveMtSentencesPagedResponse)((Object)this.listAdaptiveMtSentencesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesPagedCallable() {
        return this.stub.listAdaptiveMtSentencesPagedCallable();
    }

    public final UnaryCallable<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse> listAdaptiveMtSentencesCallable() {
        return this.stub.listAdaptiveMtSentencesCallable();
    }

    public final OperationFuture<Empty, ImportDataMetadata> importDataAsync(String dataset, DatasetInputConfig inputConfig) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setDataset(dataset).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    public final OperationFuture<Empty, ImportDataMetadata> importDataAsync(ImportDataRequest request) {
        return this.importDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDataRequest, Empty, ImportDataMetadata> importDataOperationCallable() {
        return this.stub.importDataOperationCallable();
    }

    public final UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.stub.importDataCallable();
    }

    public final OperationFuture<Empty, ExportDataMetadata> exportDataAsync(String dataset, DatasetOutputConfig outputConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setDataset(dataset).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    public final OperationFuture<Empty, ExportDataMetadata> exportDataAsync(ExportDataRequest request) {
        return this.exportDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportDataRequest, Empty, ExportDataMetadata> exportDataOperationCallable() {
        return this.stub.exportDataOperationCallable();
    }

    public final UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.stub.exportDataCallable();
    }

    public final ListExamplesPagedResponse listExamples(DatasetName parent) {
        ListExamplesRequest request = ListExamplesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExamples(request);
    }

    public final ListExamplesPagedResponse listExamples(String parent) {
        ListExamplesRequest request = ListExamplesRequest.newBuilder().setParent(parent).build();
        return this.listExamples(request);
    }

    public final ListExamplesPagedResponse listExamples(ListExamplesRequest request) {
        return (ListExamplesPagedResponse)((Object)this.listExamplesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesPagedResponse> listExamplesPagedCallable() {
        return this.stub.listExamplesPagedCallable();
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesResponse> listExamplesCallable() {
        return this.stub.listExamplesCallable();
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(LocationName parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(String parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(CreateModelRequest request) {
        return this.createModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable() {
        return this.stub.createModelOperationCallable();
    }

    public final UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.stub.createModelCallable();
    }

    public final ListModelsPagedResponse listModels(LocationName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final OperationFuture<Empty, DeleteModelMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteModelMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteModelMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelRequest, Empty, DeleteModelMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelsPagedResponse((ListModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExamplesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        private ListExamplesFixedSizeCollection(List<ListExamplesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExamplesFixedSizeCollection createEmptyCollection() {
            return new ListExamplesFixedSizeCollection(null, 0);
        }

        protected ListExamplesFixedSizeCollection createCollection(List<ListExamplesPage> pages, int collectionSize) {
            return new ListExamplesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExamplesPage
    extends AbstractPage<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage> {
        private ListExamplesPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            super(context, (Object)response);
        }

        private static ListExamplesPage createEmptyPage() {
            return new ListExamplesPage(null, null);
        }

        protected ListExamplesPage createPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            return new ListExamplesPage(context, response);
        }

        public ApiFuture<ListExamplesPage> createPageAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExamplesPagedResponse
    extends AbstractPagedListResponse<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        public static ApiFuture<ListExamplesPagedResponse> createAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            ApiFuture<ListExamplesPage> futurePage = ListExamplesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExamplesPagedResponse((ListExamplesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExamplesPagedResponse(ListExamplesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExamplesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAdaptiveMtSentencesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence, ListAdaptiveMtSentencesPage, ListAdaptiveMtSentencesFixedSizeCollection> {
        private ListAdaptiveMtSentencesFixedSizeCollection(List<ListAdaptiveMtSentencesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdaptiveMtSentencesFixedSizeCollection createEmptyCollection() {
            return new ListAdaptiveMtSentencesFixedSizeCollection(null, 0);
        }

        protected ListAdaptiveMtSentencesFixedSizeCollection createCollection(List<ListAdaptiveMtSentencesPage> pages, int collectionSize) {
            return new ListAdaptiveMtSentencesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdaptiveMtSentencesPage
    extends AbstractPage<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence, ListAdaptiveMtSentencesPage> {
        private ListAdaptiveMtSentencesPage(PageContext<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence> context, ListAdaptiveMtSentencesResponse response) {
            super(context, (Object)response);
        }

        private static ListAdaptiveMtSentencesPage createEmptyPage() {
            return new ListAdaptiveMtSentencesPage(null, null);
        }

        protected ListAdaptiveMtSentencesPage createPage(PageContext<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence> context, ListAdaptiveMtSentencesResponse response) {
            return new ListAdaptiveMtSentencesPage(context, response);
        }

        public ApiFuture<ListAdaptiveMtSentencesPage> createPageAsync(PageContext<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence> context, ApiFuture<ListAdaptiveMtSentencesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdaptiveMtSentencesPagedResponse
    extends AbstractPagedListResponse<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence, ListAdaptiveMtSentencesPage, ListAdaptiveMtSentencesFixedSizeCollection> {
        public static ApiFuture<ListAdaptiveMtSentencesPagedResponse> createAsync(PageContext<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse, AdaptiveMtSentence> context, ApiFuture<ListAdaptiveMtSentencesResponse> futureResponse) {
            ApiFuture<ListAdaptiveMtSentencesPage> futurePage = ListAdaptiveMtSentencesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdaptiveMtSentencesPagedResponse((ListAdaptiveMtSentencesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdaptiveMtSentencesPagedResponse(ListAdaptiveMtSentencesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdaptiveMtSentencesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAdaptiveMtFilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile, ListAdaptiveMtFilesPage, ListAdaptiveMtFilesFixedSizeCollection> {
        private ListAdaptiveMtFilesFixedSizeCollection(List<ListAdaptiveMtFilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdaptiveMtFilesFixedSizeCollection createEmptyCollection() {
            return new ListAdaptiveMtFilesFixedSizeCollection(null, 0);
        }

        protected ListAdaptiveMtFilesFixedSizeCollection createCollection(List<ListAdaptiveMtFilesPage> pages, int collectionSize) {
            return new ListAdaptiveMtFilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdaptiveMtFilesPage
    extends AbstractPage<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile, ListAdaptiveMtFilesPage> {
        private ListAdaptiveMtFilesPage(PageContext<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile> context, ListAdaptiveMtFilesResponse response) {
            super(context, (Object)response);
        }

        private static ListAdaptiveMtFilesPage createEmptyPage() {
            return new ListAdaptiveMtFilesPage(null, null);
        }

        protected ListAdaptiveMtFilesPage createPage(PageContext<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile> context, ListAdaptiveMtFilesResponse response) {
            return new ListAdaptiveMtFilesPage(context, response);
        }

        public ApiFuture<ListAdaptiveMtFilesPage> createPageAsync(PageContext<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile> context, ApiFuture<ListAdaptiveMtFilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdaptiveMtFilesPagedResponse
    extends AbstractPagedListResponse<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile, ListAdaptiveMtFilesPage, ListAdaptiveMtFilesFixedSizeCollection> {
        public static ApiFuture<ListAdaptiveMtFilesPagedResponse> createAsync(PageContext<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse, AdaptiveMtFile> context, ApiFuture<ListAdaptiveMtFilesResponse> futureResponse) {
            ApiFuture<ListAdaptiveMtFilesPage> futurePage = ListAdaptiveMtFilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdaptiveMtFilesPagedResponse((ListAdaptiveMtFilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdaptiveMtFilesPagedResponse(ListAdaptiveMtFilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdaptiveMtFilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAdaptiveMtDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset, ListAdaptiveMtDatasetsPage, ListAdaptiveMtDatasetsFixedSizeCollection> {
        private ListAdaptiveMtDatasetsFixedSizeCollection(List<ListAdaptiveMtDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdaptiveMtDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListAdaptiveMtDatasetsFixedSizeCollection(null, 0);
        }

        protected ListAdaptiveMtDatasetsFixedSizeCollection createCollection(List<ListAdaptiveMtDatasetsPage> pages, int collectionSize) {
            return new ListAdaptiveMtDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdaptiveMtDatasetsPage
    extends AbstractPage<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset, ListAdaptiveMtDatasetsPage> {
        private ListAdaptiveMtDatasetsPage(PageContext<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset> context, ListAdaptiveMtDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAdaptiveMtDatasetsPage createEmptyPage() {
            return new ListAdaptiveMtDatasetsPage(null, null);
        }

        protected ListAdaptiveMtDatasetsPage createPage(PageContext<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset> context, ListAdaptiveMtDatasetsResponse response) {
            return new ListAdaptiveMtDatasetsPage(context, response);
        }

        public ApiFuture<ListAdaptiveMtDatasetsPage> createPageAsync(PageContext<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset> context, ApiFuture<ListAdaptiveMtDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdaptiveMtDatasetsPagedResponse
    extends AbstractPagedListResponse<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset, ListAdaptiveMtDatasetsPage, ListAdaptiveMtDatasetsFixedSizeCollection> {
        public static ApiFuture<ListAdaptiveMtDatasetsPagedResponse> createAsync(PageContext<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse, AdaptiveMtDataset> context, ApiFuture<ListAdaptiveMtDatasetsResponse> futureResponse) {
            ApiFuture<ListAdaptiveMtDatasetsPage> futurePage = ListAdaptiveMtDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdaptiveMtDatasetsPagedResponse((ListAdaptiveMtDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdaptiveMtDatasetsPagedResponse(ListAdaptiveMtDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdaptiveMtDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGlossaryEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry, ListGlossaryEntriesPage, ListGlossaryEntriesFixedSizeCollection> {
        private ListGlossaryEntriesFixedSizeCollection(List<ListGlossaryEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossaryEntriesFixedSizeCollection createEmptyCollection() {
            return new ListGlossaryEntriesFixedSizeCollection(null, 0);
        }

        protected ListGlossaryEntriesFixedSizeCollection createCollection(List<ListGlossaryEntriesPage> pages, int collectionSize) {
            return new ListGlossaryEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossaryEntriesPage
    extends AbstractPage<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry, ListGlossaryEntriesPage> {
        private ListGlossaryEntriesPage(PageContext<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry> context, ListGlossaryEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossaryEntriesPage createEmptyPage() {
            return new ListGlossaryEntriesPage(null, null);
        }

        protected ListGlossaryEntriesPage createPage(PageContext<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry> context, ListGlossaryEntriesResponse response) {
            return new ListGlossaryEntriesPage(context, response);
        }

        public ApiFuture<ListGlossaryEntriesPage> createPageAsync(PageContext<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry> context, ApiFuture<ListGlossaryEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossaryEntriesPagedResponse
    extends AbstractPagedListResponse<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry, ListGlossaryEntriesPage, ListGlossaryEntriesFixedSizeCollection> {
        public static ApiFuture<ListGlossaryEntriesPagedResponse> createAsync(PageContext<ListGlossaryEntriesRequest, ListGlossaryEntriesResponse, GlossaryEntry> context, ApiFuture<ListGlossaryEntriesResponse> futureResponse) {
            ApiFuture<ListGlossaryEntriesPage> futurePage = ListGlossaryEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossaryEntriesPagedResponse((ListGlossaryEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossaryEntriesPagedResponse(ListGlossaryEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossaryEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGlossariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        private ListGlossariesFixedSizeCollection(List<ListGlossariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossariesFixedSizeCollection createEmptyCollection() {
            return new ListGlossariesFixedSizeCollection(null, 0);
        }

        protected ListGlossariesFixedSizeCollection createCollection(List<ListGlossariesPage> pages, int collectionSize) {
            return new ListGlossariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossariesPage
    extends AbstractPage<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage> {
        private ListGlossariesPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossariesPage createEmptyPage() {
            return new ListGlossariesPage(null, null);
        }

        protected ListGlossariesPage createPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            return new ListGlossariesPage(context, response);
        }

        public ApiFuture<ListGlossariesPage> createPageAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossariesPagedResponse
    extends AbstractPagedListResponse<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        public static ApiFuture<ListGlossariesPagedResponse> createAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            ApiFuture<ListGlossariesPage> futurePage = ListGlossariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossariesPagedResponse((ListGlossariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossariesPagedResponse(ListGlossariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossariesFixedSizeCollection.createEmptyCollection());
        }
    }
}

