/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.vision.v1p1beta1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1p1beta1.ImageAnnotatorClient;
import com.google.cloud.vision.v1p1beta1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1p1beta1.MockImageAnnotator;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageAnnotatorClientTest {
    private static MockImageAnnotator mockImageAnnotator;
    private static MockServiceHelper serviceHelper;
    private ImageAnnotatorClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockImageAnnotator = new MockImageAnnotator();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockImageAnnotator));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        ImageAnnotatorSettings settings = ((ImageAnnotatorSettings.Builder)((ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ImageAnnotatorClient.create((ImageAnnotatorSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void batchAnnotateImagesTest() {
        BatchAnnotateImagesResponse expectedResponse = BatchAnnotateImagesResponse.newBuilder().build();
        mockImageAnnotator.addResponse((GeneratedMessageV3)expectedResponse);
        ArrayList requests = new ArrayList();
        BatchAnnotateImagesResponse actualResponse = this.client.batchAnnotateImages(requests);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockImageAnnotator.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchAnnotateImagesRequest actualRequest = (BatchAnnotateImagesRequest)actualRequests.get(0);
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchAnnotateImagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockImageAnnotator.addException((Exception)exception);
        try {
            ArrayList requests = new ArrayList();
            this.client.batchAnnotateImages(requests);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

