/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p1beta1;

import com.google.cloud.vision.v1p1beta1.AnnotateImageRequest;
import com.google.cloud.vision.v1p1beta1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1p1beta1.Feature;
import com.google.cloud.vision.v1p1beta1.Image;
import com.google.cloud.vision.v1p1beta1.ImageAnnotatorClient;
import com.google.cloud.vision.v1p1beta1.ImageSource;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Test;

public class ImageAnnotatorSmokeTest {
    private static final String PROJECT_ENV_NAME = "GOOGLE_CLOUD_PROJECT";
    private static final String LEGACY_PROJECT_ENV_NAME = "GCLOUD_PROJECT";

    @Test
    public void run() {
        ImageAnnotatorSmokeTest.main(null);
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        try {
            ImageAnnotatorSmokeTest.executeNoCatch();
            System.out.println("OK");
        }
        catch (Exception e) {
            System.err.println("Failed with exception:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void executeNoCatch() throws Exception {
        try (ImageAnnotatorClient client = ImageAnnotatorClient.create();){
            String gcsImageUri = "gs://gapic-toolkit/President_Barack_Obama.jpg";
            ImageSource source = ImageSource.newBuilder().setGcsImageUri(gcsImageUri).build();
            Image image = Image.newBuilder().setSource(source).build();
            Feature.Type type = Feature.Type.FACE_DETECTION;
            Feature featuresElement = Feature.newBuilder().setType(type).build();
            List<Feature> features = Arrays.asList(featuresElement);
            AnnotateImageRequest requestsElement = AnnotateImageRequest.newBuilder().setImage(image).addAllFeatures(features).build();
            List<AnnotateImageRequest> requests = Arrays.asList(requestsElement);
            BatchAnnotateImagesResponse batchAnnotateImagesResponse = client.batchAnnotateImages(requests);
        }
    }

    private static String getProjectId() {
        String projectId = System.getProperty(PROJECT_ENV_NAME, System.getenv(PROJECT_ENV_NAME));
        if (projectId == null) {
            projectId = System.getProperty(LEGACY_PROJECT_ENV_NAME, System.getenv(LEGACY_PROJECT_ENV_NAME));
        }
        Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"A project ID is required.");
        return projectId;
    }
}

