/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.vision.v1p4beta1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1p4beta1.CreateProductRequest;
import com.google.cloud.vision.v1p4beta1.CreateProductSetRequest;
import com.google.cloud.vision.v1p4beta1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.DeleteProductRequest;
import com.google.cloud.vision.v1p4beta1.DeleteProductSetRequest;
import com.google.cloud.vision.v1p4beta1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.GetProductRequest;
import com.google.cloud.vision.v1p4beta1.GetProductSetRequest;
import com.google.cloud.vision.v1p4beta1.GetReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsInputConfig;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsRequest;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsResponse;
import com.google.cloud.vision.v1p4beta1.ListProductSetsRequest;
import com.google.cloud.vision.v1p4beta1.ListProductSetsResponse;
import com.google.cloud.vision.v1p4beta1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1p4beta1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1p4beta1.ListProductsRequest;
import com.google.cloud.vision.v1p4beta1.ListProductsResponse;
import com.google.cloud.vision.v1p4beta1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1p4beta1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1p4beta1.LocationName;
import com.google.cloud.vision.v1p4beta1.MockImageAnnotator;
import com.google.cloud.vision.v1p4beta1.MockProductSearch;
import com.google.cloud.vision.v1p4beta1.Product;
import com.google.cloud.vision.v1p4beta1.ProductName;
import com.google.cloud.vision.v1p4beta1.ProductSearchClient;
import com.google.cloud.vision.v1p4beta1.ProductSearchSettings;
import com.google.cloud.vision.v1p4beta1.ProductSet;
import com.google.cloud.vision.v1p4beta1.ProductSetName;
import com.google.cloud.vision.v1p4beta1.ReferenceImage;
import com.google.cloud.vision.v1p4beta1.ReferenceImageName;
import com.google.cloud.vision.v1p4beta1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1p4beta1.UpdateProductRequest;
import com.google.cloud.vision.v1p4beta1.UpdateProductSetRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductSearchClientTest {
    private static MockProductSearch mockProductSearch;
    private static MockImageAnnotator mockImageAnnotator;
    private static MockServiceHelper serviceHelper;
    private ProductSearchClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockProductSearch = new MockProductSearch();
        mockImageAnnotator = new MockImageAnnotator();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockProductSearch, mockImageAnnotator));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        ProductSearchSettings settings = ((ProductSearchSettings.Builder)((ProductSearchSettings.Builder)ProductSearchSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ProductSearchClient.create((ProductSearchSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createProductSetTest() {
        String name = "name3373707";
        String displayName = "displayName1615086568";
        ProductSet expectedResponse = ProductSet.newBuilder().setName(name).setDisplayName(displayName).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSet productSet = ProductSet.newBuilder().build();
        String productSetId = "productSetId4216680";
        ProductSet actualResponse = this.client.createProductSet(parent, productSet, productSetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductSetRequest actualRequest = (CreateProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)productSet, (Object)actualRequest.getProductSet());
        Assert.assertEquals((Object)productSetId, (Object)actualRequest.getProductSetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ProductSet productSet = ProductSet.newBuilder().build();
            String productSetId = "productSetId4216680";
            this.client.createProductSet(parent, productSet, productSetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductSetsTest() {
        String nextPageToken = "";
        ProductSet productSetsElement = ProductSet.newBuilder().build();
        List<ProductSet> productSets = Arrays.asList(productSetsElement);
        ListProductSetsResponse expectedResponse = ListProductSetsResponse.newBuilder().setNextPageToken(nextPageToken).addAllProductSets(productSets).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductSetsPagedResponse pagedListResponse = this.client.listProductSets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductSetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductSetsRequest actualRequest = (ListProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductSetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProductSets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductSetTest() {
        String name2 = "name2-1052831874";
        String displayName = "displayName1615086568";
        ProductSet expectedResponse = ProductSet.newBuilder().setName(name2).setDisplayName(displayName).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSet actualResponse = this.client.getProductSet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductSetRequest actualRequest = (GetProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductSetName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.getProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductSetTest() {
        String name = "name3373707";
        String displayName = "displayName1615086568";
        ProductSet expectedResponse = ProductSet.newBuilder().setName(name).setDisplayName(displayName).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSet productSet = ProductSet.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ProductSet actualResponse = this.client.updateProductSet(productSet, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProductSetRequest actualRequest = (UpdateProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)productSet, (Object)actualRequest.getProductSet());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSet productSet = ProductSet.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProductSet(productSet, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductSetTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        this.client.deleteProductSet(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductSetRequest actualRequest = (DeleteProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductSetName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.deleteProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductTest() {
        String name = "name3373707";
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        String productCategory = "productCategory-1607451058";
        Product expectedResponse = Product.newBuilder().setName(name).setDisplayName(displayName).setDescription(description).setProductCategory(productCategory).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Product product = Product.newBuilder().build();
        String productId = "productId1753008747";
        Product actualResponse = this.client.createProduct(parent, product, productId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductRequest actualRequest = (CreateProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertEquals((Object)productId, (Object)actualRequest.getProductId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Product product = Product.newBuilder().build();
            String productId = "productId1753008747";
            this.client.createProduct(parent, product, productId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsTest() {
        String nextPageToken = "";
        Product productsElement = Product.newBuilder().build();
        List<Product> products = Arrays.asList(productsElement);
        ListProductsResponse expectedResponse = ListProductsResponse.newBuilder().setNextPageToken(nextPageToken).addAllProducts(products).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductsPagedResponse pagedListResponse = this.client.listProducts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsRequest actualRequest = (ListProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProducts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductTest() {
        String name2 = "name2-1052831874";
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        String productCategory = "productCategory-1607451058";
        Product expectedResponse = Product.newBuilder().setName(name2).setDisplayName(displayName).setDescription(description).setProductCategory(productCategory).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        Product actualResponse = this.client.getProduct(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductRequest actualRequest = (GetProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.getProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductTest() {
        String name = "name3373707";
        String displayName = "displayName1615086568";
        String description = "description-1724546052";
        String productCategory = "productCategory-1607451058";
        Product expectedResponse = Product.newBuilder().setName(name).setDisplayName(displayName).setDescription(description).setProductCategory(productCategory).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        Product product = Product.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Product actualResponse = this.client.updateProduct(product, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProductRequest actualRequest = (UpdateProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            Product product = Product.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProduct(product, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.deleteProduct(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductRequest actualRequest = (DeleteProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.deleteProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReferenceImageTest() {
        String name = "name3373707";
        String uri = "uri116076";
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(name).setUri(uri).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
        String referenceImageId = "referenceImageId1946713331";
        ReferenceImage actualResponse = this.client.createReferenceImage(parent, referenceImage, referenceImageId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReferenceImageRequest actualRequest = (CreateReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProductName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)referenceImage, (Object)actualRequest.getReferenceImage());
        Assert.assertEquals((Object)referenceImageId, (Object)actualRequest.getReferenceImageId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
            String referenceImageId = "referenceImageId1946713331";
            this.client.createReferenceImage(parent, referenceImage, referenceImageId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReferenceImageTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        this.client.deleteReferenceImage(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteReferenceImageRequest actualRequest = (DeleteReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ReferenceImageName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            this.client.deleteReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReferenceImagesTest() {
        int pageSize = 883849137;
        String nextPageToken = "";
        ReferenceImage referenceImagesElement = ReferenceImage.newBuilder().build();
        List<ReferenceImage> referenceImages = Arrays.asList(referenceImagesElement);
        ListReferenceImagesResponse expectedResponse = ListReferenceImagesResponse.newBuilder().setPageSize(pageSize).setNextPageToken(nextPageToken).addAllReferenceImages(referenceImages).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ProductSearchClient.ListReferenceImagesPagedResponse pagedListResponse = this.client.listReferenceImages(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReferenceImagesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReferenceImagesRequest actualRequest = (ListReferenceImagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)ProductName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReferenceImagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.listReferenceImages(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReferenceImageTest() {
        String name2 = "name2-1052831874";
        String uri = "uri116076";
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(name2).setUri(uri).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        ReferenceImage actualResponse = this.client.getReferenceImage(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetReferenceImageRequest actualRequest = (GetReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ReferenceImageName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            this.client.getReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        this.client.addProductToProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddProductToProductSetRequest actualRequest = (AddProductToProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductSetName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addProductToProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            this.client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        this.client.removeProductFromProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveProductFromProductSetRequest actualRequest = (RemoveProductFromProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductSetName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeProductFromProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            this.client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsInProductSetTest() {
        String nextPageToken = "";
        Product productsElement = Product.newBuilder().build();
        List<Product> products = Arrays.asList(productsElement);
        ListProductsInProductSetResponse expectedResponse = ListProductsInProductSetResponse.newBuilder().setNextPageToken(nextPageToken).addAllProducts(products).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSearchClient.ListProductsInProductSetPagedResponse pagedListResponse = this.client.listProductsInProductSet(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsInProductSetRequest actualRequest = (ListProductsInProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProductSetName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsInProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.listProductsInProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importProductSetsTest() throws Exception {
        ImportProductSetsResponse expectedResponse = ImportProductSetsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("importProductSetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockProductSearch.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
        ImportProductSetsResponse actualResponse = (ImportProductSetsResponse)this.client.importProductSetsAsync(parent, inputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportProductSetsRequest actualRequest = (ImportProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)inputConfig, (Object)actualRequest.getInputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importProductSetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
            this.client.importProductSetsAsync(parent, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

