/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.it;

import com.google.cloud.ServiceOptions;
import com.google.cloud.vision.v1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.ColorInfo;
import com.google.cloud.vision.v1.CreateProductRequest;
import com.google.cloud.vision.v1.CreateProductSetRequest;
import com.google.cloud.vision.v1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1.DeleteProductRequest;
import com.google.cloud.vision.v1.DeleteProductSetRequest;
import com.google.cloud.vision.v1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1.DominantColorsAnnotation;
import com.google.cloud.vision.v1.EntityAnnotation;
import com.google.cloud.vision.v1.FaceAnnotation;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.GetProductRequest;
import com.google.cloud.vision.v1.GetProductSetRequest;
import com.google.cloud.vision.v1.GetReferenceImageRequest;
import com.google.cloud.vision.v1.Image;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageContext;
import com.google.cloud.vision.v1.ImageSource;
import com.google.cloud.vision.v1.Likelihood;
import com.google.cloud.vision.v1.ListProductSetsRequest;
import com.google.cloud.vision.v1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1.ListProductsRequest;
import com.google.cloud.vision.v1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1.LocalizedObjectAnnotation;
import com.google.cloud.vision.v1.LocationName;
import com.google.cloud.vision.v1.Product;
import com.google.cloud.vision.v1.ProductName;
import com.google.cloud.vision.v1.ProductSearchClient;
import com.google.cloud.vision.v1.ProductSet;
import com.google.cloud.vision.v1.ProductSetName;
import com.google.cloud.vision.v1.ReferenceImage;
import com.google.cloud.vision.v1.ReferenceImageName;
import com.google.cloud.vision.v1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1.SafeSearchAnnotation;
import com.google.cloud.vision.v1.TextAnnotation;
import com.google.cloud.vision.v1.UpdateProductRequest;
import com.google.cloud.vision.v1.WebDetection;
import com.google.cloud.vision.v1.WebDetectionParams;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITSystemTest {
    private static ImageAnnotatorClient imageAnnotatorClient;
    private static ProductSearchClient productSearchClient;
    private static Product product;
    private static String formatProductName;
    private static ProductSet productSet;
    private static String formatProductSetName;
    private static ReferenceImage referenceImage;
    private static String formatReferenceImageName;
    private static final String PROJECT_ID;
    private static final String ID;
    private static final String RESOURCES;
    private static final String GCS_BUCKET_ENV_VAR = "GOOGLE_CLOUD_TESTS_VISION_BUCKET";
    private static final String SAMPLE_BUCKET;
    private static final String SAMPLE_URI;
    private static final int MAX_RESULTS = 15;
    private static final int RETRIES = 3;
    private static final String COMPUTE_REGION = "us-west1";
    private static final String LOCATION_NAME;
    private static final String PRODUCT_DISPLAY_NAME;
    private static final String PRODUCT_CATEGORY = "homegoods";
    private static final String PRODUCT_ID;
    private static final String KEY;
    private static final String VALUE;
    private static final Product.KeyValue KEY_VALUE;
    private static final String PRODUCT_SET_ID;
    private static final String PRODUCT_SET_DISPLAY_NAME;

    @BeforeClass
    public static void setUp() throws IOException {
        imageAnnotatorClient = ImageAnnotatorClient.create();
        productSearchClient = ProductSearchClient.create();
        Product createProduct = Product.newBuilder().setName(PRODUCT_ID).setDisplayName(PRODUCT_DISPLAY_NAME).setProductCategory(PRODUCT_CATEGORY).build();
        CreateProductRequest productRequest = CreateProductRequest.newBuilder().setParent(LOCATION_NAME).setProduct(createProduct).build();
        product = productSearchClient.createProduct(productRequest);
        String productName = ITSystemTest.getName(product.getName());
        formatProductName = ProductName.of((String)PROJECT_ID, (String)COMPUTE_REGION, (String)productName).toString();
        ProductSet createProductSet = ProductSet.newBuilder().setDisplayName(PRODUCT_SET_DISPLAY_NAME).build();
        CreateProductSetRequest productSetRequest = CreateProductSetRequest.newBuilder().setParent(LOCATION_NAME).setProductSet(createProductSet).setProductSetId(PRODUCT_SET_ID).build();
        productSet = productSearchClient.createProductSet(productSetRequest);
        String productSetName = ITSystemTest.getName(productSet.getName());
        formatProductSetName = ProductSetName.of((String)PROJECT_ID, (String)COMPUTE_REGION, (String)productSetName).toString();
        AddProductToProductSetRequest productToProductSetRequest = AddProductToProductSetRequest.newBuilder().setName(formatProductSetName).setProduct(formatProductName).build();
        productSearchClient.addProductToProductSet(productToProductSetRequest);
        ReferenceImage createReferenceImage = ReferenceImage.newBuilder().setUri(SAMPLE_BUCKET + "product_search/shoes_1.jpg").build();
        CreateReferenceImageRequest imageRequest = CreateReferenceImageRequest.newBuilder().setParent(formatProductName).setReferenceImage(createReferenceImage).build();
        referenceImage = productSearchClient.createReferenceImage(imageRequest);
        String referenceImageName = ITSystemTest.getName(referenceImage.getName());
        formatReferenceImageName = ReferenceImageName.of((String)PROJECT_ID, (String)COMPUTE_REGION, (String)productName, (String)referenceImageName).toString();
    }

    @AfterClass
    public static void tearDown() {
        DeleteReferenceImageRequest imageRequest = DeleteReferenceImageRequest.newBuilder().setName(formatReferenceImageName).build();
        productSearchClient.deleteReferenceImage(imageRequest);
        RemoveProductFromProductSetRequest removeProductRequest = RemoveProductFromProductSetRequest.newBuilder().setName(formatProductSetName).setProduct(formatProductName).build();
        productSearchClient.removeProductFromProductSet(removeProductRequest);
        DeleteProductSetRequest deleteProductSetRequest = DeleteProductSetRequest.newBuilder().setName(formatProductSetName).build();
        productSearchClient.deleteProductSet(deleteProductSetRequest);
        DeleteProductRequest deleteProductRequest = DeleteProductRequest.newBuilder().setName(formatProductName).build();
        productSearchClient.deleteProduct(deleteProductRequest);
        productSearchClient.close();
        imageAnnotatorClient.close();
    }

    private static AnnotateImageResponse requestAnnotatedImage(String image, Feature.Type type, boolean isGcs) throws IOException {
        Image img;
        if (isGcs) {
            ImageSource imgSource = ImageSource.newBuilder().setGcsImageUri(SAMPLE_BUCKET + image).build();
            img = Image.newBuilder().setSource(imgSource).build();
        } else {
            ByteString imgBytes = ByteString.readFrom((InputStream)new FileInputStream(RESOURCES + image));
            img = Image.newBuilder().setContent(imgBytes).build();
        }
        Feature feat = Feature.newBuilder().setType(type).build();
        return ITSystemTest.request(AnnotateImageRequest.newBuilder().addFeatures(feat).setImage(img).build());
    }

    private static AnnotateImageResponse request(AnnotateImageRequest request) {
        return ITSystemTest.request(request, 3);
    }

    private static AnnotateImageResponse request(AnnotateImageRequest request, int retries) {
        try {
            return ITSystemTest.executeRequest(request);
        }
        catch (StatusRuntimeException ex) {
            if (retries <= 0) {
                throw ex;
            }
            System.out.println("Retrying in 30s: " + ex.getMessage());
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return ITSystemTest.request(request, retries - 1);
        }
    }

    private static AnnotateImageResponse executeRequest(AnnotateImageRequest request) {
        AnnotateImageResponse response;
        int errorCode;
        BatchAnnotateImagesResponse batchResponse = imageAnnotatorClient.batchAnnotateImages((List)ImmutableList.of((Object)request));
        List responses = batchResponse.getResponsesList();
        if (responses.isEmpty()) {
            System.out.println("Request: " + request);
            System.out.println("Response: " + batchResponse);
            Assert.fail((String)"Empty response.");
        }
        if ((errorCode = (response = (AnnotateImageResponse)ITSystemTest.assertSingleEntry(responses)).getError().getCode()) != 0) {
            throw new StatusRuntimeException(Status.fromCodeValue((int)errorCode));
        }
        return response;
    }

    private static <T> T assertSingleEntry(Collection<T> collection) {
        Assert.assertEquals((long)1L, (long)collection.size());
        return collection.iterator().next();
    }

    private static <T> List<T> assertNotEmpty(AnnotateImageResponse response, List<T> list) {
        Assert.assertFalse((String)("Empty response list: " + response), (boolean)list.isEmpty());
        return list;
    }

    @Test
    public void detectFacesTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("face_no_surprise.jpg", Feature.Type.FACE_DETECTION, false);
        for (FaceAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getFaceAnnotationsList())) {
            Truth.assertThat((Comparable)annotation.getAngerLikelihood()).isAnyOf((Object)Likelihood.LIKELY, (Object)Likelihood.POSSIBLE, new Object[0]);
            Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getJoyLikelihood());
            Assert.assertEquals((Object)Likelihood.LIKELY, (Object)annotation.getSurpriseLikelihood());
        }
    }

    @Test
    public void detectFacesGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("face/face_no_surprise.jpg", Feature.Type.FACE_DETECTION, true);
        for (FaceAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getFaceAnnotationsList())) {
            Truth.assertThat((Comparable)annotation.getAngerLikelihood()).isAnyOf((Object)Likelihood.LIKELY, (Object)Likelihood.POSSIBLE, new Object[0]);
            Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getJoyLikelihood());
            Assert.assertEquals((Object)Likelihood.LIKELY, (Object)annotation.getSurpriseLikelihood());
        }
    }

    @Test
    public void detectLabelsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("wakeupcat.jpg", Feature.Type.LABEL_DETECTION, false);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLabelAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        Truth.assertThat(actual).contains((Object)"Whiskers");
    }

    @Test
    public void detectLabelsGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("label/wakeupcat.jpg", Feature.Type.LABEL_DETECTION, true);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLabelAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        Truth.assertThat(actual).contains((Object)"Whiskers");
    }

    @Test
    public void detectLandmarksTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("landmark.jpg", Feature.Type.LANDMARK_DETECTION, false);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLandmarkAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        String allAnnotations = String.join((CharSequence)";", actual);
        Truth.assertThat((String)allAnnotations).ignoringCase().contains((CharSequence)"Palace of Fine Arts");
    }

    @Test
    public void detectLandmarksUrlTest() throws Exception {
        ImageSource imgSource = ImageSource.newBuilder().setImageUri(SAMPLE_URI + "landmark/pofa.jpg").build();
        Image img = Image.newBuilder().setSource(imgSource).build();
        Feature feat = Feature.newBuilder().setType(Feature.Type.LANDMARK_DETECTION).build();
        AnnotateImageRequest request = AnnotateImageRequest.newBuilder().addFeatures(feat).setImage(img).build();
        ArrayList<String> actual = new ArrayList<String>();
        AnnotateImageResponse res = ITSystemTest.request(request);
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLandmarkAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        String allAnnotations = String.join((CharSequence)";", actual);
        Truth.assertThat((String)allAnnotations).ignoringCase().contains((CharSequence)"Palace of Fine Arts");
    }

    @Test
    public void detectLandmarksGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("landmark/pofa.jpg", Feature.Type.LANDMARK_DETECTION, true);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLandmarkAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        String allAnnotations = String.join((CharSequence)";", actual);
        Truth.assertThat((String)allAnnotations).ignoringCase().contains((CharSequence)"Palace of Fine Arts");
    }

    @Test
    public void detectLogosTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("logos.png", Feature.Type.LOGO_DETECTION, false);
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLogoAnnotationsList())) {
            Assert.assertEquals((Object)"Google", (Object)annotation.getDescription());
        }
    }

    @Test
    public void detectLogosGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("logo/logo_google.png", Feature.Type.LOGO_DETECTION, true);
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getLogoAnnotationsList())) {
            Assert.assertEquals((Object)"Google", (Object)annotation.getDescription());
        }
    }

    @Test
    public void detectTextTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("text.jpg", Feature.Type.TEXT_DETECTION, false);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getTextAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        Truth.assertThat(actual).contains((Object)"PS4");
    }

    @Test
    public void detectTextGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("text/screen.jpg", Feature.Type.TEXT_DETECTION, true);
        ArrayList<String> actual = new ArrayList<String>();
        for (EntityAnnotation annotation : ITSystemTest.assertNotEmpty(res, res.getTextAnnotationsList())) {
            actual.add(annotation.getDescription());
        }
        String joinedActual = String.join((CharSequence)" ", actual);
        Truth.assertThat((String)joinedActual).contains((CharSequence)"37%");
    }

    @Test
    public void detectPropertiesTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("landmark.jpg", Feature.Type.IMAGE_PROPERTIES, false);
        ArrayList<Float> actual = new ArrayList<Float>();
        DominantColorsAnnotation colors = res.getImagePropertiesAnnotation().getDominantColors();
        for (ColorInfo color : ITSystemTest.assertNotEmpty(res, colors.getColorsList())) {
            actual.add(Float.valueOf(color.getPixelFraction()));
        }
        Truth.assertThat(actual).contains((Object)Float.valueOf(0.14140345f));
    }

    @Test
    public void detectPropertiesGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("landmark/pofa.jpg", Feature.Type.IMAGE_PROPERTIES, true);
        ArrayList<Float> actual = new ArrayList<Float>();
        DominantColorsAnnotation colors = res.getImagePropertiesAnnotation().getDominantColors();
        for (ColorInfo color : ITSystemTest.assertNotEmpty(res, colors.getColorsList())) {
            actual.add(Float.valueOf(color.getPixelFraction()));
        }
        Truth.assertThat(actual).contains((Object)Float.valueOf(0.14140345f));
    }

    @Test
    public void detectSafeSearchTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("wakeupcat.jpg", Feature.Type.SAFE_SEARCH_DETECTION, false);
        SafeSearchAnnotation annotation = res.getSafeSearchAnnotation();
        Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getAdult());
        Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getRacy());
    }

    @Test
    public void detectWebEntitiesTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("city.jpg", Feature.Type.WEB_DETECTION, false);
        ArrayList<String> actual = new ArrayList<String>();
        for (WebDetection.WebEntity entity : ITSystemTest.assertNotEmpty(res, res.getWebDetection().getWebEntitiesList())) {
            actual.add(entity.getDescription());
        }
        Truth.assertThat(actual).contains((Object)"Skyscraper");
    }

    @Test
    public void detectSafeSearchGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("label/wakeupcat.jpg", Feature.Type.SAFE_SEARCH_DETECTION, true);
        SafeSearchAnnotation annotation = res.getSafeSearchAnnotation();
        Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getAdult());
        Assert.assertEquals((Object)Likelihood.VERY_UNLIKELY, (Object)annotation.getRacy());
    }

    @Test
    public void detectWebEntitiesGcsTest() {
        ImageSource imgSource = ImageSource.newBuilder().setGcsImageUri(SAMPLE_BUCKET + "landmark/pofa.jpg").build();
        Image img = Image.newBuilder().setSource(imgSource).build();
        Feature feat = Feature.newBuilder().setType(Feature.Type.WEB_DETECTION).setMaxResults(15).build();
        AnnotateImageRequest request = AnnotateImageRequest.newBuilder().addFeatures(feat).setImage(img).build();
        AnnotateImageResponse res = ITSystemTest.request(request);
        List entities = ITSystemTest.assertNotEmpty(res, res.getWebDetection().getWebEntitiesList());
        List descriptions = Lists.transform(entities, WebDetection.WebEntity::getDescription);
        Truth.assertThat((Iterable)descriptions).isNotEmpty();
    }

    @Test
    public void detectWebEntitiesIncludeGeoResultsTest() throws IOException {
        ByteString imgBytes = ByteString.readFrom((InputStream)new FileInputStream(RESOURCES + "city.jpg"));
        Image img = Image.newBuilder().setContent(imgBytes).build();
        Feature feat = Feature.newBuilder().setType(Feature.Type.WEB_DETECTION).setMaxResults(15).build();
        WebDetectionParams webDetectionParams = WebDetectionParams.newBuilder().setIncludeGeoResults(true).build();
        ImageContext imageContext = ImageContext.newBuilder().setWebDetectionParams(webDetectionParams).build();
        AnnotateImageRequest request = AnnotateImageRequest.newBuilder().addFeatures(feat).setImageContext(imageContext).setImage(img).build();
        AnnotateImageResponse res = ITSystemTest.request(request);
        ArrayList<String> actual = new ArrayList<String>();
        for (WebDetection.WebEntity entity : ITSystemTest.assertNotEmpty(res, res.getWebDetection().getWebEntitiesList())) {
            actual.add(entity.getDescription());
        }
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.add("Electra Tower");
        expectedResults.add("Metropolitan area");
        Truth.assertThat(actual).containsAnyIn(expectedResults);
    }

    @Test
    public void detectWebEntitiesIncludeGeoResultsGcsTest() {
        ImageSource imgSource = ImageSource.newBuilder().setGcsImageUri(SAMPLE_BUCKET + "landmark/pofa.jpg").build();
        Image img = Image.newBuilder().setSource(imgSource).build();
        Feature feat = Feature.newBuilder().setType(Feature.Type.WEB_DETECTION).setMaxResults(15).build();
        WebDetectionParams webDetectionParams = WebDetectionParams.newBuilder().setIncludeGeoResults(true).build();
        ImageContext imageContext = ImageContext.newBuilder().setWebDetectionParams(webDetectionParams).build();
        AnnotateImageRequest request = AnnotateImageRequest.newBuilder().addFeatures(feat).setImageContext(imageContext).setImage(img).build();
        AnnotateImageResponse res = ITSystemTest.request(request);
        List entities = ITSystemTest.assertNotEmpty(res, res.getWebDetection().getWebEntitiesList());
        List descriptions = Lists.transform(entities, WebDetection.WebEntity::getDescription);
        Truth.assertThat((Iterable)descriptions).isNotEmpty();
    }

    @Test
    public void detectDocumentTextTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("text.jpg", Feature.Type.DOCUMENT_TEXT_DETECTION, false);
        TextAnnotation annotation = res.getFullTextAnnotation();
        String actual = annotation.getText();
        Truth.assertThat((String)actual).contains((CharSequence)"After preparation is complete");
    }

    @Test
    public void detectDocumentTextGcs() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("text/screen.jpg", Feature.Type.DOCUMENT_TEXT_DETECTION, true);
        TextAnnotation annotation = res.getFullTextAnnotation();
        String actual = annotation.getText();
        Truth.assertThat((String)actual).contains((CharSequence)"After preparation is complete");
    }

    @Test
    public void detectLocalizedObjectsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("puppies.jpg", Feature.Type.OBJECT_LOCALIZATION, false);
        ArrayList<String> actual = new ArrayList<String>();
        for (LocalizedObjectAnnotation entity : ITSystemTest.assertNotEmpty(res, res.getLocalizedObjectAnnotationsList())) {
            actual.add(entity.getName());
        }
        Truth.assertThat(actual).contains((Object)"Dog");
    }

    @Test
    public void listProductsTest() {
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(LOCATION_NAME).build();
        for (Product actualProduct : productSearchClient.listProducts(request).iterateAll()) {
            if (!product.getName().equals(actualProduct.getName())) continue;
            Assert.assertEquals((Object)PRODUCT_DISPLAY_NAME, (Object)actualProduct.getDisplayName());
            Assert.assertEquals((Object)PRODUCT_CATEGORY, (Object)actualProduct.getProductCategory());
        }
    }

    @Test
    public void getProductTest() {
        GetProductRequest request = GetProductRequest.newBuilder().setName(formatProductName).build();
        Product actualProduct = productSearchClient.getProduct(request);
        Assert.assertEquals((Object)product.getName(), (Object)actualProduct.getName());
        Assert.assertEquals((Object)PRODUCT_DISPLAY_NAME, (Object)actualProduct.getDisplayName());
        Assert.assertEquals((Object)PRODUCT_CATEGORY, (Object)actualProduct.getProductCategory());
    }

    @Test
    public void detectLocalizedObjectsGcsTest() throws IOException {
        AnnotateImageResponse res = ITSystemTest.requestAnnotatedImage("object_localization/puppies.jpg", Feature.Type.OBJECT_LOCALIZATION, true);
        ArrayList<String> actual = new ArrayList<String>();
        for (LocalizedObjectAnnotation entity : ITSystemTest.assertNotEmpty(res, res.getLocalizedObjectAnnotationsList())) {
            actual.add(entity.getName());
        }
        Truth.assertThat(actual).contains((Object)"Dog");
    }

    @Test
    public void updateProductTest() {
        Product updateProduct = product.toBuilder().addProductLabels(KEY_VALUE).build();
        UpdateProductRequest request = UpdateProductRequest.newBuilder().setProduct(updateProduct).build();
        Product actualProduct = productSearchClient.updateProduct(request);
        Assert.assertEquals((Object)product.getName(), (Object)actualProduct.getName());
        Assert.assertEquals((Object)PRODUCT_DISPLAY_NAME, (Object)actualProduct.getDisplayName());
        Assert.assertEquals((Object)PRODUCT_CATEGORY, (Object)actualProduct.getProductCategory());
        Assert.assertEquals((Object)ImmutableList.of((Object)KEY_VALUE), (Object)actualProduct.getProductLabelsList());
        Assert.assertEquals((long)1L, (long)actualProduct.getProductLabelsCount());
    }

    @Test
    public void listProductSetsTest() {
        ListProductSetsRequest request = ListProductSetsRequest.newBuilder().setParent(LOCATION_NAME).build();
        for (ProductSet actualProductSet : productSearchClient.listProductSets(request).iterateAll()) {
            if (!productSet.getName().equals(actualProductSet.getName())) continue;
            Assert.assertEquals((Object)PRODUCT_SET_DISPLAY_NAME, (Object)actualProductSet.getDisplayName());
        }
    }

    @Test
    public void getProductSetTest() {
        GetProductSetRequest request = GetProductSetRequest.newBuilder().setName(formatProductSetName).build();
        ProductSet actualProductSet = productSearchClient.getProductSet(request);
        Assert.assertEquals((Object)productSet.getName(), (Object)actualProductSet.getName());
        Assert.assertEquals((Object)PRODUCT_SET_DISPLAY_NAME, (Object)actualProductSet.getDisplayName());
    }

    @Test
    public void listProductsInProductSetTest() {
        ListProductsInProductSetRequest request = ListProductsInProductSetRequest.newBuilder().setName(formatProductSetName).build();
        for (Product actualProduct : productSearchClient.listProductsInProductSet(request).iterateAll()) {
            Assert.assertEquals((Object)product.getName(), (Object)actualProduct.getName());
            Assert.assertEquals((Object)PRODUCT_DISPLAY_NAME, (Object)actualProduct.getDisplayName());
            Assert.assertEquals((Object)PRODUCT_CATEGORY, (Object)actualProduct.getProductCategory());
        }
    }

    @Test
    public void listReferenceImagesTest() {
        ListReferenceImagesRequest request = ListReferenceImagesRequest.newBuilder().setParent(formatProductName).build();
        for (ReferenceImage actualReferenceImage : productSearchClient.listReferenceImages(request).iterateAll()) {
            Assert.assertEquals((Object)referenceImage.getName(), (Object)actualReferenceImage.getName());
            Assert.assertEquals((Object)referenceImage.getUri(), (Object)actualReferenceImage.getUri());
        }
    }

    private static String getName(String name) {
        return name.substring(name.lastIndexOf("/")).replace("/", "");
    }

    @Test
    public void getReferenceImageTest() {
        GetReferenceImageRequest request = GetReferenceImageRequest.newBuilder().setName(formatReferenceImageName).build();
        ReferenceImage actualReferenceImage = productSearchClient.getReferenceImage(request);
        Assert.assertEquals((Object)referenceImage.getName(), (Object)actualReferenceImage.getName());
        Assert.assertEquals((Object)referenceImage.getUri(), (Object)actualReferenceImage.getUri());
    }

    static {
        PROJECT_ID = ServiceOptions.getDefaultProjectId();
        ID = UUID.randomUUID().toString().substring(0, 8);
        RESOURCES = Files.exists(Paths.get("java-vision", "google-cloud-vision", "src", "test", "resources"), new LinkOption[0]) ? "java-vision/google-cloud-vision/src/test/resources/" : "src/test/resources/";
        String GCS_BUCKET = System.getenv(GCS_BUCKET_ENV_VAR) != null ? System.getenv(GCS_BUCKET_ENV_VAR) : "cloud-samples-data";
        SAMPLE_BUCKET = String.format("gs://%s/vision/", GCS_BUCKET);
        SAMPLE_URI = String.format("https://storage-download.googleapis.com/%s/vision/", GCS_BUCKET);
        LOCATION_NAME = LocationName.of((String)PROJECT_ID, (String)COMPUTE_REGION).toString();
        PRODUCT_DISPLAY_NAME = "test-product-display-name-" + ID;
        PRODUCT_ID = "test-product-" + ID;
        KEY = "test-key-" + ID;
        VALUE = "test-value-" + ID;
        KEY_VALUE = Product.KeyValue.newBuilder().setKey(KEY).setValue(VALUE).build();
        PRODUCT_SET_ID = "test-product-set-" + ID;
        PRODUCT_SET_DISPLAY_NAME = "test-product-set-display-name-" + ID;
    }
}

