/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;
import com.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.BatchAnnotateFilesRequest;
import com.google.cloud.vision.v1.BatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1.MockImageAnnotator;
import com.google.cloud.vision.v1.OutputConfig;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageAnnotatorClientTest {
    private static MockImageAnnotator mockImageAnnotator;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private ImageAnnotatorClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockImageAnnotator = new MockImageAnnotator();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockImageAnnotator));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        ImageAnnotatorSettings settings = ((ImageAnnotatorSettings.Builder)((ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ImageAnnotatorClient.create((ImageAnnotatorSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void batchAnnotateImagesTest() throws Exception {
        BatchAnnotateImagesResponse expectedResponse = BatchAnnotateImagesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        mockImageAnnotator.addResponse((AbstractMessage)expectedResponse);
        ArrayList requests = new ArrayList();
        BatchAnnotateImagesResponse actualResponse = this.client.batchAnnotateImages(requests);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockImageAnnotator.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchAnnotateImagesRequest actualRequest = (BatchAnnotateImagesRequest)actualRequests.get(0);
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchAnnotateImagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockImageAnnotator.addException((Exception)((Object)exception));
        try {
            ArrayList requests = new ArrayList();
            this.client.batchAnnotateImages(requests);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchAnnotateFilesTest() throws Exception {
        BatchAnnotateFilesResponse expectedResponse = BatchAnnotateFilesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        mockImageAnnotator.addResponse((AbstractMessage)expectedResponse);
        ArrayList requests = new ArrayList();
        BatchAnnotateFilesResponse actualResponse = this.client.batchAnnotateFiles(requests);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockImageAnnotator.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchAnnotateFilesRequest actualRequest = (BatchAnnotateFilesRequest)actualRequests.get(0);
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchAnnotateFilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockImageAnnotator.addException((Exception)((Object)exception));
        try {
            ArrayList requests = new ArrayList();
            this.client.batchAnnotateFiles(requests);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void asyncBatchAnnotateImagesTest() throws Exception {
        AsyncBatchAnnotateImagesResponse expectedResponse = AsyncBatchAnnotateImagesResponse.newBuilder().setOutputConfig(OutputConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("asyncBatchAnnotateImagesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockImageAnnotator.addResponse((AbstractMessage)resultOperation);
        ArrayList requests = new ArrayList();
        OutputConfig outputConfig = OutputConfig.newBuilder().build();
        AsyncBatchAnnotateImagesResponse actualResponse = (AsyncBatchAnnotateImagesResponse)this.client.asyncBatchAnnotateImagesAsync(requests, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockImageAnnotator.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AsyncBatchAnnotateImagesRequest actualRequest = (AsyncBatchAnnotateImagesRequest)actualRequests.get(0);
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertEquals((Object)outputConfig, (Object)actualRequest.getOutputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void asyncBatchAnnotateImagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockImageAnnotator.addException((Exception)((Object)exception));
        try {
            ArrayList requests = new ArrayList();
            OutputConfig outputConfig = OutputConfig.newBuilder().build();
            this.client.asyncBatchAnnotateImagesAsync(requests, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void asyncBatchAnnotateFilesTest() throws Exception {
        AsyncBatchAnnotateFilesResponse expectedResponse = AsyncBatchAnnotateFilesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("asyncBatchAnnotateFilesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockImageAnnotator.addResponse((AbstractMessage)resultOperation);
        ArrayList requests = new ArrayList();
        AsyncBatchAnnotateFilesResponse actualResponse = (AsyncBatchAnnotateFilesResponse)this.client.asyncBatchAnnotateFilesAsync(requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockImageAnnotator.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AsyncBatchAnnotateFilesRequest actualRequest = (AsyncBatchAnnotateFilesRequest)actualRequests.get(0);
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void asyncBatchAnnotateFilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockImageAnnotator.addException((Exception)((Object)exception));
        try {
            ArrayList requests = new ArrayList();
            this.client.asyncBatchAnnotateFilesAsync(requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

