/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p3beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.vision.v1p3beta1.ImportProductSetsInputConfig;
import com.google.cloud.vision.v1p3beta1.ImportProductSetsResponse;
import com.google.cloud.vision.v1p3beta1.ListProductSetsResponse;
import com.google.cloud.vision.v1p3beta1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1p3beta1.ListProductsResponse;
import com.google.cloud.vision.v1p3beta1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1p3beta1.LocationName;
import com.google.cloud.vision.v1p3beta1.Product;
import com.google.cloud.vision.v1p3beta1.ProductName;
import com.google.cloud.vision.v1p3beta1.ProductSearchClient;
import com.google.cloud.vision.v1p3beta1.ProductSearchSettings;
import com.google.cloud.vision.v1p3beta1.ProductSet;
import com.google.cloud.vision.v1p3beta1.ProductSetName;
import com.google.cloud.vision.v1p3beta1.ReferenceImage;
import com.google.cloud.vision.v1p3beta1.ReferenceImageName;
import com.google.cloud.vision.v1p3beta1.stub.HttpJsonProductSearchStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductSearchClientHttpJsonTest {
    private static MockHttpService mockService;
    private static ProductSearchClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonProductSearchStub.getMethodDescriptors(), ProductSearchSettings.getDefaultEndpoint());
        ProductSearchSettings settings = ((ProductSearchSettings.Builder)((ProductSearchSettings.Builder)ProductSearchSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)ProductSearchSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = ProductSearchClient.create((ProductSearchSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSet productSet = ProductSet.newBuilder().build();
        String productSetId = "productSetId1003042158";
        ProductSet actualResponse = client.createProductSet(parent, productSet, productSetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ProductSet productSet = ProductSet.newBuilder().build();
            String productSetId = "productSetId1003042158";
            client.createProductSet(parent, productSet, productSetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductSetTest2() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ProductSet productSet = ProductSet.newBuilder().build();
        String productSetId = "productSetId1003042158";
        ProductSet actualResponse = client.createProductSet(parent, productSet, productSetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            ProductSet productSet = ProductSet.newBuilder().build();
            String productSetId = "productSetId1003042158";
            client.createProductSet(parent, productSet, productSetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductSetsTest() throws Exception {
        ProductSet responsesElement = ProductSet.newBuilder().build();
        ListProductSetsResponse expectedResponse = ListProductSetsResponse.newBuilder().setNextPageToken("").addAllProductSets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductSetsPagedResponse pagedListResponse = client.listProductSets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductSetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductSetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listProductSets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductSetsTest2() throws Exception {
        ProductSet responsesElement = ProductSet.newBuilder().build();
        ListProductSetsResponse expectedResponse = ListProductSetsResponse.newBuilder().setNextPageToken("").addAllProductSets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ProductSearchClient.ListProductSetsPagedResponse pagedListResponse = client.listProductSets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductSetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductSetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listProductSets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSet actualResponse = client.getProductSet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            client.getProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductSetTest2() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        ProductSet actualResponse = client.getProductSet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            client.getProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProductSet productSet = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ProductSet actualResponse = client.updateProductSet(productSet, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSet productSet = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(Status.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateProductSet(productSet, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        client.deleteProductSet(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            client.deleteProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        client.deleteProductSet(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            client.deleteProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Product product = Product.newBuilder().build();
        String productId = "productId-1051830678";
        Product actualResponse = client.createProduct(parent, product, productId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProductExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Product product = Product.newBuilder().build();
            String productId = "productId-1051830678";
            client.createProduct(parent, product, productId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductTest2() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        Product product = Product.newBuilder().build();
        String productId = "productId-1051830678";
        Product actualResponse = client.createProduct(parent, product, productId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProductExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Product product = Product.newBuilder().build();
            String productId = "productId-1051830678";
            client.createProduct(parent, product, productId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsResponse expectedResponse = ListProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductsPagedResponse pagedListResponse = client.listProducts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listProducts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsTest2() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsResponse expectedResponse = ListProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ProductSearchClient.ListProductsPagedResponse pagedListResponse = client.listProducts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listProducts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        Product actualResponse = client.getProduct(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProductExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.getProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductTest2() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4324/locations/location-4324/products/product-4324";
        Product actualResponse = client.getProduct(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProductExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4324/locations/location-4324/products/product-4324";
            client.getProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        Product product = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Product actualResponse = client.updateProduct(product, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProductExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Product product = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateProduct(product, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        client.deleteProduct(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProductExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.deleteProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4324/locations/location-4324/products/product-4324";
        client.deleteProduct(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProductExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4324/locations/location-4324/products/product-4324";
            client.deleteProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReferenceImageTest() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
        String referenceImageId = "referenceImageId1224107531";
        ReferenceImage actualResponse = client.createReferenceImage(parent, referenceImage, referenceImageId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createReferenceImageExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
            String referenceImageId = "referenceImageId1224107531";
            client.createReferenceImage(parent, referenceImage, referenceImageId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReferenceImageTest2() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7253/locations/location-7253/products/product-7253";
        ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
        String referenceImageId = "referenceImageId1224107531";
        ReferenceImage actualResponse = client.createReferenceImage(parent, referenceImage, referenceImageId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createReferenceImageExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7253/locations/location-7253/products/product-7253";
            ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
            String referenceImageId = "referenceImageId1224107531";
            client.createReferenceImage(parent, referenceImage, referenceImageId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReferenceImageTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        client.deleteReferenceImage(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteReferenceImageExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            client.deleteReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReferenceImageTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-61/locations/location-61/products/product-61/referenceImages/referenceImage-61";
        client.deleteReferenceImage(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteReferenceImageExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-61/locations/location-61/products/product-61/referenceImages/referenceImage-61";
            client.deleteReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReferenceImagesTest() throws Exception {
        ReferenceImage responsesElement = ReferenceImage.newBuilder().build();
        ListReferenceImagesResponse expectedResponse = ListReferenceImagesResponse.newBuilder().setNextPageToken("").addAllReferenceImages(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ProductSearchClient.ListReferenceImagesPagedResponse pagedListResponse = client.listReferenceImages(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReferenceImagesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listReferenceImagesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.listReferenceImages(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReferenceImagesTest2() throws Exception {
        ReferenceImage responsesElement = ReferenceImage.newBuilder().build();
        ListReferenceImagesResponse expectedResponse = ListReferenceImagesResponse.newBuilder().setNextPageToken("").addAllReferenceImages(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7253/locations/location-7253/products/product-7253";
        ProductSearchClient.ListReferenceImagesPagedResponse pagedListResponse = client.listReferenceImages(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReferenceImagesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listReferenceImagesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7253/locations/location-7253/products/product-7253";
            client.listReferenceImages(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReferenceImageTest() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        ReferenceImage actualResponse = client.getReferenceImage(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getReferenceImageExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            client.getReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReferenceImageTest2() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-61/locations/location-61/products/product-61/referenceImages/referenceImage-61";
        ReferenceImage actualResponse = client.getReferenceImage(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getReferenceImageExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-61/locations/location-61/products/product-61/referenceImages/referenceImage-61";
            client.getReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        client.addProductToProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addProductToProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        client.addProductToProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addProductToProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        client.addProductToProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addProductToProductSetExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest4() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        String product = "product-309474065";
        client.addProductToProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addProductToProductSetExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            String product = "product-309474065";
            client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        client.removeProductFromProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeProductFromProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        client.removeProductFromProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeProductFromProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        client.removeProductFromProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeProductFromProductSetExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest4() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        String product = "product-309474065";
        client.removeProductFromProductSet(name, product);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeProductFromProductSetExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            String product = "product-309474065";
            client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsInProductSetTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsInProductSetResponse expectedResponse = ListProductsInProductSetResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSearchClient.ListProductsInProductSetPagedResponse pagedListResponse = client.listProductsInProductSet(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductsInProductSetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            client.listProductsInProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsInProductSetTest2() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsInProductSetResponse expectedResponse = ListProductsInProductSetResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
        ProductSearchClient.ListProductsInProductSetPagedResponse pagedListResponse = client.listProductsInProductSet(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProductsInProductSetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7514/locations/location-7514/productSets/productSet-7514";
            client.listProductsInProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importProductSetsTest() throws Exception {
        ImportProductSetsResponse expectedResponse = ImportProductSetsResponse.newBuilder().addAllReferenceImages(new ArrayList()).addAllStatuses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("importProductSetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
        ImportProductSetsResponse actualResponse = (ImportProductSetsResponse)client.importProductSetsAsync(parent, inputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void importProductSetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
            client.importProductSetsAsync(parent, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void importProductSetsTest2() throws Exception {
        ImportProductSetsResponse expectedResponse = ImportProductSetsResponse.newBuilder().addAllReferenceImages(new ArrayList()).addAllStatuses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("importProductSetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
        ImportProductSetsResponse actualResponse = (ImportProductSetsResponse)client.importProductSetsAsync(parent, inputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void importProductSetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
            client.importProductSetsAsync(parent, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

