/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p4beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.vision.v1p4beta1.AsyncBatchAnnotateFilesResponse;
import com.google.cloud.vision.v1p4beta1.AsyncBatchAnnotateImagesResponse;
import com.google.cloud.vision.v1p4beta1.BatchAnnotateFilesResponse;
import com.google.cloud.vision.v1p4beta1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1p4beta1.ImageAnnotatorClient;
import com.google.cloud.vision.v1p4beta1.ImageAnnotatorSettings;
import com.google.cloud.vision.v1p4beta1.OutputConfig;
import com.google.cloud.vision.v1p4beta1.stub.HttpJsonImageAnnotatorStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageAnnotatorClientHttpJsonTest {
    private static MockHttpService mockService;
    private static ImageAnnotatorClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonImageAnnotatorStub.getMethodDescriptors(), ImageAnnotatorSettings.getDefaultEndpoint());
        ImageAnnotatorSettings settings = ((ImageAnnotatorSettings.Builder)((ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)ImageAnnotatorSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = ImageAnnotatorClient.create((ImageAnnotatorSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void batchAnnotateImagesTest() throws Exception {
        BatchAnnotateImagesResponse expectedResponse = BatchAnnotateImagesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ArrayList requests = new ArrayList();
        BatchAnnotateImagesResponse actualResponse = client.batchAnnotateImages(requests);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchAnnotateImagesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ArrayList requests = new ArrayList();
            client.batchAnnotateImages(requests);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchAnnotateFilesTest() throws Exception {
        BatchAnnotateFilesResponse expectedResponse = BatchAnnotateFilesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ArrayList requests = new ArrayList();
        BatchAnnotateFilesResponse actualResponse = client.batchAnnotateFiles(requests);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchAnnotateFilesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ArrayList requests = new ArrayList();
            client.batchAnnotateFiles(requests);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void asyncBatchAnnotateImagesTest() throws Exception {
        AsyncBatchAnnotateImagesResponse expectedResponse = AsyncBatchAnnotateImagesResponse.newBuilder().setOutputConfig(OutputConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("asyncBatchAnnotateImagesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ArrayList requests = new ArrayList();
        OutputConfig outputConfig = OutputConfig.newBuilder().build();
        AsyncBatchAnnotateImagesResponse actualResponse = (AsyncBatchAnnotateImagesResponse)client.asyncBatchAnnotateImagesAsync(requests, outputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void asyncBatchAnnotateImagesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ArrayList requests = new ArrayList();
            OutputConfig outputConfig = OutputConfig.newBuilder().build();
            client.asyncBatchAnnotateImagesAsync(requests, outputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void asyncBatchAnnotateFilesTest() throws Exception {
        AsyncBatchAnnotateFilesResponse expectedResponse = AsyncBatchAnnotateFilesResponse.newBuilder().addAllResponses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("asyncBatchAnnotateFilesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ArrayList requests = new ArrayList();
        AsyncBatchAnnotateFilesResponse actualResponse = (AsyncBatchAnnotateFilesResponse)client.asyncBatchAnnotateFilesAsync(requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void asyncBatchAnnotateFilesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ArrayList requests = new ArrayList();
            client.asyncBatchAnnotateFilesAsync(requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

