/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.vision.v1p4beta1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1p4beta1.CreateProductRequest;
import com.google.cloud.vision.v1p4beta1.CreateProductSetRequest;
import com.google.cloud.vision.v1p4beta1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.DeleteProductRequest;
import com.google.cloud.vision.v1p4beta1.DeleteProductSetRequest;
import com.google.cloud.vision.v1p4beta1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.GetProductRequest;
import com.google.cloud.vision.v1p4beta1.GetProductSetRequest;
import com.google.cloud.vision.v1p4beta1.GetReferenceImageRequest;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsInputConfig;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsRequest;
import com.google.cloud.vision.v1p4beta1.ImportProductSetsResponse;
import com.google.cloud.vision.v1p4beta1.ListProductSetsRequest;
import com.google.cloud.vision.v1p4beta1.ListProductSetsResponse;
import com.google.cloud.vision.v1p4beta1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1p4beta1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1p4beta1.ListProductsRequest;
import com.google.cloud.vision.v1p4beta1.ListProductsResponse;
import com.google.cloud.vision.v1p4beta1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1p4beta1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1p4beta1.LocationName;
import com.google.cloud.vision.v1p4beta1.MockProductSearch;
import com.google.cloud.vision.v1p4beta1.Product;
import com.google.cloud.vision.v1p4beta1.ProductName;
import com.google.cloud.vision.v1p4beta1.ProductSearchClient;
import com.google.cloud.vision.v1p4beta1.ProductSearchSettings;
import com.google.cloud.vision.v1p4beta1.ProductSet;
import com.google.cloud.vision.v1p4beta1.ProductSetName;
import com.google.cloud.vision.v1p4beta1.PurgeProductsRequest;
import com.google.cloud.vision.v1p4beta1.ReferenceImage;
import com.google.cloud.vision.v1p4beta1.ReferenceImageName;
import com.google.cloud.vision.v1p4beta1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1p4beta1.UpdateProductRequest;
import com.google.cloud.vision.v1p4beta1.UpdateProductSetRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductSearchClientTest {
    private static MockProductSearch mockProductSearch;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private ProductSearchClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockProductSearch = new MockProductSearch();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockProductSearch));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        ProductSearchSettings settings = ((ProductSearchSettings.Builder)((ProductSearchSettings.Builder)ProductSearchSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ProductSearchClient.create((ProductSearchSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(com.google.rpc.Status.newBuilder().build()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSet productSet = ProductSet.newBuilder().build();
        String productSetId = "productSetId1003042158";
        ProductSet actualResponse = this.client.createProductSet(parent, productSet, productSetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductSetRequest actualRequest = (CreateProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)productSet, (Object)actualRequest.getProductSet());
        Assert.assertEquals((Object)productSetId, (Object)actualRequest.getProductSetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ProductSet productSet = ProductSet.newBuilder().build();
            String productSetId = "productSetId1003042158";
            this.client.createProductSet(parent, productSet, productSetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductSetTest2() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(com.google.rpc.Status.newBuilder().build()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ProductSet productSet = ProductSet.newBuilder().build();
        String productSetId = "productSetId1003042158";
        ProductSet actualResponse = this.client.createProductSet(parent, productSet, productSetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductSetRequest actualRequest = (CreateProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)productSet, (Object)actualRequest.getProductSet());
        Assert.assertEquals((Object)productSetId, (Object)actualRequest.getProductSetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ProductSet productSet = ProductSet.newBuilder().build();
            String productSetId = "productSetId1003042158";
            this.client.createProductSet(parent, productSet, productSetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductSetsTest() throws Exception {
        ProductSet responsesElement = ProductSet.newBuilder().build();
        ListProductSetsResponse expectedResponse = ListProductSetsResponse.newBuilder().setNextPageToken("").addAllProductSets(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductSetsPagedResponse pagedListResponse = this.client.listProductSets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductSetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductSetsRequest actualRequest = (ListProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductSetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProductSets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductSetsTest2() throws Exception {
        ProductSet responsesElement = ProductSet.newBuilder().build();
        ListProductSetsResponse expectedResponse = ListProductSetsResponse.newBuilder().setNextPageToken("").addAllProductSets(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ProductSearchClient.ListProductSetsPagedResponse pagedListResponse = this.client.listProductSets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductSetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductSetsRequest actualRequest = (ListProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductSetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listProductSets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(com.google.rpc.Status.newBuilder().build()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSet actualResponse = this.client.getProductSet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductSetRequest actualRequest = (GetProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.getProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductSetTest2() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(com.google.rpc.Status.newBuilder().build()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProductSet actualResponse = this.client.getProductSet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductSetRequest actualRequest = (GetProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductSetTest() throws Exception {
        ProductSet expectedResponse = ProductSet.newBuilder().setName(ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]").toString()).setDisplayName("displayName1714148973").setIndexTime(Timestamp.newBuilder().build()).setIndexError(com.google.rpc.Status.newBuilder().build()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSet productSet = ProductSet.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ProductSet actualResponse = this.client.updateProductSet(productSet, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProductSetRequest actualRequest = (UpdateProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)productSet, (Object)actualRequest.getProductSet());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSet productSet = ProductSet.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProductSet(productSet, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        this.client.deleteProductSet(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductSetRequest actualRequest = (DeleteProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.deleteProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteProductSet(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductSetRequest actualRequest = (DeleteProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Product product = Product.newBuilder().build();
        String productId = "productId-1051830678";
        Product actualResponse = this.client.createProduct(parent, product, productId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductRequest actualRequest = (CreateProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertEquals((Object)productId, (Object)actualRequest.getProductId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Product product = Product.newBuilder().build();
            String productId = "productId-1051830678";
            this.client.createProduct(parent, product, productId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProductTest2() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Product product = Product.newBuilder().build();
        String productId = "productId-1051830678";
        Product actualResponse = this.client.createProduct(parent, product, productId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProductRequest actualRequest = (CreateProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertEquals((Object)productId, (Object)actualRequest.getProductId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProductExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Product product = Product.newBuilder().build();
            String productId = "productId-1051830678";
            this.client.createProduct(parent, product, productId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsResponse expectedResponse = ListProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ProductSearchClient.ListProductsPagedResponse pagedListResponse = this.client.listProducts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsRequest actualRequest = (ListProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProducts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsTest2() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsResponse expectedResponse = ListProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ProductSearchClient.ListProductsPagedResponse pagedListResponse = this.client.listProducts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsRequest actualRequest = (ListProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listProducts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        Product actualResponse = this.client.getProduct(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductRequest actualRequest = (GetProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.getProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProductTest2() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Product actualResponse = this.client.getProduct(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProductRequest actualRequest = (GetProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProductExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProductTest() throws Exception {
        Product expectedResponse = Product.newBuilder().setName(ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setProductCategory("productCategory197299981").addAllProductLabels(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        Product product = Product.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Product actualResponse = this.client.updateProduct(product, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProductRequest actualRequest = (UpdateProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            Product product = Product.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProduct(product, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.deleteProduct(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductRequest actualRequest = (DeleteProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName name = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.deleteProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProductTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteProduct(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProductRequest actualRequest = (DeleteProductRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProductExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteProduct(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReferenceImageTest() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
        String referenceImageId = "referenceImageId1224107531";
        ReferenceImage actualResponse = this.client.createReferenceImage(parent, referenceImage, referenceImageId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReferenceImageRequest actualRequest = (CreateReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)referenceImage, (Object)actualRequest.getReferenceImage());
        Assert.assertEquals((Object)referenceImageId, (Object)actualRequest.getReferenceImageId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
            String referenceImageId = "referenceImageId1224107531";
            this.client.createReferenceImage(parent, referenceImage, referenceImageId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReferenceImageTest2() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
        String referenceImageId = "referenceImageId1224107531";
        ReferenceImage actualResponse = this.client.createReferenceImage(parent, referenceImage, referenceImageId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReferenceImageRequest actualRequest = (CreateReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)referenceImage, (Object)actualRequest.getReferenceImage());
        Assert.assertEquals((Object)referenceImageId, (Object)actualRequest.getReferenceImageId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReferenceImageExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ReferenceImage referenceImage = ReferenceImage.newBuilder().build();
            String referenceImageId = "referenceImageId1224107531";
            this.client.createReferenceImage(parent, referenceImage, referenceImageId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReferenceImageTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        this.client.deleteReferenceImage(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteReferenceImageRequest actualRequest = (DeleteReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            this.client.deleteReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteReferenceImageTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteReferenceImage(name);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteReferenceImageRequest actualRequest = (DeleteReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteReferenceImageExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReferenceImagesTest() throws Exception {
        ReferenceImage responsesElement = ReferenceImage.newBuilder().build();
        ListReferenceImagesResponse expectedResponse = ListReferenceImagesResponse.newBuilder().setNextPageToken("").addAllReferenceImages(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        ProductSearchClient.ListReferenceImagesPagedResponse pagedListResponse = this.client.listReferenceImages(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReferenceImagesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReferenceImagesRequest actualRequest = (ListReferenceImagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReferenceImagesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductName parent = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.listReferenceImages(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listReferenceImagesTest2() throws Exception {
        ReferenceImage responsesElement = ReferenceImage.newBuilder().build();
        ListReferenceImagesResponse expectedResponse = ListReferenceImagesResponse.newBuilder().setNextPageToken("").addAllReferenceImages(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ProductSearchClient.ListReferenceImagesPagedResponse pagedListResponse = this.client.listReferenceImages(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getReferenceImagesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListReferenceImagesRequest actualRequest = (ListReferenceImagesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listReferenceImagesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listReferenceImages(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReferenceImageTest() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
        ReferenceImage actualResponse = this.client.getReferenceImage(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetReferenceImageRequest actualRequest = (GetReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getReferenceImageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ReferenceImageName name = ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]");
            this.client.getReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getReferenceImageTest2() throws Exception {
        ReferenceImage expectedResponse = ReferenceImage.newBuilder().setName(ReferenceImageName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]", (String)"[REFERENCE_IMAGE]").toString()).setUri("uri116076").addAllBoundingPolys(new ArrayList()).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ReferenceImage actualResponse = this.client.getReferenceImage(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetReferenceImageRequest actualRequest = (GetReferenceImageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getReferenceImageExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getReferenceImage(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.addProductToProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddProductToProductSetRequest actualRequest = (AddProductToProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)product.toString(), (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addProductToProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        this.client.addProductToProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddProductToProductSetRequest actualRequest = (AddProductToProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addProductToProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            this.client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.addProductToProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddProductToProductSetRequest actualRequest = (AddProductToProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)product.toString(), (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addProductToProductSetExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addProductToProductSetTest4() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String product = "product-309474065";
        this.client.addProductToProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddProductToProductSetRequest actualRequest = (AddProductToProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addProductToProductSetExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            String product = "product-309474065";
            this.client.addProductToProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.removeProductFromProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveProductFromProductSetRequest actualRequest = (RemoveProductFromProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)product.toString(), (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeProductFromProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        String product = "product-309474065";
        this.client.removeProductFromProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveProductFromProductSetRequest actualRequest = (RemoveProductFromProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeProductFromProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            String product = "product-309474065";
            this.client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest3() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
        this.client.removeProductFromProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveProductFromProductSetRequest actualRequest = (RemoveProductFromProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)product.toString(), (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeProductFromProductSetExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            ProductName product = ProductName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT]");
            this.client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeProductFromProductSetTest4() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String product = "product-309474065";
        this.client.removeProductFromProductSet(name, product);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveProductFromProductSetRequest actualRequest = (RemoveProductFromProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)product, (Object)actualRequest.getProduct());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeProductFromProductSetExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            String product = "product-309474065";
            this.client.removeProductFromProductSet(name, product);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsInProductSetTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsInProductSetResponse expectedResponse = ListProductsInProductSetResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
        ProductSearchClient.ListProductsInProductSetPagedResponse pagedListResponse = this.client.listProductsInProductSet(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsInProductSetRequest actualRequest = (ListProductsInProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsInProductSetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            ProductSetName name = ProductSetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRODUCT_SET]");
            this.client.listProductsInProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProductsInProductSetTest2() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        ListProductsInProductSetResponse expectedResponse = ListProductsInProductSetResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockProductSearch.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProductSearchClient.ListProductsInProductSetPagedResponse pagedListResponse = this.client.listProductsInProductSet(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProductsInProductSetRequest actualRequest = (ListProductsInProductSetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProductsInProductSetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listProductsInProductSet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importProductSetsTest() throws Exception {
        ImportProductSetsResponse expectedResponse = ImportProductSetsResponse.newBuilder().addAllReferenceImages(new ArrayList()).addAllStatuses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("importProductSetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockProductSearch.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
        ImportProductSetsResponse actualResponse = (ImportProductSetsResponse)this.client.importProductSetsAsync(parent, inputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportProductSetsRequest actualRequest = (ImportProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)inputConfig, (Object)actualRequest.getInputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importProductSetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
            this.client.importProductSetsAsync(parent, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void importProductSetsTest2() throws Exception {
        ImportProductSetsResponse expectedResponse = ImportProductSetsResponse.newBuilder().addAllReferenceImages(new ArrayList()).addAllStatuses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("importProductSetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockProductSearch.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
        ImportProductSetsResponse actualResponse = (ImportProductSetsResponse)this.client.importProductSetsAsync(parent, inputConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportProductSetsRequest actualRequest = (ImportProductSetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)inputConfig, (Object)actualRequest.getInputConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importProductSetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ImportProductSetsInputConfig inputConfig = ImportProductSetsInputConfig.newBuilder().build();
            this.client.importProductSetsAsync(parent, inputConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void purgeProductsTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("purgeProductsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockProductSearch.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        this.client.purgeProductsAsync(parent).get();
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PurgeProductsRequest actualRequest = (PurgeProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void purgeProductsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.purgeProductsAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void purgeProductsTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("purgeProductsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockProductSearch.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        this.client.purgeProductsAsync(parent).get();
        List<AbstractMessage> actualRequests = mockProductSearch.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PurgeProductsRequest actualRequest = (PurgeProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void purgeProductsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockProductSearch.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.purgeProductsAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

