/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.AcquireLeaseRequest;
import com.google.cloud.visionai.v1.Lease;
import com.google.cloud.visionai.v1.ReceiveEventsRequest;
import com.google.cloud.visionai.v1.ReceiveEventsResponse;
import com.google.cloud.visionai.v1.ReceivePacketsRequest;
import com.google.cloud.visionai.v1.ReceivePacketsResponse;
import com.google.cloud.visionai.v1.ReleaseLeaseRequest;
import com.google.cloud.visionai.v1.ReleaseLeaseResponse;
import com.google.cloud.visionai.v1.RenewLeaseRequest;
import com.google.cloud.visionai.v1.SendPacketsRequest;
import com.google.cloud.visionai.v1.SendPacketsResponse;
import com.google.cloud.visionai.v1.StreamingServiceSettings;
import com.google.cloud.visionai.v1.stub.StreamingServiceStub;
import com.google.cloud.visionai.v1.stub.StreamingServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class StreamingServiceClient
implements BackgroundResource {
    private final StreamingServiceSettings settings;
    private final StreamingServiceStub stub;

    public static final StreamingServiceClient create() throws IOException {
        return StreamingServiceClient.create(StreamingServiceSettings.newBuilder().build());
    }

    public static final StreamingServiceClient create(StreamingServiceSettings settings) throws IOException {
        return new StreamingServiceClient(settings);
    }

    public static final StreamingServiceClient create(StreamingServiceStub stub) {
        return new StreamingServiceClient(stub);
    }

    protected StreamingServiceClient(StreamingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StreamingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected StreamingServiceClient(StreamingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StreamingServiceSettings getSettings() {
        return this.settings;
    }

    public StreamingServiceStub getStub() {
        return this.stub;
    }

    public final BidiStreamingCallable<SendPacketsRequest, SendPacketsResponse> sendPacketsCallable() {
        return this.stub.sendPacketsCallable();
    }

    public final BidiStreamingCallable<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsCallable() {
        return this.stub.receivePacketsCallable();
    }

    public final BidiStreamingCallable<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsCallable() {
        return this.stub.receiveEventsCallable();
    }

    public final Lease acquireLease(AcquireLeaseRequest request) {
        return (Lease)this.acquireLeaseCallable().call((Object)request);
    }

    public final UnaryCallable<AcquireLeaseRequest, Lease> acquireLeaseCallable() {
        return this.stub.acquireLeaseCallable();
    }

    public final Lease renewLease(RenewLeaseRequest request) {
        return (Lease)this.renewLeaseCallable().call((Object)request);
    }

    public final UnaryCallable<RenewLeaseRequest, Lease> renewLeaseCallable() {
        return this.stub.renewLeaseCallable();
    }

    public final ReleaseLeaseResponse releaseLease(ReleaseLeaseRequest request) {
        return (ReleaseLeaseResponse)this.releaseLeaseCallable().call((Object)request);
    }

    public final UnaryCallable<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseCallable() {
        return this.stub.releaseLeaseCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

