/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.AddApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.AppPlatformClient;
import com.google.cloud.visionai.v1.AppPlatformSettings;
import com.google.cloud.visionai.v1.Application;
import com.google.cloud.visionai.v1.ApplicationConfigs;
import com.google.cloud.visionai.v1.ApplicationName;
import com.google.cloud.visionai.v1.CreateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.CustomProcessorSourceInfo;
import com.google.cloud.visionai.v1.DeployApplicationResponse;
import com.google.cloud.visionai.v1.Draft;
import com.google.cloud.visionai.v1.DraftName;
import com.google.cloud.visionai.v1.Instance;
import com.google.cloud.visionai.v1.InstanceName;
import com.google.cloud.visionai.v1.ListApplicationsResponse;
import com.google.cloud.visionai.v1.ListDraftsResponse;
import com.google.cloud.visionai.v1.ListInstancesResponse;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsResponse;
import com.google.cloud.visionai.v1.ListProcessorsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.ModelType;
import com.google.cloud.visionai.v1.Processor;
import com.google.cloud.visionai.v1.ProcessorIOSpec;
import com.google.cloud.visionai.v1.ProcessorName;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UndeployApplicationResponse;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.stub.HttpJsonAppPlatformStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AppPlatformClientHttpJsonTest {
    private static MockHttpService mockService;
    private static AppPlatformClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonAppPlatformStub.getMethodDescriptors(), AppPlatformSettings.getDefaultEndpoint());
        AppPlatformSettings settings = ((AppPlatformSettings.Builder)((AppPlatformSettings.Builder)AppPlatformSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)AppPlatformSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = AppPlatformClient.create((AppPlatformSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listApplicationsTest() throws Exception {
        Application responsesElement = Application.newBuilder().build();
        ListApplicationsResponse expectedResponse = ListApplicationsResponse.newBuilder().setNextPageToken("").addAllApplications(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AppPlatformClient.ListApplicationsPagedResponse pagedListResponse = client.listApplications(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getApplicationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listApplicationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listApplications(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listApplicationsTest2() throws Exception {
        Application responsesElement = Application.newBuilder().build();
        ListApplicationsResponse expectedResponse = ListApplicationsResponse.newBuilder().setNextPageToken("").addAllApplications(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        AppPlatformClient.ListApplicationsPagedResponse pagedListResponse = client.listApplications(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getApplicationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listApplicationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listApplications(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Application actualResponse = client.getApplication(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.getApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getApplicationTest2() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        Application actualResponse = client.getApplication(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getApplicationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.getApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Application application = Application.newBuilder().build();
        Application actualResponse = (Application)client.createApplicationAsync(parent, application).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Application application = Application.newBuilder().build();
            client.createApplicationAsync(parent, application).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationTest2() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Application application = Application.newBuilder().build();
        Application actualResponse = (Application)client.createApplicationAsync(parent, application).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createApplicationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Application application = Application.newBuilder().build();
            client.createApplicationAsync(parent, application).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Application application = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Application actualResponse = (Application)client.updateApplicationAsync(application, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Application application = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateApplicationAsync(application, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteApplicationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        client.deleteApplicationAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.deleteApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteApplicationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        client.deleteApplicationAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteApplicationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.deleteApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deployApplicationTest() throws Exception {
        DeployApplicationResponse expectedResponse = DeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        DeployApplicationResponse actualResponse = (DeployApplicationResponse)client.deployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deployApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.deployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deployApplicationTest2() throws Exception {
        DeployApplicationResponse expectedResponse = DeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        DeployApplicationResponse actualResponse = (DeployApplicationResponse)client.deployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deployApplicationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.deployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void undeployApplicationTest() throws Exception {
        UndeployApplicationResponse expectedResponse = UndeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        UndeployApplicationResponse actualResponse = (UndeployApplicationResponse)client.undeployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void undeployApplicationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.undeployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void undeployApplicationTest2() throws Exception {
        UndeployApplicationResponse expectedResponse = UndeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        UndeployApplicationResponse actualResponse = (UndeployApplicationResponse)client.undeployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void undeployApplicationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.undeployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void addApplicationStreamInputTest() throws Exception {
        AddApplicationStreamInputResponse expectedResponse = AddApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("addApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AddApplicationStreamInputResponse actualResponse = (AddApplicationStreamInputResponse)client.addApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addApplicationStreamInputExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.addApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void addApplicationStreamInputTest2() throws Exception {
        AddApplicationStreamInputResponse expectedResponse = AddApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("addApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        AddApplicationStreamInputResponse actualResponse = (AddApplicationStreamInputResponse)client.addApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addApplicationStreamInputExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.addApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void removeApplicationStreamInputTest() throws Exception {
        RemoveApplicationStreamInputResponse expectedResponse = RemoveApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        RemoveApplicationStreamInputResponse actualResponse = (RemoveApplicationStreamInputResponse)client.removeApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeApplicationStreamInputExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.removeApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void removeApplicationStreamInputTest2() throws Exception {
        RemoveApplicationStreamInputResponse expectedResponse = RemoveApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        RemoveApplicationStreamInputResponse actualResponse = (RemoveApplicationStreamInputResponse)client.removeApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeApplicationStreamInputExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.removeApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationStreamInputTest() throws Exception {
        UpdateApplicationStreamInputResponse expectedResponse = UpdateApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        UpdateApplicationStreamInputResponse actualResponse = (UpdateApplicationStreamInputResponse)client.updateApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateApplicationStreamInputExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.updateApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationStreamInputTest2() throws Exception {
        UpdateApplicationStreamInputResponse expectedResponse = UpdateApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        UpdateApplicationStreamInputResponse actualResponse = (UpdateApplicationStreamInputResponse)client.updateApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateApplicationStreamInputExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.updateApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AppPlatformClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
        AppPlatformClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]");
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]");
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2349/locations/location-2349/applications/application-2349/instances/instance-2349";
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2349/locations/location-2349/applications/application-2349/instances/instance-2349";
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationInstancesTest() throws Exception {
        CreateApplicationInstancesResponse expectedResponse = CreateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        CreateApplicationInstancesResponse actualResponse = (CreateApplicationInstancesResponse)client.createApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createApplicationInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.createApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationInstancesTest2() throws Exception {
        CreateApplicationInstancesResponse expectedResponse = CreateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        CreateApplicationInstancesResponse actualResponse = (CreateApplicationInstancesResponse)client.createApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createApplicationInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.createApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteApplicationInstancesTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Instance actualResponse = (Instance)client.deleteApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteApplicationInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.deleteApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteApplicationInstancesTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        Instance actualResponse = (Instance)client.deleteApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteApplicationInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            client.deleteApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationInstancesTest() throws Exception {
        UpdateApplicationInstancesResponse expectedResponse = UpdateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        ArrayList applicationInstances = new ArrayList();
        UpdateApplicationInstancesResponse actualResponse = (UpdateApplicationInstancesResponse)client.updateApplicationInstancesAsync(name, applicationInstances).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateApplicationInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            ArrayList applicationInstances = new ArrayList();
            client.updateApplicationInstancesAsync(name, applicationInstances).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateApplicationInstancesTest2() throws Exception {
        UpdateApplicationInstancesResponse expectedResponse = UpdateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8131/locations/location-8131/applications/application-8131";
        ArrayList applicationInstances = new ArrayList();
        UpdateApplicationInstancesResponse actualResponse = (UpdateApplicationInstancesResponse)client.updateApplicationInstancesAsync(name, applicationInstances).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateApplicationInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8131/locations/location-8131/applications/application-8131";
            ArrayList applicationInstances = new ArrayList();
            client.updateApplicationInstancesAsync(name, applicationInstances).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listDraftsTest() throws Exception {
        Draft responsesElement = Draft.newBuilder().build();
        ListDraftsResponse expectedResponse = ListDraftsResponse.newBuilder().setNextPageToken("").addAllDrafts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AppPlatformClient.ListDraftsPagedResponse pagedListResponse = client.listDrafts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDraftsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDraftsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            client.listDrafts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDraftsTest2() throws Exception {
        Draft responsesElement = Draft.newBuilder().build();
        ListDraftsResponse expectedResponse = ListDraftsResponse.newBuilder().setNextPageToken("").addAllDrafts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
        AppPlatformClient.ListDraftsPagedResponse pagedListResponse = client.listDrafts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDraftsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDraftsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
            client.listDrafts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
        Draft actualResponse = client.getDraft(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDraftExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
            client.getDraft(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDraftTest2() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8201/locations/location-8201/applications/application-8201/drafts/draft-8201";
        Draft actualResponse = client.getDraft(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDraftExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8201/locations/location-8201/applications/application-8201/drafts/draft-8201";
            client.getDraft(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Draft draft = Draft.newBuilder().build();
        String draftId = "draftId1912512156";
        Draft actualResponse = (Draft)client.createDraftAsync(parent, draft, draftId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDraftExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            Draft draft = Draft.newBuilder().build();
            String draftId = "draftId1912512156";
            client.createDraftAsync(parent, draft, draftId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createDraftTest2() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
        Draft draft = Draft.newBuilder().build();
        String draftId = "draftId1912512156";
        Draft actualResponse = (Draft)client.createDraftAsync(parent, draft, draftId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDraftExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3956/locations/location-3956/applications/application-3956";
            Draft draft = Draft.newBuilder().build();
            String draftId = "draftId1912512156";
            client.createDraftAsync(parent, draft, draftId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Draft draft = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Draft actualResponse = (Draft)client.updateDraftAsync(draft, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDraftExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Draft draft = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDraftAsync(draft, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDraftTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
        client.deleteDraftAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDraftExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
            client.deleteDraftAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDraftTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8201/locations/location-8201/applications/application-8201/drafts/draft-8201";
        client.deleteDraftAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDraftExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8201/locations/location-8201/applications/application-8201/drafts/draft-8201";
            client.deleteDraftAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessorsTest() throws Exception {
        Processor responsesElement = Processor.newBuilder().build();
        ListProcessorsResponse expectedResponse = ListProcessorsResponse.newBuilder().setNextPageToken("").addAllProcessors(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AppPlatformClient.ListProcessorsPagedResponse pagedListResponse = client.listProcessors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessorsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessorsTest2() throws Exception {
        Processor responsesElement = Processor.newBuilder().build();
        ListProcessorsResponse expectedResponse = ListProcessorsResponse.newBuilder().setNextPageToken("").addAllProcessors(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        AppPlatformClient.ListProcessorsPagedResponse pagedListResponse = client.listProcessors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessorsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrebuiltProcessorsTest() throws Exception {
        ListPrebuiltProcessorsResponse expectedResponse = ListPrebuiltProcessorsResponse.newBuilder().addAllProcessors(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ListPrebuiltProcessorsResponse actualResponse = client.listPrebuiltProcessors(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPrebuiltProcessorsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listPrebuiltProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrebuiltProcessorsTest2() throws Exception {
        ListPrebuiltProcessorsResponse expectedResponse = ListPrebuiltProcessorsResponse.newBuilder().addAllProcessors(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ListPrebuiltProcessorsResponse actualResponse = client.listPrebuiltProcessors(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPrebuiltProcessorsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listPrebuiltProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
        Processor actualResponse = client.getProcessor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
            client.getProcessor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessorTest2() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5167/locations/location-5167/processors/processor-5167";
        Processor actualResponse = client.getProcessor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5167/locations/location-5167/processors/processor-5167";
            client.getProcessor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Processor processor = Processor.newBuilder().build();
        String processorId = "processorId203323725";
        Processor actualResponse = (Processor)client.createProcessorAsync(parent, processor, processorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Processor processor = Processor.newBuilder().build();
            String processorId = "processorId203323725";
            client.createProcessorAsync(parent, processor, processorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessorTest2() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Processor processor = Processor.newBuilder().build();
        String processorId = "processorId203323725";
        Processor actualResponse = (Processor)client.createProcessorAsync(parent, processor, processorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Processor processor = Processor.newBuilder().build();
            String processorId = "processorId203323725";
            client.createProcessorAsync(parent, processor, processorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Processor processor = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Processor actualResponse = (Processor)client.updateProcessorAsync(processor, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProcessorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Processor processor = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateProcessorAsync(processor, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessorTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
        client.deleteProcessorAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
            client.deleteProcessorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessorTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-5167/locations/location-5167/processors/processor-5167";
        client.deleteProcessorAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5167/locations/location-5167/processors/processor-5167";
            client.deleteProcessorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

