/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.AddApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.AddApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.AppPlatformClient;
import com.google.cloud.visionai.v1.AppPlatformSettings;
import com.google.cloud.visionai.v1.Application;
import com.google.cloud.visionai.v1.ApplicationConfigs;
import com.google.cloud.visionai.v1.ApplicationName;
import com.google.cloud.visionai.v1.CreateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.CreateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.CreateApplicationRequest;
import com.google.cloud.visionai.v1.CreateDraftRequest;
import com.google.cloud.visionai.v1.CreateProcessorRequest;
import com.google.cloud.visionai.v1.CustomProcessorSourceInfo;
import com.google.cloud.visionai.v1.DeleteApplicationInstancesRequest;
import com.google.cloud.visionai.v1.DeleteApplicationRequest;
import com.google.cloud.visionai.v1.DeleteDraftRequest;
import com.google.cloud.visionai.v1.DeleteProcessorRequest;
import com.google.cloud.visionai.v1.DeployApplicationRequest;
import com.google.cloud.visionai.v1.DeployApplicationResponse;
import com.google.cloud.visionai.v1.Draft;
import com.google.cloud.visionai.v1.DraftName;
import com.google.cloud.visionai.v1.GetApplicationRequest;
import com.google.cloud.visionai.v1.GetDraftRequest;
import com.google.cloud.visionai.v1.GetInstanceRequest;
import com.google.cloud.visionai.v1.GetProcessorRequest;
import com.google.cloud.visionai.v1.Instance;
import com.google.cloud.visionai.v1.InstanceName;
import com.google.cloud.visionai.v1.ListApplicationsRequest;
import com.google.cloud.visionai.v1.ListApplicationsResponse;
import com.google.cloud.visionai.v1.ListDraftsRequest;
import com.google.cloud.visionai.v1.ListDraftsResponse;
import com.google.cloud.visionai.v1.ListInstancesRequest;
import com.google.cloud.visionai.v1.ListInstancesResponse;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsRequest;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsResponse;
import com.google.cloud.visionai.v1.ListProcessorsRequest;
import com.google.cloud.visionai.v1.ListProcessorsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.MockAppPlatform;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.cloud.visionai.v1.ModelType;
import com.google.cloud.visionai.v1.Processor;
import com.google.cloud.visionai.v1.ProcessorIOSpec;
import com.google.cloud.visionai.v1.ProcessorName;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UndeployApplicationRequest;
import com.google.cloud.visionai.v1.UndeployApplicationResponse;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.UpdateApplicationRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UpdateDraftRequest;
import com.google.cloud.visionai.v1.UpdateProcessorRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AppPlatformClientTest {
    private static MockAppPlatform mockAppPlatform;
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private AppPlatformClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockAppPlatform = new MockAppPlatform();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAppPlatform, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        AppPlatformSettings settings = ((AppPlatformSettings.Builder)((AppPlatformSettings.Builder)AppPlatformSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = AppPlatformClient.create((AppPlatformSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listApplicationsTest() throws Exception {
        Application responsesElement = Application.newBuilder().build();
        ListApplicationsResponse expectedResponse = ListApplicationsResponse.newBuilder().setNextPageToken("").addAllApplications(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AppPlatformClient.ListApplicationsPagedResponse pagedListResponse = this.client.listApplications(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getApplicationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListApplicationsRequest actualRequest = (ListApplicationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listApplicationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listApplications(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listApplicationsTest2() throws Exception {
        Application responsesElement = Application.newBuilder().build();
        ListApplicationsResponse expectedResponse = ListApplicationsResponse.newBuilder().setNextPageToken("").addAllApplications(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AppPlatformClient.ListApplicationsPagedResponse pagedListResponse = this.client.listApplications(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getApplicationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListApplicationsRequest actualRequest = (ListApplicationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listApplicationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listApplications(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Application actualResponse = this.client.getApplication(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetApplicationRequest actualRequest = (GetApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.getApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getApplicationTest2() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Application actualResponse = this.client.getApplication(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetApplicationRequest actualRequest = (GetApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getApplicationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getApplication(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Application application = Application.newBuilder().build();
        Application actualResponse = (Application)this.client.createApplicationAsync(parent, application).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateApplicationRequest actualRequest = (CreateApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)application, (Object)actualRequest.getApplication());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Application application = Application.newBuilder().build();
            this.client.createApplicationAsync(parent, application).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createApplicationTest2() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Application application = Application.newBuilder().build();
        Application actualResponse = (Application)this.client.createApplicationAsync(parent, application).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateApplicationRequest actualRequest = (CreateApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)application, (Object)actualRequest.getApplication());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createApplicationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Application application = Application.newBuilder().build();
            this.client.createApplicationAsync(parent, application).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateApplicationTest() throws Exception {
        Application expectedResponse = Application.newBuilder().setName(ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setApplicationConfigs(ApplicationConfigs.newBuilder().build()).setRuntimeInfo(Application.ApplicationRuntimeInfo.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        Application application = Application.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Application actualResponse = (Application)this.client.updateApplicationAsync(application, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationRequest actualRequest = (UpdateApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)application, (Object)actualRequest.getApplication());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            Application application = Application.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateApplicationAsync(application, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteApplicationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        this.client.deleteApplicationAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteApplicationRequest actualRequest = (DeleteApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.deleteApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteApplicationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteApplicationAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteApplicationRequest actualRequest = (DeleteApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteApplicationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deployApplicationTest() throws Exception {
        DeployApplicationResponse expectedResponse = DeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        DeployApplicationResponse actualResponse = (DeployApplicationResponse)this.client.deployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeployApplicationRequest actualRequest = (DeployApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deployApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.deployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deployApplicationTest2() throws Exception {
        DeployApplicationResponse expectedResponse = DeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        DeployApplicationResponse actualResponse = (DeployApplicationResponse)this.client.deployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeployApplicationRequest actualRequest = (DeployApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deployApplicationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void undeployApplicationTest() throws Exception {
        UndeployApplicationResponse expectedResponse = UndeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        UndeployApplicationResponse actualResponse = (UndeployApplicationResponse)this.client.undeployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UndeployApplicationRequest actualRequest = (UndeployApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void undeployApplicationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.undeployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void undeployApplicationTest2() throws Exception {
        UndeployApplicationResponse expectedResponse = UndeployApplicationResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployApplicationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        UndeployApplicationResponse actualResponse = (UndeployApplicationResponse)this.client.undeployApplicationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UndeployApplicationRequest actualRequest = (UndeployApplicationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void undeployApplicationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.undeployApplicationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void addApplicationStreamInputTest() throws Exception {
        AddApplicationStreamInputResponse expectedResponse = AddApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("addApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AddApplicationStreamInputResponse actualResponse = (AddApplicationStreamInputResponse)this.client.addApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddApplicationStreamInputRequest actualRequest = (AddApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addApplicationStreamInputExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.addApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void addApplicationStreamInputTest2() throws Exception {
        AddApplicationStreamInputResponse expectedResponse = AddApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("addApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        AddApplicationStreamInputResponse actualResponse = (AddApplicationStreamInputResponse)this.client.addApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddApplicationStreamInputRequest actualRequest = (AddApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addApplicationStreamInputExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.addApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void removeApplicationStreamInputTest() throws Exception {
        RemoveApplicationStreamInputResponse expectedResponse = RemoveApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        RemoveApplicationStreamInputResponse actualResponse = (RemoveApplicationStreamInputResponse)this.client.removeApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveApplicationStreamInputRequest actualRequest = (RemoveApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeApplicationStreamInputExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.removeApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void removeApplicationStreamInputTest2() throws Exception {
        RemoveApplicationStreamInputResponse expectedResponse = RemoveApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        RemoveApplicationStreamInputResponse actualResponse = (RemoveApplicationStreamInputResponse)this.client.removeApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveApplicationStreamInputRequest actualRequest = (RemoveApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeApplicationStreamInputExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.removeApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateApplicationStreamInputTest() throws Exception {
        UpdateApplicationStreamInputResponse expectedResponse = UpdateApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        UpdateApplicationStreamInputResponse actualResponse = (UpdateApplicationStreamInputResponse)this.client.updateApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationStreamInputRequest actualRequest = (UpdateApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationStreamInputExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.updateApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateApplicationStreamInputTest2() throws Exception {
        UpdateApplicationStreamInputResponse expectedResponse = UpdateApplicationStreamInputResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationStreamInputTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        UpdateApplicationStreamInputResponse actualResponse = (UpdateApplicationStreamInputResponse)this.client.updateApplicationStreamInputAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationStreamInputRequest actualRequest = (UpdateApplicationStreamInputRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationStreamInputExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.updateApplicationStreamInputAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AppPlatformClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AppPlatformClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createApplicationInstancesTest() throws Exception {
        CreateApplicationInstancesResponse expectedResponse = CreateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        CreateApplicationInstancesResponse actualResponse = (CreateApplicationInstancesResponse)this.client.createApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateApplicationInstancesRequest actualRequest = (CreateApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createApplicationInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.createApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createApplicationInstancesTest2() throws Exception {
        CreateApplicationInstancesResponse expectedResponse = CreateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("createApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        CreateApplicationInstancesResponse actualResponse = (CreateApplicationInstancesResponse)this.client.createApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateApplicationInstancesRequest actualRequest = (CreateApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createApplicationInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.createApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteApplicationInstancesTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Instance actualResponse = (Instance)this.client.deleteApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteApplicationInstancesRequest actualRequest = (DeleteApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteApplicationInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.deleteApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteApplicationInstancesTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[INSTANCE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllInputResources(new ArrayList()).addAllOutputResources(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Instance actualResponse = (Instance)this.client.deleteApplicationInstancesAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteApplicationInstancesRequest actualRequest = (DeleteApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteApplicationInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteApplicationInstancesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateApplicationInstancesTest() throws Exception {
        UpdateApplicationInstancesResponse expectedResponse = UpdateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        ArrayList applicationInstances = new ArrayList();
        UpdateApplicationInstancesResponse actualResponse = (UpdateApplicationInstancesResponse)this.client.updateApplicationInstancesAsync(name, applicationInstances).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationInstancesRequest actualRequest = (UpdateApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals(applicationInstances, (Object)actualRequest.getApplicationInstancesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName name = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            ArrayList applicationInstances = new ArrayList();
            this.client.updateApplicationInstancesAsync(name, applicationInstances).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateApplicationInstancesTest2() throws Exception {
        UpdateApplicationInstancesResponse expectedResponse = UpdateApplicationInstancesResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateApplicationInstancesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        ArrayList applicationInstances = new ArrayList();
        UpdateApplicationInstancesResponse actualResponse = (UpdateApplicationInstancesResponse)this.client.updateApplicationInstancesAsync(name, applicationInstances).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateApplicationInstancesRequest actualRequest = (UpdateApplicationInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals(applicationInstances, (Object)actualRequest.getApplicationInstancesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateApplicationInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            ArrayList applicationInstances = new ArrayList();
            this.client.updateApplicationInstancesAsync(name, applicationInstances).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listDraftsTest() throws Exception {
        Draft responsesElement = Draft.newBuilder().build();
        ListDraftsResponse expectedResponse = ListDraftsResponse.newBuilder().setNextPageToken("").addAllDrafts(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        AppPlatformClient.ListDraftsPagedResponse pagedListResponse = this.client.listDrafts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDraftsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDraftsRequest actualRequest = (ListDraftsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDraftsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            this.client.listDrafts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDraftsTest2() throws Exception {
        Draft responsesElement = Draft.newBuilder().build();
        ListDraftsResponse expectedResponse = ListDraftsResponse.newBuilder().setNextPageToken("").addAllDrafts(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AppPlatformClient.ListDraftsPagedResponse pagedListResponse = this.client.listDrafts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDraftsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDraftsRequest actualRequest = (ListDraftsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDraftsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDrafts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
        Draft actualResponse = this.client.getDraft(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDraftRequest actualRequest = (GetDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDraftExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
            this.client.getDraft(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDraftTest2() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Draft actualResponse = this.client.getDraft(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDraftRequest actualRequest = (GetDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDraftExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDraft(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
        Draft draft = Draft.newBuilder().build();
        String draftId = "draftId1912512156";
        Draft actualResponse = (Draft)this.client.createDraftAsync(parent, draft, draftId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDraftRequest actualRequest = (CreateDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)draft, (Object)actualRequest.getDraft());
        Assert.assertEquals((Object)draftId, (Object)actualRequest.getDraftId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDraftExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ApplicationName parent = ApplicationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]");
            Draft draft = Draft.newBuilder().build();
            String draftId = "draftId1912512156";
            this.client.createDraftAsync(parent, draft, draftId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createDraftTest2() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Draft draft = Draft.newBuilder().build();
        String draftId = "draftId1912512156";
        Draft actualResponse = (Draft)this.client.createDraftAsync(parent, draft, draftId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDraftRequest actualRequest = (CreateDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)draft, (Object)actualRequest.getDraft());
        Assert.assertEquals((Object)draftId, (Object)actualRequest.getDraftId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDraftExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Draft draft = Draft.newBuilder().build();
            String draftId = "draftId1912512156";
            this.client.createDraftAsync(parent, draft, draftId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateDraftTest() throws Exception {
        Draft expectedResponse = Draft.newBuilder().setName(DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDraftApplicationConfigs(ApplicationConfigs.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        Draft draft = Draft.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Draft actualResponse = (Draft)this.client.updateDraftAsync(draft, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDraftRequest actualRequest = (UpdateDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)draft, (Object)actualRequest.getDraft());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDraftExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            Draft draft = Draft.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDraftAsync(draft, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteDraftTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
        this.client.deleteDraftAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDraftRequest actualRequest = (DeleteDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDraftExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            DraftName name = DraftName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[APPLICATION]", (String)"[DRAFT]");
            this.client.deleteDraftAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteDraftTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDraftTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteDraftAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDraftRequest actualRequest = (DeleteDraftRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDraftExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDraftAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listProcessorsTest() throws Exception {
        Processor responsesElement = Processor.newBuilder().build();
        ListProcessorsResponse expectedResponse = ListProcessorsResponse.newBuilder().setNextPageToken("").addAllProcessors(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        AppPlatformClient.ListProcessorsPagedResponse pagedListResponse = this.client.listProcessors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessorsRequest actualRequest = (ListProcessorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessorsTest2() throws Exception {
        Processor responsesElement = Processor.newBuilder().build();
        ListProcessorsResponse expectedResponse = ListProcessorsResponse.newBuilder().setNextPageToken("").addAllProcessors(Arrays.asList(responsesElement)).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        AppPlatformClient.ListProcessorsPagedResponse pagedListResponse = this.client.listProcessors(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessorsRequest actualRequest = (ListProcessorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrebuiltProcessorsTest() throws Exception {
        ListPrebuiltProcessorsResponse expectedResponse = ListPrebuiltProcessorsResponse.newBuilder().addAllProcessors(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ListPrebuiltProcessorsResponse actualResponse = this.client.listPrebuiltProcessors(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrebuiltProcessorsRequest actualRequest = (ListPrebuiltProcessorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrebuiltProcessorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listPrebuiltProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrebuiltProcessorsTest2() throws Exception {
        ListPrebuiltProcessorsResponse expectedResponse = ListPrebuiltProcessorsResponse.newBuilder().addAllProcessors(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ListPrebuiltProcessorsResponse actualResponse = this.client.listPrebuiltProcessors(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrebuiltProcessorsRequest actualRequest = (ListPrebuiltProcessorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrebuiltProcessorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPrebuiltProcessors(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
        Processor actualResponse = this.client.getProcessor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessorRequest actualRequest = (GetProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
            this.client.getProcessor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessorTest2() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        mockAppPlatform.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Processor actualResponse = this.client.getProcessor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessorRequest actualRequest = (GetProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProcessor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Processor processor = Processor.newBuilder().build();
        String processorId = "processorId203323725";
        Processor actualResponse = (Processor)this.client.createProcessorAsync(parent, processor, processorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessorRequest actualRequest = (CreateProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)processor, (Object)actualRequest.getProcessor());
        Assert.assertEquals((Object)processorId, (Object)actualRequest.getProcessorId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Processor processor = Processor.newBuilder().build();
            String processorId = "processorId203323725";
            this.client.createProcessorAsync(parent, processor, processorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createProcessorTest2() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Processor processor = Processor.newBuilder().build();
        String processorId = "processorId203323725";
        Processor actualResponse = (Processor)this.client.createProcessorAsync(parent, processor, processorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessorRequest actualRequest = (CreateProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)processor, (Object)actualRequest.getProcessor());
        Assert.assertEquals((Object)processorId, (Object)actualRequest.getProcessorId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Processor processor = Processor.newBuilder().build();
            String processorId = "processorId203323725";
            this.client.createProcessorAsync(parent, processor, processorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateProcessorTest() throws Exception {
        Processor expectedResponse = Processor.newBuilder().setName(ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setModelType(ModelType.forNumber((int)0)).setCustomProcessorSourceInfo(CustomProcessorSourceInfo.newBuilder().build()).setProcessorIoSpec(ProcessorIOSpec.newBuilder().build()).setConfigurationTypeurl("configurationTypeurl679671327").addAllSupportedAnnotationTypes(new ArrayList()).setSupportsPostProcessing(true).addAllSupportedInstanceTypes(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        Processor processor = Processor.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Processor actualResponse = (Processor)this.client.updateProcessorAsync(processor, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProcessorRequest actualRequest = (UpdateProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)processor, (Object)actualRequest.getProcessor());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProcessorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            Processor processor = Processor.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProcessorAsync(processor, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteProcessorTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
        this.client.deleteProcessorAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessorRequest actualRequest = (DeleteProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            ProcessorName name = ProcessorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESSOR]");
            this.client.deleteProcessorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteProcessorTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAppPlatform.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteProcessorAsync(name).get();
        List<AbstractMessage> actualRequests = mockAppPlatform.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessorRequest actualRequest = (DeleteProcessorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAppPlatform.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteProcessorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

