/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.ClusterInfo;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.HealthCheckRequest;
import com.google.cloud.visionai.v1.HealthCheckResponse;
import com.google.cloud.visionai.v1.HealthCheckServiceClient;
import com.google.cloud.visionai.v1.HealthCheckServiceSettings;
import com.google.cloud.visionai.v1.stub.HttpJsonHealthCheckServiceStub;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HealthCheckServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static HealthCheckServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonHealthCheckServiceStub.getMethodDescriptors(), HealthCheckServiceSettings.getDefaultEndpoint());
        HealthCheckServiceSettings settings = ((HealthCheckServiceSettings.Builder)((HealthCheckServiceSettings.Builder)HealthCheckServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)HealthCheckServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = HealthCheckServiceClient.create((HealthCheckServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void healthCheckTest() throws Exception {
        HealthCheckResponse expectedResponse = HealthCheckResponse.newBuilder().setHealthy(true).setReason("reason-934964668").setClusterInfo(ClusterInfo.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        HealthCheckRequest request = HealthCheckRequest.newBuilder().setCluster(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).build();
        HealthCheckResponse actualResponse = client.healthCheck(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void healthCheckExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            HealthCheckRequest request = HealthCheckRequest.newBuilder().setCluster(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).build();
            client.healthCheck(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

