/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.ClusterInfo;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.HealthCheckRequest;
import com.google.cloud.visionai.v1.HealthCheckResponse;
import com.google.cloud.visionai.v1.HealthCheckServiceClient;
import com.google.cloud.visionai.v1.HealthCheckServiceSettings;
import com.google.cloud.visionai.v1.MockHealthCheckService;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HealthCheckServiceClientTest {
    private static MockHealthCheckService mockHealthCheckService;
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private HealthCheckServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockHealthCheckService = new MockHealthCheckService();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockHealthCheckService, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        HealthCheckServiceSettings settings = ((HealthCheckServiceSettings.Builder)((HealthCheckServiceSettings.Builder)HealthCheckServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = HealthCheckServiceClient.create((HealthCheckServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void healthCheckTest() throws Exception {
        HealthCheckResponse expectedResponse = HealthCheckResponse.newBuilder().setHealthy(true).setReason("reason-934964668").setClusterInfo(ClusterInfo.newBuilder().build()).build();
        mockHealthCheckService.addResponse((AbstractMessage)expectedResponse);
        HealthCheckRequest request = HealthCheckRequest.newBuilder().setCluster(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).build();
        HealthCheckResponse actualResponse = this.client.healthCheck(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockHealthCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        HealthCheckRequest actualRequest = (HealthCheckRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getCluster(), (Object)actualRequest.getCluster());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void healthCheckExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockHealthCheckService.addException((Exception)exception);
        try {
            HealthCheckRequest request = HealthCheckRequest.newBuilder().setCluster(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).build();
            this.client.healthCheck(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

