/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.Analysis;
import com.google.cloud.visionai.v1.AnalysisDefinition;
import com.google.cloud.visionai.v1.AnalysisName;
import com.google.cloud.visionai.v1.BatchRunProcessResponse;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.ListAnalysesResponse;
import com.google.cloud.visionai.v1.ListOperatorsResponse;
import com.google.cloud.visionai.v1.ListProcessesResponse;
import com.google.cloud.visionai.v1.ListPublicOperatorsResponse;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsClient;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsSettings;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.Operator;
import com.google.cloud.visionai.v1.OperatorDefinition;
import com.google.cloud.visionai.v1.OperatorName;
import com.google.cloud.visionai.v1.Process;
import com.google.cloud.visionai.v1.ProcessName;
import com.google.cloud.visionai.v1.ResolveOperatorInfoResponse;
import com.google.cloud.visionai.v1.RunMode;
import com.google.cloud.visionai.v1.RunStatus;
import com.google.cloud.visionai.v1.stub.HttpJsonLiveVideoAnalyticsStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LiveVideoAnalyticsClientHttpJsonTest {
    private static MockHttpService mockService;
    private static LiveVideoAnalyticsClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonLiveVideoAnalyticsStub.getMethodDescriptors(), LiveVideoAnalyticsSettings.getDefaultEndpoint());
        LiveVideoAnalyticsSettings settings = ((LiveVideoAnalyticsSettings.Builder)((LiveVideoAnalyticsSettings.Builder)LiveVideoAnalyticsSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)LiveVideoAnalyticsSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = LiveVideoAnalyticsClient.create((LiveVideoAnalyticsSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listPublicOperatorsTest() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListPublicOperatorsResponse expectedResponse = ListPublicOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse pagedListResponse = client.listPublicOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPublicOperatorsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listPublicOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPublicOperatorsTest2() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListPublicOperatorsResponse expectedResponse = ListPublicOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse pagedListResponse = client.listPublicOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPublicOperatorsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listPublicOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resolveOperatorInfoTest() throws Exception {
        ResolveOperatorInfoResponse expectedResponse = ResolveOperatorInfoResponse.newBuilder().addAllOperators(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ArrayList queries = new ArrayList();
        ResolveOperatorInfoResponse actualResponse = client.resolveOperatorInfo(parent, queries);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void resolveOperatorInfoExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ArrayList queries = new ArrayList();
            client.resolveOperatorInfo(parent, queries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resolveOperatorInfoTest2() throws Exception {
        ResolveOperatorInfoResponse expectedResponse = ResolveOperatorInfoResponse.newBuilder().addAllOperators(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ArrayList queries = new ArrayList();
        ResolveOperatorInfoResponse actualResponse = client.resolveOperatorInfo(parent, queries);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void resolveOperatorInfoExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            ArrayList queries = new ArrayList();
            client.resolveOperatorInfo(parent, queries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOperatorsTest() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListOperatorsResponse expectedResponse = ListOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LiveVideoAnalyticsClient.ListOperatorsPagedResponse pagedListResponse = client.listOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOperatorsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOperatorsTest2() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListOperatorsResponse expectedResponse = ListOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        LiveVideoAnalyticsClient.ListOperatorsPagedResponse pagedListResponse = client.listOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOperatorsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        mockService.addResponse((Object)expectedResponse);
        OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
        Operator actualResponse = client.getOperator(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOperatorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
            client.getOperator(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOperatorTest2() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1387/locations/location-1387/operators/operator-1387";
        Operator actualResponse = client.getOperator(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOperatorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1387/locations/location-1387/operators/operator-1387";
            client.getOperator(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("createOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Operator operator = Operator.newBuilder().build();
        String operatorId = "operatorId4364511";
        Operator actualResponse = (Operator)client.createOperatorAsync(parent, operator, operatorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createOperatorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Operator operator = Operator.newBuilder().build();
            String operatorId = "operatorId4364511";
            client.createOperatorAsync(parent, operator, operatorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createOperatorTest2() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("createOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Operator operator = Operator.newBuilder().build();
        String operatorId = "operatorId4364511";
        Operator actualResponse = (Operator)client.createOperatorAsync(parent, operator, operatorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createOperatorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Operator operator = Operator.newBuilder().build();
            String operatorId = "operatorId4364511";
            client.createOperatorAsync(parent, operator, operatorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("updateOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Operator operator = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Operator actualResponse = (Operator)client.updateOperatorAsync(operator, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateOperatorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Operator operator = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateOperatorAsync(operator, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteOperatorTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
        client.deleteOperatorAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteOperatorExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
            client.deleteOperatorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteOperatorTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-1387/locations/location-1387/operators/operator-1387";
        client.deleteOperatorAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteOperatorExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1387/locations/location-1387/operators/operator-1387";
            client.deleteOperatorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listAnalysesTest() throws Exception {
        Analysis responsesElement = Analysis.newBuilder().build();
        ListAnalysesResponse expectedResponse = ListAnalysesResponse.newBuilder().setNextPageToken("").addAllAnalyses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        LiveVideoAnalyticsClient.ListAnalysesPagedResponse pagedListResponse = client.listAnalyses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnalysesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAnalysesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.listAnalyses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnalysesTest2() throws Exception {
        Analysis responsesElement = Analysis.newBuilder().build();
        ListAnalysesResponse expectedResponse = ListAnalysesResponse.newBuilder().setNextPageToken("").addAllAnalyses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        LiveVideoAnalyticsClient.ListAnalysesPagedResponse pagedListResponse = client.listAnalyses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnalysesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAnalysesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            client.listAnalyses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        mockService.addResponse((Object)expectedResponse);
        AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
        Analysis actualResponse = client.getAnalysis(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAnalysisExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
            client.getAnalysis(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnalysisTest2() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7631/locations/location-7631/clusters/cluster-7631/analyses/analyse-7631";
        Analysis actualResponse = client.getAnalysis(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAnalysisExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7631/locations/location-7631/clusters/cluster-7631/analyses/analyse-7631";
            client.getAnalysis(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Analysis analysis = Analysis.newBuilder().build();
        String analysisId = "analysisId-944835305";
        Analysis actualResponse = (Analysis)client.createAnalysisAsync(parent, analysis, analysisId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAnalysisExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Analysis analysis = Analysis.newBuilder().build();
            String analysisId = "analysisId-944835305";
            client.createAnalysisAsync(parent, analysis, analysisId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createAnalysisTest2() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Analysis analysis = Analysis.newBuilder().build();
        String analysisId = "analysisId-944835305";
        Analysis actualResponse = (Analysis)client.createAnalysisAsync(parent, analysis, analysisId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAnalysisExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Analysis analysis = Analysis.newBuilder().build();
            String analysisId = "analysisId-944835305";
            client.createAnalysisAsync(parent, analysis, analysisId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Analysis analysis = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Analysis actualResponse = (Analysis)client.updateAnalysisAsync(analysis, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateAnalysisExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Analysis analysis = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateAnalysisAsync(analysis, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnalysisTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
        client.deleteAnalysisAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAnalysisExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
            client.deleteAnalysisAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnalysisTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-7631/locations/location-7631/clusters/cluster-7631/analyses/analyse-7631";
        client.deleteAnalysisAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAnalysisExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7631/locations/location-7631/clusters/cluster-7631/analyses/analyse-7631";
            client.deleteAnalysisAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        LiveVideoAnalyticsClient.ListProcessesPagedResponse pagedListResponse = client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest2() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        LiveVideoAnalyticsClient.ListProcessesPagedResponse pagedListResponse = client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        mockService.addResponse((Object)expectedResponse);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
        Process actualResponse = client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
            client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2622/locations/location-2622/clusters/cluster-2622/processes/processe-2622";
        Process actualResponse = client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2622/locations/location-2622/clusters/cluster-2622/processes/processe-2622";
            client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Process process = Process.newBuilder().build();
        String processId = "processId-1094760470";
        Process actualResponse = (Process)client.createProcessAsync(parent, process, processId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Process process = Process.newBuilder().build();
            String processId = "processId-1094760470";
            client.createProcessAsync(parent, process, processId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Process process = Process.newBuilder().build();
        String processId = "processId-1094760470";
        Process actualResponse = (Process)client.createProcessAsync(parent, process, processId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Process process = Process.newBuilder().build();
            String processId = "processId-1094760470";
            client.createProcessAsync(parent, process, processId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("updateProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Process process = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Process actualResponse = (Process)client.updateProcessAsync(process, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Process process = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateProcessAsync(process, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
        client.deleteProcessAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
            client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-2622/locations/location-2622/clusters/cluster-2622/processes/processe-2622";
        client.deleteProcessAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2622/locations/location-2622/clusters/cluster-2622/processes/processe-2622";
            client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchRunProcessTest() throws Exception {
        BatchRunProcessResponse expectedResponse = BatchRunProcessResponse.newBuilder().setBatchId("batchId-331744779").addAllProcesses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchRunProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        ArrayList requests = new ArrayList();
        BatchRunProcessResponse actualResponse = (BatchRunProcessResponse)client.batchRunProcessAsync(parent, requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchRunProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            ArrayList requests = new ArrayList();
            client.batchRunProcessAsync(parent, requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void batchRunProcessTest2() throws Exception {
        BatchRunProcessResponse expectedResponse = BatchRunProcessResponse.newBuilder().setBatchId("batchId-331744779").addAllProcesses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchRunProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        ArrayList requests = new ArrayList();
        BatchRunProcessResponse actualResponse = (BatchRunProcessResponse)client.batchRunProcessAsync(parent, requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchRunProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            ArrayList requests = new ArrayList();
            client.batchRunProcessAsync(parent, requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

