/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.Analysis;
import com.google.cloud.visionai.v1.AnalysisDefinition;
import com.google.cloud.visionai.v1.AnalysisName;
import com.google.cloud.visionai.v1.BatchRunProcessRequest;
import com.google.cloud.visionai.v1.BatchRunProcessResponse;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.CreateAnalysisRequest;
import com.google.cloud.visionai.v1.CreateOperatorRequest;
import com.google.cloud.visionai.v1.CreateProcessRequest;
import com.google.cloud.visionai.v1.DeleteAnalysisRequest;
import com.google.cloud.visionai.v1.DeleteOperatorRequest;
import com.google.cloud.visionai.v1.DeleteProcessRequest;
import com.google.cloud.visionai.v1.GetAnalysisRequest;
import com.google.cloud.visionai.v1.GetOperatorRequest;
import com.google.cloud.visionai.v1.GetProcessRequest;
import com.google.cloud.visionai.v1.ListAnalysesRequest;
import com.google.cloud.visionai.v1.ListAnalysesResponse;
import com.google.cloud.visionai.v1.ListOperatorsRequest;
import com.google.cloud.visionai.v1.ListOperatorsResponse;
import com.google.cloud.visionai.v1.ListProcessesRequest;
import com.google.cloud.visionai.v1.ListProcessesResponse;
import com.google.cloud.visionai.v1.ListPublicOperatorsRequest;
import com.google.cloud.visionai.v1.ListPublicOperatorsResponse;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsClient;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsSettings;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLiveVideoAnalytics;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.cloud.visionai.v1.Operator;
import com.google.cloud.visionai.v1.OperatorDefinition;
import com.google.cloud.visionai.v1.OperatorName;
import com.google.cloud.visionai.v1.Process;
import com.google.cloud.visionai.v1.ProcessName;
import com.google.cloud.visionai.v1.ResolveOperatorInfoRequest;
import com.google.cloud.visionai.v1.ResolveOperatorInfoResponse;
import com.google.cloud.visionai.v1.RunMode;
import com.google.cloud.visionai.v1.RunStatus;
import com.google.cloud.visionai.v1.UpdateAnalysisRequest;
import com.google.cloud.visionai.v1.UpdateOperatorRequest;
import com.google.cloud.visionai.v1.UpdateProcessRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LiveVideoAnalyticsClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLiveVideoAnalytics mockLiveVideoAnalytics;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private LiveVideoAnalyticsClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockLiveVideoAnalytics = new MockLiveVideoAnalytics();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockLiveVideoAnalytics, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        LiveVideoAnalyticsSettings settings = ((LiveVideoAnalyticsSettings.Builder)((LiveVideoAnalyticsSettings.Builder)LiveVideoAnalyticsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = LiveVideoAnalyticsClient.create((LiveVideoAnalyticsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listPublicOperatorsTest() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListPublicOperatorsResponse expectedResponse = ListPublicOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse pagedListResponse = this.client.listPublicOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPublicOperatorsRequest actualRequest = (ListPublicOperatorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPublicOperatorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listPublicOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPublicOperatorsTest2() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListPublicOperatorsResponse expectedResponse = ListPublicOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse pagedListResponse = this.client.listPublicOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPublicOperatorsRequest actualRequest = (ListPublicOperatorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPublicOperatorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPublicOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resolveOperatorInfoTest() throws Exception {
        ResolveOperatorInfoResponse expectedResponse = ResolveOperatorInfoResponse.newBuilder().addAllOperators(new ArrayList()).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ArrayList queries = new ArrayList();
        ResolveOperatorInfoResponse actualResponse = this.client.resolveOperatorInfo(parent, queries);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResolveOperatorInfoRequest actualRequest = (ResolveOperatorInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(queries, (Object)actualRequest.getQueriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resolveOperatorInfoExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ArrayList queries = new ArrayList();
            this.client.resolveOperatorInfo(parent, queries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resolveOperatorInfoTest2() throws Exception {
        ResolveOperatorInfoResponse expectedResponse = ResolveOperatorInfoResponse.newBuilder().addAllOperators(new ArrayList()).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ArrayList queries = new ArrayList();
        ResolveOperatorInfoResponse actualResponse = this.client.resolveOperatorInfo(parent, queries);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResolveOperatorInfoRequest actualRequest = (ResolveOperatorInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(queries, (Object)actualRequest.getQueriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resolveOperatorInfoExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList queries = new ArrayList();
            this.client.resolveOperatorInfo(parent, queries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOperatorsTest() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListOperatorsResponse expectedResponse = ListOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LiveVideoAnalyticsClient.ListOperatorsPagedResponse pagedListResponse = this.client.listOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOperatorsRequest actualRequest = (ListOperatorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOperatorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOperatorsTest2() throws Exception {
        Operator responsesElement = Operator.newBuilder().build();
        ListOperatorsResponse expectedResponse = ListOperatorsResponse.newBuilder().setNextPageToken("").addAllOperators(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LiveVideoAnalyticsClient.ListOperatorsPagedResponse pagedListResponse = this.client.listOperators(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperatorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOperatorsRequest actualRequest = (ListOperatorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOperatorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listOperators(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
        Operator actualResponse = this.client.getOperator(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOperatorRequest actualRequest = (GetOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOperatorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
            this.client.getOperator(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOperatorTest2() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Operator actualResponse = this.client.getOperator(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOperatorRequest actualRequest = (GetOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOperatorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOperator(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("createOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Operator operator = Operator.newBuilder().build();
        String operatorId = "operatorId4364511";
        Operator actualResponse = (Operator)this.client.createOperatorAsync(parent, operator, operatorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateOperatorRequest actualRequest = (CreateOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)operator, (Object)actualRequest.getOperator());
        Assert.assertEquals((Object)operatorId, (Object)actualRequest.getOperatorId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createOperatorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Operator operator = Operator.newBuilder().build();
            String operatorId = "operatorId4364511";
            this.client.createOperatorAsync(parent, operator, operatorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createOperatorTest2() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("createOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Operator operator = Operator.newBuilder().build();
        String operatorId = "operatorId4364511";
        Operator actualResponse = (Operator)this.client.createOperatorAsync(parent, operator, operatorId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateOperatorRequest actualRequest = (CreateOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)operator, (Object)actualRequest.getOperator());
        Assert.assertEquals((Object)operatorId, (Object)actualRequest.getOperatorId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createOperatorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Operator operator = Operator.newBuilder().build();
            String operatorId = "operatorId4364511";
            this.client.createOperatorAsync(parent, operator, operatorId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateOperatorTest() throws Exception {
        Operator expectedResponse = Operator.newBuilder().setName(OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setOperatorDefinition(OperatorDefinition.newBuilder().build()).setDockerImage("dockerImage2086149915").build();
        Operation resultOperation = Operation.newBuilder().setName("updateOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        Operator operator = Operator.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Operator actualResponse = (Operator)this.client.updateOperatorAsync(operator, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateOperatorRequest actualRequest = (UpdateOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)operator, (Object)actualRequest.getOperator());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateOperatorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            Operator operator = Operator.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateOperatorAsync(operator, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteOperatorTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
        this.client.deleteOperatorAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteOperatorRequest actualRequest = (DeleteOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteOperatorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            OperatorName name = OperatorName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[OPERATOR]");
            this.client.deleteOperatorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteOperatorTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteOperatorTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteOperatorAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteOperatorRequest actualRequest = (DeleteOperatorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteOperatorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteOperatorAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listAnalysesTest() throws Exception {
        Analysis responsesElement = Analysis.newBuilder().build();
        ListAnalysesResponse expectedResponse = ListAnalysesResponse.newBuilder().setNextPageToken("").addAllAnalyses(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        LiveVideoAnalyticsClient.ListAnalysesPagedResponse pagedListResponse = this.client.listAnalyses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnalysesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAnalysesRequest actualRequest = (ListAnalysesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAnalysesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.listAnalyses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnalysesTest2() throws Exception {
        Analysis responsesElement = Analysis.newBuilder().build();
        ListAnalysesResponse expectedResponse = ListAnalysesResponse.newBuilder().setNextPageToken("").addAllAnalyses(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LiveVideoAnalyticsClient.ListAnalysesPagedResponse pagedListResponse = this.client.listAnalyses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnalysesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAnalysesRequest actualRequest = (ListAnalysesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAnalysesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAnalyses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
        Analysis actualResponse = this.client.getAnalysis(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAnalysisRequest actualRequest = (GetAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAnalysisExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
            this.client.getAnalysis(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnalysisTest2() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Analysis actualResponse = this.client.getAnalysis(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAnalysisRequest actualRequest = (GetAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAnalysisExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAnalysis(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Analysis analysis = Analysis.newBuilder().build();
        String analysisId = "analysisId-944835305";
        Analysis actualResponse = (Analysis)this.client.createAnalysisAsync(parent, analysis, analysisId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAnalysisRequest actualRequest = (CreateAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)analysis, (Object)actualRequest.getAnalysis());
        Assert.assertEquals((Object)analysisId, (Object)actualRequest.getAnalysisId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAnalysisExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Analysis analysis = Analysis.newBuilder().build();
            String analysisId = "analysisId-944835305";
            this.client.createAnalysisAsync(parent, analysis, analysisId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createAnalysisTest2() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Analysis analysis = Analysis.newBuilder().build();
        String analysisId = "analysisId-944835305";
        Analysis actualResponse = (Analysis)this.client.createAnalysisAsync(parent, analysis, analysisId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAnalysisRequest actualRequest = (CreateAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)analysis, (Object)actualRequest.getAnalysis());
        Assert.assertEquals((Object)analysisId, (Object)actualRequest.getAnalysisId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAnalysisExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Analysis analysis = Analysis.newBuilder().build();
            String analysisId = "analysisId-944835305";
            this.client.createAnalysisAsync(parent, analysis, analysisId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateAnalysisTest() throws Exception {
        Analysis expectedResponse = Analysis.newBuilder().setName(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setAnalysisDefinition(AnalysisDefinition.newBuilder().build()).putAllInputStreamsMapping(new HashMap()).putAllOutputStreamsMapping(new HashMap()).setDisableEventWatch(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        Analysis analysis = Analysis.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Analysis actualResponse = (Analysis)this.client.updateAnalysisAsync(analysis, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAnalysisRequest actualRequest = (UpdateAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)analysis, (Object)actualRequest.getAnalysis());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAnalysisExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            Analysis analysis = Analysis.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAnalysisAsync(analysis, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAnalysisTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
        this.client.deleteAnalysisAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAnalysisRequest actualRequest = (DeleteAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAnalysisExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            AnalysisName name = AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]");
            this.client.deleteAnalysisAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAnalysisTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAnalysisTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteAnalysisAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAnalysisRequest actualRequest = (DeleteAnalysisRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAnalysisExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAnalysisAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listProcessesTest() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        LiveVideoAnalyticsClient.ListProcessesPagedResponse pagedListResponse = this.client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessesRequest actualRequest = (ListProcessesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest2() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LiveVideoAnalyticsClient.ListProcessesPagedResponse pagedListResponse = this.client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessesRequest actualRequest = (ListProcessesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
        Process actualResponse = this.client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessRequest actualRequest = (GetProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
            this.client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Process actualResponse = this.client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessRequest actualRequest = (GetProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Process process = Process.newBuilder().build();
        String processId = "processId-1094760470";
        Process actualResponse = (Process)this.client.createProcessAsync(parent, process, processId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessRequest actualRequest = (CreateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertEquals((Object)processId, (Object)actualRequest.getProcessId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Process process = Process.newBuilder().build();
            String processId = "processId-1094760470";
            this.client.createProcessAsync(parent, process, processId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("createProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Process process = Process.newBuilder().build();
        String processId = "processId-1094760470";
        Process actualResponse = (Process)this.client.createProcessAsync(parent, process, processId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessRequest actualRequest = (CreateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertEquals((Object)processId, (Object)actualRequest.getProcessId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Process process = Process.newBuilder().build();
            String processId = "processId-1094760470";
            this.client.createProcessAsync(parent, process, processId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setAnalysis(AnalysisName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[ANALYSIS]").toString()).addAllAttributeOverrides(new ArrayList()).setRunStatus(RunStatus.newBuilder().build()).setRunMode(RunMode.forNumber((int)0)).setEventId("eventId-1376502443").setBatchId("batchId-331744779").setRetryCount(-928040776).build();
        Operation resultOperation = Operation.newBuilder().setName("updateProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        Process process = Process.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Process actualResponse = (Process)this.client.updateProcessAsync(process, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProcessRequest actualRequest = (UpdateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            Process process = Process.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProcessAsync(process, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteProcessTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
        this.client.deleteProcessAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessRequest actualRequest = (DeleteProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[PROCESS]");
            this.client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteProcessTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteProcessAsync(name).get();
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessRequest actualRequest = (DeleteProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchRunProcessTest() throws Exception {
        BatchRunProcessResponse expectedResponse = BatchRunProcessResponse.newBuilder().setBatchId("batchId-331744779").addAllProcesses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchRunProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        ArrayList requests = new ArrayList();
        BatchRunProcessResponse actualResponse = (BatchRunProcessResponse)this.client.batchRunProcessAsync(parent, requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchRunProcessRequest actualRequest = (BatchRunProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchRunProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            ArrayList requests = new ArrayList();
            this.client.batchRunProcessAsync(parent, requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchRunProcessTest2() throws Exception {
        BatchRunProcessResponse expectedResponse = BatchRunProcessResponse.newBuilder().setBatchId("batchId-331744779").addAllProcesses(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("batchRunProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLiveVideoAnalytics.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ArrayList requests = new ArrayList();
        BatchRunProcessResponse actualResponse = (BatchRunProcessResponse)this.client.batchRunProcessAsync(parent, requests).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLiveVideoAnalytics.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchRunProcessRequest actualRequest = (BatchRunProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals(requests, (Object)actualRequest.getRequestsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchRunProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLiveVideoAnalytics.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ArrayList requests = new ArrayList();
            this.client.batchRunProcessAsync(parent, requests).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

