/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.AcquireLeaseRequest;
import com.google.cloud.visionai.v1.Lease;
import com.google.cloud.visionai.v1.LeaseType;
import com.google.cloud.visionai.v1.ReleaseLeaseRequest;
import com.google.cloud.visionai.v1.ReleaseLeaseResponse;
import com.google.cloud.visionai.v1.RenewLeaseRequest;
import com.google.cloud.visionai.v1.StreamingServiceClient;
import com.google.cloud.visionai.v1.StreamingServiceSettings;
import com.google.cloud.visionai.v1.stub.HttpJsonStreamingServiceStub;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StreamingServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static StreamingServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonStreamingServiceStub.getMethodDescriptors(), StreamingServiceSettings.getDefaultEndpoint());
        StreamingServiceSettings settings = ((StreamingServiceSettings.Builder)((StreamingServiceSettings.Builder)StreamingServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)StreamingServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = StreamingServiceClient.create((StreamingServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void sendPacketsUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void receivePacketsUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void receiveEventsUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void acquireLeaseTest() throws Exception {
        Lease expectedResponse = Lease.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setExpireTime(Timestamp.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        AcquireLeaseRequest request = AcquireLeaseRequest.newBuilder().setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        Lease actualResponse = client.acquireLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void acquireLeaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AcquireLeaseRequest request = AcquireLeaseRequest.newBuilder().setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
            client.acquireLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renewLeaseTest() throws Exception {
        Lease expectedResponse = Lease.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setExpireTime(Timestamp.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        RenewLeaseRequest request = RenewLeaseRequest.newBuilder().setId("id3355").setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).build();
        Lease actualResponse = client.renewLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void renewLeaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RenewLeaseRequest request = RenewLeaseRequest.newBuilder().setId("id3355").setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).build();
            client.renewLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void releaseLeaseTest() throws Exception {
        ReleaseLeaseResponse expectedResponse = ReleaseLeaseResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ReleaseLeaseRequest request = ReleaseLeaseRequest.newBuilder().setId("id3355").setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").build();
        ReleaseLeaseResponse actualResponse = client.releaseLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void releaseLeaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ReleaseLeaseRequest request = ReleaseLeaseRequest.newBuilder().setId("id3355").setSeries("projects/project-4804/locations/location-4804/clusters/cluster-4804/series/serie-4804").setOwner("owner106164915").build();
            client.releaseLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

