/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.AcquireLeaseRequest;
import com.google.cloud.visionai.v1.Lease;
import com.google.cloud.visionai.v1.LeaseType;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.cloud.visionai.v1.MockStreamingService;
import com.google.cloud.visionai.v1.ReceiveEventsRequest;
import com.google.cloud.visionai.v1.ReceiveEventsResponse;
import com.google.cloud.visionai.v1.ReceivePacketsRequest;
import com.google.cloud.visionai.v1.ReceivePacketsResponse;
import com.google.cloud.visionai.v1.ReleaseLeaseRequest;
import com.google.cloud.visionai.v1.ReleaseLeaseResponse;
import com.google.cloud.visionai.v1.RenewLeaseRequest;
import com.google.cloud.visionai.v1.SendPacketsRequest;
import com.google.cloud.visionai.v1.SendPacketsResponse;
import com.google.cloud.visionai.v1.StreamingServiceClient;
import com.google.cloud.visionai.v1.StreamingServiceSettings;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StreamingServiceClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private static MockStreamingService mockStreamingService;
    private LocalChannelProvider channelProvider;
    private StreamingServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockStreamingService = new MockStreamingService();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockStreamingService, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        StreamingServiceSettings settings = ((StreamingServiceSettings.Builder)((StreamingServiceSettings.Builder)StreamingServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = StreamingServiceClient.create((StreamingServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void sendPacketsTest() throws Exception {
        SendPacketsResponse expectedResponse = SendPacketsResponse.newBuilder().build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        SendPacketsRequest request = SendPacketsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.sendPacketsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void sendPacketsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        SendPacketsRequest request = SendPacketsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.sendPacketsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void receivePacketsTest() throws Exception {
        ReceivePacketsResponse expectedResponse = ReceivePacketsResponse.newBuilder().build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        ReceivePacketsRequest request = ReceivePacketsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.receivePacketsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void receivePacketsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        ReceivePacketsRequest request = ReceivePacketsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.receivePacketsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void receiveEventsTest() throws Exception {
        ReceiveEventsResponse expectedResponse = ReceiveEventsResponse.newBuilder().build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        ReceiveEventsRequest request = ReceiveEventsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.receiveEventsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void receiveEventsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        ReceiveEventsRequest request = ReceiveEventsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.receiveEventsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void acquireLeaseTest() throws Exception {
        Lease expectedResponse = Lease.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setExpireTime(Timestamp.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        AcquireLeaseRequest request = AcquireLeaseRequest.newBuilder().setSeries("series-905838985").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        Lease actualResponse = this.client.acquireLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamingService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AcquireLeaseRequest actualRequest = (AcquireLeaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSeries(), (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)request.getOwner(), (Object)actualRequest.getOwner());
        Assert.assertEquals((Object)request.getTerm(), (Object)actualRequest.getTerm());
        Assert.assertEquals((Object)request.getLeaseType(), (Object)actualRequest.getLeaseType());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void acquireLeaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        try {
            AcquireLeaseRequest request = AcquireLeaseRequest.newBuilder().setSeries("series-905838985").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
            this.client.acquireLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renewLeaseTest() throws Exception {
        Lease expectedResponse = Lease.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setExpireTime(Timestamp.newBuilder().build()).setLeaseType(LeaseType.forNumber((int)0)).build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        RenewLeaseRequest request = RenewLeaseRequest.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).build();
        Lease actualResponse = this.client.renewLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamingService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenewLeaseRequest actualRequest = (RenewLeaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getId(), (Object)actualRequest.getId());
        Assert.assertEquals((Object)request.getSeries(), (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)request.getOwner(), (Object)actualRequest.getOwner());
        Assert.assertEquals((Object)request.getTerm(), (Object)actualRequest.getTerm());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renewLeaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        try {
            RenewLeaseRequest request = RenewLeaseRequest.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").setTerm(Duration.newBuilder().build()).build();
            this.client.renewLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void releaseLeaseTest() throws Exception {
        ReleaseLeaseResponse expectedResponse = ReleaseLeaseResponse.newBuilder().build();
        mockStreamingService.addResponse((AbstractMessage)expectedResponse);
        ReleaseLeaseRequest request = ReleaseLeaseRequest.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").build();
        ReleaseLeaseResponse actualResponse = this.client.releaseLease(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamingService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ReleaseLeaseRequest actualRequest = (ReleaseLeaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getId(), (Object)actualRequest.getId());
        Assert.assertEquals((Object)request.getSeries(), (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)request.getOwner(), (Object)actualRequest.getOwner());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void releaseLeaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamingService.addException((Exception)exception);
        try {
            ReleaseLeaseRequest request = ReleaseLeaseRequest.newBuilder().setId("id3355").setSeries("series-905838985").setOwner("owner106164915").build();
            this.client.releaseLease(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

