/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.Channel;
import com.google.cloud.visionai.v1.Cluster;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.Event;
import com.google.cloud.visionai.v1.EventName;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenResponse;
import com.google.cloud.visionai.v1.GetStreamThumbnailResponse;
import com.google.cloud.visionai.v1.ListClustersResponse;
import com.google.cloud.visionai.v1.ListEventsResponse;
import com.google.cloud.visionai.v1.ListSeriesResponse;
import com.google.cloud.visionai.v1.ListStreamsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.Series;
import com.google.cloud.visionai.v1.SeriesName;
import com.google.cloud.visionai.v1.Stream;
import com.google.cloud.visionai.v1.StreamName;
import com.google.cloud.visionai.v1.StreamsServiceClient;
import com.google.cloud.visionai.v1.StreamsServiceSettings;
import com.google.cloud.visionai.v1.stub.HttpJsonStreamsServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StreamsServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static StreamsServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonStreamsServiceStub.getMethodDescriptors(), StreamsServiceSettings.getDefaultEndpoint());
        StreamsServiceSettings settings = ((StreamsServiceSettings.Builder)((StreamsServiceSettings.Builder)StreamsServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)StreamsServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = StreamsServiceClient.create((StreamsServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listClustersTest() throws Exception {
        Cluster responsesElement = Cluster.newBuilder().build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().setNextPageToken("").addAllClusters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        StreamsServiceClient.ListClustersPagedResponse pagedListResponse = client.listClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getClustersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listClustersExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listClustersTest2() throws Exception {
        Cluster responsesElement = Cluster.newBuilder().build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().setNextPageToken("").addAllClusters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        StreamsServiceClient.ListClustersPagedResponse pagedListResponse = client.listClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getClustersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listClustersExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Cluster actualResponse = client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6537/locations/location-6537/clusters/cluster-6537";
        Cluster actualResponse = client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6537/locations/location-6537/clusters/cluster-6537";
            client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Cluster cluster = Cluster.newBuilder().build();
        String clusterId = "clusterId561939637";
        Cluster actualResponse = (Cluster)client.createClusterAsync(parent, cluster, clusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Cluster cluster = Cluster.newBuilder().build();
            String clusterId = "clusterId561939637";
            client.createClusterAsync(parent, cluster, clusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Cluster cluster = Cluster.newBuilder().build();
        String clusterId = "clusterId561939637";
        Cluster actualResponse = (Cluster)client.createClusterAsync(parent, cluster, clusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Cluster cluster = Cluster.newBuilder().build();
            String clusterId = "clusterId561939637";
            client.createClusterAsync(parent, cluster, clusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("updateClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Cluster cluster = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Cluster actualResponse = (Cluster)client.updateClusterAsync(cluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Cluster cluster = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateClusterAsync(cluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        client.deleteClusterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.deleteClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteClusterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-6537/locations/location-6537/clusters/cluster-6537";
        client.deleteClusterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6537/locations/location-6537/clusters/cluster-6537";
            client.deleteClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listStreamsTest() throws Exception {
        Stream responsesElement = Stream.newBuilder().build();
        ListStreamsResponse expectedResponse = ListStreamsResponse.newBuilder().setNextPageToken("").addAllStreams(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListStreamsPagedResponse pagedListResponse = client.listStreams(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getStreamsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listStreamsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.listStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listStreamsTest2() throws Exception {
        Stream responsesElement = Stream.newBuilder().build();
        ListStreamsResponse expectedResponse = ListStreamsResponse.newBuilder().setNextPageToken("").addAllStreams(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        StreamsServiceClient.ListStreamsPagedResponse pagedListResponse = client.listStreams(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getStreamsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listStreamsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            client.listStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        mockService.addResponse((Object)expectedResponse);
        StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
        Stream actualResponse = client.getStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getStreamExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
            client.getStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStreamTest2() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9704/locations/location-9704/clusters/cluster-9704/streams/stream-9704";
        Stream actualResponse = client.getStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getStreamExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9704/locations/location-9704/clusters/cluster-9704/streams/stream-9704";
            client.getStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("createStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Stream stream = Stream.newBuilder().build();
        String streamId = "streamId1790933179";
        Stream actualResponse = (Stream)client.createStreamAsync(parent, stream, streamId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createStreamExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Stream stream = Stream.newBuilder().build();
            String streamId = "streamId1790933179";
            client.createStreamAsync(parent, stream, streamId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createStreamTest2() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("createStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Stream stream = Stream.newBuilder().build();
        String streamId = "streamId1790933179";
        Stream actualResponse = (Stream)client.createStreamAsync(parent, stream, streamId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createStreamExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Stream stream = Stream.newBuilder().build();
            String streamId = "streamId1790933179";
            client.createStreamAsync(parent, stream, streamId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("updateStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Stream stream = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Stream actualResponse = (Stream)client.updateStreamAsync(stream, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateStreamExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Stream stream = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateStreamAsync(stream, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStreamTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
        client.deleteStreamAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteStreamExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
            client.deleteStreamAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStreamTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-9704/locations/location-9704/clusters/cluster-9704/streams/stream-9704";
        client.deleteStreamAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteStreamExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9704/locations/location-9704/clusters/cluster-9704/streams/stream-9704";
            client.deleteStreamAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getStreamThumbnailTest() throws Exception {
        GetStreamThumbnailResponse expectedResponse = GetStreamThumbnailResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("getStreamThumbnailTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String stream = "projects/project-4115/locations/location-4115/clusters/cluster-4115/streams/stream-4115";
        String gcsObjectName = "gcsObjectName-1987275551";
        GetStreamThumbnailResponse actualResponse = (GetStreamThumbnailResponse)client.getStreamThumbnailAsync(stream, gcsObjectName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getStreamThumbnailExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String stream = "projects/project-4115/locations/location-4115/clusters/cluster-4115/streams/stream-4115";
            String gcsObjectName = "gcsObjectName-1987275551";
            client.getStreamThumbnailAsync(stream, gcsObjectName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void generateStreamHlsTokenTest() throws Exception {
        GenerateStreamHlsTokenResponse expectedResponse = GenerateStreamHlsTokenResponse.newBuilder().setToken("token110541305").setExpirationTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String stream = "projects/project-4115/locations/location-4115/clusters/cluster-4115/streams/stream-4115";
        GenerateStreamHlsTokenResponse actualResponse = client.generateStreamHlsToken(stream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void generateStreamHlsTokenExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String stream = "projects/project-4115/locations/location-4115/clusters/cluster-4115/streams/stream-4115";
            client.generateStreamHlsToken(stream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListEventsPagedResponse pagedListResponse = client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEventsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest2() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        StreamsServiceClient.ListEventsPagedResponse pagedListResponse = client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEventsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
        Event actualResponse = client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
            client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8010/locations/location-8010/clusters/cluster-8010/events/event-8010";
        Event actualResponse = client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8010/locations/location-8010/clusters/cluster-8010/events/event-8010";
            client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Event event = Event.newBuilder().build();
        String eventId = "eventId-1376502443";
        Event actualResponse = (Event)client.createEventAsync(parent, event, eventId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Event event = Event.newBuilder().build();
            String eventId = "eventId-1376502443";
            client.createEventAsync(parent, event, eventId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Event event = Event.newBuilder().build();
        String eventId = "eventId-1376502443";
        Event actualResponse = (Event)client.createEventAsync(parent, event, eventId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Event event = Event.newBuilder().build();
            String eventId = "eventId-1376502443";
            client.createEventAsync(parent, event, eventId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Event event = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Event actualResponse = (Event)client.updateEventAsync(event, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Event event = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateEventAsync(event, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEventTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
        client.deleteEventAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
            client.deleteEventAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEventTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-8010/locations/location-8010/clusters/cluster-8010/events/event-8010";
        client.deleteEventAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8010/locations/location-8010/clusters/cluster-8010/events/event-8010";
            client.deleteEventAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listSeriesTest() throws Exception {
        Series responsesElement = Series.newBuilder().build();
        ListSeriesResponse expectedResponse = ListSeriesResponse.newBuilder().setNextPageToken("").addAllSeries(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListSeriesPagedResponse pagedListResponse = client.listSeries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSeriesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSeriesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            client.listSeries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSeriesTest2() throws Exception {
        Series responsesElement = Series.newBuilder().build();
        ListSeriesResponse expectedResponse = ListSeriesResponse.newBuilder().setNextPageToken("").addAllSeries(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        StreamsServiceClient.ListSeriesPagedResponse pagedListResponse = client.listSeries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSeriesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSeriesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            client.listSeries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        mockService.addResponse((Object)expectedResponse);
        SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
        Series actualResponse = client.getSeries(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSeriesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
            client.getSeries(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSeriesTest2() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7272/locations/location-7272/clusters/cluster-7272/series/serie-7272";
        Series actualResponse = client.getSeries(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSeriesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7272/locations/location-7272/clusters/cluster-7272/series/serie-7272";
            client.getSeries(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Series series = Series.newBuilder().build();
        String seriesId = "seriesId1367098866";
        Series actualResponse = (Series)client.createSeriesAsync(parent, series, seriesId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSeriesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Series series = Series.newBuilder().build();
            String seriesId = "seriesId1367098866";
            client.createSeriesAsync(parent, series, seriesId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createSeriesTest2() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Series series = Series.newBuilder().build();
        String seriesId = "seriesId1367098866";
        Series actualResponse = (Series)client.createSeriesAsync(parent, series, seriesId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSeriesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Series series = Series.newBuilder().build();
            String seriesId = "seriesId1367098866";
            client.createSeriesAsync(parent, series, seriesId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Series series = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Series actualResponse = (Series)client.updateSeriesAsync(series, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSeriesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Series series = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSeriesAsync(series, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSeriesTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
        client.deleteSeriesAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSeriesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
            client.deleteSeriesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSeriesTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-7272/locations/location-7272/clusters/cluster-7272/series/serie-7272";
        client.deleteSeriesAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSeriesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7272/locations/location-7272/clusters/cluster-7272/series/serie-7272";
            client.deleteSeriesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void materializeChannelTest() throws Exception {
        Channel expectedResponse = Channel.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("materializeChannelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Channel channel = Channel.newBuilder().build();
        String channelId = "channelId1461735806";
        Channel actualResponse = (Channel)client.materializeChannelAsync(parent, channel, channelId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void materializeChannelExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Channel channel = Channel.newBuilder().build();
            String channelId = "channelId1461735806";
            client.materializeChannelAsync(parent, channel, channelId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void materializeChannelTest2() throws Exception {
        Channel expectedResponse = Channel.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("materializeChannelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
        Channel channel = Channel.newBuilder().build();
        String channelId = "channelId1461735806";
        Channel actualResponse = (Channel)client.materializeChannelAsync(parent, channel, channelId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void materializeChannelExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9466/locations/location-9466/clusters/cluster-9466";
            Channel channel = Channel.newBuilder().build();
            String channelId = "channelId1461735806";
            client.materializeChannelAsync(parent, channel, channelId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

