/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.Channel;
import com.google.cloud.visionai.v1.Cluster;
import com.google.cloud.visionai.v1.ClusterName;
import com.google.cloud.visionai.v1.CreateClusterRequest;
import com.google.cloud.visionai.v1.CreateEventRequest;
import com.google.cloud.visionai.v1.CreateSeriesRequest;
import com.google.cloud.visionai.v1.CreateStreamRequest;
import com.google.cloud.visionai.v1.DeleteClusterRequest;
import com.google.cloud.visionai.v1.DeleteEventRequest;
import com.google.cloud.visionai.v1.DeleteSeriesRequest;
import com.google.cloud.visionai.v1.DeleteStreamRequest;
import com.google.cloud.visionai.v1.Event;
import com.google.cloud.visionai.v1.EventName;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenRequest;
import com.google.cloud.visionai.v1.GenerateStreamHlsTokenResponse;
import com.google.cloud.visionai.v1.GetClusterRequest;
import com.google.cloud.visionai.v1.GetEventRequest;
import com.google.cloud.visionai.v1.GetSeriesRequest;
import com.google.cloud.visionai.v1.GetStreamRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailRequest;
import com.google.cloud.visionai.v1.GetStreamThumbnailResponse;
import com.google.cloud.visionai.v1.ListClustersRequest;
import com.google.cloud.visionai.v1.ListClustersResponse;
import com.google.cloud.visionai.v1.ListEventsRequest;
import com.google.cloud.visionai.v1.ListEventsResponse;
import com.google.cloud.visionai.v1.ListSeriesRequest;
import com.google.cloud.visionai.v1.ListSeriesResponse;
import com.google.cloud.visionai.v1.ListStreamsRequest;
import com.google.cloud.visionai.v1.ListStreamsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.MaterializeChannelRequest;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.cloud.visionai.v1.MockStreamsService;
import com.google.cloud.visionai.v1.Series;
import com.google.cloud.visionai.v1.SeriesName;
import com.google.cloud.visionai.v1.Stream;
import com.google.cloud.visionai.v1.StreamName;
import com.google.cloud.visionai.v1.StreamsServiceClient;
import com.google.cloud.visionai.v1.StreamsServiceSettings;
import com.google.cloud.visionai.v1.UpdateClusterRequest;
import com.google.cloud.visionai.v1.UpdateEventRequest;
import com.google.cloud.visionai.v1.UpdateSeriesRequest;
import com.google.cloud.visionai.v1.UpdateStreamRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StreamsServiceClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private static MockStreamsService mockStreamsService;
    private LocalChannelProvider channelProvider;
    private StreamsServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockStreamsService = new MockStreamsService();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockStreamsService, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        StreamsServiceSettings settings = ((StreamsServiceSettings.Builder)((StreamsServiceSettings.Builder)StreamsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = StreamsServiceClient.create((StreamsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listClustersTest() throws Exception {
        Cluster responsesElement = Cluster.newBuilder().build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().setNextPageToken("").addAllClusters(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        StreamsServiceClient.ListClustersPagedResponse pagedListResponse = this.client.listClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListClustersRequest actualRequest = (ListClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listClustersTest2() throws Exception {
        Cluster responsesElement = Cluster.newBuilder().build();
        ListClustersResponse expectedResponse = ListClustersResponse.newBuilder().setNextPageToken("").addAllClusters(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StreamsServiceClient.ListClustersPagedResponse pagedListResponse = this.client.listClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListClustersRequest actualRequest = (ListClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listClustersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Cluster actualResponse = this.client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetClusterRequest actualRequest = (GetClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Cluster actualResponse = this.client.getCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetClusterRequest actualRequest = (GetClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Cluster cluster = Cluster.newBuilder().build();
        String clusterId = "clusterId561939637";
        Cluster actualResponse = (Cluster)this.client.createClusterAsync(parent, cluster, clusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClusterRequest actualRequest = (CreateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)clusterId, (Object)actualRequest.getClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Cluster cluster = Cluster.newBuilder().build();
            String clusterId = "clusterId561939637";
            this.client.createClusterAsync(parent, cluster, clusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createClusterTest2() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("createClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Cluster cluster = Cluster.newBuilder().build();
        String clusterId = "clusterId561939637";
        Cluster actualResponse = (Cluster)this.client.createClusterAsync(parent, cluster, clusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClusterRequest actualRequest = (CreateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)clusterId, (Object)actualRequest.getClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Cluster cluster = Cluster.newBuilder().build();
            String clusterId = "clusterId561939637";
            this.client.createClusterAsync(parent, cluster, clusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateClusterTest() throws Exception {
        Cluster expectedResponse = Cluster.newBuilder().setName(ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDataplaneServiceEndpoint("dataplaneServiceEndpoint-81226728").setPscTarget("pscTarget-1845231503").build();
        Operation resultOperation = Operation.newBuilder().setName("updateClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        Cluster cluster = Cluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Cluster actualResponse = (Cluster)this.client.updateClusterAsync(cluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateClusterRequest actualRequest = (UpdateClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)cluster, (Object)actualRequest.getCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            Cluster cluster = Cluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateClusterAsync(cluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        this.client.deleteClusterAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteClusterRequest actualRequest = (DeleteClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName name = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.deleteClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteClusterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteClusterAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteClusterRequest actualRequest = (DeleteClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listStreamsTest() throws Exception {
        Stream responsesElement = Stream.newBuilder().build();
        ListStreamsResponse expectedResponse = ListStreamsResponse.newBuilder().setNextPageToken("").addAllStreams(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListStreamsPagedResponse pagedListResponse = this.client.listStreams(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getStreamsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListStreamsRequest actualRequest = (ListStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listStreamsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.listStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listStreamsTest2() throws Exception {
        Stream responsesElement = Stream.newBuilder().build();
        ListStreamsResponse expectedResponse = ListStreamsResponse.newBuilder().setNextPageToken("").addAllStreams(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StreamsServiceClient.ListStreamsPagedResponse pagedListResponse = this.client.listStreams(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getStreamsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListStreamsRequest actualRequest = (ListStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listStreamsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
        Stream actualResponse = this.client.getStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStreamRequest actualRequest = (GetStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
            this.client.getStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getStreamTest2() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Stream actualResponse = this.client.getStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStreamRequest actualRequest = (GetStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("createStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Stream stream = Stream.newBuilder().build();
        String streamId = "streamId1790933179";
        Stream actualResponse = (Stream)this.client.createStreamAsync(parent, stream, streamId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateStreamRequest actualRequest = (CreateStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertEquals((Object)streamId, (Object)actualRequest.getStreamId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Stream stream = Stream.newBuilder().build();
            String streamId = "streamId1790933179";
            this.client.createStreamAsync(parent, stream, streamId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createStreamTest2() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("createStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Stream stream = Stream.newBuilder().build();
        String streamId = "streamId1790933179";
        Stream actualResponse = (Stream)this.client.createStreamAsync(parent, stream, streamId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateStreamRequest actualRequest = (CreateStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertEquals((Object)streamId, (Object)actualRequest.getStreamId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Stream stream = Stream.newBuilder().build();
            String streamId = "streamId1790933179";
            this.client.createStreamAsync(parent, stream, streamId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateStreamTest() throws Exception {
        Stream expectedResponse = Stream.newBuilder().setName(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setDisplayName("displayName1714148973").setEnableHlsPlayback(true).setMediaWarehouseAsset("mediaWarehouseAsset-188571919").build();
        Operation resultOperation = Operation.newBuilder().setName("updateStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        Stream stream = Stream.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Stream actualResponse = (Stream)this.client.updateStreamAsync(stream, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateStreamRequest actualRequest = (UpdateStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            Stream stream = Stream.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateStreamAsync(stream, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteStreamTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
        this.client.deleteStreamAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteStreamRequest actualRequest = (DeleteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            StreamName name = StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]");
            this.client.deleteStreamAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteStreamTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteStreamTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteStreamAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteStreamRequest actualRequest = (DeleteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteStreamAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getStreamThumbnailTest() throws Exception {
        GetStreamThumbnailResponse expectedResponse = GetStreamThumbnailResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("getStreamThumbnailTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String stream = "stream-891990144";
        String gcsObjectName = "gcsObjectName-1987275551";
        GetStreamThumbnailResponse actualResponse = (GetStreamThumbnailResponse)this.client.getStreamThumbnailAsync(stream, gcsObjectName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetStreamThumbnailRequest actualRequest = (GetStreamThumbnailRequest)actualRequests.get(0);
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertEquals((Object)gcsObjectName, (Object)actualRequest.getGcsObjectName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getStreamThumbnailExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String stream = "stream-891990144";
            String gcsObjectName = "gcsObjectName-1987275551";
            this.client.getStreamThumbnailAsync(stream, gcsObjectName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void generateStreamHlsTokenTest() throws Exception {
        GenerateStreamHlsTokenResponse expectedResponse = GenerateStreamHlsTokenResponse.newBuilder().setToken("token110541305").setExpirationTime(Timestamp.newBuilder().build()).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String stream = "stream-891990144";
        GenerateStreamHlsTokenResponse actualResponse = this.client.generateStreamHlsToken(stream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateStreamHlsTokenRequest actualRequest = (GenerateStreamHlsTokenRequest)actualRequests.get(0);
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateStreamHlsTokenExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String stream = "stream-891990144";
            this.client.generateStreamHlsToken(stream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListEventsPagedResponse pagedListResponse = this.client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEventsRequest actualRequest = (ListEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEventsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest2() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StreamsServiceClient.ListEventsPagedResponse pagedListResponse = this.client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEventsRequest actualRequest = (ListEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEventsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
        Event actualResponse = this.client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEventRequest actualRequest = (GetEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
            this.client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Event actualResponse = this.client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEventRequest actualRequest = (GetEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Event event = Event.newBuilder().build();
        String eventId = "eventId-1376502443";
        Event actualResponse = (Event)this.client.createEventAsync(parent, event, eventId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateEventRequest actualRequest = (CreateEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)event, (Object)actualRequest.getEvent());
        Assert.assertEquals((Object)eventId, (Object)actualRequest.getEventId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Event event = Event.newBuilder().build();
            String eventId = "eventId-1376502443";
            this.client.createEventAsync(parent, event, eventId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Event event = Event.newBuilder().build();
        String eventId = "eventId-1376502443";
        Event actualResponse = (Event)this.client.createEventAsync(parent, event, eventId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateEventRequest actualRequest = (CreateEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)event, (Object)actualRequest.getEvent());
        Assert.assertEquals((Object)eventId, (Object)actualRequest.getEventId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Event event = Event.newBuilder().build();
            String eventId = "eventId-1376502443";
            this.client.createEventAsync(parent, event, eventId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setGracePeriod(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        Event event = Event.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Event actualResponse = (Event)this.client.updateEventAsync(event, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateEventRequest actualRequest = (UpdateEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)event, (Object)actualRequest.getEvent());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            Event event = Event.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateEventAsync(event, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteEventTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
        this.client.deleteEventAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteEventRequest actualRequest = (DeleteEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]");
            this.client.deleteEventAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteEventTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteEventTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteEventAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteEventRequest actualRequest = (DeleteEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteEventAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listSeriesTest() throws Exception {
        Series responsesElement = Series.newBuilder().build();
        ListSeriesResponse expectedResponse = ListSeriesResponse.newBuilder().setNextPageToken("").addAllSeries(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        StreamsServiceClient.ListSeriesPagedResponse pagedListResponse = this.client.listSeries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSeriesRequest actualRequest = (ListSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            this.client.listSeries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSeriesTest2() throws Exception {
        Series responsesElement = Series.newBuilder().build();
        ListSeriesResponse expectedResponse = ListSeriesResponse.newBuilder().setNextPageToken("").addAllSeries(Arrays.asList(responsesElement)).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        StreamsServiceClient.ListSeriesPagedResponse pagedListResponse = this.client.listSeries(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSeriesRequest actualRequest = (ListSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSeries(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
        Series actualResponse = this.client.getSeries(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSeriesRequest actualRequest = (GetSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
            this.client.getSeries(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSeriesTest2() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        mockStreamsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Series actualResponse = this.client.getSeries(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSeriesRequest actualRequest = (GetSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSeries(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Series series = Series.newBuilder().build();
        String seriesId = "seriesId1367098866";
        Series actualResponse = (Series)this.client.createSeriesAsync(parent, series, seriesId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSeriesRequest actualRequest = (CreateSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)series, (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)seriesId, (Object)actualRequest.getSeriesId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Series series = Series.newBuilder().build();
            String seriesId = "seriesId1367098866";
            this.client.createSeriesAsync(parent, series, seriesId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createSeriesTest2() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Series series = Series.newBuilder().build();
        String seriesId = "seriesId1367098866";
        Series actualResponse = (Series)this.client.createSeriesAsync(parent, series, seriesId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSeriesRequest actualRequest = (CreateSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)series, (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)seriesId, (Object)actualRequest.getSeriesId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Series series = Series.newBuilder().build();
            String seriesId = "seriesId1367098866";
            this.client.createSeriesAsync(parent, series, seriesId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateSeriesTest() throws Exception {
        Series expectedResponse = Series.newBuilder().setName(SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        Series series = Series.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Series actualResponse = (Series)this.client.updateSeriesAsync(series, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSeriesRequest actualRequest = (UpdateSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)series, (Object)actualRequest.getSeries());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            Series series = Series.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSeriesAsync(series, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSeriesTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
        this.client.deleteSeriesAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSeriesRequest actualRequest = (DeleteSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            SeriesName name = SeriesName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[SERIES]");
            this.client.deleteSeriesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSeriesTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSeriesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteSeriesAsync(name).get();
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSeriesRequest actualRequest = (DeleteSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSeriesAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void materializeChannelTest() throws Exception {
        Channel expectedResponse = Channel.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("materializeChannelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
        Channel channel = Channel.newBuilder().build();
        String channelId = "channelId1461735806";
        Channel actualResponse = (Channel)this.client.materializeChannelAsync(parent, channel, channelId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        MaterializeChannelRequest actualRequest = (MaterializeChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)channel, (Object)actualRequest.getChannel());
        Assert.assertEquals((Object)channelId, (Object)actualRequest.getChannelId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void materializeChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            ClusterName parent = ClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]");
            Channel channel = Channel.newBuilder().build();
            String channelId = "channelId1461735806";
            this.client.materializeChannelAsync(parent, channel, channelId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void materializeChannelTest2() throws Exception {
        Channel expectedResponse = Channel.newBuilder().setName("name3373707").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setStream(StreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[STREAM]").toString()).setEvent(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CLUSTER]", (String)"[EVENT]").toString()).build();
        Operation resultOperation = Operation.newBuilder().setName("materializeChannelTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockStreamsService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Channel channel = Channel.newBuilder().build();
        String channelId = "channelId1461735806";
        Channel actualResponse = (Channel)this.client.materializeChannelAsync(parent, channel, channelId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockStreamsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        MaterializeChannelRequest actualRequest = (MaterializeChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)channel, (Object)actualRequest.getChannel());
        Assert.assertEquals((Object)channelId, (Object)actualRequest.getChannelId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void materializeChannelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockStreamsService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Channel channel = Channel.newBuilder().build();
            String channelId = "channelId1461735806";
            this.client.materializeChannelAsync(parent, channel, channelId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

