/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.visionai.v1.AddCollectionItemResponse;
import com.google.cloud.visionai.v1.AnalyzeAssetRequest;
import com.google.cloud.visionai.v1.AnalyzeAssetResponse;
import com.google.cloud.visionai.v1.AnalyzeCorpusRequest;
import com.google.cloud.visionai.v1.AnalyzeCorpusResponse;
import com.google.cloud.visionai.v1.Annotation;
import com.google.cloud.visionai.v1.AnnotationName;
import com.google.cloud.visionai.v1.Asset;
import com.google.cloud.visionai.v1.AssetName;
import com.google.cloud.visionai.v1.AssetSource;
import com.google.cloud.visionai.v1.ClipAssetRequest;
import com.google.cloud.visionai.v1.ClipAssetResponse;
import com.google.cloud.visionai.v1.Collection;
import com.google.cloud.visionai.v1.CollectionItem;
import com.google.cloud.visionai.v1.CollectionName;
import com.google.cloud.visionai.v1.Corpus;
import com.google.cloud.visionai.v1.CorpusName;
import com.google.cloud.visionai.v1.DataSchema;
import com.google.cloud.visionai.v1.DataSchemaDetails;
import com.google.cloud.visionai.v1.DataSchemaName;
import com.google.cloud.visionai.v1.DateTimeRangeArray;
import com.google.cloud.visionai.v1.DeployIndexRequest;
import com.google.cloud.visionai.v1.DeployIndexResponse;
import com.google.cloud.visionai.v1.DeployedIndex;
import com.google.cloud.visionai.v1.FacetProperty;
import com.google.cloud.visionai.v1.GenerateHlsUriRequest;
import com.google.cloud.visionai.v1.GenerateHlsUriResponse;
import com.google.cloud.visionai.v1.GenerateRetrievalUrlRequest;
import com.google.cloud.visionai.v1.GenerateRetrievalUrlResponse;
import com.google.cloud.visionai.v1.ImportAssetsRequest;
import com.google.cloud.visionai.v1.ImportAssetsResponse;
import com.google.cloud.visionai.v1.Index;
import com.google.cloud.visionai.v1.IndexAssetRequest;
import com.google.cloud.visionai.v1.IndexAssetResponse;
import com.google.cloud.visionai.v1.IndexEndpoint;
import com.google.cloud.visionai.v1.IndexEndpointName;
import com.google.cloud.visionai.v1.IndexName;
import com.google.cloud.visionai.v1.IndexedAsset;
import com.google.cloud.visionai.v1.ListAnnotationsResponse;
import com.google.cloud.visionai.v1.ListAssetsResponse;
import com.google.cloud.visionai.v1.ListCollectionsResponse;
import com.google.cloud.visionai.v1.ListCorporaResponse;
import com.google.cloud.visionai.v1.ListDataSchemasResponse;
import com.google.cloud.visionai.v1.ListIndexEndpointsResponse;
import com.google.cloud.visionai.v1.ListIndexesResponse;
import com.google.cloud.visionai.v1.ListSearchConfigsResponse;
import com.google.cloud.visionai.v1.ListSearchHypernymsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.Partition;
import com.google.cloud.visionai.v1.RemoveCollectionItemResponse;
import com.google.cloud.visionai.v1.RemoveIndexAssetRequest;
import com.google.cloud.visionai.v1.RemoveIndexAssetResponse;
import com.google.cloud.visionai.v1.SearchAssetsRequest;
import com.google.cloud.visionai.v1.SearchAssetsResponse;
import com.google.cloud.visionai.v1.SearchCapabilitySetting;
import com.google.cloud.visionai.v1.SearchConfig;
import com.google.cloud.visionai.v1.SearchConfigName;
import com.google.cloud.visionai.v1.SearchCriteriaProperty;
import com.google.cloud.visionai.v1.SearchHypernym;
import com.google.cloud.visionai.v1.SearchHypernymName;
import com.google.cloud.visionai.v1.SearchIndexEndpointRequest;
import com.google.cloud.visionai.v1.SearchIndexEndpointResponse;
import com.google.cloud.visionai.v1.SearchResultItem;
import com.google.cloud.visionai.v1.UndeployIndexRequest;
import com.google.cloud.visionai.v1.UndeployIndexResponse;
import com.google.cloud.visionai.v1.UploadAssetRequest;
import com.google.cloud.visionai.v1.UploadAssetResponse;
import com.google.cloud.visionai.v1.UserSpecifiedAnnotation;
import com.google.cloud.visionai.v1.ViewCollectionItemsResponse;
import com.google.cloud.visionai.v1.ViewIndexedAssetsResponse;
import com.google.cloud.visionai.v1.WarehouseClient;
import com.google.cloud.visionai.v1.WarehouseSettings;
import com.google.cloud.visionai.v1.stub.HttpJsonWarehouseStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WarehouseClientHttpJsonTest {
    private static MockHttpService mockService;
    private static WarehouseClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonWarehouseStub.getMethodDescriptors(), WarehouseSettings.getDefaultEndpoint());
        WarehouseSettings settings = ((WarehouseSettings.Builder)((WarehouseSettings.Builder)WarehouseSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)WarehouseSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = WarehouseClient.create((WarehouseSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Asset asset = Asset.newBuilder().build();
        String assetId = "assetId-704776149";
        Asset actualResponse = client.createAsset(parent, asset, assetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Asset asset = Asset.newBuilder().build();
            String assetId = "assetId-704776149";
            client.createAsset(parent, asset, assetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAssetTest2() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        Asset asset = Asset.newBuilder().build();
        String assetId = "assetId-704776149";
        Asset actualResponse = client.createAsset(parent, asset, assetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAssetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            Asset asset = Asset.newBuilder().build();
            String assetId = "assetId-704776149";
            client.createAsset(parent, asset, assetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Asset asset = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Asset actualResponse = client.updateAsset(asset, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Asset asset = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateAsset(asset, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        Asset actualResponse = client.getAsset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            client.getAsset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAssetTest2() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1853/locations/location-1853/corpora/corpor-1853/assets/asset-1853";
        Asset actualResponse = client.getAsset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAssetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1853/locations/location-1853/corpora/corpor-1853/assets/asset-1853";
            client.getAsset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        Asset responsesElement = Asset.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllAssets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAssetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest2() throws Exception {
        Asset responsesElement = Asset.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllAssets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAssetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAssetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        client.deleteAssetAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            client.deleteAssetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAssetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-1853/locations/location-1853/corpora/corpor-1853/assets/asset-1853";
        client.deleteAssetAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAssetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1853/locations/location-1853/corpora/corpor-1853/assets/asset-1853";
            client.deleteAssetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void uploadAssetTest() throws Exception {
        UploadAssetResponse expectedResponse = UploadAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("uploadAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        UploadAssetRequest request = UploadAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setAssetSource(AssetSource.newBuilder().build()).build();
        UploadAssetResponse actualResponse = (UploadAssetResponse)client.uploadAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void uploadAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            UploadAssetRequest request = UploadAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setAssetSource(AssetSource.newBuilder().build()).build();
            client.uploadAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void generateRetrievalUrlTest() throws Exception {
        GenerateRetrievalUrlResponse expectedResponse = GenerateRetrievalUrlResponse.newBuilder().setSignedUri("signedUri1076770992").build();
        mockService.addResponse((Object)expectedResponse);
        GenerateRetrievalUrlRequest request = GenerateRetrievalUrlRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
        GenerateRetrievalUrlResponse actualResponse = client.generateRetrievalUrl(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void generateRetrievalUrlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GenerateRetrievalUrlRequest request = GenerateRetrievalUrlRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
            client.generateRetrievalUrl(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void analyzeAssetTest() throws Exception {
        AnalyzeAssetResponse expectedResponse = AnalyzeAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("analyzeAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        AnalyzeAssetRequest request = AnalyzeAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
        AnalyzeAssetResponse actualResponse = (AnalyzeAssetResponse)client.analyzeAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void analyzeAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnalyzeAssetRequest request = AnalyzeAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
            client.analyzeAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void indexAssetTest() throws Exception {
        IndexAssetResponse expectedResponse = IndexAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("indexAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        IndexAssetRequest request = IndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
        IndexAssetResponse actualResponse = (IndexAssetResponse)client.indexAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void indexAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexAssetRequest request = IndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
            client.indexAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void removeIndexAssetTest() throws Exception {
        RemoveIndexAssetResponse expectedResponse = RemoveIndexAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeIndexAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RemoveIndexAssetRequest request = RemoveIndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
        RemoveIndexAssetResponse actualResponse = (RemoveIndexAssetResponse)client.removeIndexAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeIndexAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RemoveIndexAssetRequest request = RemoveIndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
            client.removeIndexAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void viewIndexedAssetsTest() throws Exception {
        IndexedAsset responsesElement = IndexedAsset.newBuilder().build();
        ViewIndexedAssetsResponse expectedResponse = ViewIndexedAssetsResponse.newBuilder().setNextPageToken("").addAllIndexedAssets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        IndexName index = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        WarehouseClient.ViewIndexedAssetsPagedResponse pagedListResponse = client.viewIndexedAssets(index);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexedAssetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void viewIndexedAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexName index = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            client.viewIndexedAssets(index);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewIndexedAssetsTest2() throws Exception {
        IndexedAsset responsesElement = IndexedAsset.newBuilder().build();
        ViewIndexedAssetsResponse expectedResponse = ViewIndexedAssetsResponse.newBuilder().setNextPageToken("").addAllIndexedAssets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String index = "projects/project-3117/locations/location-3117/corpora/corpor-3117/indexes/indexe-3117";
        WarehouseClient.ViewIndexedAssetsPagedResponse pagedListResponse = client.viewIndexedAssets(index);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexedAssetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void viewIndexedAssetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String index = "projects/project-3117/locations/location-3117/corpora/corpor-3117/indexes/indexe-3117";
            client.viewIndexedAssets(index);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Index index = Index.newBuilder().build();
        String indexId = "indexId1943291277";
        Index actualResponse = (Index)client.createIndexAsync(parent, index, indexId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Index index = Index.newBuilder().build();
            String indexId = "indexId1943291277";
            client.createIndexAsync(parent, index, indexId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexTest2() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        Index index = Index.newBuilder().build();
        String indexId = "indexId1943291277";
        Index actualResponse = (Index)client.createIndexAsync(parent, index, indexId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createIndexExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            Index index = Index.newBuilder().build();
            String indexId = "indexId1943291277";
            client.createIndexAsync(parent, index, indexId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Index index = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Index actualResponse = (Index)client.updateIndexAsync(index, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Index index = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateIndexAsync(index, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        Index actualResponse = client.getIndex(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            client.getIndex(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexTest2() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9254/locations/location-9254/corpora/corpor-9254/indexes/indexe-9254";
        Index actualResponse = client.getIndex(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIndexExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9254/locations/location-9254/corpora/corpor-9254/indexes/indexe-9254";
            client.getIndex(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexesTest() throws Exception {
        Index responsesElement = Index.newBuilder().build();
        ListIndexesResponse expectedResponse = ListIndexesResponse.newBuilder().setNextPageToken("").addAllIndexes(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListIndexesPagedResponse pagedListResponse = client.listIndexes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listIndexesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listIndexes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexesTest2() throws Exception {
        Index responsesElement = Index.newBuilder().build();
        ListIndexesResponse expectedResponse = ListIndexesResponse.newBuilder().setNextPageToken("").addAllIndexes(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListIndexesPagedResponse pagedListResponse = client.listIndexes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listIndexesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listIndexes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIndexTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        client.deleteIndexAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            client.deleteIndexAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIndexTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-9254/locations/location-9254/corpora/corpor-9254/indexes/indexe-9254";
        client.deleteIndexAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteIndexExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9254/locations/location-9254/corpora/corpor-9254/indexes/indexe-9254";
            client.deleteIndexAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createCorpusTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Corpus corpus = Corpus.newBuilder().build();
        Corpus actualResponse = (Corpus)client.createCorpusAsync(parent, corpus).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCorpusExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Corpus corpus = Corpus.newBuilder().build();
            client.createCorpusAsync(parent, corpus).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Corpus actualResponse = client.getCorpus(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCorpusExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.getCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCorpusTest2() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1702/locations/location-1702/corpora/corpor-1702";
        Corpus actualResponse = client.getCorpus(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCorpusExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1702/locations/location-1702/corpora/corpor-1702";
            client.getCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        Corpus corpus = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Corpus actualResponse = client.updateCorpus(corpus, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateCorpusExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Corpus corpus = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateCorpus(corpus, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCorporaTest() throws Exception {
        Corpus responsesElement = Corpus.newBuilder().build();
        ListCorporaResponse expectedResponse = ListCorporaResponse.newBuilder().setNextPageToken("").addAllCorpora(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        WarehouseClient.ListCorporaPagedResponse pagedListResponse = client.listCorpora(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCorporaList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCorporaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listCorpora(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCorpusTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        client.deleteCorpus(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCorpusExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.deleteCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCorpusTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1702/locations/location-1702/corpora/corpor-1702";
        client.deleteCorpus(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCorpusExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1702/locations/location-1702/corpora/corpor-1702";
            client.deleteCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void analyzeCorpusTest() throws Exception {
        AnalyzeCorpusResponse expectedResponse = AnalyzeCorpusResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("analyzeCorpusTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        AnalyzeCorpusRequest request = AnalyzeCorpusRequest.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
        AnalyzeCorpusResponse actualResponse = (AnalyzeCorpusResponse)client.analyzeCorpusAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void analyzeCorpusExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnalyzeCorpusRequest request = AnalyzeCorpusRequest.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
            client.analyzeCorpusAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        DataSchema dataSchema = DataSchema.newBuilder().build();
        DataSchema actualResponse = client.createDataSchema(parent, dataSchema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDataSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            DataSchema dataSchema = DataSchema.newBuilder().build();
            client.createDataSchema(parent, dataSchema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDataSchemaTest2() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        DataSchema dataSchema = DataSchema.newBuilder().build();
        DataSchema actualResponse = client.createDataSchema(parent, dataSchema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDataSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            DataSchema dataSchema = DataSchema.newBuilder().build();
            client.createDataSchema(parent, dataSchema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DataSchema dataSchema = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        DataSchema actualResponse = client.updateDataSchema(dataSchema, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDataSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DataSchema dataSchema = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDataSchema(dataSchema, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
        DataSchema actualResponse = client.getDataSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDataSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
            client.getDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDataSchemaTest2() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-558/locations/location-558/corpora/corpor-558/dataSchemas/dataSchema-558";
        DataSchema actualResponse = client.getDataSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDataSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-558/locations/location-558/corpora/corpor-558/dataSchemas/dataSchema-558";
            client.getDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDataSchemaTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
        client.deleteDataSchema(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDataSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
            client.deleteDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDataSchemaTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-558/locations/location-558/corpora/corpor-558/dataSchemas/dataSchema-558";
        client.deleteDataSchema(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDataSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-558/locations/location-558/corpora/corpor-558/dataSchemas/dataSchema-558";
            client.deleteDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDataSchemasTest() throws Exception {
        DataSchema responsesElement = DataSchema.newBuilder().build();
        ListDataSchemasResponse expectedResponse = ListDataSchemasResponse.newBuilder().setNextPageToken("").addAllDataSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListDataSchemasPagedResponse pagedListResponse = client.listDataSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDataSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDataSchemasExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listDataSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDataSchemasTest2() throws Exception {
        DataSchema responsesElement = DataSchema.newBuilder().build();
        ListDataSchemasResponse expectedResponse = ListDataSchemasResponse.newBuilder().setNextPageToken("").addAllDataSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListDataSchemasPagedResponse pagedListResponse = client.listDataSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDataSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDataSchemasExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listDataSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        Annotation annotation = Annotation.newBuilder().build();
        String annotationId = "annotationId251782314";
        Annotation actualResponse = client.createAnnotation(parent, annotation, annotationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAnnotationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            Annotation annotation = Annotation.newBuilder().build();
            String annotationId = "annotationId251782314";
            client.createAnnotation(parent, annotation, annotationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnnotationTest2() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-3476/locations/location-3476/corpora/corpor-3476/assets/asset-3476";
        Annotation annotation = Annotation.newBuilder().build();
        String annotationId = "annotationId251782314";
        Annotation actualResponse = client.createAnnotation(parent, annotation, annotationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createAnnotationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3476/locations/location-3476/corpora/corpor-3476/assets/asset-3476";
            Annotation annotation = Annotation.newBuilder().build();
            String annotationId = "annotationId251782314";
            client.createAnnotation(parent, annotation, annotationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
        Annotation actualResponse = client.getAnnotation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAnnotationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
            client.getAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnnotationTest2() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2515/locations/location-2515/corpora/corpor-2515/assets/asset-2515/annotations/annotation-2515";
        Annotation actualResponse = client.getAnnotation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getAnnotationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2515/locations/location-2515/corpora/corpor-2515/assets/asset-2515/annotations/annotation-2515";
            client.getAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnnotationsTest() throws Exception {
        Annotation responsesElement = Annotation.newBuilder().build();
        ListAnnotationsResponse expectedResponse = ListAnnotationsResponse.newBuilder().setNextPageToken("").addAllAnnotations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        WarehouseClient.ListAnnotationsPagedResponse pagedListResponse = client.listAnnotations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnnotationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAnnotationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            client.listAnnotations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnnotationsTest2() throws Exception {
        Annotation responsesElement = Annotation.newBuilder().build();
        ListAnnotationsResponse expectedResponse = ListAnnotationsResponse.newBuilder().setNextPageToken("").addAllAnnotations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-3476/locations/location-3476/corpora/corpor-3476/assets/asset-3476";
        WarehouseClient.ListAnnotationsPagedResponse pagedListResponse = client.listAnnotations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnnotationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAnnotationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3476/locations/location-3476/corpora/corpor-3476/assets/asset-3476";
            client.listAnnotations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Annotation annotation = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Annotation actualResponse = client.updateAnnotation(annotation, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateAnnotationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Annotation annotation = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateAnnotation(annotation, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnnotationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
        client.deleteAnnotation(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAnnotationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
            client.deleteAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnnotationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2515/locations/location-2515/corpora/corpor-2515/assets/asset-2515/annotations/annotation-2515";
        client.deleteAnnotation(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteAnnotationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2515/locations/location-2515/corpora/corpor-2515/assets/asset-2515/annotations/annotation-2515";
            client.deleteAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void ingestAssetUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void clipAssetTest() throws Exception {
        ClipAssetResponse expectedResponse = ClipAssetResponse.newBuilder().addAllTimeIndexedUris(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ClipAssetRequest request = ClipAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTemporalPartition(Partition.TemporalPartition.newBuilder().build()).build();
        ClipAssetResponse actualResponse = client.clipAsset(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void clipAssetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ClipAssetRequest request = ClipAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTemporalPartition(Partition.TemporalPartition.newBuilder().build()).build();
            client.clipAsset(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateHlsUriTest() throws Exception {
        GenerateHlsUriResponse expectedResponse = GenerateHlsUriResponse.newBuilder().setUri("uri116076").addAllTemporalPartitions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        GenerateHlsUriRequest request = GenerateHlsUriRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).addAllTemporalPartitions(new ArrayList()).setLiveViewEnabled(true).build();
        GenerateHlsUriResponse actualResponse = client.generateHlsUri(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void generateHlsUriExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GenerateHlsUriRequest request = GenerateHlsUriRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).addAllTemporalPartitions(new ArrayList()).setLiveViewEnabled(true).build();
            client.generateHlsUri(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importAssetsTest() throws Exception {
        ImportAssetsResponse expectedResponse = ImportAssetsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("importAssetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ImportAssetsRequest request = ImportAssetsRequest.newBuilder().setParent(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
        ImportAssetsResponse actualResponse = (ImportAssetsResponse)client.importAssetsAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void importAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ImportAssetsRequest request = ImportAssetsRequest.newBuilder().setParent(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
            client.importAssetsAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        SearchConfig searchConfig = SearchConfig.newBuilder().build();
        String searchConfigId = "searchConfigId1576297925";
        SearchConfig actualResponse = client.createSearchConfig(parent, searchConfig, searchConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSearchConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            SearchConfig searchConfig = SearchConfig.newBuilder().build();
            String searchConfigId = "searchConfigId1576297925";
            client.createSearchConfig(parent, searchConfig, searchConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchConfigTest2() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        SearchConfig searchConfig = SearchConfig.newBuilder().build();
        String searchConfigId = "searchConfigId1576297925";
        SearchConfig actualResponse = client.createSearchConfig(parent, searchConfig, searchConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSearchConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            SearchConfig searchConfig = SearchConfig.newBuilder().build();
            String searchConfigId = "searchConfigId1576297925";
            client.createSearchConfig(parent, searchConfig, searchConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SearchConfig searchConfig = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SearchConfig actualResponse = client.updateSearchConfig(searchConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSearchConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchConfig searchConfig = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSearchConfig(searchConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
        SearchConfig actualResponse = client.getSearchConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSearchConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
            client.getSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchConfigTest2() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4415/locations/location-4415/corpora/corpor-4415/searchConfigs/searchConfig-4415";
        SearchConfig actualResponse = client.getSearchConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSearchConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4415/locations/location-4415/corpora/corpor-4415/searchConfigs/searchConfig-4415";
            client.getSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
        client.deleteSearchConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSearchConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
            client.deleteSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4415/locations/location-4415/corpora/corpor-4415/searchConfigs/searchConfig-4415";
        client.deleteSearchConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSearchConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4415/locations/location-4415/corpora/corpor-4415/searchConfigs/searchConfig-4415";
            client.deleteSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchConfigsTest() throws Exception {
        SearchConfig responsesElement = SearchConfig.newBuilder().build();
        ListSearchConfigsResponse expectedResponse = ListSearchConfigsResponse.newBuilder().setNextPageToken("").addAllSearchConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListSearchConfigsPagedResponse pagedListResponse = client.listSearchConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSearchConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listSearchConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchConfigsTest2() throws Exception {
        SearchConfig responsesElement = SearchConfig.newBuilder().build();
        ListSearchConfigsResponse expectedResponse = ListSearchConfigsResponse.newBuilder().setNextPageToken("").addAllSearchConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListSearchConfigsPagedResponse pagedListResponse = client.listSearchConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSearchConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listSearchConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
        String searchHypernymId = "searchHypernymId-314707559";
        SearchHypernym actualResponse = client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSearchHypernymExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
            String searchHypernymId = "searchHypernymId-314707559";
            client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchHypernymTest2() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
        String searchHypernymId = "searchHypernymId-314707559";
        SearchHypernym actualResponse = client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSearchHypernymExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
            String searchHypernymId = "searchHypernymId-314707559";
            client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SearchHypernym actualResponse = client.updateSearchHypernym(searchHypernym, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSearchHypernymExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSearchHypernym(searchHypernym, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
        SearchHypernym actualResponse = client.getSearchHypernym(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSearchHypernymExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
            client.getSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchHypernymTest2() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3909/locations/location-3909/corpora/corpor-3909/searchHypernyms/searchHypernym-3909";
        SearchHypernym actualResponse = client.getSearchHypernym(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSearchHypernymExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3909/locations/location-3909/corpora/corpor-3909/searchHypernyms/searchHypernym-3909";
            client.getSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchHypernymTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
        client.deleteSearchHypernym(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSearchHypernymExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
            client.deleteSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchHypernymTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3909/locations/location-3909/corpora/corpor-3909/searchHypernyms/searchHypernym-3909";
        client.deleteSearchHypernym(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSearchHypernymExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3909/locations/location-3909/corpora/corpor-3909/searchHypernyms/searchHypernym-3909";
            client.deleteSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchHypernymsTest() throws Exception {
        SearchHypernym responsesElement = SearchHypernym.newBuilder().build();
        ListSearchHypernymsResponse expectedResponse = ListSearchHypernymsResponse.newBuilder().setNextPageToken("").addAllSearchHypernyms(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListSearchHypernymsPagedResponse pagedListResponse = client.listSearchHypernyms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchHypernymsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSearchHypernymsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listSearchHypernyms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchHypernymsTest2() throws Exception {
        SearchHypernym responsesElement = SearchHypernym.newBuilder().build();
        ListSearchHypernymsResponse expectedResponse = ListSearchHypernymsResponse.newBuilder().setNextPageToken("").addAllSearchHypernyms(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListSearchHypernymsPagedResponse pagedListResponse = client.listSearchHypernyms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchHypernymsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSearchHypernymsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listSearchHypernyms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchAssetsTest() throws Exception {
        SearchResultItem responsesElement = SearchResultItem.newBuilder().build();
        SearchAssetsResponse expectedResponse = SearchAssetsResponse.newBuilder().setNextPageToken("").addAllSearchResultItems(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchAssetsRequest request = SearchAssetsRequest.newBuilder().setCorpus(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setContentTimeRanges(DateTimeRangeArray.newBuilder().build()).addAllCriteria(new ArrayList()).addAllFacetSelections(new ArrayList()).addAllResultAnnotationKeys(new ArrayList()).setSearchQuery("searchQuery-552137728").build();
        WarehouseClient.SearchAssetsPagedResponse pagedListResponse = client.searchAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchResultItemsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchAssetsRequest request = SearchAssetsRequest.newBuilder().setCorpus(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setContentTimeRanges(DateTimeRangeArray.newBuilder().build()).addAllCriteria(new ArrayList()).addAllFacetSelections(new ArrayList()).addAllResultAnnotationKeys(new ArrayList()).setSearchQuery("searchQuery-552137728").build();
            client.searchAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchIndexEndpointTest() throws Exception {
        SearchResultItem responsesElement = SearchResultItem.newBuilder().build();
        SearchIndexEndpointResponse expectedResponse = SearchIndexEndpointResponse.newBuilder().setNextPageToken("").addAllSearchResultItems(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchIndexEndpointRequest request = SearchIndexEndpointRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).addAllCriteria(new ArrayList()).addAllExclusionCriteria(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        WarehouseClient.SearchIndexEndpointPagedResponse pagedListResponse = client.searchIndexEndpoint(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchResultItemsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchIndexEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchIndexEndpointRequest request = SearchIndexEndpointRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).addAllCriteria(new ArrayList()).addAllExclusionCriteria(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.searchIndexEndpoint(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
        String indexEndpointId = "indexEndpointId-250889214";
        IndexEndpoint actualResponse = (IndexEndpoint)client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createIndexEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
            String indexEndpointId = "indexEndpointId-250889214";
            client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexEndpointTest2() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
        String indexEndpointId = "indexEndpointId-250889214";
        IndexEndpoint actualResponse = (IndexEndpoint)client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createIndexEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
            String indexEndpointId = "indexEndpointId-250889214";
            client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
        IndexEndpoint actualResponse = client.getIndexEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIndexEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
            client.getIndexEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexEndpointTest2() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1372/locations/location-1372/indexEndpoints/indexEndpoint-1372";
        IndexEndpoint actualResponse = client.getIndexEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIndexEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1372/locations/location-1372/indexEndpoints/indexEndpoint-1372";
            client.getIndexEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexEndpointsTest() throws Exception {
        IndexEndpoint responsesElement = IndexEndpoint.newBuilder().build();
        ListIndexEndpointsResponse expectedResponse = ListIndexEndpointsResponse.newBuilder().setNextPageToken("").addAllIndexEndpoints(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        WarehouseClient.ListIndexEndpointsPagedResponse pagedListResponse = client.listIndexEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexEndpointsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listIndexEndpointsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listIndexEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexEndpointsTest2() throws Exception {
        IndexEndpoint responsesElement = IndexEndpoint.newBuilder().build();
        ListIndexEndpointsResponse expectedResponse = ListIndexEndpointsResponse.newBuilder().setNextPageToken("").addAllIndexEndpoints(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        WarehouseClient.ListIndexEndpointsPagedResponse pagedListResponse = client.listIndexEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexEndpointsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listIndexEndpointsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listIndexEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        IndexEndpoint actualResponse = (IndexEndpoint)client.updateIndexEndpointAsync(indexEndpoint, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateIndexEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateIndexEndpointAsync(indexEndpoint, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIndexEndpointTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
        client.deleteIndexEndpointAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteIndexEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
            client.deleteIndexEndpointAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIndexEndpointTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-1372/locations/location-1372/indexEndpoints/indexEndpoint-1372";
        client.deleteIndexEndpointAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteIndexEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1372/locations/location-1372/indexEndpoints/indexEndpoint-1372";
            client.deleteIndexEndpointAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deployIndexTest() throws Exception {
        DeployIndexResponse expectedResponse = DeployIndexResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDeployedIndex(DeployedIndex.newBuilder().build()).build();
        DeployIndexResponse actualResponse = (DeployIndexResponse)client.deployIndexAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deployIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDeployedIndex(DeployedIndex.newBuilder().build()).build();
            client.deployIndexAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void undeployIndexTest() throws Exception {
        UndeployIndexResponse expectedResponse = UndeployIndexResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).build();
        UndeployIndexResponse actualResponse = (UndeployIndexResponse)client.undeployIndexAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void undeployIndexExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).build();
            client.undeployIndexAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Collection collection = Collection.newBuilder().build();
        String collectionId = "collectionId1636075609";
        Collection actualResponse = (Collection)client.createCollectionAsync(parent, collection, collectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCollectionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Collection collection = Collection.newBuilder().build();
            String collectionId = "collectionId1636075609";
            client.createCollectionAsync(parent, collection, collectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createCollectionTest2() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        Collection collection = Collection.newBuilder().build();
        String collectionId = "collectionId1636075609";
        Collection actualResponse = (Collection)client.createCollectionAsync(parent, collection, collectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCollectionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            Collection collection = Collection.newBuilder().build();
            String collectionId = "collectionId1636075609";
            client.createCollectionAsync(parent, collection, collectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCollectionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        client.deleteCollectionAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCollectionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            client.deleteCollectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCollectionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-3989/locations/location-3989/corpora/corpor-3989/collections/collection-3989";
        client.deleteCollectionAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCollectionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3989/locations/location-3989/corpora/corpor-3989/collections/collection-3989";
            client.deleteCollectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        Collection actualResponse = client.getCollection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCollectionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            client.getCollection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCollectionTest2() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3989/locations/location-3989/corpora/corpor-3989/collections/collection-3989";
        Collection actualResponse = client.getCollection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCollectionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3989/locations/location-3989/corpora/corpor-3989/collections/collection-3989";
            client.getCollection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockService.addResponse((Object)expectedResponse);
        Collection collection = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Collection actualResponse = client.updateCollection(collection, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateCollectionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Collection collection = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateCollection(collection, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCollectionsTest() throws Exception {
        Collection responsesElement = Collection.newBuilder().build();
        ListCollectionsResponse expectedResponse = ListCollectionsResponse.newBuilder().setNextPageToken("").addAllCollections(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListCollectionsPagedResponse pagedListResponse = client.listCollections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCollectionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCollectionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            client.listCollections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCollectionsTest2() throws Exception {
        Collection responsesElement = Collection.newBuilder().build();
        ListCollectionsResponse expectedResponse = ListCollectionsResponse.newBuilder().setNextPageToken("").addAllCollections(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
        WarehouseClient.ListCollectionsPagedResponse pagedListResponse = client.listCollections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCollectionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCollectionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7911/locations/location-7911/corpora/corpor-7911";
            client.listCollections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addCollectionItemTest() throws Exception {
        AddCollectionItemResponse expectedResponse = AddCollectionItemResponse.newBuilder().setItem(CollectionItem.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CollectionItem item = CollectionItem.newBuilder().setCollection(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setItemResource("itemResource287367233").build();
        AddCollectionItemResponse actualResponse = client.addCollectionItem(item);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void addCollectionItemExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CollectionItem item = CollectionItem.newBuilder().setCollection(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setItemResource("itemResource287367233").build();
            client.addCollectionItem(item);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeCollectionItemTest() throws Exception {
        RemoveCollectionItemResponse expectedResponse = RemoveCollectionItemResponse.newBuilder().setItem(CollectionItem.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CollectionItem item = CollectionItem.newBuilder().setCollection(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setItemResource("itemResource287367233").build();
        RemoveCollectionItemResponse actualResponse = client.removeCollectionItem(item);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void removeCollectionItemExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CollectionItem item = CollectionItem.newBuilder().setCollection(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setItemResource("itemResource287367233").build();
            client.removeCollectionItem(item);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewCollectionItemsTest() throws Exception {
        CollectionItem responsesElement = CollectionItem.newBuilder().build();
        ViewCollectionItemsResponse expectedResponse = ViewCollectionItemsResponse.newBuilder().setNextPageToken("").addAllItems(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CollectionName collection = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        WarehouseClient.ViewCollectionItemsPagedResponse pagedListResponse = client.viewCollectionItems(collection);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getItemsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void viewCollectionItemsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CollectionName collection = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            client.viewCollectionItems(collection);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewCollectionItemsTest2() throws Exception {
        CollectionItem responsesElement = CollectionItem.newBuilder().build();
        ViewCollectionItemsResponse expectedResponse = ViewCollectionItemsResponse.newBuilder().setNextPageToken("").addAllItems(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String collection = "projects/project-5278/locations/location-5278/corpora/corpor-5278/collections/collection-5278";
        WarehouseClient.ViewCollectionItemsPagedResponse pagedListResponse = client.viewCollectionItems(collection);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getItemsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void viewCollectionItemsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String collection = "projects/project-5278/locations/location-5278/corpora/corpor-5278/collections/collection-5278";
            client.viewCollectionItems(collection);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

