/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.visionai.v1.AddCollectionItemRequest;
import com.google.cloud.visionai.v1.AddCollectionItemResponse;
import com.google.cloud.visionai.v1.AnalyzeAssetRequest;
import com.google.cloud.visionai.v1.AnalyzeAssetResponse;
import com.google.cloud.visionai.v1.AnalyzeCorpusRequest;
import com.google.cloud.visionai.v1.AnalyzeCorpusResponse;
import com.google.cloud.visionai.v1.Annotation;
import com.google.cloud.visionai.v1.AnnotationName;
import com.google.cloud.visionai.v1.Asset;
import com.google.cloud.visionai.v1.AssetName;
import com.google.cloud.visionai.v1.AssetSource;
import com.google.cloud.visionai.v1.ClipAssetRequest;
import com.google.cloud.visionai.v1.ClipAssetResponse;
import com.google.cloud.visionai.v1.Collection;
import com.google.cloud.visionai.v1.CollectionItem;
import com.google.cloud.visionai.v1.CollectionName;
import com.google.cloud.visionai.v1.Corpus;
import com.google.cloud.visionai.v1.CorpusName;
import com.google.cloud.visionai.v1.CreateAnnotationRequest;
import com.google.cloud.visionai.v1.CreateAssetRequest;
import com.google.cloud.visionai.v1.CreateCollectionRequest;
import com.google.cloud.visionai.v1.CreateCorpusRequest;
import com.google.cloud.visionai.v1.CreateDataSchemaRequest;
import com.google.cloud.visionai.v1.CreateIndexEndpointRequest;
import com.google.cloud.visionai.v1.CreateIndexRequest;
import com.google.cloud.visionai.v1.CreateSearchConfigRequest;
import com.google.cloud.visionai.v1.CreateSearchHypernymRequest;
import com.google.cloud.visionai.v1.DataSchema;
import com.google.cloud.visionai.v1.DataSchemaDetails;
import com.google.cloud.visionai.v1.DataSchemaName;
import com.google.cloud.visionai.v1.DateTimeRangeArray;
import com.google.cloud.visionai.v1.DeleteAnnotationRequest;
import com.google.cloud.visionai.v1.DeleteAssetRequest;
import com.google.cloud.visionai.v1.DeleteCollectionRequest;
import com.google.cloud.visionai.v1.DeleteCorpusRequest;
import com.google.cloud.visionai.v1.DeleteDataSchemaRequest;
import com.google.cloud.visionai.v1.DeleteIndexEndpointRequest;
import com.google.cloud.visionai.v1.DeleteIndexRequest;
import com.google.cloud.visionai.v1.DeleteSearchConfigRequest;
import com.google.cloud.visionai.v1.DeleteSearchHypernymRequest;
import com.google.cloud.visionai.v1.DeployIndexRequest;
import com.google.cloud.visionai.v1.DeployIndexResponse;
import com.google.cloud.visionai.v1.DeployedIndex;
import com.google.cloud.visionai.v1.FacetProperty;
import com.google.cloud.visionai.v1.GenerateHlsUriRequest;
import com.google.cloud.visionai.v1.GenerateHlsUriResponse;
import com.google.cloud.visionai.v1.GenerateRetrievalUrlRequest;
import com.google.cloud.visionai.v1.GenerateRetrievalUrlResponse;
import com.google.cloud.visionai.v1.GetAnnotationRequest;
import com.google.cloud.visionai.v1.GetAssetRequest;
import com.google.cloud.visionai.v1.GetCollectionRequest;
import com.google.cloud.visionai.v1.GetCorpusRequest;
import com.google.cloud.visionai.v1.GetDataSchemaRequest;
import com.google.cloud.visionai.v1.GetIndexEndpointRequest;
import com.google.cloud.visionai.v1.GetIndexRequest;
import com.google.cloud.visionai.v1.GetSearchConfigRequest;
import com.google.cloud.visionai.v1.GetSearchHypernymRequest;
import com.google.cloud.visionai.v1.ImportAssetsRequest;
import com.google.cloud.visionai.v1.ImportAssetsResponse;
import com.google.cloud.visionai.v1.Index;
import com.google.cloud.visionai.v1.IndexAssetRequest;
import com.google.cloud.visionai.v1.IndexAssetResponse;
import com.google.cloud.visionai.v1.IndexEndpoint;
import com.google.cloud.visionai.v1.IndexEndpointName;
import com.google.cloud.visionai.v1.IndexName;
import com.google.cloud.visionai.v1.IndexedAsset;
import com.google.cloud.visionai.v1.IngestAssetRequest;
import com.google.cloud.visionai.v1.IngestAssetResponse;
import com.google.cloud.visionai.v1.ListAnnotationsRequest;
import com.google.cloud.visionai.v1.ListAnnotationsResponse;
import com.google.cloud.visionai.v1.ListAssetsRequest;
import com.google.cloud.visionai.v1.ListAssetsResponse;
import com.google.cloud.visionai.v1.ListCollectionsRequest;
import com.google.cloud.visionai.v1.ListCollectionsResponse;
import com.google.cloud.visionai.v1.ListCorporaRequest;
import com.google.cloud.visionai.v1.ListCorporaResponse;
import com.google.cloud.visionai.v1.ListDataSchemasRequest;
import com.google.cloud.visionai.v1.ListDataSchemasResponse;
import com.google.cloud.visionai.v1.ListIndexEndpointsRequest;
import com.google.cloud.visionai.v1.ListIndexEndpointsResponse;
import com.google.cloud.visionai.v1.ListIndexesRequest;
import com.google.cloud.visionai.v1.ListIndexesResponse;
import com.google.cloud.visionai.v1.ListSearchConfigsRequest;
import com.google.cloud.visionai.v1.ListSearchConfigsResponse;
import com.google.cloud.visionai.v1.ListSearchHypernymsRequest;
import com.google.cloud.visionai.v1.ListSearchHypernymsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.MockIAMPolicy;
import com.google.cloud.visionai.v1.MockLocations;
import com.google.cloud.visionai.v1.MockWarehouse;
import com.google.cloud.visionai.v1.Partition;
import com.google.cloud.visionai.v1.RemoveCollectionItemRequest;
import com.google.cloud.visionai.v1.RemoveCollectionItemResponse;
import com.google.cloud.visionai.v1.RemoveIndexAssetRequest;
import com.google.cloud.visionai.v1.RemoveIndexAssetResponse;
import com.google.cloud.visionai.v1.SearchAssetsRequest;
import com.google.cloud.visionai.v1.SearchAssetsResponse;
import com.google.cloud.visionai.v1.SearchCapabilitySetting;
import com.google.cloud.visionai.v1.SearchConfig;
import com.google.cloud.visionai.v1.SearchConfigName;
import com.google.cloud.visionai.v1.SearchCriteriaProperty;
import com.google.cloud.visionai.v1.SearchHypernym;
import com.google.cloud.visionai.v1.SearchHypernymName;
import com.google.cloud.visionai.v1.SearchIndexEndpointRequest;
import com.google.cloud.visionai.v1.SearchIndexEndpointResponse;
import com.google.cloud.visionai.v1.SearchResultItem;
import com.google.cloud.visionai.v1.UndeployIndexRequest;
import com.google.cloud.visionai.v1.UndeployIndexResponse;
import com.google.cloud.visionai.v1.UpdateAnnotationRequest;
import com.google.cloud.visionai.v1.UpdateAssetRequest;
import com.google.cloud.visionai.v1.UpdateCollectionRequest;
import com.google.cloud.visionai.v1.UpdateCorpusRequest;
import com.google.cloud.visionai.v1.UpdateDataSchemaRequest;
import com.google.cloud.visionai.v1.UpdateIndexEndpointRequest;
import com.google.cloud.visionai.v1.UpdateIndexRequest;
import com.google.cloud.visionai.v1.UpdateSearchConfigRequest;
import com.google.cloud.visionai.v1.UpdateSearchHypernymRequest;
import com.google.cloud.visionai.v1.UploadAssetRequest;
import com.google.cloud.visionai.v1.UploadAssetResponse;
import com.google.cloud.visionai.v1.UserSpecifiedAnnotation;
import com.google.cloud.visionai.v1.ViewCollectionItemsRequest;
import com.google.cloud.visionai.v1.ViewCollectionItemsResponse;
import com.google.cloud.visionai.v1.ViewIndexedAssetsRequest;
import com.google.cloud.visionai.v1.ViewIndexedAssetsResponse;
import com.google.cloud.visionai.v1.WarehouseClient;
import com.google.cloud.visionai.v1.WarehouseSettings;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WarehouseClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private static MockWarehouse mockWarehouse;
    private LocalChannelProvider channelProvider;
    private WarehouseClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockWarehouse = new MockWarehouse();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockWarehouse, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        WarehouseSettings settings = ((WarehouseSettings.Builder)((WarehouseSettings.Builder)WarehouseSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = WarehouseClient.create((WarehouseSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Asset asset = Asset.newBuilder().build();
        String assetId = "assetId-704776149";
        Asset actualResponse = this.client.createAsset(parent, asset, assetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAssetRequest actualRequest = (CreateAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)asset, (Object)actualRequest.getAsset());
        Assert.assertEquals((Object)assetId, (Object)actualRequest.getAssetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Asset asset = Asset.newBuilder().build();
            String assetId = "assetId-704776149";
            this.client.createAsset(parent, asset, assetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAssetTest2() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Asset asset = Asset.newBuilder().build();
        String assetId = "assetId-704776149";
        Asset actualResponse = this.client.createAsset(parent, asset, assetId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAssetRequest actualRequest = (CreateAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)asset, (Object)actualRequest.getAsset());
        Assert.assertEquals((Object)assetId, (Object)actualRequest.getAssetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAssetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Asset asset = Asset.newBuilder().build();
            String assetId = "assetId-704776149";
            this.client.createAsset(parent, asset, assetId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        Asset asset = Asset.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Asset actualResponse = this.client.updateAsset(asset, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAssetRequest actualRequest = (UpdateAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)asset, (Object)actualRequest.getAsset());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            Asset asset = Asset.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAsset(asset, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAssetTest() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        Asset actualResponse = this.client.getAsset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAssetRequest actualRequest = (GetAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            this.client.getAsset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAssetTest2() throws Exception {
        Asset expectedResponse = Asset.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTtl(Duration.newBuilder().build()).setAssetGcsSource(AssetSource.AssetGcsSource.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Asset actualResponse = this.client.getAsset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAssetRequest actualRequest = (GetAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAssetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAsset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        Asset responsesElement = Asset.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllAssets(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListAssetsPagedResponse pagedListResponse = this.client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAssetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAssetsRequest actualRequest = (ListAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest2() throws Exception {
        Asset responsesElement = Asset.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllAssets(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListAssetsPagedResponse pagedListResponse = this.client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAssetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAssetsRequest actualRequest = (ListAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAssetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAssetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        this.client.deleteAssetAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAssetRequest actualRequest = (DeleteAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AssetName name = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            this.client.deleteAssetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAssetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteAssetAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAssetRequest actualRequest = (DeleteAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAssetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAssetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void uploadAssetTest() throws Exception {
        UploadAssetResponse expectedResponse = UploadAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("uploadAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        UploadAssetRequest request = UploadAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setAssetSource(AssetSource.newBuilder().build()).build();
        UploadAssetResponse actualResponse = (UploadAssetResponse)this.client.uploadAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UploadAssetRequest actualRequest = (UploadAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getAssetSource(), (Object)actualRequest.getAssetSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void uploadAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            UploadAssetRequest request = UploadAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setAssetSource(AssetSource.newBuilder().build()).build();
            this.client.uploadAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void generateRetrievalUrlTest() throws Exception {
        GenerateRetrievalUrlResponse expectedResponse = GenerateRetrievalUrlResponse.newBuilder().setSignedUri("signedUri1076770992").build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        GenerateRetrievalUrlRequest request = GenerateRetrievalUrlRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
        GenerateRetrievalUrlResponse actualResponse = this.client.generateRetrievalUrl(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateRetrievalUrlRequest actualRequest = (GenerateRetrievalUrlRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateRetrievalUrlExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            GenerateRetrievalUrlRequest request = GenerateRetrievalUrlRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
            this.client.generateRetrievalUrl(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void analyzeAssetTest() throws Exception {
        AnalyzeAssetResponse expectedResponse = AnalyzeAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("analyzeAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        AnalyzeAssetRequest request = AnalyzeAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
        AnalyzeAssetResponse actualResponse = (AnalyzeAssetResponse)this.client.analyzeAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AnalyzeAssetRequest actualRequest = (AnalyzeAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void analyzeAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AnalyzeAssetRequest request = AnalyzeAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).build();
            this.client.analyzeAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void indexAssetTest() throws Exception {
        IndexAssetResponse expectedResponse = IndexAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("indexAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        IndexAssetRequest request = IndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
        IndexAssetResponse actualResponse = (IndexAssetResponse)this.client.indexAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        IndexAssetRequest actualRequest = (IndexAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getIndex(), (Object)actualRequest.getIndex());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void indexAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexAssetRequest request = IndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
            this.client.indexAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void removeIndexAssetTest() throws Exception {
        RemoveIndexAssetResponse expectedResponse = RemoveIndexAssetResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("removeIndexAssetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        RemoveIndexAssetRequest request = RemoveIndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
        RemoveIndexAssetResponse actualResponse = (RemoveIndexAssetResponse)this.client.removeIndexAssetAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveIndexAssetRequest actualRequest = (RemoveIndexAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getIndex(), (Object)actualRequest.getIndex());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeIndexAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            RemoveIndexAssetRequest request = RemoveIndexAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setIndex(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).build();
            this.client.removeIndexAssetAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void viewIndexedAssetsTest() throws Exception {
        IndexedAsset responsesElement = IndexedAsset.newBuilder().build();
        ViewIndexedAssetsResponse expectedResponse = ViewIndexedAssetsResponse.newBuilder().setNextPageToken("").addAllIndexedAssets(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        IndexName index = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        WarehouseClient.ViewIndexedAssetsPagedResponse pagedListResponse = this.client.viewIndexedAssets(index);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexedAssetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ViewIndexedAssetsRequest actualRequest = (ViewIndexedAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)index.toString(), (Object)actualRequest.getIndex());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void viewIndexedAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexName index = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            this.client.viewIndexedAssets(index);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewIndexedAssetsTest2() throws Exception {
        IndexedAsset responsesElement = IndexedAsset.newBuilder().build();
        ViewIndexedAssetsResponse expectedResponse = ViewIndexedAssetsResponse.newBuilder().setNextPageToken("").addAllIndexedAssets(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String index = "index100346066";
        WarehouseClient.ViewIndexedAssetsPagedResponse pagedListResponse = this.client.viewIndexedAssets(index);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexedAssetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ViewIndexedAssetsRequest actualRequest = (ViewIndexedAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)index, (Object)actualRequest.getIndex());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void viewIndexedAssetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String index = "index100346066";
            this.client.viewIndexedAssets(index);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Index index = Index.newBuilder().build();
        String indexId = "indexId1943291277";
        Index actualResponse = (Index)this.client.createIndexAsync(parent, index, indexId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateIndexRequest actualRequest = (CreateIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)index, (Object)actualRequest.getIndex());
        Assert.assertEquals((Object)indexId, (Object)actualRequest.getIndexId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Index index = Index.newBuilder().build();
            String indexId = "indexId1943291277";
            this.client.createIndexAsync(parent, index, indexId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createIndexTest2() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Index index = Index.newBuilder().build();
        String indexId = "indexId1943291277";
        Index actualResponse = (Index)this.client.createIndexAsync(parent, index, indexId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateIndexRequest actualRequest = (CreateIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)index, (Object)actualRequest.getIndex());
        Assert.assertEquals((Object)indexId, (Object)actualRequest.getIndexId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createIndexExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Index index = Index.newBuilder().build();
            String indexId = "indexId1943291277";
            this.client.createIndexAsync(parent, index, indexId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        Index index = Index.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Index actualResponse = (Index)this.client.updateIndexAsync(index, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateIndexRequest actualRequest = (UpdateIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)index, (Object)actualRequest.getIndex());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            Index index = Index.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateIndexAsync(index, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getIndexTest() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        Index actualResponse = this.client.getIndex(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIndexRequest actualRequest = (GetIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            this.client.getIndex(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexTest2() throws Exception {
        Index expectedResponse = Index.newBuilder().setName(IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllDeployedIndexes(new ArrayList()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Index actualResponse = this.client.getIndex(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIndexRequest actualRequest = (GetIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIndexExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getIndex(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexesTest() throws Exception {
        Index responsesElement = Index.newBuilder().build();
        ListIndexesResponse expectedResponse = ListIndexesResponse.newBuilder().setNextPageToken("").addAllIndexes(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListIndexesPagedResponse pagedListResponse = this.client.listIndexes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListIndexesRequest actualRequest = (ListIndexesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listIndexesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listIndexes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexesTest2() throws Exception {
        Index responsesElement = Index.newBuilder().build();
        ListIndexesResponse expectedResponse = ListIndexesResponse.newBuilder().setNextPageToken("").addAllIndexes(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListIndexesPagedResponse pagedListResponse = this.client.listIndexes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListIndexesRequest actualRequest = (ListIndexesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listIndexesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listIndexes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIndexTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
        this.client.deleteIndexAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteIndexRequest actualRequest = (DeleteIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexName name = IndexName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[INDEX]");
            this.client.deleteIndexAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteIndexTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteIndexAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteIndexRequest actualRequest = (DeleteIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteIndexExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteIndexAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createCorpusTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Corpus corpus = Corpus.newBuilder().build();
        Corpus actualResponse = (Corpus)this.client.createCorpusAsync(parent, corpus).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCorpusRequest actualRequest = (CreateCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)corpus, (Object)actualRequest.getCorpus());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCorpusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Corpus corpus = Corpus.newBuilder().build();
            this.client.createCorpusAsync(parent, corpus).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Corpus actualResponse = this.client.getCorpus(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCorpusRequest actualRequest = (GetCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCorpusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.getCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCorpusTest2() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Corpus actualResponse = this.client.getCorpus(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCorpusRequest actualRequest = (GetCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCorpusExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCorpusTest() throws Exception {
        Corpus expectedResponse = Corpus.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDefaultTtl(Duration.newBuilder().build()).setSearchCapabilitySetting(SearchCapabilitySetting.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        Corpus corpus = Corpus.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Corpus actualResponse = this.client.updateCorpus(corpus, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateCorpusRequest actualRequest = (UpdateCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)corpus, (Object)actualRequest.getCorpus());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateCorpusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            Corpus corpus = Corpus.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateCorpus(corpus, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCorporaTest() throws Exception {
        Corpus responsesElement = Corpus.newBuilder().build();
        ListCorporaResponse expectedResponse = ListCorporaResponse.newBuilder().setNextPageToken("").addAllCorpora(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListCorporaPagedResponse pagedListResponse = this.client.listCorpora(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCorporaList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCorporaRequest actualRequest = (ListCorporaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCorporaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listCorpora(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCorpusTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        this.client.deleteCorpus(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCorpusRequest actualRequest = (DeleteCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCorpusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName name = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.deleteCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCorpusTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteCorpus(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCorpusRequest actualRequest = (DeleteCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCorpusExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteCorpus(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void analyzeCorpusTest() throws Exception {
        AnalyzeCorpusResponse expectedResponse = AnalyzeCorpusResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("analyzeCorpusTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        AnalyzeCorpusRequest request = AnalyzeCorpusRequest.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
        AnalyzeCorpusResponse actualResponse = (AnalyzeCorpusResponse)this.client.analyzeCorpusAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AnalyzeCorpusRequest actualRequest = (AnalyzeCorpusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void analyzeCorpusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AnalyzeCorpusRequest request = AnalyzeCorpusRequest.newBuilder().setName(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
            this.client.analyzeCorpusAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        DataSchema dataSchema = DataSchema.newBuilder().build();
        DataSchema actualResponse = this.client.createDataSchema(parent, dataSchema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDataSchemaRequest actualRequest = (CreateDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataSchema, (Object)actualRequest.getDataSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDataSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            DataSchema dataSchema = DataSchema.newBuilder().build();
            this.client.createDataSchema(parent, dataSchema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDataSchemaTest2() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataSchema dataSchema = DataSchema.newBuilder().build();
        DataSchema actualResponse = this.client.createDataSchema(parent, dataSchema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDataSchemaRequest actualRequest = (CreateDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataSchema, (Object)actualRequest.getDataSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDataSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            DataSchema dataSchema = DataSchema.newBuilder().build();
            this.client.createDataSchema(parent, dataSchema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        DataSchema dataSchema = DataSchema.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        DataSchema actualResponse = this.client.updateDataSchema(dataSchema, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDataSchemaRequest actualRequest = (UpdateDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)dataSchema, (Object)actualRequest.getDataSchema());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDataSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            DataSchema dataSchema = DataSchema.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDataSchema(dataSchema, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDataSchemaTest() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
        DataSchema actualResponse = this.client.getDataSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDataSchemaRequest actualRequest = (GetDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDataSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
            this.client.getDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDataSchemaTest2() throws Exception {
        DataSchema expectedResponse = DataSchema.newBuilder().setName(DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]").toString()).setKey("key106079").setSchemaDetails(DataSchemaDetails.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        DataSchema actualResponse = this.client.getDataSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDataSchemaRequest actualRequest = (GetDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDataSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDataSchemaTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
        this.client.deleteDataSchema(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDataSchemaRequest actualRequest = (DeleteDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDataSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            DataSchemaName name = DataSchemaName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[DATA_SCHEMA]");
            this.client.deleteDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDataSchemaTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteDataSchema(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDataSchemaRequest actualRequest = (DeleteDataSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDataSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDataSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDataSchemasTest() throws Exception {
        DataSchema responsesElement = DataSchema.newBuilder().build();
        ListDataSchemasResponse expectedResponse = ListDataSchemasResponse.newBuilder().setNextPageToken("").addAllDataSchemas(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListDataSchemasPagedResponse pagedListResponse = this.client.listDataSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDataSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDataSchemasRequest actualRequest = (ListDataSchemasRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDataSchemasExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listDataSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDataSchemasTest2() throws Exception {
        DataSchema responsesElement = DataSchema.newBuilder().build();
        ListDataSchemasResponse expectedResponse = ListDataSchemasResponse.newBuilder().setNextPageToken("").addAllDataSchemas(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListDataSchemasPagedResponse pagedListResponse = this.client.listDataSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDataSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDataSchemasRequest actualRequest = (ListDataSchemasRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDataSchemasExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDataSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        Annotation annotation = Annotation.newBuilder().build();
        String annotationId = "annotationId251782314";
        Annotation actualResponse = this.client.createAnnotation(parent, annotation, annotationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAnnotationRequest actualRequest = (CreateAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)annotation, (Object)actualRequest.getAnnotation());
        Assert.assertEquals((Object)annotationId, (Object)actualRequest.getAnnotationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAnnotationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            Annotation annotation = Annotation.newBuilder().build();
            String annotationId = "annotationId251782314";
            this.client.createAnnotation(parent, annotation, annotationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAnnotationTest2() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Annotation annotation = Annotation.newBuilder().build();
        String annotationId = "annotationId251782314";
        Annotation actualResponse = this.client.createAnnotation(parent, annotation, annotationId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAnnotationRequest actualRequest = (CreateAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)annotation, (Object)actualRequest.getAnnotation());
        Assert.assertEquals((Object)annotationId, (Object)actualRequest.getAnnotationId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAnnotationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Annotation annotation = Annotation.newBuilder().build();
            String annotationId = "annotationId251782314";
            this.client.createAnnotation(parent, annotation, annotationId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
        Annotation actualResponse = this.client.getAnnotation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAnnotationRequest actualRequest = (GetAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAnnotationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
            this.client.getAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAnnotationTest2() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Annotation actualResponse = this.client.getAnnotation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAnnotationRequest actualRequest = (GetAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAnnotationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnnotationsTest() throws Exception {
        Annotation responsesElement = Annotation.newBuilder().build();
        ListAnnotationsResponse expectedResponse = ListAnnotationsResponse.newBuilder().setNextPageToken("").addAllAnnotations(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
        WarehouseClient.ListAnnotationsPagedResponse pagedListResponse = this.client.listAnnotations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnnotationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAnnotationsRequest actualRequest = (ListAnnotationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAnnotationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AssetName parent = AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]");
            this.client.listAnnotations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAnnotationsTest2() throws Exception {
        Annotation responsesElement = Annotation.newBuilder().build();
        ListAnnotationsResponse expectedResponse = ListAnnotationsResponse.newBuilder().setNextPageToken("").addAllAnnotations(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListAnnotationsPagedResponse pagedListResponse = this.client.listAnnotations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAnnotationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAnnotationsRequest actualRequest = (ListAnnotationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAnnotationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAnnotations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAnnotationTest() throws Exception {
        Annotation expectedResponse = Annotation.newBuilder().setName(AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]").toString()).setUserSpecifiedAnnotation(UserSpecifiedAnnotation.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        Annotation annotation = Annotation.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Annotation actualResponse = this.client.updateAnnotation(annotation, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAnnotationRequest actualRequest = (UpdateAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)annotation, (Object)actualRequest.getAnnotation());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAnnotationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            Annotation annotation = Annotation.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAnnotation(annotation, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnnotationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
        this.client.deleteAnnotation(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAnnotationRequest actualRequest = (DeleteAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAnnotationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            AnnotationName name = AnnotationName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]", (String)"[ANNOTATION]");
            this.client.deleteAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAnnotationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAnnotation(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAnnotationRequest actualRequest = (DeleteAnnotationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAnnotationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAnnotation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void ingestAssetTest() throws Exception {
        IngestAssetResponse expectedResponse = IngestAssetResponse.newBuilder().setSuccessfullyIngestedPartition(Partition.TemporalPartition.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        IngestAssetRequest request = IngestAssetRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.ingestAssetCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void ingestAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        IngestAssetRequest request = IngestAssetRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.ingestAssetCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void clipAssetTest() throws Exception {
        ClipAssetResponse expectedResponse = ClipAssetResponse.newBuilder().addAllTimeIndexedUris(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        ClipAssetRequest request = ClipAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTemporalPartition(Partition.TemporalPartition.newBuilder().build()).build();
        ClipAssetResponse actualResponse = this.client.clipAsset(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ClipAssetRequest actualRequest = (ClipAssetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getTemporalPartition(), (Object)actualRequest.getTemporalPartition());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void clipAssetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            ClipAssetRequest request = ClipAssetRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).setTemporalPartition(Partition.TemporalPartition.newBuilder().build()).build();
            this.client.clipAsset(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateHlsUriTest() throws Exception {
        GenerateHlsUriResponse expectedResponse = GenerateHlsUriResponse.newBuilder().setUri("uri116076").addAllTemporalPartitions(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        GenerateHlsUriRequest request = GenerateHlsUriRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).addAllTemporalPartitions(new ArrayList()).setLiveViewEnabled(true).build();
        GenerateHlsUriResponse actualResponse = this.client.generateHlsUri(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateHlsUriRequest actualRequest = (GenerateHlsUriRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getTemporalPartitionsList(), (Object)actualRequest.getTemporalPartitionsList());
        Assert.assertEquals((Object)request.getLiveViewEnabled(), (Object)actualRequest.getLiveViewEnabled());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateHlsUriExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            GenerateHlsUriRequest request = GenerateHlsUriRequest.newBuilder().setName(AssetName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[ASSET]").toString()).addAllTemporalPartitions(new ArrayList()).setLiveViewEnabled(true).build();
            this.client.generateHlsUri(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importAssetsTest() throws Exception {
        ImportAssetsResponse expectedResponse = ImportAssetsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("importAssetsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        ImportAssetsRequest request = ImportAssetsRequest.newBuilder().setParent(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
        ImportAssetsResponse actualResponse = (ImportAssetsResponse)this.client.importAssetsAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportAssetsRequest actualRequest = (ImportAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getAssetsGcsUri(), (Object)actualRequest.getAssetsGcsUri());
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            ImportAssetsRequest request = ImportAssetsRequest.newBuilder().setParent(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).build();
            this.client.importAssetsAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        SearchConfig searchConfig = SearchConfig.newBuilder().build();
        String searchConfigId = "searchConfigId1576297925";
        SearchConfig actualResponse = this.client.createSearchConfig(parent, searchConfig, searchConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSearchConfigRequest actualRequest = (CreateSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)searchConfig, (Object)actualRequest.getSearchConfig());
        Assert.assertEquals((Object)searchConfigId, (Object)actualRequest.getSearchConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSearchConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            SearchConfig searchConfig = SearchConfig.newBuilder().build();
            String searchConfigId = "searchConfigId1576297925";
            this.client.createSearchConfig(parent, searchConfig, searchConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchConfigTest2() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SearchConfig searchConfig = SearchConfig.newBuilder().build();
        String searchConfigId = "searchConfigId1576297925";
        SearchConfig actualResponse = this.client.createSearchConfig(parent, searchConfig, searchConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSearchConfigRequest actualRequest = (CreateSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)searchConfig, (Object)actualRequest.getSearchConfig());
        Assert.assertEquals((Object)searchConfigId, (Object)actualRequest.getSearchConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSearchConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            SearchConfig searchConfig = SearchConfig.newBuilder().build();
            String searchConfigId = "searchConfigId1576297925";
            this.client.createSearchConfig(parent, searchConfig, searchConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchConfig searchConfig = SearchConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SearchConfig actualResponse = this.client.updateSearchConfig(searchConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSearchConfigRequest actualRequest = (UpdateSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)searchConfig, (Object)actualRequest.getSearchConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSearchConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchConfig searchConfig = SearchConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSearchConfig(searchConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchConfigTest() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
        SearchConfig actualResponse = this.client.getSearchConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSearchConfigRequest actualRequest = (GetSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSearchConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
            this.client.getSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchConfigTest2() throws Exception {
        SearchConfig expectedResponse = SearchConfig.newBuilder().setName(SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]").toString()).setFacetProperty(FacetProperty.newBuilder().build()).setSearchCriteriaProperty(SearchCriteriaProperty.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        SearchConfig actualResponse = this.client.getSearchConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSearchConfigRequest actualRequest = (GetSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSearchConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
        this.client.deleteSearchConfig(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSearchConfigRequest actualRequest = (DeleteSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSearchConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchConfigName name = SearchConfigName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_CONFIG]");
            this.client.deleteSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSearchConfig(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSearchConfigRequest actualRequest = (DeleteSearchConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSearchConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSearchConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchConfigsTest() throws Exception {
        SearchConfig responsesElement = SearchConfig.newBuilder().build();
        ListSearchConfigsResponse expectedResponse = ListSearchConfigsResponse.newBuilder().setNextPageToken("").addAllSearchConfigs(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListSearchConfigsPagedResponse pagedListResponse = this.client.listSearchConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSearchConfigsRequest actualRequest = (ListSearchConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSearchConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listSearchConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchConfigsTest2() throws Exception {
        SearchConfig responsesElement = SearchConfig.newBuilder().build();
        ListSearchConfigsResponse expectedResponse = ListSearchConfigsResponse.newBuilder().setNextPageToken("").addAllSearchConfigs(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListSearchConfigsPagedResponse pagedListResponse = this.client.listSearchConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSearchConfigsRequest actualRequest = (ListSearchConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSearchConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSearchConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
        String searchHypernymId = "searchHypernymId-314707559";
        SearchHypernym actualResponse = this.client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSearchHypernymRequest actualRequest = (CreateSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)searchHypernym, (Object)actualRequest.getSearchHypernym());
        Assert.assertEquals((Object)searchHypernymId, (Object)actualRequest.getSearchHypernymId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSearchHypernymExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
            String searchHypernymId = "searchHypernymId-314707559";
            this.client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSearchHypernymTest2() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
        String searchHypernymId = "searchHypernymId-314707559";
        SearchHypernym actualResponse = this.client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSearchHypernymRequest actualRequest = (CreateSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)searchHypernym, (Object)actualRequest.getSearchHypernym());
        Assert.assertEquals((Object)searchHypernymId, (Object)actualRequest.getSearchHypernymId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSearchHypernymExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
            String searchHypernymId = "searchHypernymId-314707559";
            this.client.createSearchHypernym(parent, searchHypernym, searchHypernymId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SearchHypernym actualResponse = this.client.updateSearchHypernym(searchHypernym, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSearchHypernymRequest actualRequest = (UpdateSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)searchHypernym, (Object)actualRequest.getSearchHypernym());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSearchHypernymExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchHypernym searchHypernym = SearchHypernym.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSearchHypernym(searchHypernym, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchHypernymTest() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
        SearchHypernym actualResponse = this.client.getSearchHypernym(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSearchHypernymRequest actualRequest = (GetSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSearchHypernymExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
            this.client.getSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSearchHypernymTest2() throws Exception {
        SearchHypernym expectedResponse = SearchHypernym.newBuilder().setName(SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]").toString()).setHypernym("hypernym-114309610").addAllHyponyms(new ArrayList()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        SearchHypernym actualResponse = this.client.getSearchHypernym(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSearchHypernymRequest actualRequest = (GetSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSearchHypernymExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchHypernymTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
        this.client.deleteSearchHypernym(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSearchHypernymRequest actualRequest = (DeleteSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSearchHypernymExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchHypernymName name = SearchHypernymName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[SEARCH_HYPERNYM]");
            this.client.deleteSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSearchHypernymTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSearchHypernym(name);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSearchHypernymRequest actualRequest = (DeleteSearchHypernymRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSearchHypernymExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSearchHypernym(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchHypernymsTest() throws Exception {
        SearchHypernym responsesElement = SearchHypernym.newBuilder().build();
        ListSearchHypernymsResponse expectedResponse = ListSearchHypernymsResponse.newBuilder().setNextPageToken("").addAllSearchHypernyms(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListSearchHypernymsPagedResponse pagedListResponse = this.client.listSearchHypernyms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchHypernymsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSearchHypernymsRequest actualRequest = (ListSearchHypernymsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSearchHypernymsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listSearchHypernyms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSearchHypernymsTest2() throws Exception {
        SearchHypernym responsesElement = SearchHypernym.newBuilder().build();
        ListSearchHypernymsResponse expectedResponse = ListSearchHypernymsResponse.newBuilder().setNextPageToken("").addAllSearchHypernyms(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListSearchHypernymsPagedResponse pagedListResponse = this.client.listSearchHypernyms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchHypernymsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSearchHypernymsRequest actualRequest = (ListSearchHypernymsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSearchHypernymsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSearchHypernyms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchAssetsTest() throws Exception {
        SearchResultItem responsesElement = SearchResultItem.newBuilder().build();
        SearchAssetsResponse expectedResponse = SearchAssetsResponse.newBuilder().setNextPageToken("").addAllSearchResultItems(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchAssetsRequest request = SearchAssetsRequest.newBuilder().setCorpus(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setContentTimeRanges(DateTimeRangeArray.newBuilder().build()).addAllCriteria(new ArrayList()).addAllFacetSelections(new ArrayList()).addAllResultAnnotationKeys(new ArrayList()).setSearchQuery("searchQuery-552137728").build();
        WarehouseClient.SearchAssetsPagedResponse pagedListResponse = this.client.searchAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchResultItemsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchAssetsRequest actualRequest = (SearchAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSchemaKeySortingStrategy(), (Object)actualRequest.getSchemaKeySortingStrategy());
        Assert.assertEquals((Object)request.getCorpus(), (Object)actualRequest.getCorpus());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((Object)request.getContentTimeRanges(), (Object)actualRequest.getContentTimeRanges());
        Assert.assertEquals((Object)request.getCriteriaList(), (Object)actualRequest.getCriteriaList());
        Assert.assertEquals((Object)request.getFacetSelectionsList(), (Object)actualRequest.getFacetSelectionsList());
        Assert.assertEquals((Object)request.getResultAnnotationKeysList(), (Object)actualRequest.getResultAnnotationKeysList());
        Assert.assertEquals((Object)request.getSearchQuery(), (Object)actualRequest.getSearchQuery());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchAssetsRequest request = SearchAssetsRequest.newBuilder().setCorpus(CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setContentTimeRanges(DateTimeRangeArray.newBuilder().build()).addAllCriteria(new ArrayList()).addAllFacetSelections(new ArrayList()).addAllResultAnnotationKeys(new ArrayList()).setSearchQuery("searchQuery-552137728").build();
            this.client.searchAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchIndexEndpointTest() throws Exception {
        SearchResultItem responsesElement = SearchResultItem.newBuilder().build();
        SearchIndexEndpointResponse expectedResponse = SearchIndexEndpointResponse.newBuilder().setNextPageToken("").addAllSearchResultItems(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        SearchIndexEndpointRequest request = SearchIndexEndpointRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).addAllCriteria(new ArrayList()).addAllExclusionCriteria(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        WarehouseClient.SearchIndexEndpointPagedResponse pagedListResponse = this.client.searchIndexEndpoint(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSearchResultItemsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchIndexEndpointRequest actualRequest = (SearchIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getImageQuery(), (Object)actualRequest.getImageQuery());
        Assert.assertEquals((Object)request.getTextQuery(), (Object)actualRequest.getTextQuery());
        Assert.assertEquals((Object)request.getIndexEndpoint(), (Object)actualRequest.getIndexEndpoint());
        Assert.assertEquals((Object)request.getCriteriaList(), (Object)actualRequest.getCriteriaList());
        Assert.assertEquals((Object)request.getExclusionCriteriaList(), (Object)actualRequest.getExclusionCriteriaList());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchIndexEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            SearchIndexEndpointRequest request = SearchIndexEndpointRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).addAllCriteria(new ArrayList()).addAllExclusionCriteria(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.searchIndexEndpoint(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
        String indexEndpointId = "indexEndpointId-250889214";
        IndexEndpoint actualResponse = (IndexEndpoint)this.client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateIndexEndpointRequest actualRequest = (CreateIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)indexEndpoint, (Object)actualRequest.getIndexEndpoint());
        Assert.assertEquals((Object)indexEndpointId, (Object)actualRequest.getIndexEndpointId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createIndexEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
            String indexEndpointId = "indexEndpointId-250889214";
            this.client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createIndexEndpointTest2() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
        String indexEndpointId = "indexEndpointId-250889214";
        IndexEndpoint actualResponse = (IndexEndpoint)this.client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateIndexEndpointRequest actualRequest = (CreateIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)indexEndpoint, (Object)actualRequest.getIndexEndpoint());
        Assert.assertEquals((Object)indexEndpointId, (Object)actualRequest.getIndexEndpointId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createIndexEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
            String indexEndpointId = "indexEndpointId-250889214";
            this.client.createIndexEndpointAsync(parent, indexEndpoint, indexEndpointId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
        IndexEndpoint actualResponse = this.client.getIndexEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIndexEndpointRequest actualRequest = (GetIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIndexEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
            this.client.getIndexEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIndexEndpointTest2() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        IndexEndpoint actualResponse = this.client.getIndexEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIndexEndpointRequest actualRequest = (GetIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIndexEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getIndexEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexEndpointsTest() throws Exception {
        IndexEndpoint responsesElement = IndexEndpoint.newBuilder().build();
        ListIndexEndpointsResponse expectedResponse = ListIndexEndpointsResponse.newBuilder().setNextPageToken("").addAllIndexEndpoints(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        WarehouseClient.ListIndexEndpointsPagedResponse pagedListResponse = this.client.listIndexEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexEndpointsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListIndexEndpointsRequest actualRequest = (ListIndexEndpointsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listIndexEndpointsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listIndexEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listIndexEndpointsTest2() throws Exception {
        IndexEndpoint responsesElement = IndexEndpoint.newBuilder().build();
        ListIndexEndpointsResponse expectedResponse = ListIndexEndpointsResponse.newBuilder().setNextPageToken("").addAllIndexEndpoints(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListIndexEndpointsPagedResponse pagedListResponse = this.client.listIndexEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getIndexEndpointsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListIndexEndpointsRequest actualRequest = (ListIndexEndpointsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listIndexEndpointsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listIndexEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateIndexEndpointTest() throws Exception {
        IndexEndpoint expectedResponse = IndexEndpoint.newBuilder().setName(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setDeployedIndex(DeployedIndex.newBuilder().build()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setSatisfiesPzs(true).setSatisfiesPzi(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        IndexEndpoint actualResponse = (IndexEndpoint)this.client.updateIndexEndpointAsync(indexEndpoint, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateIndexEndpointRequest actualRequest = (UpdateIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)indexEndpoint, (Object)actualRequest.getIndexEndpoint());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateIndexEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexEndpoint indexEndpoint = IndexEndpoint.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateIndexEndpointAsync(indexEndpoint, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteIndexEndpointTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
        this.client.deleteIndexEndpointAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteIndexEndpointRequest actualRequest = (DeleteIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteIndexEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            IndexEndpointName name = IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]");
            this.client.deleteIndexEndpointAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteIndexEndpointTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteIndexEndpointTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteIndexEndpointAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteIndexEndpointRequest actualRequest = (DeleteIndexEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteIndexEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteIndexEndpointAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deployIndexTest() throws Exception {
        DeployIndexResponse expectedResponse = DeployIndexResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deployIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDeployedIndex(DeployedIndex.newBuilder().build()).build();
        DeployIndexResponse actualResponse = (DeployIndexResponse)this.client.deployIndexAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeployIndexRequest actualRequest = (DeployIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getIndexEndpoint(), (Object)actualRequest.getIndexEndpoint());
        Assert.assertEquals((Object)request.getDeployedIndex(), (Object)actualRequest.getDeployedIndex());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deployIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            DeployIndexRequest request = DeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).setDeployedIndex(DeployedIndex.newBuilder().build()).build();
            this.client.deployIndexAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void undeployIndexTest() throws Exception {
        UndeployIndexResponse expectedResponse = UndeployIndexResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("undeployIndexTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).build();
        UndeployIndexResponse actualResponse = (UndeployIndexResponse)this.client.undeployIndexAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UndeployIndexRequest actualRequest = (UndeployIndexRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getIndexEndpoint(), (Object)actualRequest.getIndexEndpoint());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void undeployIndexExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            UndeployIndexRequest request = UndeployIndexRequest.newBuilder().setIndexEndpoint(IndexEndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INDEX_ENDPOINT]").toString()).build();
            this.client.undeployIndexAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        Collection collection = Collection.newBuilder().build();
        String collectionId = "collectionId1636075609";
        Collection actualResponse = (Collection)this.client.createCollectionAsync(parent, collection, collectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCollectionRequest actualRequest = (CreateCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)collection, (Object)actualRequest.getCollection());
        Assert.assertEquals((Object)collectionId, (Object)actualRequest.getCollectionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCollectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            Collection collection = Collection.newBuilder().build();
            String collectionId = "collectionId1636075609";
            this.client.createCollectionAsync(parent, collection, collectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createCollectionTest2() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Collection collection = Collection.newBuilder().build();
        String collectionId = "collectionId1636075609";
        Collection actualResponse = (Collection)this.client.createCollectionAsync(parent, collection, collectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCollectionRequest actualRequest = (CreateCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)collection, (Object)actualRequest.getCollection());
        Assert.assertEquals((Object)collectionId, (Object)actualRequest.getCollectionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCollectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Collection collection = Collection.newBuilder().build();
            String collectionId = "collectionId1636075609";
            this.client.createCollectionAsync(parent, collection, collectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteCollectionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        this.client.deleteCollectionAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCollectionRequest actualRequest = (DeleteCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCollectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            this.client.deleteCollectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteCollectionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteCollectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWarehouse.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteCollectionAsync(name).get();
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCollectionRequest actualRequest = (DeleteCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCollectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteCollectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        Collection actualResponse = this.client.getCollection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCollectionRequest actualRequest = (GetCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCollectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CollectionName name = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            this.client.getCollection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCollectionTest2() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Collection actualResponse = this.client.getCollection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCollectionRequest actualRequest = (GetCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCollectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCollection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateCollectionTest() throws Exception {
        Collection expectedResponse = Collection.newBuilder().setName(CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        Collection collection = Collection.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Collection actualResponse = this.client.updateCollection(collection, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateCollectionRequest actualRequest = (UpdateCollectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)collection, (Object)actualRequest.getCollection());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateCollectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            Collection collection = Collection.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateCollection(collection, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCollectionsTest() throws Exception {
        Collection responsesElement = Collection.newBuilder().build();
        ListCollectionsResponse expectedResponse = ListCollectionsResponse.newBuilder().setNextPageToken("").addAllCollections(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
        WarehouseClient.ListCollectionsPagedResponse pagedListResponse = this.client.listCollections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCollectionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCollectionsRequest actualRequest = (ListCollectionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCollectionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CorpusName parent = CorpusName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]");
            this.client.listCollections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCollectionsTest2() throws Exception {
        Collection responsesElement = Collection.newBuilder().build();
        ListCollectionsResponse expectedResponse = ListCollectionsResponse.newBuilder().setNextPageToken("").addAllCollections(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WarehouseClient.ListCollectionsPagedResponse pagedListResponse = this.client.listCollections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCollectionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCollectionsRequest actualRequest = (ListCollectionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCollectionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listCollections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void addCollectionItemTest() throws Exception {
        AddCollectionItemResponse expectedResponse = AddCollectionItemResponse.newBuilder().setItem(CollectionItem.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CollectionItem item = CollectionItem.newBuilder().build();
        AddCollectionItemResponse actualResponse = this.client.addCollectionItem(item);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AddCollectionItemRequest actualRequest = (AddCollectionItemRequest)actualRequests.get(0);
        Assert.assertEquals((Object)item, (Object)actualRequest.getItem());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void addCollectionItemExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CollectionItem item = CollectionItem.newBuilder().build();
            this.client.addCollectionItem(item);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removeCollectionItemTest() throws Exception {
        RemoveCollectionItemResponse expectedResponse = RemoveCollectionItemResponse.newBuilder().setItem(CollectionItem.newBuilder().build()).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CollectionItem item = CollectionItem.newBuilder().build();
        RemoveCollectionItemResponse actualResponse = this.client.removeCollectionItem(item);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RemoveCollectionItemRequest actualRequest = (RemoveCollectionItemRequest)actualRequests.get(0);
        Assert.assertEquals((Object)item, (Object)actualRequest.getItem());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void removeCollectionItemExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CollectionItem item = CollectionItem.newBuilder().build();
            this.client.removeCollectionItem(item);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewCollectionItemsTest() throws Exception {
        CollectionItem responsesElement = CollectionItem.newBuilder().build();
        ViewCollectionItemsResponse expectedResponse = ViewCollectionItemsResponse.newBuilder().setNextPageToken("").addAllItems(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        CollectionName collection = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
        WarehouseClient.ViewCollectionItemsPagedResponse pagedListResponse = this.client.viewCollectionItems(collection);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getItemsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ViewCollectionItemsRequest actualRequest = (ViewCollectionItemsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)collection.toString(), (Object)actualRequest.getCollection());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void viewCollectionItemsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            CollectionName collection = CollectionName.of((String)"[PROJECT_NUMBER]", (String)"[LOCATION]", (String)"[CORPUS]", (String)"[COLLECTION]");
            this.client.viewCollectionItems(collection);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void viewCollectionItemsTest2() throws Exception {
        CollectionItem responsesElement = CollectionItem.newBuilder().build();
        ViewCollectionItemsResponse expectedResponse = ViewCollectionItemsResponse.newBuilder().setNextPageToken("").addAllItems(Arrays.asList(responsesElement)).build();
        mockWarehouse.addResponse((AbstractMessage)expectedResponse);
        String collection = "collection-1741312354";
        WarehouseClient.ViewCollectionItemsPagedResponse pagedListResponse = this.client.viewCollectionItems(collection);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getItemsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockWarehouse.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ViewCollectionItemsRequest actualRequest = (ViewCollectionItemsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)collection, (Object)actualRequest.getCollection());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void viewCollectionItemsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWarehouse.addException((Exception)exception);
        try {
            String collection = "collection-1741312354";
            this.client.viewCollectionItems(collection);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

