/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.HealthCheckRequest;
import com.google.cloud.visionai.v1.HealthCheckResponse;
import com.google.cloud.visionai.v1.stub.GrpcHealthCheckServiceCallableFactory;
import com.google.cloud.visionai.v1.stub.HealthCheckServiceStub;
import com.google.cloud.visionai.v1.stub.HealthCheckServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcHealthCheckServiceStub
extends HealthCheckServiceStub {
    private static final MethodDescriptor<HealthCheckRequest, HealthCheckResponse> healthCheckMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.visionai.v1.HealthCheckService/HealthCheck").setRequestMarshaller(ProtoUtils.marshaller((Message)HealthCheckRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)HealthCheckResponse.getDefaultInstance())).build();
    private final UnaryCallable<HealthCheckRequest, HealthCheckResponse> healthCheckCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcHealthCheckServiceStub create(HealthCheckServiceStubSettings settings) throws IOException {
        return new GrpcHealthCheckServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcHealthCheckServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcHealthCheckServiceStub(HealthCheckServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcHealthCheckServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcHealthCheckServiceStub(HealthCheckServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcHealthCheckServiceStub(HealthCheckServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcHealthCheckServiceCallableFactory());
    }

    protected GrpcHealthCheckServiceStub(HealthCheckServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings healthCheckTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(healthCheckMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cluster", String.valueOf(request.getCluster()));
            return builder.build();
        }).build();
        this.healthCheckCallable = callableFactory.createUnaryCallable(healthCheckTransportSettings, settings.healthCheckSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<HealthCheckRequest, HealthCheckResponse> healthCheckCallable() {
        return this.healthCheckCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

