/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.visionai.v1.AcquireLeaseRequest;
import com.google.cloud.visionai.v1.Lease;
import com.google.cloud.visionai.v1.ReceiveEventsRequest;
import com.google.cloud.visionai.v1.ReceiveEventsResponse;
import com.google.cloud.visionai.v1.ReceivePacketsRequest;
import com.google.cloud.visionai.v1.ReceivePacketsResponse;
import com.google.cloud.visionai.v1.ReleaseLeaseRequest;
import com.google.cloud.visionai.v1.ReleaseLeaseResponse;
import com.google.cloud.visionai.v1.RenewLeaseRequest;
import com.google.cloud.visionai.v1.SendPacketsRequest;
import com.google.cloud.visionai.v1.SendPacketsResponse;
import com.google.cloud.visionai.v1.stub.GrpcStreamingServiceStub;
import com.google.cloud.visionai.v1.stub.HttpJsonStreamingServiceStub;
import com.google.cloud.visionai.v1.stub.StreamingServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StreamingServiceStubSettings
extends StubSettings<StreamingServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final StreamingCallSettings<SendPacketsRequest, SendPacketsResponse> sendPacketsSettings;
    private final StreamingCallSettings<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsSettings;
    private final StreamingCallSettings<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsSettings;
    private final UnaryCallSettings<AcquireLeaseRequest, Lease> acquireLeaseSettings;
    private final UnaryCallSettings<RenewLeaseRequest, Lease> renewLeaseSettings;
    private final UnaryCallSettings<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseSettings;

    public StreamingCallSettings<SendPacketsRequest, SendPacketsResponse> sendPacketsSettings() {
        return this.sendPacketsSettings;
    }

    public StreamingCallSettings<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsSettings() {
        return this.receivePacketsSettings;
    }

    public StreamingCallSettings<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsSettings() {
        return this.receiveEventsSettings;
    }

    public UnaryCallSettings<AcquireLeaseRequest, Lease> acquireLeaseSettings() {
        return this.acquireLeaseSettings;
    }

    public UnaryCallSettings<RenewLeaseRequest, Lease> renewLeaseSettings() {
        return this.renewLeaseSettings;
    }

    public UnaryCallSettings<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseSettings() {
        return this.releaseLeaseSettings;
    }

    public StreamingServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStreamingServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonStreamingServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "visionai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "visionai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "visionai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StreamingServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StreamingServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StreamingServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return StreamingServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StreamingServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.sendPacketsSettings = settingsBuilder.sendPacketsSettings().build();
        this.receivePacketsSettings = settingsBuilder.receivePacketsSettings().build();
        this.receiveEventsSettings = settingsBuilder.receiveEventsSettings().build();
        this.acquireLeaseSettings = settingsBuilder.acquireLeaseSettings().build();
        this.renewLeaseSettings = settingsBuilder.renewLeaseSettings().build();
        this.releaseLeaseSettings = settingsBuilder.releaseLeaseSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StreamingServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final StreamingCallSettings.Builder<SendPacketsRequest, SendPacketsResponse> sendPacketsSettings;
        private final StreamingCallSettings.Builder<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsSettings;
        private final StreamingCallSettings.Builder<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsSettings;
        private final UnaryCallSettings.Builder<AcquireLeaseRequest, Lease> acquireLeaseSettings;
        private final UnaryCallSettings.Builder<RenewLeaseRequest, Lease> renewLeaseSettings;
        private final UnaryCallSettings.Builder<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.sendPacketsSettings = StreamingCallSettings.newBuilder();
            this.receivePacketsSettings = StreamingCallSettings.newBuilder();
            this.receiveEventsSettings = StreamingCallSettings.newBuilder();
            this.acquireLeaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renewLeaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.releaseLeaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.acquireLeaseSettings, this.renewLeaseSettings, this.releaseLeaseSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StreamingServiceStubSettings settings) {
            super((StubSettings)settings);
            this.sendPacketsSettings = settings.sendPacketsSettings.toBuilder();
            this.receivePacketsSettings = settings.receivePacketsSettings.toBuilder();
            this.receiveEventsSettings = settings.receiveEventsSettings.toBuilder();
            this.acquireLeaseSettings = settings.acquireLeaseSettings.toBuilder();
            this.renewLeaseSettings = settings.renewLeaseSettings.toBuilder();
            this.releaseLeaseSettings = settings.releaseLeaseSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.acquireLeaseSettings, this.renewLeaseSettings, this.releaseLeaseSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StreamingServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StreamingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StreamingServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StreamingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)StreamingServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)StreamingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StreamingServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StreamingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.acquireLeaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.renewLeaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.releaseLeaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public StreamingCallSettings.Builder<SendPacketsRequest, SendPacketsResponse> sendPacketsSettings() {
            return this.sendPacketsSettings;
        }

        public StreamingCallSettings.Builder<ReceivePacketsRequest, ReceivePacketsResponse> receivePacketsSettings() {
            return this.receivePacketsSettings;
        }

        public StreamingCallSettings.Builder<ReceiveEventsRequest, ReceiveEventsResponse> receiveEventsSettings() {
            return this.receiveEventsSettings;
        }

        public UnaryCallSettings.Builder<AcquireLeaseRequest, Lease> acquireLeaseSettings() {
            return this.acquireLeaseSettings;
        }

        public UnaryCallSettings.Builder<RenewLeaseRequest, Lease> renewLeaseSettings() {
            return this.renewLeaseSettings;
        }

        public UnaryCallSettings.Builder<ReleaseLeaseRequest, ReleaseLeaseResponse> releaseLeaseSettings() {
            return this.releaseLeaseSettings;
        }

        public StreamingServiceStubSettings build() throws IOException {
            return new StreamingServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

